/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class Time
extends Quantity
implements Comparable<Time> {
    private static final int SEED1 = 78;
    private static final int SEED2 = 89;
    Number value;
    Unit<Time> unit;
    private int hashCodeValue;

    public Time(Number inValue, Unit<Time> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("Time: Time cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 78;
        this.hashCodeValue = 89 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 89 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<Time> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Time otherTime = (Time)other;
        if (this.unit.equals(otherTime.unit)) {
            return this.value.equals(otherTime.value);
        }
        if (this.unit.isConvertible(otherTime.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherTime.unit).equals(otherTime.value);
        }
        return false;
    }

    @Override
    public int compareTo(Time other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return this.getClass().getName() + ": " + "value[" + this.value + "], unit[" + this.unit.getSymbol() + "] stored as " + this.value.getClass().getName();
    }

    public Unit<Time> unit() {
        return this.unit;
    }
}

