/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Image;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.MicrobeamManipulationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MicrobeamManipulation
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrobeamManipulation.class);
    private String id;
    private MicrobeamManipulationType type;
    private String description;
    private List<ROI> roiLinks = new ReferenceList<ROI>();
    private Experimenter experimenter;
    private List<LightSourceSettings> lightSourceSettingsCombinations = new ArrayList<LightSourceSettings>();
    private List<Image> imageLinks = new ReferenceList<Image>();
    private Experiment experiment;

    public MicrobeamManipulation() {
    }

    public MicrobeamManipulation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public MicrobeamManipulation(MicrobeamManipulation orig) {
        this.id = orig.id;
        this.type = orig.type;
        this.description = orig.description;
        this.roiLinks = orig.roiLinks;
        this.experimenter = orig.experimenter;
        this.lightSourceSettingsCombinations = orig.lightSourceSettingsCombinations;
        this.imageLinks = orig.imageLinks;
        this.experiment = orig.experiment;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("MicrobeamManipulation missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Type")) {
            this.setType(MicrobeamManipulationType.fromString(element.getAttribute("Type")));
        }
        if ((Description_nodeList = MicrobeamManipulation.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ROIRef_nodeList = MicrobeamManipulation.getChildrenByTagName(element, "ROIRef");
        for (Element element2 : ROIRef_nodeList) {
            ROIRef roiLinks_reference = new ROIRef();
            roiLinks_reference.setID(element2.getAttribute("ID"));
            model.addReference(this, roiLinks_reference);
        }
        List<Element> ExperimenterRef_nodeList = MicrobeamManipulation.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> list = MicrobeamManipulation.getChildrenByTagName(element, "LightSourceSettings");
        for (Element LightSourceSettings_element : list) {
            this.addLightSourceSettings(new LightSourceSettings(LightSourceSettings_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof ROIRef) {
            ROI o_casted = (ROI)o;
            o_casted.linkMicrobeamManipulation(this);
            this.roiLinks.add(o_casted);
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkMicrobeamManipulation(this);
            this.experimenter = o_casted;
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public MicrobeamManipulationType getType() {
        return this.type;
    }

    public void setType(MicrobeamManipulationType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedROIList() {
        return this.roiLinks.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiLinks);
    }

    public ROI getLinkedROI(int index) {
        return this.roiLinks.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiLinks.set(index, o);
    }

    public boolean linkROI(ROI o) {
        o.linkMicrobeamManipulation(this);
        return this.roiLinks.add(o);
    }

    public boolean unlinkROI(ROI o) {
        o.unlinkMicrobeamManipulation(this);
        return this.roiLinks.remove(o);
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public int sizeOfLightSourceSettingsList() {
        return this.lightSourceSettingsCombinations.size();
    }

    public List<LightSourceSettings> copyLightSourceSettingsList() {
        return new ArrayList<LightSourceSettings>(this.lightSourceSettingsCombinations);
    }

    public LightSourceSettings getLightSourceSettings(int index) {
        return this.lightSourceSettingsCombinations.get(index);
    }

    public LightSourceSettings setLightSourceSettings(int index, LightSourceSettings lightSourceSettings) {
        lightSourceSettings.setMicrobeamManipulation(this);
        return this.lightSourceSettingsCombinations.set(index, lightSourceSettings);
    }

    public void addLightSourceSettings(LightSourceSettings lightSourceSettings) {
        lightSourceSettings.setMicrobeamManipulation(this);
        this.lightSourceSettingsCombinations.add(lightSourceSettings);
    }

    public void removeLightSourceSettings(LightSourceSettings lightSourceSettings) {
        this.lightSourceSettingsCombinations.remove(lightSourceSettings);
    }

    public int sizeOfLinkedImageList() {
        return this.imageLinks.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.imageLinks);
    }

    public Image getLinkedImage(int index) {
        return this.imageLinks.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.imageLinks.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.imageLinks.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.imageLinks.remove(o);
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(Experiment experiment_BackReference) {
        this.experiment = experiment_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element MicrobeamManipulation_element) {
        if (MicrobeamManipulation_element == null) {
            MicrobeamManipulation_element = document.createElementNS(NAMESPACE, "MicrobeamManipulation");
        }
        super.asXMLElement(document, MicrobeamManipulation_element);
        if (this.id != null) {
            MicrobeamManipulation_element.setAttribute("ID", this.id);
        }
        if (this.type != null) {
            MicrobeamManipulation_element.setAttribute("Type", this.type.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description);
            MicrobeamManipulation_element.appendChild(description_element);
        }
        if (this.roiLinks != null) {
            for (ROI roiLinks_value : this.roiLinks) {
                ROIRef o = new ROIRef();
                o.setID(roiLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "ROIRef");
                o.asXMLElement(document, child);
                MicrobeamManipulation_element.appendChild(child);
            }
        }
        if (this.experimenter != null) {
            ExperimenterRef o = new ExperimenterRef();
            o.setID(this.experimenter.getID());
            Element child = document.createElementNS(NAMESPACE, "ExperimenterRef");
            o.asXMLElement(document, child);
            MicrobeamManipulation_element.appendChild(child);
        }
        if (this.lightSourceSettingsCombinations != null) {
            for (LightSourceSettings lightSourceSettingsCombinations_value : this.lightSourceSettingsCombinations) {
                Element child = document.createElementNS(NAMESPACE, "LightSourceSettings");
                lightSourceSettingsCombinations_value.asXMLElement(document, child);
                MicrobeamManipulation_element.appendChild(child);
            }
        }
        return MicrobeamManipulation_element;
    }
}

