# coding: utf-8

"""
    URL redirects

    URL redirect operations  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.cms.url_redirects.configuration import Configuration


class UrlMapping(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'portal_id': 'int',
        'created': 'int',
        'updated': 'int',
        'created_by_id': 'int',
        'updated_by_id': 'int',
        'route_prefix': 'str',
        'destination': 'str',
        'redirect_style': 'int',
        'content_group_id': 'int',
        'is_only_after_not_found': 'bool',
        'is_regex': 'bool',
        'is_match_full_url': 'bool',
        'is_match_query_string': 'bool',
        'is_pattern': 'bool',
        'is_trailing_slash_optional': 'bool',
        'is_protocol_agnostic': 'bool',
        'name': 'str',
        'precedence': 'int',
        'deleted_at': 'int',
        'note': 'str',
        'label': 'str',
        'internally_created': 'bool',
        'cos_object_type': 'str',
        'cdn_purge_embargo_time': 'int'
    }

    attribute_map = {
        'id': 'id',
        'portal_id': 'portalId',
        'created': 'created',
        'updated': 'updated',
        'created_by_id': 'createdById',
        'updated_by_id': 'updatedById',
        'route_prefix': 'routePrefix',
        'destination': 'destination',
        'redirect_style': 'redirectStyle',
        'content_group_id': 'contentGroupId',
        'is_only_after_not_found': 'isOnlyAfterNotFound',
        'is_regex': 'isRegex',
        'is_match_full_url': 'isMatchFullUrl',
        'is_match_query_string': 'isMatchQueryString',
        'is_pattern': 'isPattern',
        'is_trailing_slash_optional': 'isTrailingSlashOptional',
        'is_protocol_agnostic': 'isProtocolAgnostic',
        'name': 'name',
        'precedence': 'precedence',
        'deleted_at': 'deletedAt',
        'note': 'note',
        'label': 'label',
        'internally_created': 'internallyCreated',
        'cos_object_type': 'cosObjectType',
        'cdn_purge_embargo_time': 'cdnPurgeEmbargoTime'
    }

    def __init__(self, id=None, portal_id=None, created=None, updated=None, created_by_id=None, updated_by_id=None, route_prefix=None, destination=None, redirect_style=None, content_group_id=None, is_only_after_not_found=None, is_regex=None, is_match_full_url=None, is_match_query_string=None, is_pattern=None, is_trailing_slash_optional=None, is_protocol_agnostic=None, name=None, precedence=None, deleted_at=None, note=None, label=None, internally_created=None, cos_object_type=None, cdn_purge_embargo_time=None, local_vars_configuration=None):  # noqa: E501
        """UrlMapping - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._portal_id = None
        self._created = None
        self._updated = None
        self._created_by_id = None
        self._updated_by_id = None
        self._route_prefix = None
        self._destination = None
        self._redirect_style = None
        self._content_group_id = None
        self._is_only_after_not_found = None
        self._is_regex = None
        self._is_match_full_url = None
        self._is_match_query_string = None
        self._is_pattern = None
        self._is_trailing_slash_optional = None
        self._is_protocol_agnostic = None
        self._name = None
        self._precedence = None
        self._deleted_at = None
        self._note = None
        self._label = None
        self._internally_created = None
        self._cos_object_type = None
        self._cdn_purge_embargo_time = None
        self.discriminator = None

        self.id = id
        self.portal_id = portal_id
        self.created = created
        self.updated = updated
        self.created_by_id = created_by_id
        self.updated_by_id = updated_by_id
        self.route_prefix = route_prefix
        self.destination = destination
        self.redirect_style = redirect_style
        self.content_group_id = content_group_id
        self.is_only_after_not_found = is_only_after_not_found
        self.is_regex = is_regex
        self.is_match_full_url = is_match_full_url
        self.is_match_query_string = is_match_query_string
        self.is_pattern = is_pattern
        self.is_trailing_slash_optional = is_trailing_slash_optional
        self.is_protocol_agnostic = is_protocol_agnostic
        self.name = name
        self.precedence = precedence
        self.deleted_at = deleted_at
        self.note = note
        self.label = label
        self.internally_created = internally_created
        self.cos_object_type = cos_object_type
        self.cdn_purge_embargo_time = cdn_purge_embargo_time

    @property
    def id(self):
        """Gets the id of this UrlMapping.  # noqa: E501

        The unique ID of this URL redirect.  # noqa: E501

        :return: The id of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UrlMapping.

        The unique ID of this URL redirect.  # noqa: E501

        :param id: The id of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def portal_id(self):
        """Gets the portal_id of this UrlMapping.  # noqa: E501


        :return: The portal_id of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._portal_id

    @portal_id.setter
    def portal_id(self, portal_id):
        """Sets the portal_id of this UrlMapping.


        :param portal_id: The portal_id of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and portal_id is None:  # noqa: E501
            raise ValueError("Invalid value for `portal_id`, must not be `None`")  # noqa: E501

        self._portal_id = portal_id

    @property
    def created(self):
        """Gets the created of this UrlMapping.  # noqa: E501


        :return: The created of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this UrlMapping.


        :param created: The created of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and created is None:  # noqa: E501
            raise ValueError("Invalid value for `created`, must not be `None`")  # noqa: E501

        self._created = created

    @property
    def updated(self):
        """Gets the updated of this UrlMapping.  # noqa: E501


        :return: The updated of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this UrlMapping.


        :param updated: The updated of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and updated is None:  # noqa: E501
            raise ValueError("Invalid value for `updated`, must not be `None`")  # noqa: E501

        self._updated = updated

    @property
    def created_by_id(self):
        """Gets the created_by_id of this UrlMapping.  # noqa: E501


        :return: The created_by_id of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._created_by_id

    @created_by_id.setter
    def created_by_id(self, created_by_id):
        """Sets the created_by_id of this UrlMapping.


        :param created_by_id: The created_by_id of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and created_by_id is None:  # noqa: E501
            raise ValueError("Invalid value for `created_by_id`, must not be `None`")  # noqa: E501

        self._created_by_id = created_by_id

    @property
    def updated_by_id(self):
        """Gets the updated_by_id of this UrlMapping.  # noqa: E501


        :return: The updated_by_id of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._updated_by_id

    @updated_by_id.setter
    def updated_by_id(self, updated_by_id):
        """Sets the updated_by_id of this UrlMapping.


        :param updated_by_id: The updated_by_id of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and updated_by_id is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_by_id`, must not be `None`")  # noqa: E501

        self._updated_by_id = updated_by_id

    @property
    def route_prefix(self):
        """Gets the route_prefix of this UrlMapping.  # noqa: E501

        The target incoming URL, path, or pattern to match for redirection.  # noqa: E501

        :return: The route_prefix of this UrlMapping.  # noqa: E501
        :rtype: str
        """
        return self._route_prefix

    @route_prefix.setter
    def route_prefix(self, route_prefix):
        """Sets the route_prefix of this UrlMapping.

        The target incoming URL, path, or pattern to match for redirection.  # noqa: E501

        :param route_prefix: The route_prefix of this UrlMapping.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and route_prefix is None:  # noqa: E501
            raise ValueError("Invalid value for `route_prefix`, must not be `None`")  # noqa: E501

        self._route_prefix = route_prefix

    @property
    def destination(self):
        """Gets the destination of this UrlMapping.  # noqa: E501

        The destination URL, where the target URL should be redirected if it matches the `routePrefix`.  # noqa: E501

        :return: The destination of this UrlMapping.  # noqa: E501
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """Sets the destination of this UrlMapping.

        The destination URL, where the target URL should be redirected if it matches the `routePrefix`.  # noqa: E501

        :param destination: The destination of this UrlMapping.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and destination is None:  # noqa: E501
            raise ValueError("Invalid value for `destination`, must not be `None`")  # noqa: E501

        self._destination = destination

    @property
    def redirect_style(self):
        """Gets the redirect_style of this UrlMapping.  # noqa: E501

        The type of redirect to create. Options include: 301 (permanent), 302 (temporary), or 305 (proxy). Find more details [here](https://knowledge.hubspot.com/cos-general/how-to-redirect-a-hubspot-page).  # noqa: E501

        :return: The redirect_style of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._redirect_style

    @redirect_style.setter
    def redirect_style(self, redirect_style):
        """Sets the redirect_style of this UrlMapping.

        The type of redirect to create. Options include: 301 (permanent), 302 (temporary), or 305 (proxy). Find more details [here](https://knowledge.hubspot.com/cos-general/how-to-redirect-a-hubspot-page).  # noqa: E501

        :param redirect_style: The redirect_style of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and redirect_style is None:  # noqa: E501
            raise ValueError("Invalid value for `redirect_style`, must not be `None`")  # noqa: E501

        self._redirect_style = redirect_style

    @property
    def content_group_id(self):
        """Gets the content_group_id of this UrlMapping.  # noqa: E501


        :return: The content_group_id of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._content_group_id

    @content_group_id.setter
    def content_group_id(self, content_group_id):
        """Sets the content_group_id of this UrlMapping.


        :param content_group_id: The content_group_id of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and content_group_id is None:  # noqa: E501
            raise ValueError("Invalid value for `content_group_id`, must not be `None`")  # noqa: E501

        self._content_group_id = content_group_id

    @property
    def is_only_after_not_found(self):
        """Gets the is_only_after_not_found of this UrlMapping.  # noqa: E501

        Whether the URL redirect mapping should apply only if a live page on the URL isn't found. If False, the URL redirect mapping will take precedence over any existing page.  # noqa: E501

        :return: The is_only_after_not_found of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_only_after_not_found

    @is_only_after_not_found.setter
    def is_only_after_not_found(self, is_only_after_not_found):
        """Sets the is_only_after_not_found of this UrlMapping.

        Whether the URL redirect mapping should apply only if a live page on the URL isn't found. If False, the URL redirect mapping will take precedence over any existing page.  # noqa: E501

        :param is_only_after_not_found: The is_only_after_not_found of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_only_after_not_found is None:  # noqa: E501
            raise ValueError("Invalid value for `is_only_after_not_found`, must not be `None`")  # noqa: E501

        self._is_only_after_not_found = is_only_after_not_found

    @property
    def is_regex(self):
        """Gets the is_regex of this UrlMapping.  # noqa: E501


        :return: The is_regex of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_regex

    @is_regex.setter
    def is_regex(self, is_regex):
        """Sets the is_regex of this UrlMapping.


        :param is_regex: The is_regex of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_regex is None:  # noqa: E501
            raise ValueError("Invalid value for `is_regex`, must not be `None`")  # noqa: E501

        self._is_regex = is_regex

    @property
    def is_match_full_url(self):
        """Gets the is_match_full_url of this UrlMapping.  # noqa: E501

        Whether the `routePrefix` should match on the entire URL, including the domain.  # noqa: E501

        :return: The is_match_full_url of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_match_full_url

    @is_match_full_url.setter
    def is_match_full_url(self, is_match_full_url):
        """Sets the is_match_full_url of this UrlMapping.

        Whether the `routePrefix` should match on the entire URL, including the domain.  # noqa: E501

        :param is_match_full_url: The is_match_full_url of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_match_full_url is None:  # noqa: E501
            raise ValueError("Invalid value for `is_match_full_url`, must not be `None`")  # noqa: E501

        self._is_match_full_url = is_match_full_url

    @property
    def is_match_query_string(self):
        """Gets the is_match_query_string of this UrlMapping.  # noqa: E501

        Whether the `routePrefix` should match on the entire URL path, including the query string.  # noqa: E501

        :return: The is_match_query_string of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_match_query_string

    @is_match_query_string.setter
    def is_match_query_string(self, is_match_query_string):
        """Sets the is_match_query_string of this UrlMapping.

        Whether the `routePrefix` should match on the entire URL path, including the query string.  # noqa: E501

        :param is_match_query_string: The is_match_query_string of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_match_query_string is None:  # noqa: E501
            raise ValueError("Invalid value for `is_match_query_string`, must not be `None`")  # noqa: E501

        self._is_match_query_string = is_match_query_string

    @property
    def is_pattern(self):
        """Gets the is_pattern of this UrlMapping.  # noqa: E501

        Whether the `routePrefix` should match based on pattern.  # noqa: E501

        :return: The is_pattern of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_pattern

    @is_pattern.setter
    def is_pattern(self, is_pattern):
        """Sets the is_pattern of this UrlMapping.

        Whether the `routePrefix` should match based on pattern.  # noqa: E501

        :param is_pattern: The is_pattern of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_pattern is None:  # noqa: E501
            raise ValueError("Invalid value for `is_pattern`, must not be `None`")  # noqa: E501

        self._is_pattern = is_pattern

    @property
    def is_trailing_slash_optional(self):
        """Gets the is_trailing_slash_optional of this UrlMapping.  # noqa: E501

        Whether a trailing slash will be ignored.  # noqa: E501

        :return: The is_trailing_slash_optional of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_trailing_slash_optional

    @is_trailing_slash_optional.setter
    def is_trailing_slash_optional(self, is_trailing_slash_optional):
        """Sets the is_trailing_slash_optional of this UrlMapping.

        Whether a trailing slash will be ignored.  # noqa: E501

        :param is_trailing_slash_optional: The is_trailing_slash_optional of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_trailing_slash_optional is None:  # noqa: E501
            raise ValueError("Invalid value for `is_trailing_slash_optional`, must not be `None`")  # noqa: E501

        self._is_trailing_slash_optional = is_trailing_slash_optional

    @property
    def is_protocol_agnostic(self):
        """Gets the is_protocol_agnostic of this UrlMapping.  # noqa: E501

        Whether the `routePrefix` should match both HTTP and HTTPS protocols.  # noqa: E501

        :return: The is_protocol_agnostic of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._is_protocol_agnostic

    @is_protocol_agnostic.setter
    def is_protocol_agnostic(self, is_protocol_agnostic):
        """Sets the is_protocol_agnostic of this UrlMapping.

        Whether the `routePrefix` should match both HTTP and HTTPS protocols.  # noqa: E501

        :param is_protocol_agnostic: The is_protocol_agnostic of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_protocol_agnostic is None:  # noqa: E501
            raise ValueError("Invalid value for `is_protocol_agnostic`, must not be `None`")  # noqa: E501

        self._is_protocol_agnostic = is_protocol_agnostic

    @property
    def name(self):
        """Gets the name of this UrlMapping.  # noqa: E501


        :return: The name of this UrlMapping.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UrlMapping.


        :param name: The name of this UrlMapping.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def precedence(self):
        """Gets the precedence of this UrlMapping.  # noqa: E501

        Used to prioritize URL redirection. If a given URL matches more than one redirect, the one with the **lower** precedence will be used.  # noqa: E501

        :return: The precedence of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._precedence

    @precedence.setter
    def precedence(self, precedence):
        """Sets the precedence of this UrlMapping.

        Used to prioritize URL redirection. If a given URL matches more than one redirect, the one with the **lower** precedence will be used.  # noqa: E501

        :param precedence: The precedence of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and precedence is None:  # noqa: E501
            raise ValueError("Invalid value for `precedence`, must not be `None`")  # noqa: E501

        self._precedence = precedence

    @property
    def deleted_at(self):
        """Gets the deleted_at of this UrlMapping.  # noqa: E501


        :return: The deleted_at of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this UrlMapping.


        :param deleted_at: The deleted_at of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and deleted_at is None:  # noqa: E501
            raise ValueError("Invalid value for `deleted_at`, must not be `None`")  # noqa: E501

        self._deleted_at = deleted_at

    @property
    def note(self):
        """Gets the note of this UrlMapping.  # noqa: E501


        :return: The note of this UrlMapping.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this UrlMapping.


        :param note: The note of this UrlMapping.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and note is None:  # noqa: E501
            raise ValueError("Invalid value for `note`, must not be `None`")  # noqa: E501

        self._note = note

    @property
    def label(self):
        """Gets the label of this UrlMapping.  # noqa: E501


        :return: The label of this UrlMapping.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this UrlMapping.


        :param label: The label of this UrlMapping.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and label is None:  # noqa: E501
            raise ValueError("Invalid value for `label`, must not be `None`")  # noqa: E501

        self._label = label

    @property
    def internally_created(self):
        """Gets the internally_created of this UrlMapping.  # noqa: E501


        :return: The internally_created of this UrlMapping.  # noqa: E501
        :rtype: bool
        """
        return self._internally_created

    @internally_created.setter
    def internally_created(self, internally_created):
        """Sets the internally_created of this UrlMapping.


        :param internally_created: The internally_created of this UrlMapping.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and internally_created is None:  # noqa: E501
            raise ValueError("Invalid value for `internally_created`, must not be `None`")  # noqa: E501

        self._internally_created = internally_created

    @property
    def cos_object_type(self):
        """Gets the cos_object_type of this UrlMapping.  # noqa: E501


        :return: The cos_object_type of this UrlMapping.  # noqa: E501
        :rtype: str
        """
        return self._cos_object_type

    @cos_object_type.setter
    def cos_object_type(self, cos_object_type):
        """Sets the cos_object_type of this UrlMapping.


        :param cos_object_type: The cos_object_type of this UrlMapping.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and cos_object_type is None:  # noqa: E501
            raise ValueError("Invalid value for `cos_object_type`, must not be `None`")  # noqa: E501
        allowed_values = ["CONTENT", "EXTENSION_RESOURCE", "LAYOUT", "CUSTOM_WIDGET", "WIDGET", "FORM", "PLACEMENT", "IMAGE", "DOMAIN_SETTINGS", "SITE_SETTINGS", "EMAIL_ADDRESS", "WORKFLOW", "HUBDB_TABLE", "REDIRECT_URL", "DESIGN_FOLDER", "SITE_MAP", "DOMAIN", "BLOG", "FILE", "FOLDER", "SITE_MENU", "THEME", "CONTENT_GROUP", "FOLLOW_ME", "KNOWLEDGE_BASE", "LIST_MEMBERSHIP", "CONTACT_MEMBERSHIP", "PASSWORD_PROTECTED", "UNRESTRICTED_ACCESS", "MARKETPLACE_LISTING", "LAYOUT_SECTION", "THEME_SETTINGS", "VIDEO_PLAYER", "URL_MAPPING", "KNOWLEDGE_CATEGORY", "KNOWLEDGE_HOMEPAGE_CATEGORY", "RAW_ASSET", "GLOBAL_CONTENT", "HUBDB_TABLE_ROW", "BLOG_AUTHOR", "SERVERLESS_FUNCTION", "KNOWLEDGE_CATEGORY_TRANSLATION"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and cos_object_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `cos_object_type` ({0}), must be one of {1}"  # noqa: E501
                .format(cos_object_type, allowed_values)
            )

        self._cos_object_type = cos_object_type

    @property
    def cdn_purge_embargo_time(self):
        """Gets the cdn_purge_embargo_time of this UrlMapping.  # noqa: E501


        :return: The cdn_purge_embargo_time of this UrlMapping.  # noqa: E501
        :rtype: int
        """
        return self._cdn_purge_embargo_time

    @cdn_purge_embargo_time.setter
    def cdn_purge_embargo_time(self, cdn_purge_embargo_time):
        """Sets the cdn_purge_embargo_time of this UrlMapping.


        :param cdn_purge_embargo_time: The cdn_purge_embargo_time of this UrlMapping.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and cdn_purge_embargo_time is None:  # noqa: E501
            raise ValueError("Invalid value for `cdn_purge_embargo_time`, must not be `None`")  # noqa: E501

        self._cdn_purge_embargo_time = cdn_purge_embargo_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UrlMapping):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UrlMapping):
            return True

        return self.to_dict() != other.to_dict()
