# coding: utf-8

"""
    Schemas

    The CRM uses schemas to define how custom objects should store and represent information in the HubSpot CRM. Schemas define details about an object's type, properties, and associations. The schema can be uniquely identified by its **object type ID**.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.schemas.configuration import Configuration


class ObjectTypeDefinition(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'labels': 'ObjectTypeDefinitionLabels',
        'required_properties': 'list[str]',
        'searchable_properties': 'list[str]',
        'primary_display_property': 'str',
        'secondary_display_properties': 'list[str]',
        'id': 'str',
        'fully_qualified_name': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'object_type_id': 'str',
        'name': 'str',
        'portal_id': 'int'
    }

    attribute_map = {
        'labels': 'labels',
        'required_properties': 'requiredProperties',
        'searchable_properties': 'searchableProperties',
        'primary_display_property': 'primaryDisplayProperty',
        'secondary_display_properties': 'secondaryDisplayProperties',
        'id': 'id',
        'fully_qualified_name': 'fullyQualifiedName',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'object_type_id': 'objectTypeId',
        'name': 'name',
        'portal_id': 'portalId'
    }

    def __init__(self, labels=None, required_properties=None, searchable_properties=None, primary_display_property=None, secondary_display_properties=None, id=None, fully_qualified_name=None, created_at=None, updated_at=None, object_type_id=None, name=None, portal_id=None, local_vars_configuration=None):  # noqa: E501
        """ObjectTypeDefinition - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._labels = None
        self._required_properties = None
        self._searchable_properties = None
        self._primary_display_property = None
        self._secondary_display_properties = None
        self._id = None
        self._fully_qualified_name = None
        self._created_at = None
        self._updated_at = None
        self._object_type_id = None
        self._name = None
        self._portal_id = None
        self.discriminator = None

        self.labels = labels
        self.required_properties = required_properties
        self.searchable_properties = searchable_properties
        if primary_display_property is not None:
            self.primary_display_property = primary_display_property
        self.secondary_display_properties = secondary_display_properties
        self.id = id
        self.fully_qualified_name = fully_qualified_name
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        self.object_type_id = object_type_id
        self.name = name
        if portal_id is not None:
            self.portal_id = portal_id

    @property
    def labels(self):
        """Gets the labels of this ObjectTypeDefinition.  # noqa: E501


        :return: The labels of this ObjectTypeDefinition.  # noqa: E501
        :rtype: ObjectTypeDefinitionLabels
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ObjectTypeDefinition.


        :param labels: The labels of this ObjectTypeDefinition.  # noqa: E501
        :type: ObjectTypeDefinitionLabels
        """
        if self.local_vars_configuration.client_side_validation and labels is None:  # noqa: E501
            raise ValueError("Invalid value for `labels`, must not be `None`")  # noqa: E501

        self._labels = labels

    @property
    def required_properties(self):
        """Gets the required_properties of this ObjectTypeDefinition.  # noqa: E501

        The names of properties that should be **required** when creating an object of this type.  # noqa: E501

        :return: The required_properties of this ObjectTypeDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._required_properties

    @required_properties.setter
    def required_properties(self, required_properties):
        """Sets the required_properties of this ObjectTypeDefinition.

        The names of properties that should be **required** when creating an object of this type.  # noqa: E501

        :param required_properties: The required_properties of this ObjectTypeDefinition.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and required_properties is None:  # noqa: E501
            raise ValueError("Invalid value for `required_properties`, must not be `None`")  # noqa: E501

        self._required_properties = required_properties

    @property
    def searchable_properties(self):
        """Gets the searchable_properties of this ObjectTypeDefinition.  # noqa: E501

        Names of properties that will be indexed for this object type in by HubSpot's product search.  # noqa: E501

        :return: The searchable_properties of this ObjectTypeDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._searchable_properties

    @searchable_properties.setter
    def searchable_properties(self, searchable_properties):
        """Sets the searchable_properties of this ObjectTypeDefinition.

        Names of properties that will be indexed for this object type in by HubSpot's product search.  # noqa: E501

        :param searchable_properties: The searchable_properties of this ObjectTypeDefinition.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and searchable_properties is None:  # noqa: E501
            raise ValueError("Invalid value for `searchable_properties`, must not be `None`")  # noqa: E501

        self._searchable_properties = searchable_properties

    @property
    def primary_display_property(self):
        """Gets the primary_display_property of this ObjectTypeDefinition.  # noqa: E501

        The name of the primary property for this object. This will be displayed as primary on the HubSpot record page for this object type.  # noqa: E501

        :return: The primary_display_property of this ObjectTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._primary_display_property

    @primary_display_property.setter
    def primary_display_property(self, primary_display_property):
        """Sets the primary_display_property of this ObjectTypeDefinition.

        The name of the primary property for this object. This will be displayed as primary on the HubSpot record page for this object type.  # noqa: E501

        :param primary_display_property: The primary_display_property of this ObjectTypeDefinition.  # noqa: E501
        :type: str
        """

        self._primary_display_property = primary_display_property

    @property
    def secondary_display_properties(self):
        """Gets the secondary_display_properties of this ObjectTypeDefinition.  # noqa: E501

        The names of secondary properties for this object. These will be displayed as secondary on the HubSpot record page for this object type.  # noqa: E501

        :return: The secondary_display_properties of this ObjectTypeDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._secondary_display_properties

    @secondary_display_properties.setter
    def secondary_display_properties(self, secondary_display_properties):
        """Sets the secondary_display_properties of this ObjectTypeDefinition.

        The names of secondary properties for this object. These will be displayed as secondary on the HubSpot record page for this object type.  # noqa: E501

        :param secondary_display_properties: The secondary_display_properties of this ObjectTypeDefinition.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and secondary_display_properties is None:  # noqa: E501
            raise ValueError("Invalid value for `secondary_display_properties`, must not be `None`")  # noqa: E501

        self._secondary_display_properties = secondary_display_properties

    @property
    def id(self):
        """Gets the id of this ObjectTypeDefinition.  # noqa: E501

        A unique ID for this object type. Will be defined as {meta-type}-{unique ID}.  # noqa: E501

        :return: The id of this ObjectTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ObjectTypeDefinition.

        A unique ID for this object type. Will be defined as {meta-type}-{unique ID}.  # noqa: E501

        :param id: The id of this ObjectTypeDefinition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def fully_qualified_name(self):
        """Gets the fully_qualified_name of this ObjectTypeDefinition.  # noqa: E501


        :return: The fully_qualified_name of this ObjectTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._fully_qualified_name

    @fully_qualified_name.setter
    def fully_qualified_name(self, fully_qualified_name):
        """Sets the fully_qualified_name of this ObjectTypeDefinition.


        :param fully_qualified_name: The fully_qualified_name of this ObjectTypeDefinition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and fully_qualified_name is None:  # noqa: E501
            raise ValueError("Invalid value for `fully_qualified_name`, must not be `None`")  # noqa: E501

        self._fully_qualified_name = fully_qualified_name

    @property
    def created_at(self):
        """Gets the created_at of this ObjectTypeDefinition.  # noqa: E501

        When the object type was created.  # noqa: E501

        :return: The created_at of this ObjectTypeDefinition.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ObjectTypeDefinition.

        When the object type was created.  # noqa: E501

        :param created_at: The created_at of this ObjectTypeDefinition.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this ObjectTypeDefinition.  # noqa: E501

        When the object type was last updated.  # noqa: E501

        :return: The updated_at of this ObjectTypeDefinition.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ObjectTypeDefinition.

        When the object type was last updated.  # noqa: E501

        :param updated_at: The updated_at of this ObjectTypeDefinition.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def object_type_id(self):
        """Gets the object_type_id of this ObjectTypeDefinition.  # noqa: E501


        :return: The object_type_id of this ObjectTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._object_type_id

    @object_type_id.setter
    def object_type_id(self, object_type_id):
        """Sets the object_type_id of this ObjectTypeDefinition.


        :param object_type_id: The object_type_id of this ObjectTypeDefinition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and object_type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `object_type_id`, must not be `None`")  # noqa: E501

        self._object_type_id = object_type_id

    @property
    def name(self):
        """Gets the name of this ObjectTypeDefinition.  # noqa: E501

        A unique name for this object. For internal use only.  # noqa: E501

        :return: The name of this ObjectTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ObjectTypeDefinition.

        A unique name for this object. For internal use only.  # noqa: E501

        :param name: The name of this ObjectTypeDefinition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def portal_id(self):
        """Gets the portal_id of this ObjectTypeDefinition.  # noqa: E501

        The ID of the account that this object type is specific to.  # noqa: E501

        :return: The portal_id of this ObjectTypeDefinition.  # noqa: E501
        :rtype: int
        """
        return self._portal_id

    @portal_id.setter
    def portal_id(self, portal_id):
        """Sets the portal_id of this ObjectTypeDefinition.

        The ID of the account that this object type is specific to.  # noqa: E501

        :param portal_id: The portal_id of this ObjectTypeDefinition.  # noqa: E501
        :type: int
        """

        self._portal_id = portal_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ObjectTypeDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ObjectTypeDefinition):
            return True

        return self.to_dict() != other.to_dict()
