# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class EntityEdge(UniversalBaseModel):
    attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional attributes of the edge. Dependent on edge types
    """

    created_at: str = pydantic.Field()
    """
    Creation time of the edge
    """

    episodes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of episode ids that reference these entity edges
    """

    expired_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Datetime of when the node was invalidated
    """

    fact: str = pydantic.Field()
    """
    Fact representing the edge and nodes that it connects
    """

    invalid_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Datetime of when the fact stopped being true
    """

    name: str = pydantic.Field()
    """
    Name of the edge, relation name
    """

    score: typing.Optional[float] = None
    source_node_uuid: str = pydantic.Field()
    """
    UUID of the source node
    """

    target_node_uuid: str = pydantic.Field()
    """
    UUID of the target node
    """

    uuid_: typing_extensions.Annotated[str, FieldMetadata(alias="uuid")] = pydantic.Field()
    """
    UUID of the edge
    """

    valid_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Datetime of when the fact became true
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
