"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemLocation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 */
class FileSystemLocation {
    /**
     * EFS file system provider.
     * @param props the EFS File System location property.
     */
    static efs(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_EfsFileSystemLocationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.efs);
            }
            throw error;
        }
        return new EfsFileSystemLocation(props);
    }
}
exports.FileSystemLocation = FileSystemLocation;
_a = JSII_RTTI_SYMBOL_1;
FileSystemLocation[_a] = { fqn: "@aws-cdk/aws-codebuild.FileSystemLocation", version: "1.184.1" };
/**
 * EfsFileSystemLocation definition for a CodeBuild project.
 */
class EfsFileSystemLocation {
    constructor(props) {
        this.props = props;
    }
    bind(_scope, _project) {
        return {
            location: {
                identifier: this.props.identifier,
                location: this.props.location,
                mountOptions: this.props.mountOptions,
                mountPoint: this.props.mountPoint,
                type: 'EFS',
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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