"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Lambdas/StartStateMachine/StartStateMachine.lambda.ts
var StartStateMachine_lambda_exports = {};
__export(StartStateMachine_lambda_exports, {
  handler: () => handler,
  onCreate: () => onCreate,
  onDelete: () => onDelete,
  onUpdate: () => onUpdate
});
module.exports = __toCommonJS(StartStateMachine_lambda_exports);
var import_client_sfn = require("@aws-sdk/client-sfn");
var region = process.env.AWS_REGION;
var sfnClient = new import_client_sfn.SFNClient({ region });
var handler = async (event, context) => {
  console.log("Lambda is invoked with:" + JSON.stringify(event));
  console.log("Context is invoked with:" + JSON.stringify(context));
  console.log("Lambda is invoked with:" + JSON.stringify(event));
  const physicalResourceId = event.ResourceProperties.PhysicalResourceId;
  let response = {
    Status: "SUCCESS",
    Reason: "See the details in CloudWatch Log Stream: " + context.logStreamName,
    PhysicalResourceId: physicalResourceId,
    StackId: event.StackId,
    RequestId: event.RequestId,
    LogicalResourceId: event.LogicalResourceId
  };
  switch (event.RequestType) {
    case "Create":
      response = await onCreate(response, event, context);
      break;
    case "Delete":
      response = await onDelete(response, event, context);
      break;
    case "Update":
      response = await onUpdate(response, event, context);
      break;
    default:
      throw new Error("Unknown Request Type of CloudFormation");
  }
  console.log("Return value:", JSON.stringify(response));
  return response;
};
async function onCreate(response, event, context) {
  try {
    console.log("We are in the Create Event");
    console.log("Context is invoked with:" + JSON.stringify(context));
    const stateMachineArn = event.ResourceProperties.StateMachineArn;
    const imagePipelineArn = event.ResourceProperties.ImagePipelineArn;
    const executionName = event.RequestId;
    await startExecution(stateMachineArn, executionName, imagePipelineArn);
  } catch (error) {
    if (error instanceof Error) {
      response.Reason = error.message;
    }
    response.Status = "FAILED";
    response.Data = { Result: error };
    return response;
  }
  return response;
}
async function onDelete(response, event, context) {
  try {
    console.log("We are in the Delete Event");
    console.log("Context is invoked with:" + JSON.stringify(context));
    console.log("Event is invoked with:" + JSON.stringify(event));
    response.Status = "SUCCESS";
  } catch (error) {
    if (error instanceof Error) {
      response.Reason = error.message;
    }
    response.Status = "FAILED";
    response.Data = { Result: error };
    return response;
  }
  return response;
}
async function onUpdate(response, event, context) {
  try {
    const executionName = event.RequestId;
    const imagePipelineArn = event.ResourceProperties.ImagePipelineArn;
    const stateMachineArn = event.ResourceProperties.StateMachineArn;
    const amiKmsId = event.ResourceProperties.AmiKmsId;
    const accounts = event.ResourceProperties.SharedAccountIds.split(",");
    console.log("Resource properties: " + JSON.stringify(event.ResourceProperties));
    console.log("Context is invoked with:" + JSON.stringify(context));
    console.log("State Machine ARN: " + stateMachineArn);
    console.log("Image Pipeline ARN: " + imagePipelineArn);
    console.log("Execution Name: " + executionName);
    console.log("Key Id: " + amiKmsId);
    console.log("Accounts: " + accounts);
    await startExecution(stateMachineArn, executionName, imagePipelineArn);
  } catch (error) {
    if (error instanceof Error) {
      response.Reason = error.message;
    }
    response.Status = "FAILED";
    response.Data = { Result: error };
    return response;
  }
  return response;
}
async function startExecution(stateMachineArn, executionName, imagePipelineArn) {
  const startExecutionCommand = new import_client_sfn.StartExecutionCommand({
    stateMachineArn,
    name: executionName,
    input: JSON.stringify({
      clientToken: executionName,
      imagePipelineArn
    })
  });
  await sfnClient.send(startExecutionCommand);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler,
  onCreate,
  onDelete,
  onUpdate
});
