import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteSubnetCidrReservationRequest, DeleteSubnetCidrReservationResult } from "../models/models_3";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteSubnetCidrReservationCommand}.
 */
export interface DeleteSubnetCidrReservationCommandInput extends DeleteSubnetCidrReservationRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteSubnetCidrReservationCommand}.
 */
export interface DeleteSubnetCidrReservationCommandOutput extends DeleteSubnetCidrReservationResult, __MetadataBearer {
}
declare const DeleteSubnetCidrReservationCommand_base: {
    new (input: DeleteSubnetCidrReservationCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteSubnetCidrReservationCommandInput, DeleteSubnetCidrReservationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteSubnetCidrReservationCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteSubnetCidrReservationCommandInput, DeleteSubnetCidrReservationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes a subnet CIDR reservation.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteSubnetCidrReservationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteSubnetCidrReservationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteSubnetCidrReservationRequest
 *   SubnetCidrReservationId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DeleteSubnetCidrReservationCommand(input);
 * const response = await client.send(command);
 * // { // DeleteSubnetCidrReservationResult
 * //   DeletedSubnetCidrReservation: { // SubnetCidrReservation
 * //     SubnetCidrReservationId: "STRING_VALUE",
 * //     SubnetId: "STRING_VALUE",
 * //     Cidr: "STRING_VALUE",
 * //     ReservationType: "prefix" || "explicit",
 * //     OwnerId: "STRING_VALUE",
 * //     Description: "STRING_VALUE",
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param DeleteSubnetCidrReservationCommandInput - {@link DeleteSubnetCidrReservationCommandInput}
 * @returns {@link DeleteSubnetCidrReservationCommandOutput}
 * @see {@link DeleteSubnetCidrReservationCommandInput} for command's `input` shape.
 * @see {@link DeleteSubnetCidrReservationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DeleteSubnetCidrReservationCommand extends DeleteSubnetCidrReservationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteSubnetCidrReservationRequest;
            output: DeleteSubnetCidrReservationResult;
        };
        sdk: {
            input: DeleteSubnetCidrReservationCommandInput;
            output: DeleteSubnetCidrReservationCommandOutput;
        };
    };
}
