import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DetachVpnGatewayRequest } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DetachVpnGatewayCommand}.
 */
export interface DetachVpnGatewayCommandInput extends DetachVpnGatewayRequest {
}
/**
 * @public
 *
 * The output of {@link DetachVpnGatewayCommand}.
 */
export interface DetachVpnGatewayCommandOutput extends __MetadataBearer {
}
declare const DetachVpnGatewayCommand_base: {
    new (input: DetachVpnGatewayCommandInput): import("@smithy/smithy-client").CommandImpl<DetachVpnGatewayCommandInput, DetachVpnGatewayCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DetachVpnGatewayCommandInput): import("@smithy/smithy-client").CommandImpl<DetachVpnGatewayCommandInput, DetachVpnGatewayCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Detaches a virtual private gateway from a VPC. You do this if you're planning to turn
 *             off the VPC and not use it anymore. You can confirm a virtual private gateway has been
 *             completely detached from a VPC by describing the virtual private gateway (any
 *             attachments to the virtual private gateway are also described).</p>
 *          <p>You must wait for the attachment's state to switch to <code>detached</code> before you
 *             can delete the VPC or attach a different VPC to the virtual private gateway.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DetachVpnGatewayCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DetachVpnGatewayCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DetachVpnGatewayRequest
 *   VpcId: "STRING_VALUE", // required
 *   VpnGatewayId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DetachVpnGatewayCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DetachVpnGatewayCommandInput - {@link DetachVpnGatewayCommandInput}
 * @returns {@link DetachVpnGatewayCommandOutput}
 * @see {@link DetachVpnGatewayCommandInput} for command's `input` shape.
 * @see {@link DetachVpnGatewayCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DetachVpnGatewayCommand extends DetachVpnGatewayCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DetachVpnGatewayRequest;
            output: {};
        };
        sdk: {
            input: DetachVpnGatewayCommandInput;
            output: DetachVpnGatewayCommandOutput;
        };
    };
}
