import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisableImageDeregistrationProtectionRequest, DisableImageDeregistrationProtectionResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DisableImageDeregistrationProtectionCommand}.
 */
export interface DisableImageDeregistrationProtectionCommandInput extends DisableImageDeregistrationProtectionRequest {
}
/**
 * @public
 *
 * The output of {@link DisableImageDeregistrationProtectionCommand}.
 */
export interface DisableImageDeregistrationProtectionCommandOutput extends DisableImageDeregistrationProtectionResult, __MetadataBearer {
}
declare const DisableImageDeregistrationProtectionCommand_base: {
    new (input: DisableImageDeregistrationProtectionCommandInput): import("@smithy/smithy-client").CommandImpl<DisableImageDeregistrationProtectionCommandInput, DisableImageDeregistrationProtectionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DisableImageDeregistrationProtectionCommandInput): import("@smithy/smithy-client").CommandImpl<DisableImageDeregistrationProtectionCommandInput, DisableImageDeregistrationProtectionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disables deregistration protection for an AMI. When deregistration protection is disabled,
 *       the AMI can be deregistered.</p>
 *          <p>If you chose to include a 24-hour cooldown period when you enabled deregistration
 *       protection for the AMI, then, when you disable deregistration protection, you won’t
 *       immediately be able to deregister the AMI.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deregistration-protection.html">Protect an Amazon EC2 AMI from
 *         deregistration</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisableImageDeregistrationProtectionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisableImageDeregistrationProtectionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DisableImageDeregistrationProtectionRequest
 *   ImageId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DisableImageDeregistrationProtectionCommand(input);
 * const response = await client.send(command);
 * // { // DisableImageDeregistrationProtectionResult
 * //   Return: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DisableImageDeregistrationProtectionCommandInput - {@link DisableImageDeregistrationProtectionCommandInput}
 * @returns {@link DisableImageDeregistrationProtectionCommandOutput}
 * @see {@link DisableImageDeregistrationProtectionCommandInput} for command's `input` shape.
 * @see {@link DisableImageDeregistrationProtectionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DisableImageDeregistrationProtectionCommand extends DisableImageDeregistrationProtectionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DisableImageDeregistrationProtectionRequest;
            output: DisableImageDeregistrationProtectionResult;
        };
        sdk: {
            input: DisableImageDeregistrationProtectionCommandInput;
            output: DisableImageDeregistrationProtectionCommandOutput;
        };
    };
}
