import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RestoreManagedPrefixListVersionRequest, RestoreManagedPrefixListVersionResult } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link RestoreManagedPrefixListVersionCommand}.
 */
export interface RestoreManagedPrefixListVersionCommandInput extends RestoreManagedPrefixListVersionRequest {
}
/**
 * @public
 *
 * The output of {@link RestoreManagedPrefixListVersionCommand}.
 */
export interface RestoreManagedPrefixListVersionCommandOutput extends RestoreManagedPrefixListVersionResult, __MetadataBearer {
}
declare const RestoreManagedPrefixListVersionCommand_base: {
    new (input: RestoreManagedPrefixListVersionCommandInput): import("@smithy/smithy-client").CommandImpl<RestoreManagedPrefixListVersionCommandInput, RestoreManagedPrefixListVersionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: RestoreManagedPrefixListVersionCommandInput): import("@smithy/smithy-client").CommandImpl<RestoreManagedPrefixListVersionCommandInput, RestoreManagedPrefixListVersionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RestoreManagedPrefixListVersionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RestoreManagedPrefixListVersionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // RestoreManagedPrefixListVersionRequest
 *   DryRun: true || false,
 *   PrefixListId: "STRING_VALUE", // required
 *   PreviousVersion: Number("long"), // required
 *   CurrentVersion: Number("long"), // required
 * };
 * const command = new RestoreManagedPrefixListVersionCommand(input);
 * const response = await client.send(command);
 * // { // RestoreManagedPrefixListVersionResult
 * //   PrefixList: { // ManagedPrefixList
 * //     PrefixListId: "STRING_VALUE",
 * //     AddressFamily: "STRING_VALUE",
 * //     State: "create-in-progress" || "create-complete" || "create-failed" || "modify-in-progress" || "modify-complete" || "modify-failed" || "restore-in-progress" || "restore-complete" || "restore-failed" || "delete-in-progress" || "delete-complete" || "delete-failed",
 * //     StateMessage: "STRING_VALUE",
 * //     PrefixListArn: "STRING_VALUE",
 * //     PrefixListName: "STRING_VALUE",
 * //     MaxEntries: Number("int"),
 * //     Version: Number("long"),
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //     OwnerId: "STRING_VALUE",
 * //   },
 * // };
 *
 * ```
 *
 * @param RestoreManagedPrefixListVersionCommandInput - {@link RestoreManagedPrefixListVersionCommandInput}
 * @returns {@link RestoreManagedPrefixListVersionCommandOutput}
 * @see {@link RestoreManagedPrefixListVersionCommandInput} for command's `input` shape.
 * @see {@link RestoreManagedPrefixListVersionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class RestoreManagedPrefixListVersionCommand extends RestoreManagedPrefixListVersionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: RestoreManagedPrefixListVersionRequest;
            output: RestoreManagedPrefixListVersionResult;
        };
        sdk: {
            input: RestoreManagedPrefixListVersionCommandInput;
            output: RestoreManagedPrefixListVersionCommandOutput;
        };
    };
}
