import {
  ActiveInstance,
  AllocationState,
  AllowsMultipleInstanceTypes,
  AssociationStatus,
  AttachmentStatus,
  AutoPlacement,
  CapacityReservationFleetState,
  ClientVpnAuthorizationRuleStatus,
  CurrencyCodeValues,
  HostMaintenance,
  HostRecovery,
  IamInstanceProfile,
  IamInstanceProfileAssociation,
  InstanceEventWindow,
  Tag,
} from "./models_0";
import {
  _InstanceType,
  AmdSevSnpSpecification,
  AttributeValue,
  BlockDeviceMapping,
  CapacityReservation,
  CapacityReservationPreference,
  CapacityReservationTargetResponse,
  CapacityReservationTenancy,
  CarrierGateway,
  ClientVpnAuthenticationType,
  ClientVpnEndpointStatus,
  ClientVpnRouteStatus,
  CoipPool,
  CustomerGateway,
  DefaultTargetCapacityType,
  DestinationFileFormat,
  DhcpOptions,
  DiskImageFormat,
  Ec2InstanceConnectEndpoint,
  EgressOnlyInternetGateway,
  EndpointIpAddressType,
  ExportTask,
  FleetCapacityReservation,
  FleetCapacityReservationTenancy,
  FleetCapacityReservationUsageStrategy,
  FleetExcessCapacityTerminationPolicy,
  FleetInstanceMatchCriteria,
  FleetLaunchTemplateOverrides,
  FleetLaunchTemplateSpecification,
  FleetOnDemandAllocationStrategy,
  FleetReplacementStrategy,
  FleetType,
  HostnameType,
  InstanceBandwidthWeighting,
  InstanceLifecycle,
  LaunchTemplateAndOverridesResponse,
  LogDestinationType,
  OperatorResponse,
  Placement,
  PlatformValues,
  SpotAllocationStrategy,
  SpotInstanceInterruptionBehavior,
  TargetCapacityUnitType,
  TrafficIpAddressType,
  TrafficType,
  TransportProtocol,
} from "./models_1";
import {
  GroupIdentifier,
  InstanceIpv6Address,
  NetworkInterfaceStatus,
  StateReason,
} from "./models_2";
import {
  Filter,
  FleetStateCode,
  IdFormat,
  InstanceTagNotificationAttribute,
} from "./models_3";
export interface CapacityReservationInfo {
  InstanceType?: string | undefined;
  AvailabilityZone?: string | undefined;
  Tenancy?: CapacityReservationTenancy | undefined;
  AvailabilityZoneId?: string | undefined;
}
export declare const CapacityReservationBillingRequestStatus: {
  readonly accepted: "accepted";
  readonly cancelled: "cancelled";
  readonly expired: "expired";
  readonly pending: "pending";
  readonly rejected: "rejected";
  readonly revoked: "revoked";
};
export type CapacityReservationBillingRequestStatus =
  (typeof CapacityReservationBillingRequestStatus)[keyof typeof CapacityReservationBillingRequestStatus];
export interface CapacityReservationBillingRequest {
  CapacityReservationId?: string | undefined;
  RequestedBy?: string | undefined;
  UnusedReservationBillingOwnerId?: string | undefined;
  LastUpdateTime?: Date | undefined;
  Status?: CapacityReservationBillingRequestStatus | undefined;
  StatusMessage?: string | undefined;
  CapacityReservationInfo?: CapacityReservationInfo | undefined;
}
export interface DescribeCapacityReservationBillingRequestsResult {
  NextToken?: string | undefined;
  CapacityReservationBillingRequests?:
    | CapacityReservationBillingRequest[]
    | undefined;
}
export interface DescribeCapacityReservationFleetsRequest {
  CapacityReservationFleetIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CapacityReservationFleet {
  CapacityReservationFleetId?: string | undefined;
  CapacityReservationFleetArn?: string | undefined;
  State?: CapacityReservationFleetState | undefined;
  TotalTargetCapacity?: number | undefined;
  TotalFulfilledCapacity?: number | undefined;
  Tenancy?: FleetCapacityReservationTenancy | undefined;
  EndDate?: Date | undefined;
  CreateTime?: Date | undefined;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | undefined;
  AllocationStrategy?: string | undefined;
  InstanceTypeSpecifications?: FleetCapacityReservation[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeCapacityReservationFleetsResult {
  CapacityReservationFleets?: CapacityReservationFleet[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeCapacityReservationsRequest {
  CapacityReservationIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeCapacityReservationsResult {
  NextToken?: string | undefined;
  CapacityReservations?: CapacityReservation[] | undefined;
}
export interface DescribeCarrierGatewaysRequest {
  CarrierGatewayIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeCarrierGatewaysResult {
  CarrierGateways?: CarrierGateway[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClassicLinkInstancesRequest {
  DryRun?: boolean | undefined;
  InstanceIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ClassicLinkInstance {
  Groups?: GroupIdentifier[] | undefined;
  InstanceId?: string | undefined;
  Tags?: Tag[] | undefined;
  VpcId?: string | undefined;
}
export interface DescribeClassicLinkInstancesResult {
  Instances?: ClassicLinkInstance[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnAuthorizationRulesRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
}
export interface AuthorizationRule {
  ClientVpnEndpointId?: string | undefined;
  Description?: string | undefined;
  GroupId?: string | undefined;
  AccessAll?: boolean | undefined;
  DestinationCidr?: string | undefined;
  Status?: ClientVpnAuthorizationRuleStatus | undefined;
}
export interface DescribeClientVpnAuthorizationRulesResult {
  AuthorizationRules?: AuthorizationRule[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnConnectionsRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export declare const ClientVpnConnectionStatusCode: {
  readonly active: "active";
  readonly failed_to_terminate: "failed-to-terminate";
  readonly terminated: "terminated";
  readonly terminating: "terminating";
};
export type ClientVpnConnectionStatusCode =
  (typeof ClientVpnConnectionStatusCode)[keyof typeof ClientVpnConnectionStatusCode];
export interface ClientVpnConnectionStatus {
  Code?: ClientVpnConnectionStatusCode | undefined;
  Message?: string | undefined;
}
export interface ClientVpnConnection {
  ClientVpnEndpointId?: string | undefined;
  Timestamp?: string | undefined;
  ConnectionId?: string | undefined;
  Username?: string | undefined;
  ConnectionEstablishedTime?: string | undefined;
  IngressBytes?: string | undefined;
  EgressBytes?: string | undefined;
  IngressPackets?: string | undefined;
  EgressPackets?: string | undefined;
  ClientIp?: string | undefined;
  ClientIpv6Address?: string | undefined;
  CommonName?: string | undefined;
  Status?: ClientVpnConnectionStatus | undefined;
  ConnectionEndTime?: string | undefined;
  PostureComplianceStatuses?: string[] | undefined;
}
export interface DescribeClientVpnConnectionsResult {
  Connections?: ClientVpnConnection[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnEndpointsRequest {
  ClientVpnEndpointIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const AssociatedNetworkType: {
  readonly vpc: "vpc";
};
export type AssociatedNetworkType =
  (typeof AssociatedNetworkType)[keyof typeof AssociatedNetworkType];
export interface AssociatedTargetNetwork {
  NetworkId?: string | undefined;
  NetworkType?: AssociatedNetworkType | undefined;
}
export interface DirectoryServiceAuthentication {
  DirectoryId?: string | undefined;
}
export interface FederatedAuthentication {
  SamlProviderArn?: string | undefined;
  SelfServiceSamlProviderArn?: string | undefined;
}
export interface CertificateAuthentication {
  ClientRootCertificateChain?: string | undefined;
}
export interface ClientVpnAuthentication {
  Type?: ClientVpnAuthenticationType | undefined;
  ActiveDirectory?: DirectoryServiceAuthentication | undefined;
  MutualAuthentication?: CertificateAuthentication | undefined;
  FederatedAuthentication?: FederatedAuthentication | undefined;
}
export declare const ClientVpnEndpointAttributeStatusCode: {
  readonly applied: "applied";
  readonly applying: "applying";
};
export type ClientVpnEndpointAttributeStatusCode =
  (typeof ClientVpnEndpointAttributeStatusCode)[keyof typeof ClientVpnEndpointAttributeStatusCode];
export interface ClientVpnEndpointAttributeStatus {
  Code?: ClientVpnEndpointAttributeStatusCode | undefined;
  Message?: string | undefined;
}
export interface ClientConnectResponseOptions {
  Enabled?: boolean | undefined;
  LambdaFunctionArn?: string | undefined;
  Status?: ClientVpnEndpointAttributeStatus | undefined;
}
export interface ClientLoginBannerResponseOptions {
  Enabled?: boolean | undefined;
  BannerText?: string | undefined;
}
export interface ClientRouteEnforcementResponseOptions {
  Enforced?: boolean | undefined;
}
export interface ConnectionLogResponseOptions {
  Enabled?: boolean | undefined;
  CloudwatchLogGroup?: string | undefined;
  CloudwatchLogStream?: string | undefined;
}
export declare const VpnProtocol: {
  readonly openvpn: "openvpn";
};
export type VpnProtocol = (typeof VpnProtocol)[keyof typeof VpnProtocol];
export interface ClientVpnEndpoint {
  ClientVpnEndpointId?: string | undefined;
  Description?: string | undefined;
  Status?: ClientVpnEndpointStatus | undefined;
  CreationTime?: string | undefined;
  DeletionTime?: string | undefined;
  DnsName?: string | undefined;
  ClientCidrBlock?: string | undefined;
  DnsServers?: string[] | undefined;
  SplitTunnel?: boolean | undefined;
  VpnProtocol?: VpnProtocol | undefined;
  TransportProtocol?: TransportProtocol | undefined;
  VpnPort?: number | undefined;
  AssociatedTargetNetworks?: AssociatedTargetNetwork[] | undefined;
  ServerCertificateArn?: string | undefined;
  AuthenticationOptions?: ClientVpnAuthentication[] | undefined;
  ConnectionLogOptions?: ConnectionLogResponseOptions | undefined;
  Tags?: Tag[] | undefined;
  SecurityGroupIds?: string[] | undefined;
  VpcId?: string | undefined;
  SelfServicePortalUrl?: string | undefined;
  ClientConnectOptions?: ClientConnectResponseOptions | undefined;
  SessionTimeoutHours?: number | undefined;
  ClientLoginBannerOptions?: ClientLoginBannerResponseOptions | undefined;
  ClientRouteEnforcementOptions?:
    | ClientRouteEnforcementResponseOptions
    | undefined;
  DisconnectOnSessionTimeout?: boolean | undefined;
  EndpointIpAddressType?: EndpointIpAddressType | undefined;
  TrafficIpAddressType?: TrafficIpAddressType | undefined;
}
export interface DescribeClientVpnEndpointsResult {
  ClientVpnEndpoints?: ClientVpnEndpoint[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnRoutesRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ClientVpnRoute {
  ClientVpnEndpointId?: string | undefined;
  DestinationCidr?: string | undefined;
  TargetSubnet?: string | undefined;
  Type?: string | undefined;
  Origin?: string | undefined;
  Status?: ClientVpnRouteStatus | undefined;
  Description?: string | undefined;
}
export interface DescribeClientVpnRoutesResult {
  Routes?: ClientVpnRoute[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnTargetNetworksRequest {
  ClientVpnEndpointId: string | undefined;
  AssociationIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface TargetNetwork {
  AssociationId?: string | undefined;
  VpcId?: string | undefined;
  TargetNetworkId?: string | undefined;
  ClientVpnEndpointId?: string | undefined;
  Status?: AssociationStatus | undefined;
  SecurityGroups?: string[] | undefined;
}
export interface DescribeClientVpnTargetNetworksResult {
  ClientVpnTargetNetworks?: TargetNetwork[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeCoipPoolsRequest {
  PoolIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeCoipPoolsResult {
  CoipPools?: CoipPool[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeConversionTasksRequest {
  DryRun?: boolean | undefined;
  ConversionTaskIds?: string[] | undefined;
}
export interface DiskImageDescription {
  Checksum?: string | undefined;
  Format?: DiskImageFormat | undefined;
  ImportManifestUrl?: string | undefined;
  Size?: number | undefined;
}
export interface DiskImageVolumeDescription {
  Id?: string | undefined;
  Size?: number | undefined;
}
export interface ImportInstanceVolumeDetailItem {
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  BytesConverted?: number | undefined;
  Description?: string | undefined;
  Image?: DiskImageDescription | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  Volume?: DiskImageVolumeDescription | undefined;
}
export interface ImportInstanceTaskDetails {
  Description?: string | undefined;
  InstanceId?: string | undefined;
  Platform?: PlatformValues | undefined;
  Volumes?: ImportInstanceVolumeDetailItem[] | undefined;
}
export interface ImportVolumeTaskDetails {
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  BytesConverted?: number | undefined;
  Description?: string | undefined;
  Image?: DiskImageDescription | undefined;
  Volume?: DiskImageVolumeDescription | undefined;
}
export declare const ConversionTaskState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly cancelling: "cancelling";
  readonly completed: "completed";
};
export type ConversionTaskState =
  (typeof ConversionTaskState)[keyof typeof ConversionTaskState];
export interface ConversionTask {
  ConversionTaskId?: string | undefined;
  ExpirationTime?: string | undefined;
  ImportInstance?: ImportInstanceTaskDetails | undefined;
  ImportVolume?: ImportVolumeTaskDetails | undefined;
  State?: ConversionTaskState | undefined;
  StatusMessage?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeConversionTasksResult {
  ConversionTasks?: ConversionTask[] | undefined;
}
export interface DescribeCustomerGatewaysRequest {
  CustomerGatewayIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeCustomerGatewaysResult {
  CustomerGateways?: CustomerGateway[] | undefined;
}
export interface DescribeDeclarativePoliciesReportsRequest {
  DryRun?: boolean | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  ReportIds?: string[] | undefined;
}
export declare const ReportState: {
  readonly cancelled: "cancelled";
  readonly complete: "complete";
  readonly error: "error";
  readonly running: "running";
};
export type ReportState = (typeof ReportState)[keyof typeof ReportState];
export interface DeclarativePoliciesReport {
  ReportId?: string | undefined;
  S3Bucket?: string | undefined;
  S3Prefix?: string | undefined;
  TargetId?: string | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  Status?: ReportState | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeDeclarativePoliciesReportsResult {
  NextToken?: string | undefined;
  Reports?: DeclarativePoliciesReport[] | undefined;
}
export interface DescribeDhcpOptionsRequest {
  DhcpOptionsIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
}
export interface DescribeDhcpOptionsResult {
  NextToken?: string | undefined;
  DhcpOptions?: DhcpOptions[] | undefined;
}
export interface DescribeEgressOnlyInternetGatewaysRequest {
  DryRun?: boolean | undefined;
  EgressOnlyInternetGatewayIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
}
export interface DescribeEgressOnlyInternetGatewaysResult {
  EgressOnlyInternetGateways?: EgressOnlyInternetGateway[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeElasticGpusRequest {
  ElasticGpuIds?: string[] | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export declare const ElasticGpuStatus: {
  readonly Impaired: "IMPAIRED";
  readonly Ok: "OK";
};
export type ElasticGpuStatus =
  (typeof ElasticGpuStatus)[keyof typeof ElasticGpuStatus];
export interface ElasticGpuHealth {
  Status?: ElasticGpuStatus | undefined;
}
export declare const ElasticGpuState: {
  readonly Attached: "ATTACHED";
};
export type ElasticGpuState =
  (typeof ElasticGpuState)[keyof typeof ElasticGpuState];
export interface ElasticGpus {
  ElasticGpuId?: string | undefined;
  AvailabilityZone?: string | undefined;
  ElasticGpuType?: string | undefined;
  ElasticGpuHealth?: ElasticGpuHealth | undefined;
  ElasticGpuState?: ElasticGpuState | undefined;
  InstanceId?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeElasticGpusResult {
  ElasticGpuSet?: ElasticGpus[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeExportImageTasksRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  ExportImageTaskIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ExportTaskS3Location {
  S3Bucket?: string | undefined;
  S3Prefix?: string | undefined;
}
export interface ExportImageTask {
  Description?: string | undefined;
  ExportImageTaskId?: string | undefined;
  ImageId?: string | undefined;
  Progress?: string | undefined;
  S3ExportLocation?: ExportTaskS3Location | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeExportImageTasksResult {
  ExportImageTasks?: ExportImageTask[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeExportTasksRequest {
  Filters?: Filter[] | undefined;
  ExportTaskIds?: string[] | undefined;
}
export interface DescribeExportTasksResult {
  ExportTasks?: ExportTask[] | undefined;
}
export interface DescribeFastLaunchImagesRequest {
  ImageIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface FastLaunchLaunchTemplateSpecificationResponse {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  Version?: string | undefined;
}
export declare const FastLaunchResourceType: {
  readonly SNAPSHOT: "snapshot";
};
export type FastLaunchResourceType =
  (typeof FastLaunchResourceType)[keyof typeof FastLaunchResourceType];
export interface FastLaunchSnapshotConfigurationResponse {
  TargetResourceCount?: number | undefined;
}
export declare const FastLaunchStateCode: {
  readonly disabling: "disabling";
  readonly disabling_failed: "disabling-failed";
  readonly enabled: "enabled";
  readonly enabled_failed: "enabled-failed";
  readonly enabling: "enabling";
  readonly enabling_failed: "enabling-failed";
};
export type FastLaunchStateCode =
  (typeof FastLaunchStateCode)[keyof typeof FastLaunchStateCode];
export interface DescribeFastLaunchImagesSuccessItem {
  ImageId?: string | undefined;
  ResourceType?: FastLaunchResourceType | undefined;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse | undefined;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse | undefined;
  MaxParallelLaunches?: number | undefined;
  OwnerId?: string | undefined;
  State?: FastLaunchStateCode | undefined;
  StateTransitionReason?: string | undefined;
  StateTransitionTime?: Date | undefined;
}
export interface DescribeFastLaunchImagesResult {
  FastLaunchImages?: DescribeFastLaunchImagesSuccessItem[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeFastSnapshotRestoresRequest {
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const FastSnapshotRestoreStateCode: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly enabling: "enabling";
  readonly optimizing: "optimizing";
};
export type FastSnapshotRestoreStateCode =
  (typeof FastSnapshotRestoreStateCode)[keyof typeof FastSnapshotRestoreStateCode];
export interface DescribeFastSnapshotRestoreSuccessItem {
  SnapshotId?: string | undefined;
  AvailabilityZone?: string | undefined;
  State?: FastSnapshotRestoreStateCode | undefined;
  StateTransitionReason?: string | undefined;
  OwnerId?: string | undefined;
  OwnerAlias?: string | undefined;
  EnablingTime?: Date | undefined;
  OptimizingTime?: Date | undefined;
  EnabledTime?: Date | undefined;
  DisablingTime?: Date | undefined;
  DisabledTime?: Date | undefined;
}
export interface DescribeFastSnapshotRestoresResult {
  FastSnapshotRestores?: DescribeFastSnapshotRestoreSuccessItem[] | undefined;
  NextToken?: string | undefined;
}
export declare const FleetEventType: {
  readonly FLEET_CHANGE: "fleet-change";
  readonly INSTANCE_CHANGE: "instance-change";
  readonly SERVICE_ERROR: "service-error";
};
export type FleetEventType =
  (typeof FleetEventType)[keyof typeof FleetEventType];
export interface DescribeFleetHistoryRequest {
  DryRun?: boolean | undefined;
  EventType?: FleetEventType | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  FleetId: string | undefined;
  StartTime: Date | undefined;
}
export interface EventInformation {
  EventDescription?: string | undefined;
  EventSubType?: string | undefined;
  InstanceId?: string | undefined;
}
export interface HistoryRecordEntry {
  EventInformation?: EventInformation | undefined;
  EventType?: FleetEventType | undefined;
  Timestamp?: Date | undefined;
}
export interface DescribeFleetHistoryResult {
  HistoryRecords?: HistoryRecordEntry[] | undefined;
  LastEvaluatedTime?: Date | undefined;
  NextToken?: string | undefined;
  FleetId?: string | undefined;
  StartTime?: Date | undefined;
}
export interface DescribeFleetInstancesRequest {
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  FleetId: string | undefined;
  Filters?: Filter[] | undefined;
}
export interface DescribeFleetInstancesResult {
  ActiveInstances?: ActiveInstance[] | undefined;
  NextToken?: string | undefined;
  FleetId?: string | undefined;
}
export interface DescribeFleetsRequest {
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  FleetIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
}
export declare const FleetActivityStatus: {
  readonly ERROR: "error";
  readonly FULFILLED: "fulfilled";
  readonly PENDING_FULFILLMENT: "pending_fulfillment";
  readonly PENDING_TERMINATION: "pending_termination";
};
export type FleetActivityStatus =
  (typeof FleetActivityStatus)[keyof typeof FleetActivityStatus];
export interface DescribeFleetError {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse | undefined;
  Lifecycle?: InstanceLifecycle | undefined;
  ErrorCode?: string | undefined;
  ErrorMessage?: string | undefined;
}
export interface DescribeFleetsInstances {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse | undefined;
  Lifecycle?: InstanceLifecycle | undefined;
  InstanceIds?: string[] | undefined;
  InstanceType?: _InstanceType | undefined;
  Platform?: PlatformValues | undefined;
}
export interface FleetLaunchTemplateConfig {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification | undefined;
  Overrides?: FleetLaunchTemplateOverrides[] | undefined;
}
export interface CapacityReservationOptions {
  UsageStrategy?: FleetCapacityReservationUsageStrategy | undefined;
}
export interface OnDemandOptions {
  AllocationStrategy?: FleetOnDemandAllocationStrategy | undefined;
  CapacityReservationOptions?: CapacityReservationOptions | undefined;
  SingleInstanceType?: boolean | undefined;
  SingleAvailabilityZone?: boolean | undefined;
  MinTargetCapacity?: number | undefined;
  MaxTotalPrice?: string | undefined;
}
export interface FleetSpotCapacityRebalance {
  ReplacementStrategy?: FleetReplacementStrategy | undefined;
  TerminationDelay?: number | undefined;
}
export interface FleetSpotMaintenanceStrategies {
  CapacityRebalance?: FleetSpotCapacityRebalance | undefined;
}
export interface SpotOptions {
  AllocationStrategy?: SpotAllocationStrategy | undefined;
  MaintenanceStrategies?: FleetSpotMaintenanceStrategies | undefined;
  InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior | undefined;
  InstancePoolsToUseCount?: number | undefined;
  SingleInstanceType?: boolean | undefined;
  SingleAvailabilityZone?: boolean | undefined;
  MinTargetCapacity?: number | undefined;
  MaxTotalPrice?: string | undefined;
}
export interface TargetCapacitySpecification {
  TotalTargetCapacity?: number | undefined;
  OnDemandTargetCapacity?: number | undefined;
  SpotTargetCapacity?: number | undefined;
  DefaultTargetCapacityType?: DefaultTargetCapacityType | undefined;
  TargetCapacityUnitType?: TargetCapacityUnitType | undefined;
}
export interface FleetData {
  ActivityStatus?: FleetActivityStatus | undefined;
  CreateTime?: Date | undefined;
  FleetId?: string | undefined;
  FleetState?: FleetStateCode | undefined;
  ClientToken?: string | undefined;
  ExcessCapacityTerminationPolicy?:
    | FleetExcessCapacityTerminationPolicy
    | undefined;
  FulfilledCapacity?: number | undefined;
  FulfilledOnDemandCapacity?: number | undefined;
  LaunchTemplateConfigs?: FleetLaunchTemplateConfig[] | undefined;
  TargetCapacitySpecification?: TargetCapacitySpecification | undefined;
  TerminateInstancesWithExpiration?: boolean | undefined;
  Type?: FleetType | undefined;
  ValidFrom?: Date | undefined;
  ValidUntil?: Date | undefined;
  ReplaceUnhealthyInstances?: boolean | undefined;
  SpotOptions?: SpotOptions | undefined;
  OnDemandOptions?: OnDemandOptions | undefined;
  Tags?: Tag[] | undefined;
  Errors?: DescribeFleetError[] | undefined;
  Instances?: DescribeFleetsInstances[] | undefined;
  Context?: string | undefined;
}
export interface DescribeFleetsResult {
  NextToken?: string | undefined;
  Fleets?: FleetData[] | undefined;
}
export interface DescribeFlowLogsRequest {
  DryRun?: boolean | undefined;
  Filter?: Filter[] | undefined;
  FlowLogIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DestinationOptionsResponse {
  FileFormat?: DestinationFileFormat | undefined;
  HiveCompatiblePartitions?: boolean | undefined;
  PerHourPartition?: boolean | undefined;
}
export interface FlowLog {
  CreationTime?: Date | undefined;
  DeliverLogsErrorMessage?: string | undefined;
  DeliverLogsPermissionArn?: string | undefined;
  DeliverCrossAccountRole?: string | undefined;
  DeliverLogsStatus?: string | undefined;
  FlowLogId?: string | undefined;
  FlowLogStatus?: string | undefined;
  LogGroupName?: string | undefined;
  ResourceId?: string | undefined;
  TrafficType?: TrafficType | undefined;
  LogDestinationType?: LogDestinationType | undefined;
  LogDestination?: string | undefined;
  LogFormat?: string | undefined;
  Tags?: Tag[] | undefined;
  MaxAggregationInterval?: number | undefined;
  DestinationOptions?: DestinationOptionsResponse | undefined;
}
export interface DescribeFlowLogsResult {
  FlowLogs?: FlowLog[] | undefined;
  NextToken?: string | undefined;
}
export declare const FpgaImageAttributeName: {
  readonly description: "description";
  readonly loadPermission: "loadPermission";
  readonly name: "name";
  readonly productCodes: "productCodes";
};
export type FpgaImageAttributeName =
  (typeof FpgaImageAttributeName)[keyof typeof FpgaImageAttributeName];
export interface DescribeFpgaImageAttributeRequest {
  DryRun?: boolean | undefined;
  FpgaImageId: string | undefined;
  Attribute: FpgaImageAttributeName | undefined;
}
export declare const PermissionGroup: {
  readonly all: "all";
};
export type PermissionGroup =
  (typeof PermissionGroup)[keyof typeof PermissionGroup];
export interface LoadPermission {
  UserId?: string | undefined;
  Group?: PermissionGroup | undefined;
}
export declare const ProductCodeValues: {
  readonly devpay: "devpay";
  readonly marketplace: "marketplace";
};
export type ProductCodeValues =
  (typeof ProductCodeValues)[keyof typeof ProductCodeValues];
export interface ProductCode {
  ProductCodeId?: string | undefined;
  ProductCodeType?: ProductCodeValues | undefined;
}
export interface FpgaImageAttribute {
  FpgaImageId?: string | undefined;
  Name?: string | undefined;
  Description?: string | undefined;
  LoadPermissions?: LoadPermission[] | undefined;
  ProductCodes?: ProductCode[] | undefined;
}
export interface DescribeFpgaImageAttributeResult {
  FpgaImageAttribute?: FpgaImageAttribute | undefined;
}
export interface DescribeFpgaImagesRequest {
  DryRun?: boolean | undefined;
  FpgaImageIds?: string[] | undefined;
  Owners?: string[] | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface PciId {
  DeviceId?: string | undefined;
  VendorId?: string | undefined;
  SubsystemId?: string | undefined;
  SubsystemVendorId?: string | undefined;
}
export declare const FpgaImageStateCode: {
  readonly available: "available";
  readonly failed: "failed";
  readonly pending: "pending";
  readonly unavailable: "unavailable";
};
export type FpgaImageStateCode =
  (typeof FpgaImageStateCode)[keyof typeof FpgaImageStateCode];
export interface FpgaImageState {
  Code?: FpgaImageStateCode | undefined;
  Message?: string | undefined;
}
export interface FpgaImage {
  FpgaImageId?: string | undefined;
  FpgaImageGlobalId?: string | undefined;
  Name?: string | undefined;
  Description?: string | undefined;
  ShellVersion?: string | undefined;
  PciId?: PciId | undefined;
  State?: FpgaImageState | undefined;
  CreateTime?: Date | undefined;
  UpdateTime?: Date | undefined;
  OwnerId?: string | undefined;
  OwnerAlias?: string | undefined;
  ProductCodes?: ProductCode[] | undefined;
  Tags?: Tag[] | undefined;
  Public?: boolean | undefined;
  DataRetentionSupport?: boolean | undefined;
  InstanceTypes?: string[] | undefined;
}
export interface DescribeFpgaImagesResult {
  FpgaImages?: FpgaImage[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeHostReservationOfferingsRequest {
  Filter?: Filter[] | undefined;
  MaxDuration?: number | undefined;
  MaxResults?: number | undefined;
  MinDuration?: number | undefined;
  NextToken?: string | undefined;
  OfferingId?: string | undefined;
}
export declare const PaymentOption: {
  readonly ALL_UPFRONT: "AllUpfront";
  readonly NO_UPFRONT: "NoUpfront";
  readonly PARTIAL_UPFRONT: "PartialUpfront";
};
export type PaymentOption = (typeof PaymentOption)[keyof typeof PaymentOption];
export interface HostOffering {
  CurrencyCode?: CurrencyCodeValues | undefined;
  Duration?: number | undefined;
  HourlyPrice?: string | undefined;
  InstanceFamily?: string | undefined;
  OfferingId?: string | undefined;
  PaymentOption?: PaymentOption | undefined;
  UpfrontPrice?: string | undefined;
}
export interface DescribeHostReservationOfferingsResult {
  NextToken?: string | undefined;
  OfferingSet?: HostOffering[] | undefined;
}
export interface DescribeHostReservationsRequest {
  Filter?: Filter[] | undefined;
  HostReservationIdSet?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export declare const ReservationState: {
  readonly ACTIVE: "active";
  readonly PAYMENT_FAILED: "payment-failed";
  readonly PAYMENT_PENDING: "payment-pending";
  readonly RETIRED: "retired";
};
export type ReservationState =
  (typeof ReservationState)[keyof typeof ReservationState];
export interface HostReservation {
  Count?: number | undefined;
  CurrencyCode?: CurrencyCodeValues | undefined;
  Duration?: number | undefined;
  End?: Date | undefined;
  HostIdSet?: string[] | undefined;
  HostReservationId?: string | undefined;
  HourlyPrice?: string | undefined;
  InstanceFamily?: string | undefined;
  OfferingId?: string | undefined;
  PaymentOption?: PaymentOption | undefined;
  Start?: Date | undefined;
  State?: ReservationState | undefined;
  UpfrontPrice?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeHostReservationsResult {
  HostReservationSet?: HostReservation[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeHostsRequest {
  HostIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filter?: Filter[] | undefined;
}
export interface InstanceCapacity {
  AvailableCapacity?: number | undefined;
  InstanceType?: string | undefined;
  TotalCapacity?: number | undefined;
}
export interface AvailableCapacity {
  AvailableInstanceCapacity?: InstanceCapacity[] | undefined;
  AvailableVCpus?: number | undefined;
}
export interface HostProperties {
  Cores?: number | undefined;
  InstanceType?: string | undefined;
  InstanceFamily?: string | undefined;
  Sockets?: number | undefined;
  TotalVCpus?: number | undefined;
}
export interface HostInstance {
  InstanceId?: string | undefined;
  InstanceType?: string | undefined;
  OwnerId?: string | undefined;
}
export interface Host {
  AutoPlacement?: AutoPlacement | undefined;
  AvailabilityZone?: string | undefined;
  AvailableCapacity?: AvailableCapacity | undefined;
  ClientToken?: string | undefined;
  HostId?: string | undefined;
  HostProperties?: HostProperties | undefined;
  HostReservationId?: string | undefined;
  Instances?: HostInstance[] | undefined;
  State?: AllocationState | undefined;
  AllocationTime?: Date | undefined;
  ReleaseTime?: Date | undefined;
  Tags?: Tag[] | undefined;
  HostRecovery?: HostRecovery | undefined;
  AllowsMultipleInstanceTypes?: AllowsMultipleInstanceTypes | undefined;
  OwnerId?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  MemberOfServiceLinkedResourceGroup?: boolean | undefined;
  OutpostArn?: string | undefined;
  HostMaintenance?: HostMaintenance | undefined;
  AssetId?: string | undefined;
}
export interface DescribeHostsResult {
  Hosts?: Host[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeIamInstanceProfileAssociationsRequest {
  AssociationIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeIamInstanceProfileAssociationsResult {
  IamInstanceProfileAssociations?: IamInstanceProfileAssociation[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeIdentityIdFormatRequest {
  Resource?: string | undefined;
  PrincipalArn: string | undefined;
}
export interface DescribeIdentityIdFormatResult {
  Statuses?: IdFormat[] | undefined;
}
export interface DescribeIdFormatRequest {
  Resource?: string | undefined;
}
export interface DescribeIdFormatResult {
  Statuses?: IdFormat[] | undefined;
}
export declare const ImageAttributeName: {
  readonly blockDeviceMapping: "blockDeviceMapping";
  readonly bootMode: "bootMode";
  readonly deregistrationProtection: "deregistrationProtection";
  readonly description: "description";
  readonly imdsSupport: "imdsSupport";
  readonly kernel: "kernel";
  readonly lastLaunchedTime: "lastLaunchedTime";
  readonly launchPermission: "launchPermission";
  readonly productCodes: "productCodes";
  readonly ramdisk: "ramdisk";
  readonly sriovNetSupport: "sriovNetSupport";
  readonly tpmSupport: "tpmSupport";
  readonly uefiData: "uefiData";
};
export type ImageAttributeName =
  (typeof ImageAttributeName)[keyof typeof ImageAttributeName];
export interface DescribeImageAttributeRequest {
  Attribute: ImageAttributeName | undefined;
  ImageId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface LaunchPermission {
  OrganizationArn?: string | undefined;
  OrganizationalUnitArn?: string | undefined;
  UserId?: string | undefined;
  Group?: PermissionGroup | undefined;
}
export interface ImageAttribute {
  Description?: AttributeValue | undefined;
  KernelId?: AttributeValue | undefined;
  RamdiskId?: AttributeValue | undefined;
  SriovNetSupport?: AttributeValue | undefined;
  BootMode?: AttributeValue | undefined;
  TpmSupport?: AttributeValue | undefined;
  UefiData?: AttributeValue | undefined;
  LastLaunchedTime?: AttributeValue | undefined;
  ImdsSupport?: AttributeValue | undefined;
  DeregistrationProtection?: AttributeValue | undefined;
  ImageId?: string | undefined;
  LaunchPermissions?: LaunchPermission[] | undefined;
  ProductCodes?: ProductCode[] | undefined;
  BlockDeviceMappings?: BlockDeviceMapping[] | undefined;
}
export declare const ImageReferenceResourceType: {
  readonly EC2_INSTANCE: "ec2:Instance";
  readonly EC2_LAUNCH_TEMPLATE: "ec2:LaunchTemplate";
  readonly IMAGE_BUILDER_CONTAINER_RECIPE: "imagebuilder:ContainerRecipe";
  readonly IMAGE_BUILDER_IMAGE_RECIPE: "imagebuilder:ImageRecipe";
  readonly SSM_PARAMETER: "ssm:Parameter";
};
export type ImageReferenceResourceType =
  (typeof ImageReferenceResourceType)[keyof typeof ImageReferenceResourceType];
export declare const ImageReferenceOptionName: {
  readonly STATE_NAME: "state-name";
  readonly VERSION_DEPTH: "version-depth";
};
export type ImageReferenceOptionName =
  (typeof ImageReferenceOptionName)[keyof typeof ImageReferenceOptionName];
export interface ResourceTypeOption {
  OptionName?: ImageReferenceOptionName | undefined;
  OptionValues?: string[] | undefined;
}
export interface ResourceTypeRequest {
  ResourceType?: ImageReferenceResourceType | undefined;
  ResourceTypeOptions?: ResourceTypeOption[] | undefined;
}
export interface DescribeImageReferencesRequest {
  ImageIds: string[] | undefined;
  IncludeAllResourceTypes?: boolean | undefined;
  ResourceTypes?: ResourceTypeRequest[] | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
}
export interface ImageReference {
  ImageId?: string | undefined;
  ResourceType?: ImageReferenceResourceType | undefined;
  Arn?: string | undefined;
}
export interface DescribeImageReferencesResult {
  NextToken?: string | undefined;
  ImageReferences?: ImageReference[] | undefined;
}
export interface DescribeImagesRequest {
  ExecutableUsers?: string[] | undefined;
  ImageIds?: string[] | undefined;
  Owners?: string[] | undefined;
  IncludeDeprecated?: boolean | undefined;
  IncludeDisabled?: boolean | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
}
export declare const ArchitectureValues: {
  readonly arm64: "arm64";
  readonly arm64_mac: "arm64_mac";
  readonly i386: "i386";
  readonly x86_64: "x86_64";
  readonly x86_64_mac: "x86_64_mac";
};
export type ArchitectureValues =
  (typeof ArchitectureValues)[keyof typeof ArchitectureValues];
export declare const BootModeValues: {
  readonly legacy_bios: "legacy-bios";
  readonly uefi: "uefi";
  readonly uefi_preferred: "uefi-preferred";
};
export type BootModeValues =
  (typeof BootModeValues)[keyof typeof BootModeValues];
export declare const HypervisorType: {
  readonly ovm: "ovm";
  readonly xen: "xen";
};
export type HypervisorType =
  (typeof HypervisorType)[keyof typeof HypervisorType];
export declare const ImageTypeValues: {
  readonly kernel: "kernel";
  readonly machine: "machine";
  readonly ramdisk: "ramdisk";
};
export type ImageTypeValues =
  (typeof ImageTypeValues)[keyof typeof ImageTypeValues];
export declare const ImdsSupportValues: {
  readonly v2_0: "v2.0";
};
export type ImdsSupportValues =
  (typeof ImdsSupportValues)[keyof typeof ImdsSupportValues];
export declare const DeviceType: {
  readonly ebs: "ebs";
  readonly instance_store: "instance-store";
};
export type DeviceType = (typeof DeviceType)[keyof typeof DeviceType];
export declare const ImageState: {
  readonly available: "available";
  readonly deregistered: "deregistered";
  readonly disabled: "disabled";
  readonly error: "error";
  readonly failed: "failed";
  readonly invalid: "invalid";
  readonly pending: "pending";
  readonly transient: "transient";
};
export type ImageState = (typeof ImageState)[keyof typeof ImageState];
export declare const TpmSupportValues: {
  readonly v2_0: "v2.0";
};
export type TpmSupportValues =
  (typeof TpmSupportValues)[keyof typeof TpmSupportValues];
export declare const VirtualizationType: {
  readonly hvm: "hvm";
  readonly paravirtual: "paravirtual";
};
export type VirtualizationType =
  (typeof VirtualizationType)[keyof typeof VirtualizationType];
export interface Image {
  PlatformDetails?: string | undefined;
  UsageOperation?: string | undefined;
  BlockDeviceMappings?: BlockDeviceMapping[] | undefined;
  Description?: string | undefined;
  EnaSupport?: boolean | undefined;
  Hypervisor?: HypervisorType | undefined;
  ImageOwnerAlias?: string | undefined;
  Name?: string | undefined;
  RootDeviceName?: string | undefined;
  RootDeviceType?: DeviceType | undefined;
  SriovNetSupport?: string | undefined;
  StateReason?: StateReason | undefined;
  Tags?: Tag[] | undefined;
  VirtualizationType?: VirtualizationType | undefined;
  BootMode?: BootModeValues | undefined;
  TpmSupport?: TpmSupportValues | undefined;
  DeprecationTime?: string | undefined;
  ImdsSupport?: ImdsSupportValues | undefined;
  SourceInstanceId?: string | undefined;
  DeregistrationProtection?: string | undefined;
  LastLaunchedTime?: string | undefined;
  ImageAllowed?: boolean | undefined;
  SourceImageId?: string | undefined;
  SourceImageRegion?: string | undefined;
  FreeTierEligible?: boolean | undefined;
  ImageId?: string | undefined;
  ImageLocation?: string | undefined;
  State?: ImageState | undefined;
  OwnerId?: string | undefined;
  CreationDate?: string | undefined;
  Public?: boolean | undefined;
  ProductCodes?: ProductCode[] | undefined;
  Architecture?: ArchitectureValues | undefined;
  ImageType?: ImageTypeValues | undefined;
  KernelId?: string | undefined;
  RamdiskId?: string | undefined;
  Platform?: PlatformValues | undefined;
}
export interface DescribeImagesResult {
  NextToken?: string | undefined;
  Images?: Image[] | undefined;
}
export interface DescribeImageUsageReportEntriesRequest {
  ImageIds?: string[] | undefined;
  ReportIds?: string[] | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
}
export interface ImageUsageReportEntry {
  ResourceType?: string | undefined;
  ReportId?: string | undefined;
  UsageCount?: number | undefined;
  AccountId?: string | undefined;
  ImageId?: string | undefined;
  ReportCreationTime?: Date | undefined;
}
export interface DescribeImageUsageReportEntriesResult {
  NextToken?: string | undefined;
  ImageUsageReportEntries?: ImageUsageReportEntry[] | undefined;
}
export interface DescribeImageUsageReportsRequest {
  ImageIds?: string[] | undefined;
  ReportIds?: string[] | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
}
export interface ImageUsageResourceTypeOption {
  OptionName?: string | undefined;
  OptionValues?: string[] | undefined;
}
export interface ImageUsageResourceType {
  ResourceType?: string | undefined;
  ResourceTypeOptions?: ImageUsageResourceTypeOption[] | undefined;
}
export interface ImageUsageReport {
  ImageId?: string | undefined;
  ReportId?: string | undefined;
  ResourceTypes?: ImageUsageResourceType[] | undefined;
  AccountIds?: string[] | undefined;
  State?: string | undefined;
  StateReason?: string | undefined;
  CreationTime?: Date | undefined;
  ExpirationTime?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeImageUsageReportsResult {
  NextToken?: string | undefined;
  ImageUsageReports?: ImageUsageReport[] | undefined;
}
export interface DescribeImportImageTasksRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  ImportTaskIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ImportImageLicenseConfigurationResponse {
  LicenseConfigurationArn?: string | undefined;
}
export interface UserBucketDetails {
  S3Bucket?: string | undefined;
  S3Key?: string | undefined;
}
export interface SnapshotDetail {
  Description?: string | undefined;
  DeviceName?: string | undefined;
  DiskImageSize?: number | undefined;
  Format?: string | undefined;
  Progress?: string | undefined;
  SnapshotId?: string | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  Url?: string | undefined;
  UserBucket?: UserBucketDetails | undefined;
}
export interface ImportImageTask {
  Architecture?: string | undefined;
  Description?: string | undefined;
  Encrypted?: boolean | undefined;
  Hypervisor?: string | undefined;
  ImageId?: string | undefined;
  ImportTaskId?: string | undefined;
  KmsKeyId?: string | undefined;
  LicenseType?: string | undefined;
  Platform?: string | undefined;
  Progress?: string | undefined;
  SnapshotDetails?: SnapshotDetail[] | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  Tags?: Tag[] | undefined;
  LicenseSpecifications?: ImportImageLicenseConfigurationResponse[] | undefined;
  UsageOperation?: string | undefined;
  BootMode?: BootModeValues | undefined;
}
export interface DescribeImportImageTasksResult {
  ImportImageTasks?: ImportImageTask[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeImportSnapshotTasksRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  ImportTaskIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface SnapshotTaskDetail {
  Description?: string | undefined;
  DiskImageSize?: number | undefined;
  Encrypted?: boolean | undefined;
  Format?: string | undefined;
  KmsKeyId?: string | undefined;
  Progress?: string | undefined;
  SnapshotId?: string | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  Url?: string | undefined;
  UserBucket?: UserBucketDetails | undefined;
}
export interface ImportSnapshotTask {
  Description?: string | undefined;
  ImportTaskId?: string | undefined;
  SnapshotTaskDetail?: SnapshotTaskDetail | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeImportSnapshotTasksResult {
  ImportSnapshotTasks?: ImportSnapshotTask[] | undefined;
  NextToken?: string | undefined;
}
export declare const InstanceAttributeName: {
  readonly blockDeviceMapping: "blockDeviceMapping";
  readonly disableApiStop: "disableApiStop";
  readonly disableApiTermination: "disableApiTermination";
  readonly ebsOptimized: "ebsOptimized";
  readonly enaSupport: "enaSupport";
  readonly enclaveOptions: "enclaveOptions";
  readonly groupSet: "groupSet";
  readonly instanceInitiatedShutdownBehavior: "instanceInitiatedShutdownBehavior";
  readonly instanceType: "instanceType";
  readonly kernel: "kernel";
  readonly productCodes: "productCodes";
  readonly ramdisk: "ramdisk";
  readonly rootDeviceName: "rootDeviceName";
  readonly sourceDestCheck: "sourceDestCheck";
  readonly sriovNetSupport: "sriovNetSupport";
  readonly userData: "userData";
};
export type InstanceAttributeName =
  (typeof InstanceAttributeName)[keyof typeof InstanceAttributeName];
export interface DescribeInstanceAttributeRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  Attribute: InstanceAttributeName | undefined;
}
export interface EbsInstanceBlockDevice {
  AttachTime?: Date | undefined;
  DeleteOnTermination?: boolean | undefined;
  Status?: AttachmentStatus | undefined;
  VolumeId?: string | undefined;
  AssociatedResource?: string | undefined;
  VolumeOwnerId?: string | undefined;
  Operator?: OperatorResponse | undefined;
}
export interface InstanceBlockDeviceMapping {
  DeviceName?: string | undefined;
  Ebs?: EbsInstanceBlockDevice | undefined;
}
export interface AttributeBooleanValue {
  Value?: boolean | undefined;
}
export interface EnclaveOptions {
  Enabled?: boolean | undefined;
}
export interface InstanceAttribute {
  BlockDeviceMappings?: InstanceBlockDeviceMapping[] | undefined;
  DisableApiTermination?: AttributeBooleanValue | undefined;
  EnaSupport?: AttributeBooleanValue | undefined;
  EnclaveOptions?: EnclaveOptions | undefined;
  EbsOptimized?: AttributeBooleanValue | undefined;
  InstanceId?: string | undefined;
  InstanceInitiatedShutdownBehavior?: AttributeValue | undefined;
  InstanceType?: AttributeValue | undefined;
  KernelId?: AttributeValue | undefined;
  ProductCodes?: ProductCode[] | undefined;
  RamdiskId?: AttributeValue | undefined;
  RootDeviceName?: AttributeValue | undefined;
  SourceDestCheck?: AttributeBooleanValue | undefined;
  SriovNetSupport?: AttributeValue | undefined;
  UserData?: AttributeValue | undefined;
  DisableApiStop?: AttributeBooleanValue | undefined;
  Groups?: GroupIdentifier[] | undefined;
}
export interface DescribeInstanceConnectEndpointsRequest {
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  InstanceConnectEndpointIds?: string[] | undefined;
}
export interface DescribeInstanceConnectEndpointsResult {
  InstanceConnectEndpoints?: Ec2InstanceConnectEndpoint[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstanceCreditSpecificationsRequest {
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  InstanceIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface InstanceCreditSpecification {
  InstanceId?: string | undefined;
  CpuCredits?: string | undefined;
}
export interface DescribeInstanceCreditSpecificationsResult {
  InstanceCreditSpecifications?: InstanceCreditSpecification[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstanceEventNotificationAttributesRequest {
  DryRun?: boolean | undefined;
}
export interface DescribeInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute | undefined;
}
export interface DescribeInstanceEventWindowsRequest {
  DryRun?: boolean | undefined;
  InstanceEventWindowIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstanceEventWindowsResult {
  InstanceEventWindows?: InstanceEventWindow[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstanceImageMetadataRequest {
  Filters?: Filter[] | undefined;
  InstanceIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ImageMetadata {
  ImageId?: string | undefined;
  Name?: string | undefined;
  OwnerId?: string | undefined;
  State?: ImageState | undefined;
  ImageOwnerAlias?: string | undefined;
  CreationDate?: string | undefined;
  DeprecationTime?: string | undefined;
  ImageAllowed?: boolean | undefined;
  IsPublic?: boolean | undefined;
}
export declare const InstanceStateName: {
  readonly pending: "pending";
  readonly running: "running";
  readonly shutting_down: "shutting-down";
  readonly stopped: "stopped";
  readonly stopping: "stopping";
  readonly terminated: "terminated";
};
export type InstanceStateName =
  (typeof InstanceStateName)[keyof typeof InstanceStateName];
export interface InstanceState {
  Code?: number | undefined;
  Name?: InstanceStateName | undefined;
}
export interface InstanceImageMetadata {
  InstanceId?: string | undefined;
  InstanceType?: _InstanceType | undefined;
  LaunchTime?: Date | undefined;
  AvailabilityZone?: string | undefined;
  ZoneId?: string | undefined;
  State?: InstanceState | undefined;
  OwnerId?: string | undefined;
  Tags?: Tag[] | undefined;
  ImageMetadata?: ImageMetadata | undefined;
  Operator?: OperatorResponse | undefined;
}
export interface DescribeInstanceImageMetadataResult {
  InstanceImageMetadata?: InstanceImageMetadata[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstancesRequest {
  InstanceIds?: string[] | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface CapacityReservationSpecificationResponse {
  CapacityReservationPreference?: CapacityReservationPreference | undefined;
  CapacityReservationTarget?: CapacityReservationTargetResponse | undefined;
}
export interface CpuOptions {
  CoreCount?: number | undefined;
  ThreadsPerCore?: number | undefined;
  AmdSevSnp?: AmdSevSnpSpecification | undefined;
}
export declare const InstanceBootModeValues: {
  readonly legacy_bios: "legacy-bios";
  readonly uefi: "uefi";
};
export type InstanceBootModeValues =
  (typeof InstanceBootModeValues)[keyof typeof InstanceBootModeValues];
export interface ElasticGpuAssociation {
  ElasticGpuId?: string | undefined;
  ElasticGpuAssociationId?: string | undefined;
  ElasticGpuAssociationState?: string | undefined;
  ElasticGpuAssociationTime?: string | undefined;
}
export interface ElasticInferenceAcceleratorAssociation {
  ElasticInferenceAcceleratorArn?: string | undefined;
  ElasticInferenceAcceleratorAssociationId?: string | undefined;
  ElasticInferenceAcceleratorAssociationState?: string | undefined;
  ElasticInferenceAcceleratorAssociationTime?: Date | undefined;
}
export interface HibernationOptions {
  Configured?: boolean | undefined;
}
export declare const InstanceLifecycleType: {
  readonly capacity_block: "capacity-block";
  readonly scheduled: "scheduled";
  readonly spot: "spot";
};
export type InstanceLifecycleType =
  (typeof InstanceLifecycleType)[keyof typeof InstanceLifecycleType];
export interface LicenseConfiguration {
  LicenseConfigurationArn?: string | undefined;
}
export declare const InstanceAutoRecoveryState: {
  readonly default: "default";
  readonly disabled: "disabled";
};
export type InstanceAutoRecoveryState =
  (typeof InstanceAutoRecoveryState)[keyof typeof InstanceAutoRecoveryState];
export declare const InstanceRebootMigrationState: {
  readonly default: "default";
  readonly disabled: "disabled";
};
export type InstanceRebootMigrationState =
  (typeof InstanceRebootMigrationState)[keyof typeof InstanceRebootMigrationState];
export interface InstanceMaintenanceOptions {
  AutoRecovery?: InstanceAutoRecoveryState | undefined;
  RebootMigration?: InstanceRebootMigrationState | undefined;
}
export declare const InstanceMetadataEndpointState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type InstanceMetadataEndpointState =
  (typeof InstanceMetadataEndpointState)[keyof typeof InstanceMetadataEndpointState];
export declare const InstanceMetadataProtocolState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type InstanceMetadataProtocolState =
  (typeof InstanceMetadataProtocolState)[keyof typeof InstanceMetadataProtocolState];
export declare const HttpTokensState: {
  readonly optional: "optional";
  readonly required: "required";
};
export type HttpTokensState =
  (typeof HttpTokensState)[keyof typeof HttpTokensState];
export declare const InstanceMetadataTagsState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type InstanceMetadataTagsState =
  (typeof InstanceMetadataTagsState)[keyof typeof InstanceMetadataTagsState];
export declare const InstanceMetadataOptionsState: {
  readonly applied: "applied";
  readonly pending: "pending";
};
export type InstanceMetadataOptionsState =
  (typeof InstanceMetadataOptionsState)[keyof typeof InstanceMetadataOptionsState];
export interface InstanceMetadataOptionsResponse {
  State?: InstanceMetadataOptionsState | undefined;
  HttpTokens?: HttpTokensState | undefined;
  HttpPutResponseHopLimit?: number | undefined;
  HttpEndpoint?: InstanceMetadataEndpointState | undefined;
  HttpProtocolIpv6?: InstanceMetadataProtocolState | undefined;
  InstanceMetadataTags?: InstanceMetadataTagsState | undefined;
}
export declare const MonitoringState: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly pending: "pending";
};
export type MonitoringState =
  (typeof MonitoringState)[keyof typeof MonitoringState];
export interface Monitoring {
  State?: MonitoringState | undefined;
}
export interface InstanceNetworkInterfaceAssociation {
  CarrierIp?: string | undefined;
  CustomerOwnedIp?: string | undefined;
  IpOwnerId?: string | undefined;
  PublicDnsName?: string | undefined;
  PublicIp?: string | undefined;
}
export interface InstanceAttachmentEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean | undefined;
}
export interface InstanceAttachmentEnaSrdSpecification {
  EnaSrdEnabled?: boolean | undefined;
  EnaSrdUdpSpecification?: InstanceAttachmentEnaSrdUdpSpecification | undefined;
}
export interface InstanceNetworkInterfaceAttachment {
  AttachTime?: Date | undefined;
  AttachmentId?: string | undefined;
  DeleteOnTermination?: boolean | undefined;
  DeviceIndex?: number | undefined;
  Status?: AttachmentStatus | undefined;
  NetworkCardIndex?: number | undefined;
  EnaSrdSpecification?: InstanceAttachmentEnaSrdSpecification | undefined;
  EnaQueueCount?: number | undefined;
}
export interface ConnectionTrackingSpecificationResponse {
  TcpEstablishedTimeout?: number | undefined;
  UdpStreamTimeout?: number | undefined;
  UdpTimeout?: number | undefined;
}
export interface InstanceIpv4Prefix {
  Ipv4Prefix?: string | undefined;
}
export interface InstanceIpv6Prefix {
  Ipv6Prefix?: string | undefined;
}
export interface InstancePrivateIpAddress {
  Association?: InstanceNetworkInterfaceAssociation | undefined;
  Primary?: boolean | undefined;
  PrivateDnsName?: string | undefined;
  PrivateIpAddress?: string | undefined;
}
export interface InstanceNetworkInterface {
  Association?: InstanceNetworkInterfaceAssociation | undefined;
  Attachment?: InstanceNetworkInterfaceAttachment | undefined;
  Description?: string | undefined;
  Groups?: GroupIdentifier[] | undefined;
  Ipv6Addresses?: InstanceIpv6Address[] | undefined;
  MacAddress?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  OwnerId?: string | undefined;
  PrivateDnsName?: string | undefined;
  PrivateIpAddress?: string | undefined;
  PrivateIpAddresses?: InstancePrivateIpAddress[] | undefined;
  SourceDestCheck?: boolean | undefined;
  Status?: NetworkInterfaceStatus | undefined;
  SubnetId?: string | undefined;
  VpcId?: string | undefined;
  InterfaceType?: string | undefined;
  Ipv4Prefixes?: InstanceIpv4Prefix[] | undefined;
  Ipv6Prefixes?: InstanceIpv6Prefix[] | undefined;
  ConnectionTrackingConfiguration?:
    | ConnectionTrackingSpecificationResponse
    | undefined;
  Operator?: OperatorResponse | undefined;
}
export interface InstanceNetworkPerformanceOptions {
  BandwidthWeighting?: InstanceBandwidthWeighting | undefined;
}
export interface PrivateDnsNameOptionsResponse {
  HostnameType?: HostnameType | undefined;
  EnableResourceNameDnsARecord?: boolean | undefined;
  EnableResourceNameDnsAAAARecord?: boolean | undefined;
}
export interface Instance {
  Architecture?: ArchitectureValues | undefined;
  BlockDeviceMappings?: InstanceBlockDeviceMapping[] | undefined;
  ClientToken?: string | undefined;
  EbsOptimized?: boolean | undefined;
  EnaSupport?: boolean | undefined;
  Hypervisor?: HypervisorType | undefined;
  IamInstanceProfile?: IamInstanceProfile | undefined;
  InstanceLifecycle?: InstanceLifecycleType | undefined;
  ElasticGpuAssociations?: ElasticGpuAssociation[] | undefined;
  ElasticInferenceAcceleratorAssociations?:
    | ElasticInferenceAcceleratorAssociation[]
    | undefined;
  NetworkInterfaces?: InstanceNetworkInterface[] | undefined;
  OutpostArn?: string | undefined;
  RootDeviceName?: string | undefined;
  RootDeviceType?: DeviceType | undefined;
  SecurityGroups?: GroupIdentifier[] | undefined;
  SourceDestCheck?: boolean | undefined;
  SpotInstanceRequestId?: string | undefined;
  SriovNetSupport?: string | undefined;
  StateReason?: StateReason | undefined;
  Tags?: Tag[] | undefined;
  VirtualizationType?: VirtualizationType | undefined;
  CpuOptions?: CpuOptions | undefined;
  CapacityBlockId?: string | undefined;
  CapacityReservationId?: string | undefined;
  CapacityReservationSpecification?:
    | CapacityReservationSpecificationResponse
    | undefined;
  HibernationOptions?: HibernationOptions | undefined;
  Licenses?: LicenseConfiguration[] | undefined;
  MetadataOptions?: InstanceMetadataOptionsResponse | undefined;
  EnclaveOptions?: EnclaveOptions | undefined;
  BootMode?: BootModeValues | undefined;
  PlatformDetails?: string | undefined;
  UsageOperation?: string | undefined;
  UsageOperationUpdateTime?: Date | undefined;
  PrivateDnsNameOptions?: PrivateDnsNameOptionsResponse | undefined;
  Ipv6Address?: string | undefined;
  TpmSupport?: string | undefined;
  MaintenanceOptions?: InstanceMaintenanceOptions | undefined;
  CurrentInstanceBootMode?: InstanceBootModeValues | undefined;
  NetworkPerformanceOptions?: InstanceNetworkPerformanceOptions | undefined;
  Operator?: OperatorResponse | undefined;
  InstanceId?: string | undefined;
  ImageId?: string | undefined;
  State?: InstanceState | undefined;
  PrivateDnsName?: string | undefined;
  PublicDnsName?: string | undefined;
  StateTransitionReason?: string | undefined;
  KeyName?: string | undefined;
  AmiLaunchIndex?: number | undefined;
  ProductCodes?: ProductCode[] | undefined;
  InstanceType?: _InstanceType | undefined;
  LaunchTime?: Date | undefined;
  Placement?: Placement | undefined;
  KernelId?: string | undefined;
  RamdiskId?: string | undefined;
  Platform?: PlatformValues | undefined;
  Monitoring?: Monitoring | undefined;
  SubnetId?: string | undefined;
  VpcId?: string | undefined;
  PrivateIpAddress?: string | undefined;
  PublicIpAddress?: string | undefined;
}
export interface Reservation {
  ReservationId?: string | undefined;
  OwnerId?: string | undefined;
  RequesterId?: string | undefined;
  Groups?: GroupIdentifier[] | undefined;
  Instances?: Instance[] | undefined;
}
export interface DescribeInstancesResult {
  NextToken?: string | undefined;
  Reservations?: Reservation[] | undefined;
}
export interface DescribeInstanceStatusRequest {
  InstanceIds?: string[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  IncludeAllInstances?: boolean | undefined;
}
export declare const StatusName: {
  readonly reachability: "reachability";
};
export type StatusName = (typeof StatusName)[keyof typeof StatusName];
export declare const StatusType: {
  readonly failed: "failed";
  readonly initializing: "initializing";
  readonly insufficient_data: "insufficient-data";
  readonly passed: "passed";
};
export type StatusType = (typeof StatusType)[keyof typeof StatusType];
export interface EbsStatusDetails {
  ImpairedSince?: Date | undefined;
  Name?: StatusName | undefined;
  Status?: StatusType | undefined;
}
export declare const SummaryStatus: {
  readonly impaired: "impaired";
  readonly initializing: "initializing";
  readonly insufficient_data: "insufficient-data";
  readonly not_applicable: "not-applicable";
  readonly ok: "ok";
};
export type SummaryStatus = (typeof SummaryStatus)[keyof typeof SummaryStatus];
export interface EbsStatusSummary {
  Details?: EbsStatusDetails[] | undefined;
  Status?: SummaryStatus | undefined;
}
export declare const EventCode: {
  readonly instance_reboot: "instance-reboot";
  readonly instance_retirement: "instance-retirement";
  readonly instance_stop: "instance-stop";
  readonly system_maintenance: "system-maintenance";
  readonly system_reboot: "system-reboot";
};
export type EventCode = (typeof EventCode)[keyof typeof EventCode];
export interface InstanceStatusEvent {
  InstanceEventId?: string | undefined;
  Code?: EventCode | undefined;
  Description?: string | undefined;
  NotAfter?: Date | undefined;
  NotBefore?: Date | undefined;
  NotBeforeDeadline?: Date | undefined;
}
export interface InstanceStatusDetails {
  ImpairedSince?: Date | undefined;
  Name?: StatusName | undefined;
  Status?: StatusType | undefined;
}
export interface InstanceStatusSummary {
  Details?: InstanceStatusDetails[] | undefined;
  Status?: SummaryStatus | undefined;
}
export interface InstanceStatus {
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  OutpostArn?: string | undefined;
  Operator?: OperatorResponse | undefined;
  Events?: InstanceStatusEvent[] | undefined;
  InstanceId?: string | undefined;
  InstanceState?: InstanceState | undefined;
  InstanceStatus?: InstanceStatusSummary | undefined;
  SystemStatus?: InstanceStatusSummary | undefined;
  AttachedEbsStatus?: EbsStatusSummary | undefined;
}
export interface DescribeInstanceStatusResult {
  InstanceStatuses?: InstanceStatus[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstanceTopologyRequest {
  DryRun?: boolean | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  InstanceIds?: string[] | undefined;
  GroupNames?: string[] | undefined;
  Filters?: Filter[] | undefined;
}
export interface InstanceTopology {
  InstanceId?: string | undefined;
  InstanceType?: string | undefined;
  GroupName?: string | undefined;
  NetworkNodes?: string[] | undefined;
  AvailabilityZone?: string | undefined;
  ZoneId?: string | undefined;
  CapacityBlockId?: string | undefined;
}
export interface DescribeInstanceTopologyResult {
  Instances?: InstanceTopology[] | undefined;
  NextToken?: string | undefined;
}
export declare const LocationType: {
  readonly availability_zone: "availability-zone";
  readonly availability_zone_id: "availability-zone-id";
  readonly outpost: "outpost";
  readonly region: "region";
};
export type LocationType = (typeof LocationType)[keyof typeof LocationType];
export interface DescribeInstanceTypeOfferingsRequest {
  DryRun?: boolean | undefined;
  LocationType?: LocationType | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface InstanceTypeOffering {
  InstanceType?: _InstanceType | undefined;
  LocationType?: LocationType | undefined;
  Location?: string | undefined;
}
export interface DescribeInstanceTypeOfferingsResult {
  InstanceTypeOfferings?: InstanceTypeOffering[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeInstanceTypesRequest {
  DryRun?: boolean | undefined;
  InstanceTypes?: _InstanceType[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export declare const AttachmentLimitType: {
  readonly DEDICATED: "dedicated";
  readonly SHARED: "shared";
};
export type AttachmentLimitType =
  (typeof AttachmentLimitType)[keyof typeof AttachmentLimitType];
export interface EbsOptimizedInfo {
  BaselineBandwidthInMbps?: number | undefined;
  BaselineThroughputInMBps?: number | undefined;
  BaselineIops?: number | undefined;
  MaximumBandwidthInMbps?: number | undefined;
  MaximumThroughputInMBps?: number | undefined;
  MaximumIops?: number | undefined;
}
export declare const EbsOptimizedSupport: {
  readonly default: "default";
  readonly supported: "supported";
  readonly unsupported: "unsupported";
};
export type EbsOptimizedSupport =
  (typeof EbsOptimizedSupport)[keyof typeof EbsOptimizedSupport];
export declare const EbsEncryptionSupport: {
  readonly supported: "supported";
  readonly unsupported: "unsupported";
};
export type EbsEncryptionSupport =
  (typeof EbsEncryptionSupport)[keyof typeof EbsEncryptionSupport];
export declare const EbsNvmeSupport: {
  readonly REQUIRED: "required";
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type EbsNvmeSupport =
  (typeof EbsNvmeSupport)[keyof typeof EbsNvmeSupport];
export interface EbsInfo {
  EbsOptimizedSupport?: EbsOptimizedSupport | undefined;
  EncryptionSupport?: EbsEncryptionSupport | undefined;
  EbsOptimizedInfo?: EbsOptimizedInfo | undefined;
  NvmeSupport?: EbsNvmeSupport | undefined;
  MaximumEbsAttachments?: number | undefined;
  AttachmentLimitType?: AttachmentLimitType | undefined;
}
export interface FpgaDeviceMemoryInfo {
  SizeInMiB?: number | undefined;
}
export interface FpgaDeviceInfo {
  Name?: string | undefined;
  Manufacturer?: string | undefined;
  Count?: number | undefined;
  MemoryInfo?: FpgaDeviceMemoryInfo | undefined;
}
export interface FpgaInfo {
  Fpgas?: FpgaDeviceInfo[] | undefined;
  TotalFpgaMemoryInMiB?: number | undefined;
}
export interface GpuDeviceMemoryInfo {
  SizeInMiB?: number | undefined;
}
export interface GpuDeviceInfo {
  Name?: string | undefined;
  Manufacturer?: string | undefined;
  Count?: number | undefined;
  MemoryInfo?: GpuDeviceMemoryInfo | undefined;
}
export interface GpuInfo {
  Gpus?: GpuDeviceInfo[] | undefined;
  TotalGpuMemoryInMiB?: number | undefined;
}
export declare const InstanceTypeHypervisor: {
  readonly NITRO: "nitro";
  readonly XEN: "xen";
};
export type InstanceTypeHypervisor =
  (typeof InstanceTypeHypervisor)[keyof typeof InstanceTypeHypervisor];
export interface InferenceDeviceMemoryInfo {
  SizeInMiB?: number | undefined;
}
export interface InferenceDeviceInfo {
  Count?: number | undefined;
  Name?: string | undefined;
  Manufacturer?: string | undefined;
  MemoryInfo?: InferenceDeviceMemoryInfo | undefined;
}
export interface InferenceAcceleratorInfo {
  Accelerators?: InferenceDeviceInfo[] | undefined;
  TotalInferenceMemoryInMiB?: number | undefined;
}
export declare const DiskType: {
  readonly hdd: "hdd";
  readonly ssd: "ssd";
};
export type DiskType = (typeof DiskType)[keyof typeof DiskType];
export interface DiskInfo {
  SizeInGB?: number | undefined;
  Count?: number | undefined;
  Type?: DiskType | undefined;
}
export declare const InstanceStorageEncryptionSupport: {
  readonly required: "required";
  readonly unsupported: "unsupported";
};
export type InstanceStorageEncryptionSupport =
  (typeof InstanceStorageEncryptionSupport)[keyof typeof InstanceStorageEncryptionSupport];
export declare const EphemeralNvmeSupport: {
  readonly REQUIRED: "required";
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type EphemeralNvmeSupport =
  (typeof EphemeralNvmeSupport)[keyof typeof EphemeralNvmeSupport];
export interface InstanceStorageInfo {
  TotalSizeInGB?: number | undefined;
  Disks?: DiskInfo[] | undefined;
  NvmeSupport?: EphemeralNvmeSupport | undefined;
  EncryptionSupport?: InstanceStorageEncryptionSupport | undefined;
}
export interface MediaDeviceMemoryInfo {
  SizeInMiB?: number | undefined;
}
export interface MediaDeviceInfo {
  Count?: number | undefined;
  Name?: string | undefined;
  Manufacturer?: string | undefined;
  MemoryInfo?: MediaDeviceMemoryInfo | undefined;
}
export interface MediaAcceleratorInfo {
  Accelerators?: MediaDeviceInfo[] | undefined;
  TotalMediaMemoryInMiB?: number | undefined;
}
export interface MemoryInfo {
  SizeInMiB?: number | undefined;
}
export declare const BandwidthWeightingType: {
  readonly DEFAULT: "default";
  readonly EBS_1: "ebs-1";
  readonly VPC_1: "vpc-1";
};
export type BandwidthWeightingType =
  (typeof BandwidthWeightingType)[keyof typeof BandwidthWeightingType];
export interface EfaInfo {
  MaximumEfaInterfaces?: number | undefined;
}
export declare const EnaSupport: {
  readonly required: "required";
  readonly supported: "supported";
  readonly unsupported: "unsupported";
};
export type EnaSupport = (typeof EnaSupport)[keyof typeof EnaSupport];
export declare const FlexibleEnaQueuesSupport: {
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type FlexibleEnaQueuesSupport =
  (typeof FlexibleEnaQueuesSupport)[keyof typeof FlexibleEnaQueuesSupport];
export interface NetworkCardInfo {
  NetworkCardIndex?: number | undefined;
  NetworkPerformance?: string | undefined;
  MaximumNetworkInterfaces?: number | undefined;
  BaselineBandwidthInGbps?: number | undefined;
  PeakBandwidthInGbps?: number | undefined;
  DefaultEnaQueueCountPerInterface?: number | undefined;
  MaximumEnaQueueCount?: number | undefined;
  MaximumEnaQueueCountPerInterface?: number | undefined;
}
export interface NetworkInfo {
  NetworkPerformance?: string | undefined;
  MaximumNetworkInterfaces?: number | undefined;
  MaximumNetworkCards?: number | undefined;
  DefaultNetworkCardIndex?: number | undefined;
  NetworkCards?: NetworkCardInfo[] | undefined;
  Ipv4AddressesPerInterface?: number | undefined;
  Ipv6AddressesPerInterface?: number | undefined;
  Ipv6Supported?: boolean | undefined;
  EnaSupport?: EnaSupport | undefined;
  EfaSupported?: boolean | undefined;
  EfaInfo?: EfaInfo | undefined;
  EncryptionInTransitSupported?: boolean | undefined;
  EnaSrdSupported?: boolean | undefined;
  BandwidthWeightings?: BandwidthWeightingType[] | undefined;
  FlexibleEnaQueuesSupport?: FlexibleEnaQueuesSupport | undefined;
}
export interface NeuronDeviceCoreInfo {
  Count?: number | undefined;
  Version?: number | undefined;
}
export interface NeuronDeviceMemoryInfo {
  SizeInMiB?: number | undefined;
}
export interface NeuronDeviceInfo {
  Count?: number | undefined;
  Name?: string | undefined;
  CoreInfo?: NeuronDeviceCoreInfo | undefined;
  MemoryInfo?: NeuronDeviceMemoryInfo | undefined;
}
export interface NeuronInfo {
  NeuronDevices?: NeuronDeviceInfo[] | undefined;
  TotalNeuronDeviceMemoryInMiB?: number | undefined;
}
export declare const NitroEnclavesSupport: {
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type NitroEnclavesSupport =
  (typeof NitroEnclavesSupport)[keyof typeof NitroEnclavesSupport];
export declare const DiskImageDescriptionFilterSensitiveLog: (
  obj: DiskImageDescription
) => any;
export declare const ImportInstanceVolumeDetailItemFilterSensitiveLog: (
  obj: ImportInstanceVolumeDetailItem
) => any;
export declare const ImportInstanceTaskDetailsFilterSensitiveLog: (
  obj: ImportInstanceTaskDetails
) => any;
export declare const ImportVolumeTaskDetailsFilterSensitiveLog: (
  obj: ImportVolumeTaskDetails
) => any;
export declare const ConversionTaskFilterSensitiveLog: (
  obj: ConversionTask
) => any;
export declare const DescribeConversionTasksResultFilterSensitiveLog: (
  obj: DescribeConversionTasksResult
) => any;
export declare const SnapshotDetailFilterSensitiveLog: (
  obj: SnapshotDetail
) => any;
export declare const ImportImageTaskFilterSensitiveLog: (
  obj: ImportImageTask
) => any;
export declare const DescribeImportImageTasksResultFilterSensitiveLog: (
  obj: DescribeImportImageTasksResult
) => any;
export declare const SnapshotTaskDetailFilterSensitiveLog: (
  obj: SnapshotTaskDetail
) => any;
export declare const ImportSnapshotTaskFilterSensitiveLog: (
  obj: ImportSnapshotTask
) => any;
export declare const DescribeImportSnapshotTasksResultFilterSensitiveLog: (
  obj: DescribeImportSnapshotTasksResult
) => any;
