import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteTopicCommand, se_DeleteTopicCommand } from "../protocols/Aws_query";
export { $Command };
export class DeleteTopicCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "DeleteTopic", {})
    .n("SNSClient", "DeleteTopicCommand")
    .f(void 0, void 0)
    .ser(se_DeleteTopicCommand)
    .de(de_DeleteTopicCommand)
    .build() {
}
