import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_SetTopicAttributesCommand, se_SetTopicAttributesCommand } from "../protocols/Aws_query";
export { $Command };
export class SetTopicAttributesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "SetTopicAttributes", {})
    .n("SNSClient", "SetTopicAttributesCommand")
    .f(void 0, void 0)
    .ser(se_SetTopicAttributesCommand)
    .de(de_SetTopicAttributesCommand)
    .build() {
}
