import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UnsubscribeCommand, se_UnsubscribeCommand } from "../protocols/Aws_query";
export { $Command };
export class UnsubscribeCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "Unsubscribe", {})
    .n("SNSClient", "UnsubscribeCommand")
    .f(void 0, void 0)
    .ser(se_UnsubscribeCommand)
    .de(de_UnsubscribeCommand)
    .build() {
}
