"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.allowEc2InstanceDeleteByOwner = allowEc2InstanceDeleteByOwner;
const __1 = require("..");
/**
 * Allows stopping EC2 instance only for the user who started them
 *
 * @param tag The tag name, where the user information will be stored - default: `Owner`
 */
function allowEc2InstanceDeleteByOwner(tag) {
    const tagName = tag ?? 'Owner';
    return [
        new __1.Statement.Ec2()
            .allow()
            .toStartInstances()
            .ifAwsRequestTag(tagName, '${aws:username}'),
        new __1.Statement.Ec2()
            .allow()
            .toStopInstances()
            .ifResourceTag(tagName, '${aws:username}'),
    ];
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxsb3dFYzJJbnN0YW5jZURlbGV0ZUJ5T3duZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhbGxvd0VjMkluc3RhbmNlRGVsZXRlQnlPd25lci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVFBLHNFQVlDO0FBcEJELDBCQUErQjtBQUUvQjs7OztHQUlHO0FBRUgsU0FBZ0IsNkJBQTZCLENBQUMsR0FBWTtJQUN4RCxNQUFNLE9BQU8sR0FBRyxHQUFHLElBQUksT0FBTyxDQUFDO0lBQy9CLE9BQU87UUFDTCxJQUFJLGFBQVMsQ0FBQyxHQUFHLEVBQUU7YUFDaEIsS0FBSyxFQUFFO2FBQ1AsZ0JBQWdCLEVBQUU7YUFDbEIsZUFBZSxDQUFDLE9BQU8sRUFBRSxpQkFBaUIsQ0FBQztRQUM5QyxJQUFJLGFBQVMsQ0FBQyxHQUFHLEVBQUU7YUFDaEIsS0FBSyxFQUFFO2FBQ1AsZUFBZSxFQUFFO2FBQ2pCLGFBQWEsQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLENBQUM7S0FDN0MsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGF0ZW1lbnQgfSBmcm9tICcuLic7XG5cbi8qKlxuICogQWxsb3dzIHN0b3BwaW5nIEVDMiBpbnN0YW5jZSBvbmx5IGZvciB0aGUgdXNlciB3aG8gc3RhcnRlZCB0aGVtXG4gKlxuICogQHBhcmFtIHRhZyBUaGUgdGFnIG5hbWUsIHdoZXJlIHRoZSB1c2VyIGluZm9ybWF0aW9uIHdpbGwgYmUgc3RvcmVkIC0gZGVmYXVsdDogYE93bmVyYFxuICovXG5cbmV4cG9ydCBmdW5jdGlvbiBhbGxvd0VjMkluc3RhbmNlRGVsZXRlQnlPd25lcih0YWc/OiBzdHJpbmcpIHtcbiAgY29uc3QgdGFnTmFtZSA9IHRhZyA/PyAnT3duZXInO1xuICByZXR1cm4gW1xuICAgIG5ldyBTdGF0ZW1lbnQuRWMyKClcbiAgICAgIC5hbGxvdygpXG4gICAgICAudG9TdGFydEluc3RhbmNlcygpXG4gICAgICAuaWZBd3NSZXF1ZXN0VGFnKHRhZ05hbWUsICcke2F3czp1c2VybmFtZX0nKSxcbiAgICBuZXcgU3RhdGVtZW50LkVjMigpXG4gICAgICAuYWxsb3coKVxuICAgICAgLnRvU3RvcEluc3RhbmNlcygpXG4gICAgICAuaWZSZXNvdXJjZVRhZyh0YWdOYW1lLCAnJHthd3M6dXNlcm5hbWV9JyksXG4gIF07XG59XG4iXX0=