import { aws_iam } from 'aws-cdk-lib';
import { AwsManagedPolicy as AwsManagedPolicyStatic } from './iam-floyd';
/**
 * Provides all AWS managed policies.
 *
 * To get the name, access the static properties of this class, e.g. `AwsManagedPolicy.ReadOnlyAccess`.
 *
 *  To get an `aws_iam.IManagedPolicy` object, call the methods on an instance of the class, e.g. `new AwsManagedPolicy().ReadOnlyAccess()`.
 */
export declare class AwsManagedPolicy extends AwsManagedPolicyStatic {
    /** Allow Access Analyzer to analyze resource metadata */
    AccessAnalyzerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS services and resources. */
    AdministratorAccess(): aws_iam.IManagedPolicy;
    /** Grants account administrative permissions while explicitly allowing direct access to resources needed by Amplify applications. */
    AdministratorAccessAmplify(): aws_iam.IManagedPolicy;
    /** Grants account administrative permissions. Explicitly allows developers and administrators to gain direct access to resources they need to manage AWS Elastic Beanstalk applications */
    AdministratorAccessAWSElasticBeanstalk(): aws_iam.IManagedPolicy;
    /** Provides ReadOnly permissions required by the Amazon AI Operations Assistant to do analysis on customer AWS resources during investigations. */
    AIOpsAssistantPolicy(): aws_iam.IManagedPolicy;
    /** Grants full access to Amazon AI Operations service and its required permissions via AWS console. It also includes permissions to use identity-aware console sessions. */
    AIOpsConsoleAdminPolicy(): aws_iam.IManagedPolicy;
    /** Grants access to the Amazon AI Operations APIs for creating, updating, and deleting investigations, investigation events, and investigation resources. It also includes ReadOnly access to all AI Operations APIs and to use identity-aware sessions. */
    AIOpsOperatorAccess(): aws_iam.IManagedPolicy;
    /** Grants ReadOnly permissions to the Amazon AI Operations service and its required resources. */
    AIOpsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provide device setup access to AlexaForBusiness services */
    AlexaForBusinessDeviceSetup(): aws_iam.IManagedPolicy;
    /** Grants full access to AlexaForBusiness resources and access to related AWS Services */
    AlexaForBusinessFullAccess(): aws_iam.IManagedPolicy;
    /** Provide gateway execution access to AlexaForBusiness services */
    AlexaForBusinessGatewayExecution(): aws_iam.IManagedPolicy;
    /** Provide access to Lifesize AVS devices */
    AlexaForBusinessLifesizeDelegatedAccessPolicy(): aws_iam.IManagedPolicy;
    /** This policy enables Alexa for Business to perform automated tasks scheduled by your network profiles. */
    AlexaForBusinessNetworkProfileServicePolicy(): aws_iam.IManagedPolicy;
    /** Provide access to Poly AVS devices */
    AlexaForBusinessPolyDelegatedAccessPolicy(): aws_iam.IManagedPolicy;
    /** Provide read only access to AlexaForBusiness services */
    AlexaForBusinessReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to create/edit/delete APIs in Amazon API Gateway via the AWS Management Console. */
    AmazonAPIGatewayAdministrator(): aws_iam.IManagedPolicy;
    /** Provides full access to invoke APIs in Amazon API Gateway. */
    AmazonAPIGatewayInvokeFullAccess(): aws_iam.IManagedPolicy;
    /** Allows API Gateway to push logs to user's account. */
    AmazonAPIGatewayPushToCloudWatchLogs(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon AppFlow and access to AWS services supported as flow source or destination (S3 and Redshift). Also provides access to KMS for encryption */
    AmazonAppFlowFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Appflow flows */
    AmazonAppFlowReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon AppStream via the AWS Management Console. */
    AmazonAppStreamFullAccess(): aws_iam.IManagedPolicy;
    /** Amazon AppStream 2.0 access to AWS Certificate Manager Private CA in customer accounts for certificate-based authentication */
    AmazonAppStreamPCAAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon AppStream via the AWS Management Console. */
    AmazonAppStreamReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Default policy for Amazon AppStream service role. */
    AmazonAppStreamServiceAccess(): aws_iam.IManagedPolicy;
    /** Provide full access to Amazon Athena and scoped access to the dependencies needed to enable querying, writing results, and data management. */
    AmazonAthenaFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Does not allow access for creating FlowDefinitions against the public-crowd Workteam. */
    AmazonAugmentedAIFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to perform all operations on HumanLoops. */
    AmazonAugmentedAIHumanLoopFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Also provides access to those operations of services that are integrated with Amazon Augmented AI. */
    AmazonAugmentedAIIntegratedAPIAccess(): aws_iam.IManagedPolicy;
    /** Provides console full administrative access to Aurora DSQL */
    AmazonAuroraDSQLConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full administrative access to Aurora DSQL */
    AmazonAuroraDSQLFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Aurora DSQL */
    AmazonAuroraDSQLReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Bedrock as well as limited access to related services that are required by it */
    AmazonBedrockFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Bedrock */
    AmazonBedrockReadOnly(): aws_iam.IManagedPolicy;
    /** Defines the maximum permissions of IAM roles that Amazon Bedrock Studio creates for operating Amazon Bedrock Studio resources. */
    AmazonBedrockStudioPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Braket via the AWS Management Console and SDK. Also provides access to related services (e.g., S3, logs). */
    AmazonBraketFullAccess(): aws_iam.IManagedPolicy;
    /** Grants access to AWS Services and resources necessary for executing an Amazon Braket Job including S3, Cloudwatch, IAM and Braket */
    AmazonBraketJobsExecutionPolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Braket to create and manage AWS resources on your behalf */
    AmazonBraketServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeReadOnly(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon Chime SDK operations */
    AmazonChimeSDK(): aws_iam.IManagedPolicy;
    /** Managed Policy For Amazon Chime SDK MediaPipelines Service Linked Role */
    AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Chime SDK Messaging to access AWS resources and enable messaging functionality */
    AmazonChimeSDKMessagingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Resources used or managed by Amazon Chime */
    AmazonChimeServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Chime to access Amazon Transcribe and Amazon Transcribe Medical on your behalf */
    AmazonChimeTranscriptionServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides user management access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeUserManagement(): aws_iam.IManagedPolicy;
    /** Managed policy for Service Linked Role for Amazon Chime VoiceConnector */
    AmazonChimeVoiceConnectorServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Cloud Directory Service. */
    AmazonCloudDirectoryFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Cloud Directory Service. */
    AmazonCloudDirectoryReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full only access to Amazon CloudWatch Evidently. Also provides access to related Amazon S3, Amazon SNS, Amazon CloudWatch, and other related services. */
    AmazonCloudWatchEvidentlyFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon CloudWatch Evidently */
    AmazonCloudWatchEvidentlyReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows CloudWatch Evidently Service to manage associated AWS Resources on behalf of the customer */
    AmazonCloudWatchEvidentlyServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants full access permissions for the Amazon CloudWatch RUM service */
    AmazonCloudWatchRUMFullAccess(): aws_iam.IManagedPolicy;
    /** Grants read only permissions for the Amazon CloudWatch RUM service */
    AmazonCloudWatchRUMReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants permission to Amazon CloudWatch RUM Service to publish monitoring data to other relevant AWS services */
    AmazonCloudWatchRUMServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon CodeCatalyst */
    AmazonCodeCatalystFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon CodeCatalyst */
    AmazonCodeCatalystReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon CodeCatalyst to create, update, and resolve AWS Support cases on your behalf. */
    AmazonCodeCatalystSupportAccess(): aws_iam.IManagedPolicy;
    /** Provides access required by Amazon CodeGuru Profiler agent. */
    AmazonCodeGuruProfilerAgentAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon CodeGuru Profiler. */
    AmazonCodeGuruProfilerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon CodeGuru Profiler. */
    AmazonCodeGuruProfilerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants full access to Amazon CodeGuru Reviewer and scoped access to required dependencies. */
    AmazonCodeGuruReviewerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon CodeGuru Reviewer. */
    AmazonCodeGuruReviewerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** A service-linked role required for Amazon CodeGuru Reviewer to access resources on your behalf. */
    AmazonCodeGuruReviewerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon CodeGuru Security. */
    AmazonCodeGuruSecurityFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access required for working with Amazon CodeGuru Security scans. */
    AmazonCodeGuruSecurityScanAccess(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon Cognito APIs to support developer authenticated identities from your authentication backend. */
    AmazonCognitoDeveloperAuthenticatedIdentities(): aws_iam.IManagedPolicy;
    /** Allows Amazon Cognito User Pools service to use your SES identities for email sending */
    AmazonCognitoIdpEmailServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Amazon Cognito User Pools */
    AmazonCognitoIdpServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides administrative access to existing Amazon Cognito resources. You will need AWS account admin privileges to create new Cognito resources. */
    AmazonCognitoPowerUser(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Cognito resources. */
    AmazonCognitoReadOnly(): aws_iam.IManagedPolicy;
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This policy is not intended to be used as a stand alone permission policy. It is used as a guardrail against overly permissive policies attached for roles in an identity pool. Do not attach this policy to any roles, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    AmazonCognitoUnAuthedIdentitiesSessionPolicy(): aws_iam.IManagedPolicy;
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This does not need to be attached to your unauth role, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    AmazonCognitoUnauthenticatedIdentities(): aws_iam.IManagedPolicy;
    /** The purpose of this policy is to grant permissions to AWS Connect users required to use Connect resources. This policy provides full access to AWS Connect resources via the Connect Console and public APIs */
    AmazonConnectFullAccess(): aws_iam.IManagedPolicy;
    /** Policy for Amazon Connect Campaigns service linked role */
    AmazonConnectCampaignsServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permission to view the Amazon Connect instances in your AWS account. */
    AmazonConnectReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon Connect to create and manage AWS resources on your behalf. */
    AmazonConnectServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Connect to synchronize AWS resources across regions on your behalf. */
    AmazonConnectSynchronizationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Connect Voice ID */
    AmazonConnectVoiceIDFullAccess(): aws_iam.IManagedPolicy;
    /** Provides permissions to consume Amazon Bedrock models, including invoking Amazon Bedrock application inference profile created for particular Amazon DataZone domain. */
    AmazonDataZoneBedrockModelConsumptionPolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions to manage Amazon Bedrock model access, including creating, tagging and deleting application inference profiles. */
    AmazonDataZoneBedrockModelManagementPolicy(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon DataZone's DomainExecutionRole service role. This role is used by Amazon DataZone to catalog, discover, govern, share, and analyze data in the Amazon DataZone domain. */
    AmazonDataZoneDomainExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon DataZone creates IAM roles for Environments to perform data analytics actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    AmazonDataZoneEnvironmentRolePermissionsBoundary(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DataZone via the AWS Management Console as well as limited access to related services that are required by it. */
    AmazonDataZoneFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DataZone, but does not allow the management of domains, users, or associated accounts. */
    AmazonDataZoneFullUserAccess(): aws_iam.IManagedPolicy;
    /** The policy grants permissions to allow Amazon DataZone to enable publishing and access grants to data. */
    AmazonDataZoneGlueManageAccessRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across AWS services, including, but not limited to, Amazon Redshift, Amazon Athena, AWS Glue, and AWS Lake Formation. */
    AmazonDataZoneRedshiftGlueProvisioningPolicy(): aws_iam.IManagedPolicy;
    /** This policy gives Amazon DataZone permissions to publish Amazon Redshift data to the catalog. It also gives Amazon DataZone permissions to grant access or revoke access to Amazon Redshift or Amazon Redshift Serverless published assets in the catalog. */
    AmazonDataZoneRedshiftManageAccessRolePolicy(): aws_iam.IManagedPolicy;
    /** The AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary policy is the list of permissions that are permitted on an execution role created in a SageMaker environment provisioned by Amazon DataZone. */
    AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary(): aws_iam.IManagedPolicy;
    /** The AmazonDataZoneSageMakerManageAccessRolePolicy policy grants Amazon DataZone the permissions required to grant user access to various resources in the SageMaker environment. */
    AmazonDataZoneSageMakerManageAccessRolePolicy(): aws_iam.IManagedPolicy;
    /** The AmazonDataZoneSageMakerProvisioningRolePolicy policy grants Amazon DataZone the permissions required to interoperate with Amazon SageMaker. */
    AmazonDataZoneSageMakerProvisioningRolePolicy(): aws_iam.IManagedPolicy;
    /**  Provides full access to Amazon Detective service and scoped access to the console UI dependencies */
    AmazonDetectiveFullAccess(): aws_iam.IManagedPolicy;
    /** Provides investigator access to Amazon Detective service and scoped access to the console UI dependencies. This policy grants permission to dive into Detective for investigation purposes and limited write access to Guardduty. */
    AmazonDetectiveInvestigatorAccess(): aws_iam.IManagedPolicy;
    /** Provides member access to Amazon Detective service and scoped access to the console UI dependencies. */
    AmazonDetectiveMemberAccess(): aws_iam.IManagedPolicy;
    /** Provides Organizations access to manage Delegated administrator for Amazon Detective and scoped access to the console UI dependencies. This also grants permission to create a service-linked role for Detective. */
    AmazonDetectiveOrganizationsAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon Detective to make service calls on your behalf */
    AmazonDetectiveServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** The policy grants full-access to the DevOps Guru console. */
    AmazonDevOpsGuruConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DevOps Guru. */
    AmazonDevOpsGuruFullAccess(): aws_iam.IManagedPolicy;
    /** Provide access to enable and manage Amazon DevOps Guru within an organization. */
    AmazonDevOpsGuruOrganizationsAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon DevOps Guru Console. */
    AmazonDevOpsGuruReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** A service-linked role required for Amazon DevOpsGuru to access your resources. */
    AmazonDevOpsGuruServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to upload DMS replication logs to cloudwatch logs in customer account. */
    AmazonDMSCloudWatchLogsRole(): aws_iam.IManagedPolicy;
    /** Provides access to manage S3 settings for Redshift endpoints for DMS. */
    AmazonDMSRedshiftS3Role(): aws_iam.IManagedPolicy;
    /** Provides access to manage VPC settings for AWS managed customer configurations */
    AmazonDMSVPCManagementRole(): aws_iam.IManagedPolicy;
    /** Allows Amazon DocumentDB-Elastic to manage AWS resources on your behalf. */
    AmazonDocDBElasticServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to manage Amazon DocumentDB with MongoDB compatibility using the AWS Management Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS and Amazon Neptune. */
    AmazonDocDBConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DocumentDB Elastic Clusters and other required permissions for its dependencies including EC2, KMS, SecretsManager, CloudWatch and IAM. */
    AmazonDocDBElasticFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon DocDB-Elastic and CloudWatch metrics. */
    AmazonDocDBElasticReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DocumentDB with MongoDB compatibility. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS and Amazon Neptune. */
    AmazonDocDBFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon DocumentDB with MongoDB compatibility. Note that this policy also grants access to Amazon RDS and Amazon Neptune resources. */
    AmazonDocDBReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to manage VPC settings for Amazon managed customer configurations */
    AmazonDRSVPCManagement(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DynamoDB via the AWS Management Console. */
    AmazonDynamoDBFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon DynamoDB */
    AmazonDynamoDBFullAccessV2(): aws_iam.IManagedPolicy;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBPipeline.html. Provides full access to Amazon DynamoDB including Export/Import using AWS Data Pipeline via the AWS Management Console. */
    AmazonDynamoDBFullAccesswithDataPipeline(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon DynamoDB via the AWS Management Console. */
    AmazonDynamoDBReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** IAM Policy that allows the CSI driver service account to make calls to related services such as EC2 on your behalf. */
    AmazonEBSCSIDriverPolicy(): aws_iam.IManagedPolicy;
    /** Provides administrative access to Amazon ECR resources */
    AmazonEC2ContainerRegistryFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EC2 Container Registry repositories, but does not allow repository deletion or policy changes. */
    AmazonEC2ContainerRegistryPowerUser(): aws_iam.IManagedPolicy;
    /** Provides access to pull images from Amazon EC2 Container Registry repositories. */
    AmazonEC2ContainerRegistryPullOnly(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon EC2 Container Registry repositories. */
    AmazonEC2ContainerRegistryReadOnly(): aws_iam.IManagedPolicy;
    /**   Policy to enable Task Autoscaling for Amazon EC2 Container Service */
    AmazonEC2ContainerServiceAutoscaleRole(): aws_iam.IManagedPolicy;
    /** Policy to enable CloudWatch Events for EC2 Container Service */
    AmazonEC2ContainerServiceEventsRole(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon EC2 Role for Amazon EC2 Container Service. */
    AmazonEC2ContainerServiceforEC2Role(): aws_iam.IManagedPolicy;
    /** Default policy for Amazon ECS service role. */
    AmazonEC2ContainerServiceRole(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EC2 via the AWS Management Console. */
    AmazonEC2FullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon EC2 via the AWS Management Console. */
    AmazonEC2ReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides EC2 access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    AmazonEC2RoleforAWSCodeDeploy(): aws_iam.IManagedPolicy;
    /** Provides EC2 limited access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    AmazonEC2RoleforAWSCodeDeployLimited(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon EC2 Role for Data Pipeline service role. */
    AmazonEC2RoleforDataPipelineRole(): aws_iam.IManagedPolicy;
    /** This policy will soon be deprecated. Please use AmazonSSMManagedInstanceCore policy to enable AWS Systems Manager service core functionality on EC2 instances. For more information see https://docs.aws.amazon.com/systems-manager/latest/userguide/setup-instance-profile.html */
    AmazonEC2RoleforSSM(): aws_iam.IManagedPolicy;
    /** Managed policy for the Amazon LaunchWizard service role for EC2 */
    AmazonEC2RolePolicyForLaunchWizard(): aws_iam.IManagedPolicy;
    /** Policy to enable Autoscaling for Amazon EC2 Spot Fleet */
    AmazonEC2SpotFleetAutoscaleRole(): aws_iam.IManagedPolicy;
    /** Allows EC2 Spot Fleet to request, terminate and tag Spot Instances on your behalf. */
    AmazonEC2SpotFleetTaggingRole(): aws_iam.IManagedPolicy;
    /** Provides administrative access to Amazon ECS resources and enables ECS features through access to other AWS service resources, including VPCs, Auto Scaling groups, and CloudFormation stacks. */
    AmazonECSFullAccess(): aws_iam.IManagedPolicy;
    /** Policy to enable Amazon ECS Compute to manage your EC2 instances and related resources as part of ECS managed instances */
    AmazonECSComputeServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides administrative access to Private Certificate Authority, AWS Secrets Manager and other AWS Services required to manage ECS Service Connect TLS features on your behalf. */
    AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity(): aws_iam.IManagedPolicy;
    /** Provides access to other AWS service resources required to manage volumes associated with ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForVolumes(): aws_iam.IManagedPolicy;
    /** Provides access to other AWS service resources required to manage VPC Lattice feature in ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForVpcLattice(): aws_iam.IManagedPolicy;
    /** Policy to enable Amazon ECS to manage your cluster. */
    AmazonECSServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to other AWS service resources that are required to run Amazon ECS tasks */
    AmazonECSTaskExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides management access to EFS resources and read access to EC2 */
    AmazonEFSCSIDriverPolicy(): aws_iam.IManagedPolicy;
    /** This policy provides the Amazon VPC CNI Plugin (amazon-vpc-cni-k8s) the permissions it requires to modify the IP address configuration on your EKS worker nodes. This permission set allows the CNI to list, describe, and modify Elastic Network Interfaces on your behalf. More information on the AWS VPC CNI Plugin is available here: https://github.com/aws/amazon-vpc-cni-k8s */
    AmazonEKSCNIPolicy(): aws_iam.IManagedPolicy;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's block storage resources. */
    AmazonEKSBlockStoragePolicy(): aws_iam.IManagedPolicy;
    /** This policy provides Kubernetes the permissions it requires to manage resources on your behalf. Kubernetes requires Ec2:CreateTags permissions to place identifying information on EC2 resources including but not limited to Instances, Security Groups, and Elastic Network Interfaces. */
    AmazonEKSClusterPolicy(): aws_iam.IManagedPolicy;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's compute resources. */
    AmazonEKSComputePolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Amazon EKS to manage AWS resources for EKS connector */
    AmazonEKSConnectorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to view the dashboard in the Amazon EKS console. The dashboard aggregates information about multiple clusters and related resources using AWS Organizations. */
    AmazonEKSDashboardConsoleReadOnly(): aws_iam.IManagedPolicy;
    /** This policy enables the Amazon EKS Dashboard to access and display organization-wide information. The policy allows the EKS Dashboard service to gather information about your AWS Organizations structure and accounts. */
    AmazonEKSDashboardServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to other AWS service resources that are required to run Amazon EKS pods on AWS Fargate */
    AmazonEKSFargatePodExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants necessary permissions to Amazon EKS to run fargate tasks */
    AmazonEKSForFargateServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's load balancing resources. */
    AmazonEKSLoadBalancingPolicy(): aws_iam.IManagedPolicy;
    /** This policy provides permissions to EKS local cluster's control-plane instances running in your account to manage resources on your behalf. */
    AmazonEKSLocalOutpostClusterPolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon EKS Local to call AWS services on your behalf. */
    AmazonEKSLocalOutpostServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's networking resources. */
    AmazonEKSNetworkingPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Amazon Elastic Container Service for Kubernetes to create and manage the necessary resources to operate EKS Clusters. */
    AmazonEKSServicePolicy(): aws_iam.IManagedPolicy;
    /** A Service-Linked Role required for Amazon EKS to call AWS services on your behalf. */
    AmazonEKSServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy used by VPC Resource Controller to manage ENI and IPs for worker nodes. */
    AmazonEKSVPCResourceController(): aws_iam.IManagedPolicy;
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    AmazonEKSWorkerNodeMinimalPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    AmazonEKSWorkerNodePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon ElastiCache via the AWS Management Console. */
    AmazonElastiCacheFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon ElastiCache via the AWS Management Console. */
    AmazonElastiCacheReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides administrative access to Amazon ECR Public resources */
    AmazonElasticContainerRegistryPublicFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon ECR Public repositories, but does not allow repository deletion or policy changes. */
    AmazonElasticContainerRegistryPublicPowerUser(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon ECR Public repositories. */
    AmazonElasticContainerRegistryPublicReadOnly(): aws_iam.IManagedPolicy;
    /** Provides root client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read and write client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientReadWriteAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EFS via the AWS Management Console. */
    AmazonElasticFileSystemFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon EFS via the AWS Management Console. */
    AmazonElasticFileSystemReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon Elastic File System to manage AWS resources on your behalf */
    AmazonElasticFileSystemServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows customers to use AWS Systems Manager to automatically manage Amazon EFS utilities (amazon-efs-utils) package on their EC2 instances, and use CloudWatchLog to get EFS file system mount success/failure notifications. */
    AmazonElasticFileSystemsUtils(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon Elastic MapReduce Editors service role. */
    AmazonElasticMapReduceEditorsRole(): aws_iam.IManagedPolicy;
    /** Amazon Elastic MapReduce for Auto Scaling. Role to allow Auto Scaling to add and remove instances from your EMR cluster. */
    AmazonElasticMapReduceforAutoScalingRole(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon Elastic MapReduce for EC2 service role. */
    AmazonElasticMapReduceforEC2Role(): aws_iam.IManagedPolicy;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html. Provides full access to Amazon Elastic MapReduce and underlying services that it requires such as EC2 and S3 */
    AmazonElasticMapReduceFullAccess(): aws_iam.IManagedPolicy;
    /** Policy to allow EMR to create, describe and delete EC2 placement groups. */
    AmazonElasticMapReducePlacementGroupPolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Elastic MapReduce via the AWS Management Console. */
    AmazonElasticMapReduceReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html.  Default policy for the Amazon Elastic MapReduce service role. */
    AmazonElasticMapReduceRole(): aws_iam.IManagedPolicy;
    /** Allow Amazon Elasticsearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    AmazonElasticsearchServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants users full access to Elastic Transcoder and the access to associated services that is required for full Elastic Transcoder functionality. */
    AmazonElasticTranscoderFullAccess(): aws_iam.IManagedPolicy;
    /** Grants users permission to change presets, submit jobs, and view Elastic Transcoder settings. This policy also grants some read-only access to some other services required to use the Elastic Transcode console, including S3, IAM, and SNS. */
    AmazonElasticTranscoderJobsSubmitter(): aws_iam.IManagedPolicy;
    /** Grants users read-only access to Elastic Transcoder and list access to related services. */
    AmazonElasticTranscoderReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon Elastic Transcoder service role. */
    AmazonElasticTranscoderRole(): aws_iam.IManagedPolicy;
    /** Allows the actions that EMR requires to terminate and delete AWS EC2 resources if the EMR Service role has lost that ability. */
    AmazonEMRCleanupPolicy(): aws_iam.IManagedPolicy;
    /** Allows access to other AWS service resources that are required to run Amazon EMR */
    AmazonEMRContainersServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EMR */
    AmazonEMRFullAccessPolicyV2(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon EMR and the associated CloudWatch Metrics. */
    AmazonEMRReadOnlyAccessPolicyV2(): aws_iam.IManagedPolicy;
    /** Allows access to other AWS service resources that are required to run Amazon EMRServerless */
    AmazonEMRServerlessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy is used for the Amazon EMR Service Role and should NOT be used for any other IAM users or roles in your account. The policy grants permissions to create and manage resources associated with EMR and related services necessary for the operation of your EMR cluster. */
    AmazonEMRServicePolicyV2(): aws_iam.IManagedPolicy;
    /** Provides limited access to the Amazon Cognito configuration service. */
    AmazonESCognitoAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to the Amazon ES configuration service. */
    AmazonESFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to the Amazon ES configuration service. */
    AmazonESReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows EventBridge to access Secret Manager resources on your behalf. */
    AmazonEventBridgeApiDestinationsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EventBridge. */
    AmazonEventBridgeFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only and operator (ability to Stop and Start running Pipes) access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesOperatorAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon EventBridge. */
    AmazonEventBridgeReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** The AmazonEventBridgeSchedulerFullAccess managed policy grants permissions to use all EventBridge Scheduler actions for schedules, and schedule groups. */
    AmazonEventBridgeSchedulerFullAccess(): aws_iam.IManagedPolicy;
    /** The AmazonEventBridgeSchedulerReadOnlyAccess managed policy grants read-only permissions to view details about your schedules and schedule groups */
    AmazonEventBridgeSchedulerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon EventBridge Schemas. */
    AmazonEventBridgeSchemasFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon EventBridge Schemas. */
    AmazonEventBridgeSchemasReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants permissions to Managed Rules created by Amazon EventBridge schemas. */
    AmazonEventBridgeSchemasServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to EVS to manage resources on your behalf */
    AmazonEVSServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy to enable AWS FIS to manage monitoring and resource selection for experiments. */
    AmazonFISServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Gives access to all actions for Amazon Forecast */
    AmazonForecastFullAccess(): aws_iam.IManagedPolicy;
    /** Gives access to all actions for Amazon Fraud Detector */
    AmazonFraudDetectorFullAccessPolicy(): aws_iam.IManagedPolicy;
    /** Full Access Policy for Amazon FreeRTOS */
    AmazonFreeRTOSFullAccess(): aws_iam.IManagedPolicy;
    /** Allows user to access Amazon FreeRTOS OTA Update */
    AmazonFreeRTOSOTAUpdate(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    AmazonFSxConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    AmazonFSxConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon FSx and access to related AWS services. */
    AmazonFSxFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon FSx. */
    AmazonFSxReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon FSx to manage AWS resources on your behalf */
    AmazonFSxServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Glacier via the AWS Management Console. */
    AmazonGlacierFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Glacier via the AWS Management Console. */
    AmazonGlacierReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy grants access to Amazon Athena and the dependencies needed to enable querying and writing results to s3 from the Amazon Athena plugin in Amazon Grafana. */
    AmazonGrafanaAthenaAccess(): aws_iam.IManagedPolicy;
    /** This policy grants access to Amazon CloudWatch and the dependencies needed to use CloudWatch as a datasource within Amazon Managed Grafana. */
    AmazonGrafanaCloudWatchAccess(): aws_iam.IManagedPolicy;
    /** This policy grants scoped access to Amazon Redshift and the dependencies needed to use the Amazon Redshift plugin in Amazon Grafana. */
    AmazonGrafanaRedshiftAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resources managed or used by Amazon Grafana. */
    AmazonGrafanaServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to use Amazon GuardDuty. */
    AmazonGuardDutyFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to use Amazon GuardDuty */
    AmazonGuardDutyFullAccessV2(): aws_iam.IManagedPolicy;
    /** GuardDuty malware protection uses the service-linked role (SLR) named AWSServiceRoleForAmazonGuardDutyMalwareProtection. This service-linked role allows GuardDuty malware protection to perform agent-less scans to detect malware. It allows GuardDuty to create snapshots in your account, and share the snapshots with the GuardDuty service account to scan for malware. It evaluates these shared snapshots and includes the retrieved EC2 instance metadata in the GuardDuty Malware Protection findings. The AWSServiceRoleForAmazonGuardDutyMalwareProtection service-linked role trusts the malware-protection.guardduty.amazonaws.com service to assume the role. */
    AmazonGuardDutyMalwareProtectionServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon GuardDuty resources */
    AmazonGuardDutyReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Enable access to AWS Resources used or managed by Amazon Guard Duty */
    AmazonGuardDutyServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon HealthLake service. */
    AmazonHealthLakeFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon HealthLake service. */
    AmazonHealthLakeReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Honeycode via the AWS Management Console and the SDK. */
    AmazonHoneycodeFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Honeycode via the AWS Management Console and the SDK. */
    AmazonHoneycodeReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** A service-linked role required for Amazon Honeycode to access your resources. */
    AmazonHoneycodeServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Honeycode Team Association via the AWS Management Console and the SDK. */
    AmazonHoneycodeTeamAssociationFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Honeycode Team Association via the AWS Management Console and the SDK. */
    AmazonHoneycodeTeamAssociationReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Honeycode Workbook via the AWS Management Console and the SDK. */
    AmazonHoneycodeWorkbookFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Honeycode Workbook via the AWS Management Console and the SDK. */
    AmazonHoneycodeWorkbookReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants Amazon Inspector access to AWS Services needed to perform agent-less security assessments */
    AmazonInspector2AgentlessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Inspector and access to other related services such as organizations. */
    AmazonInspector2FullAccess(): aws_iam.IManagedPolicy;
    /** This is a managed policy that customer should attach to their roles to communicate with inspector service for CIS scans */
    AmazonInspector2ManagedCisPolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to the Amazon inspector2 service and relevant support services */
    AmazonInspector2ReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    AmazonInspector2ServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Inspector. */
    AmazonInspectorFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Inspector. */
    AmazonInspectorReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    AmazonInspectorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Kendra via the AWS Management Console. */
    AmazonKendraFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Kendra via the AWS Management Console. */
    AmazonKendraReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provide full access to Amazon Keyspaces */
    AmazonKeyspacesFullAccess(): aws_iam.IManagedPolicy;
    /** Provide read only access to Amazon Keyspaces */
    AmazonKeyspacesReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provide read only access to Amazon Keyspaces and related AWS services. */
    AmazonKeyspacesReadOnlyAccessV2(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Kinesis Analytics via the AWS Management Console. */
    AmazonKinesisAnalyticsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon Kinesis Analytics via the AWS Management Console. */
    AmazonKinesisAnalyticsReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to all Amazon Kinesis Firehose Delivery Streams. */
    AmazonKinesisFirehoseFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all Amazon Kinesis Firehose Delivery Streams. */
    AmazonKinesisFirehoseReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all streams via the AWS Management Console. */
    AmazonKinesisFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all streams via the AWS Management Console. */
    AmazonKinesisReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Kinesis Video Streams via the AWS Management Console. */
    AmazonKinesisVideoStreamsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Kinesis Video Streams via the AWS Management Console. */
    AmazonKinesisVideoStreamsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Full access to AWS Launch wizard and other required services. */
    AmazonLaunchWizardFullAccessV2(): aws_iam.IManagedPolicy;
    /** This policy allows customers to call Lex runtime from channels */
    AmazonLexChannelsAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Lex via the AWS Management Console.  Also provides access to create Lex Service Linked Roles and grant Lex permissions to invoke a limited set of Lambda functions. */
    AmazonLexFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon Lex. */
    AmazonLexReadOnly(): aws_iam.IManagedPolicy;
    /** Allows Amazon Lex to replicate Lex resources across regions on your behalf. */
    AmazonLexReplicationPolicy(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon Lex conversational APIs. */
    AmazonLexRunBotsOnly(): aws_iam.IManagedPolicy;
    /** Provides Lex V2 bots access to call other AWS services on your behalf. */
    AmazonLexV2BotPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Lookout for Equipment operations */
    AmazonLookoutEquipmentFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Lookout for Equipments */
    AmazonLookoutEquipmentReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Gives access to all actions for Amazon Lookout for Metrics */
    AmazonLookoutMetricsFullAccess(): aws_iam.IManagedPolicy;
    /** Gives access to all read-only actions for Amazon Lookout for Metrics */
    AmazonLookoutMetricsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    AmazonLookoutVisionConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    AmazonLookoutVisionConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Lookout for Vision and scoped access to required dependencies. */
    AmazonLookoutVisionFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required dependencies. */
    AmazonLookoutVisionReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants users permission to request Amazon Machine Learning batch predictions. */
    AmazonMachineLearningBatchPredictionsAccess(): aws_iam.IManagedPolicy;
    /** Provides create access for non-prediction Amazon Machine Learning resources. */
    AmazonMachineLearningCreateOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Machine Learning resources. */
    AmazonMachineLearningFullAccess(): aws_iam.IManagedPolicy;
    /** Grants users permission to create and delete the real-time endpoint for Amazon Machine Learning models. */
    AmazonMachineLearningManageRealTimeEndpointOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Machine Learning resources. */
    AmazonMachineLearningReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants users permission to request Amazon Machine Learning real-time predictions. */
    AmazonMachineLearningRealTimePredictionOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Machine Learning to configure and use your Redshift Clusters and S3 Staging Locations for Redshift Data Source. */
    AmazonMachineLearningRoleforRedshiftDataSourceV3(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Macie. */
    AmazonMacieFullAccess(): aws_iam.IManagedPolicy;
    /** Grants permission to create the service-linked role of Amazon Macie. */
    AmazonMacieHandshakeRole(): aws_iam.IManagedPolicy;
    /** Provides readonly access to Amazon Macie. */
    AmazonMacieReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants Macie read-only access to resource dependencies in your account in order to enable data analysis. */
    AmazonMacieServiceRole(): aws_iam.IManagedPolicy;
    /** Service linked role for Amazon Macie */
    AmazonMacieServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Managed Blockchain via the AWS Management Console */
    AmazonManagedBlockchainConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Managed Blockchain. */
    AmazonManagedBlockchainFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon Managed Blockchain. */
    AmazonManagedBlockchainReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Amazon Managed Blockchain */
    AmazonManagedBlockchainServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide full access to Amazon Managed Apache Cassandra Service */
    AmazonMCSFullAccess(): aws_iam.IManagedPolicy;
    /** Provide read only access to Amazon Managed Apache Cassandra Service */
    AmazonMCSReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all APIs in Amazon Mechanical Turk. */
    AmazonMechanicalTurkFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to read only APIs in Amazon Mechanical Turk. */
    AmazonMechanicalTurkReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon MemoryDB via the AWS Management Console. */
    AmazonMemoryDBFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon MemoryDB via the AWS Management Console. */
    AmazonMemoryDBReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all reports including financial data for all application resources. */
    AmazonMobileAnalyticsFinancialReportAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all application resources. */
    AmazonMobileAnalyticsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to non financial reports for all application resources. */
    AmazonMobileAnalyticsNonFinancialReportAccess(): aws_iam.IManagedPolicy;
    /** Provides write only access to put event data for all application resources. (Recommended for SDK integration) */
    AmazonMobileAnalyticsWriteOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to manage Amazon Monitron */
    AmazonMonitronFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AmazonMQ via our API/SDK. */
    AmazonMQApiFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AmazonMQ via our API/SDK. */
    AmazonMQApiReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AmazonMQ via the AWS Management Console. */
    AmazonMQFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AmazonMQ via the AWS Management Console. */
    AmazonMQReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Service Linked Role Policy for AWS Amazon MQ */
    AmazonMQServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide readonly access to Amazon MSK Connect */
    AmazonMSKConnectReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provide full access to Amazon MSK and other required permissions for its dependencies. */
    AmazonMSKFullAccess(): aws_iam.IManagedPolicy;
    /** Provide readonly access to Amazon MSK */
    AmazonMSKReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** The Service Linked Role used by Amazon Managed Workflows for Apache Airflow. */
    AmazonMWAAServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants access to resources needed by Nimble Studio Launch Profile workers. Attach this policy to EC2 instances created by Nimble Studio Builder. */
    AmazonNimbleStudioLaunchProfileWorker(): aws_iam.IManagedPolicy;
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio admin and related studio resources in other services. Attach this policy to the Admin role associated with your studio. */
    AmazonNimbleStudioStudioAdmin(): aws_iam.IManagedPolicy;
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio user and related studio resources in other services. Attach this policy to the User role associated with your studio. */
    AmazonNimbleStudioStudioUser(): aws_iam.IManagedPolicy;
    /** Allows Oracle Database@AWS to manage AWS resources on your behalf. */
    AmazonODBServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Omics and other required AWS Services. This policy allows the user to view and accept RAM share invitations to access resources outside of the user's AWS account. */
    AmazonOmicsFullAccess(): aws_iam.IManagedPolicy;
    /** Provide read only access to Amazon Omics */
    AmazonOmicsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy grants administrative permissions that allow access to all Amazon One Enterprise resources and operations. */
    AmazonOneEnterpriseFullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants limited read and write permissions that allow device installation and activation. */
    AmazonOneEnterpriseInstallerAccess(): aws_iam.IManagedPolicy;
    /** This policy grants read only permissions to all Amazon One Enterprise resources and operations. */
    AmazonOneEnterpriseReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon OpenSearch Dashboards Service to access other AWS services such as CloudWatch on your behalf */
    AmazonOpenSearchDashboardsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows OpenSearch DirectQuery Service to access AWS Glue APIs for creating resources on your behalf. */
    AmazonOpenSearchDirectQueryGlueCreateAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon OpenSearch Ingestion to access other AWS services on your behalf. */
    AmazonOpenSearchIngestionFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to the Amazon OpenSearch Ingestion Service */
    AmazonOpenSearchIngestionReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon OpenSearch Ingestion Service to access other AWS services on your behalf. */
    AmazonOpenSearchIngestionServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allow Amazon OpenSearch Serverless to access other AWS services such as CloudWatch APIs on your behalf. */
    AmazonOpenSearchServerlessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to the Amazon Cognito configuration service. */
    AmazonOpenSearchServiceCognitoAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to the Amazon OpenSearch Service configuration service. */
    AmazonOpenSearchServiceFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to the Amazon OpenSearch Service configuration service. */
    AmazonOpenSearchServiceReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allow Amazon OpenSearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    AmazonOpenSearchServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Personalize via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, CloudWatch). */
    AmazonPersonalizeFullAccess(): aws_iam.IManagedPolicy;
    /** Grants full access to Amazon Polly service and resources. */
    AmazonPollyFullAccess(): aws_iam.IManagedPolicy;
    /** Grants read-only access to Amazon Polly resources. */
    AmazonPollyReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS Managed Prometheus resources in the AWS console */
    AmazonPrometheusConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS Managed Prometheus resources */
    AmazonPrometheusFullAccess(): aws_iam.IManagedPolicy;
    /** Grants access to run queries against AWS Managed Prometheus resources */
    AmazonPrometheusQueryAccess(): aws_iam.IManagedPolicy;
    /** Grants write only access to AWS Managed Prometheus workspaces */
    AmazonPrometheusRemoteWriteAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resources managed or used by Amazon Managed Service for Prometheus Collector */
    AmazonPrometheusScraperServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides developer access to enable interactions with Amazon Q */
    AmazonQDeveloperAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to enable interactions with Amazon Q */
    AmazonQFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon QLDB via the AWS Management Console. */
    AmazonQLDBConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon QLDB via the service API. */
    AmazonQLDBFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon QLDB. */
    AmazonQLDBReadOnly(): aws_iam.IManagedPolicy;
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    AmazonRDSBetaServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon RDS Custom to perform various automation actions and database management tasks through an EC2 instance profile. */
    AmazonRDSCustomInstanceProfileRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon RDS Custom Preview Service Role Policy */
    AmazonRDSCustomPreviewServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon RDS Custom to manage AWS resources on your behalf. */
    AmazonRDSCustomServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows full access to use the RDS data APIs, secret store APIs for RDS database credentials, and DB console query management APIs to execute SQL statements on Aurora Serverless clusters in the AWS account. */
    AmazonRDSDataFullAccess(): aws_iam.IManagedPolicy;
    /** Allow RDS to access Directory Service Managed AD on behalf of the customer for domain-joined SQL Server DB instances. */
    AmazonRDSDirectoryServiceAccess(): aws_iam.IManagedPolicy;
    /** Provides access to Cloudwatch for RDS Enhanced Monitoring */
    AmazonRDSEnhancedMonitoringRole(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon RDS via the AWS Management Console. */
    AmazonRDSFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to RDS Performance Insights via the AWS Management Console */
    AmazonRDSPerformanceInsightsFullAccess(): aws_iam.IManagedPolicy;
    /** Read-Only policy for RDS Performance Insights */
    AmazonRDSPerformanceInsightsReadOnly(): aws_iam.IManagedPolicy;
    /** Amazon RDS Preview Service Role Policy */
    AmazonRDSPreviewServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon RDS via the AWS Management Console. */
    AmazonRDSReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    AmazonRDSServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy includes permissions to run SQL commands to copy, load, unload, query, and analyze data on Amazon Redshift. The policy also grants permissions to run select statements for related services, such as Amazon S3, Amazon CloudWatch logs, Amazon SageMaker, or AWS Glue. */
    AmazonRedshiftAllCommandsFullAccess(): aws_iam.IManagedPolicy;
    /** This policy provides full access to Amazon Redshift Data APIs. This policy also grants scoped access to other required services. */
    AmazonRedshiftDataFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Redshift via the AWS Management Console. */
    AmazonRedshiftFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to the Amazon Redshift Query Editor and to saved queries via the AWS Management Console. */
    AmazonRedshiftQueryEditor(): aws_iam.IManagedPolicy;
    /** Grants full access to the Amazon Redshift Query Editor V2 operations and resources. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters, read keys and aliases in AWS KMS and manage the Query Editor V2 secrets in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2FullAccess(): aws_iam.IManagedPolicy;
    /** Grants the ability to work with Amazon Redshift Query Editor V2 without sharing resources. The granted principal can only read, update and delete its own resources but cannot share them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2NoSharing(): aws_iam.IManagedPolicy;
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with limited sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read the resources shared with its team but cannot update them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2ReadSharing(): aws_iam.IManagedPolicy;
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read and update the resources shared with its team. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2ReadWriteSharing(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Redshift via the AWS Management Console. */
    AmazonRedshiftReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon Redshift to call AWS services on your behalf */
    AmazonRedshiftServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy specifies rekognition and s3 permissions required by Amazon Rekognition Custom Labels feature. */
    AmazonRekognitionCustomLabelsFullAccess(): aws_iam.IManagedPolicy;
    /** Access to all Amazon Rekognition APIs */
    AmazonRekognitionFullAccess(): aws_iam.IManagedPolicy;
    /** Access to all Read rekognition APIs */
    AmazonRekognitionReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Rekognition to call AWS services on your behalf. */
    AmazonRekognitionServiceRole(): aws_iam.IManagedPolicy;
    /** Provides full access to all Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to all Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides registrant level access to Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingRegistrantAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all Route53 Domains actions and Create Hosted Zone to allow Hosted Zone creation as part of domain registrations. */
    AmazonRoute53DomainsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to Route53 Domains list and actions. */
    AmazonRoute53DomainsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all Amazon Route 53 via the AWS Management Console. */
    AmazonRoute53FullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants full access to Amazon Route 53 Profile resources. */
    AmazonRoute53ProfilesFullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants read-only access to Amazon Route 53 Profile resources. */
    AmazonRoute53ProfilesReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all Amazon Route 53 via the AWS Management Console. */
    AmazonRoute53ReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Route 53 Recovery Cluster */
    AmazonRoute53RecoveryClusterFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Route 53 Recovery Cluster */
    AmazonRoute53RecoveryClusterReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Route 53 Recovery Control Config */
    AmazonRoute53RecoveryControlConfigFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Route 53 Recovery Control Config */
    AmazonRoute53RecoveryControlConfigReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Route 53 Recovery Readiness */
    AmazonRoute53RecoveryReadinessFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Route 53 Recovery Readiness */
    AmazonRoute53RecoveryReadinessReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Full access policy for Route 53 Resolver */
    AmazonRoute53ResolverFullAccess(): aws_iam.IManagedPolicy;
    /** Read only policy for Route 53 Resolver */
    AmazonRoute53ResolverReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all buckets via the AWS Management Console. */
    AmazonS3FullAccess(): aws_iam.IManagedPolicy;
    /** Provides AWS Lambda functions permissions to interact with Amazon S3 Object Lambda. Also grants Lambda permissions to write to CloudWatch Logs. */
    AmazonS3ObjectLambdaExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon S3 on Outposts via the AWS Management Console. */
    AmazonS3OutpostsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon S3 on Outposts via the AWS Management Console. */
    AmazonS3OutpostsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all buckets via the AWS Management Console. */
    AmazonS3ReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all S3 table buckets. */
    AmazonS3TablesFullAccess(): aws_iam.IManagedPolicy;
    /** This managed policy grants AWS Lake Formation permissions to act on all table buckets, namespaces, and tables within the account. */
    AmazonS3TablesLakeFormationServiceRole(): aws_iam.IManagedPolicy;
    /** Provides read only access to all S3 table buckets. */
    AmazonS3TablesReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS Service Catalog service to provision products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CodePipeline, CodeBuild, CodeCommit, Glue, CloudFormation, etc,. */
    AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions for Amazon SageMaker Canvas to use AI services to support ready to use AI solutions. This policy will add more mutating permissions for services as Amazon SageMaker Canvas adds support. */
    AmazonSageMakerCanvasAIServicesAccess(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to use Amazon Bedrock in SageMaker Canvas by providing access to downstream services such as S3. */
    AmazonSageMakerCanvasBedrockAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SageMaker resources and operations for data preparation in Canvas. The policy also provides select access to related services (e.g., S3, IAM, KMS, RDS, CloudWatch Logs, Redshift, Athena, Glue, EventBridge, Secrets Manager). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    AmazonSageMakerCanvasDataPrepFullAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon SageMaker Canvas to create, manage and view endpoint details for endpoints created through Canvas. Allows Amazon SageMaker Canvas to retrieve endpoint invocation metrics from CloudWatch. */
    AmazonSageMakerCanvasDirectDeployAccess(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to Amazon EMR Serverless for services such as S3, used by Amazon SageMaker Canvas for large data processing. */
    AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions commonly needed to use SageMaker Canvas with Amazon Forecast. */
    AmazonSageMakerCanvasForecastAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SageMaker Canvas resources and operations. The policy also provides select access to related services (e.g., S3, IAM, VPC, ECR, CloudWatch Logs, Redshift, Secrets Manager, and Forecast). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    AmazonSageMakerCanvasFullAccess(): aws_iam.IManagedPolicy;
    /** Provides permissions for Amazon SageMaker Canvas to use the SageMaker Data Science Assistant service. The Data Science Assistant currently uses both Amazon SageMaker and Amazon Q Developer to process user prompts. */
    AmazonSageMakerCanvasSMDataScienceAssistantAccess(): aws_iam.IManagedPolicy;
    /** This policy grants permissions commonly needed to use Amazon SageMaker Cluster. */
    AmazonSageMakerClusterInstanceRolePolicy(): aws_iam.IManagedPolicy;
    /** Managed policy for Service Linked Role for Amazon SageMaker Core Services */
    AmazonSageMakerCoreServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions necessary for SageMaker Edge to create and manage a device fleet for the customer using the default cloud connection. */
    AmazonSageMakerEdgeDeviceFleetPolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions required to enable the offline store for an Amazon SageMaker FeatureStore feature group. */
    AmazonSageMakerFeatureStoreAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SageMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, ECR, CloudWatch Logs). */
    AmazonSageMakerFullAccess(): aws_iam.IManagedPolicy;
    /** This policy provide access to services that are commonly needed to use SageMaker geospatial. */
    AmazonSageMakerGeospatialExecutionRole(): aws_iam.IManagedPolicy;
    /** This policy grants permissions that allow full access to Amazon SageMaker Geospatial through the AWS Management Console and SDK. */
    AmazonSageMakerGeospatialFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS services that are required to run SageMaker GroundTruth Labeling job */
    AmazonSageMakerGroundTruthExecution(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to Amazon SageMaker HyperPod to related AWS services such as Amazon EKS, Amazon CloudWatch etc. */
    AmazonSageMakerHyperPodServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to create Amazon Augmented AI FlowDefinition resources against any Workteam. */
    AmazonSageMakerMechanicalTurkAccess(): aws_iam.IManagedPolicy;
    /** This AWS managed policy grants permissions needed to use all Amazon SageMaker Governance features. The policy also provides select access to related services (e.g., S3, KMS). */
    AmazonSageMakerModelGovernanceUseAccess(): aws_iam.IManagedPolicy;
    /** This is a new managed policy for Model Registry in Sagemaker. This policy is a standalone policy that can be attached to the user role to access Model Registry related functionalities in Sagemaker. */
    AmazonSageMakerModelRegistryFullAccess(): aws_iam.IManagedPolicy;
    /** Managed policy for Service Linked Role for Amazon SageMaker Notebooks */
    AmazonSageMakerNotebooksServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables Amazon SageMaker partner app users to access applications, list available applications, launch application web UIs, and connect via the application SDK. */
    AmazonSageMakerPartnerAppsFullAccess(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Lambda and others. */
    AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including Lambda, APIGateway and others. */
    AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Secrets Manager and others. */
    AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This Amazon Managed Policy grants permissions commonly needed for use with Callback steps and Lambda steps in SageMaker Model Building Pipelines. It is added to the AmazonSageMaker-ExecutionRole that can be created when setting up SageMaker Studio. It can also be attached to any other role that will be used for authoring or executing pipelines. */
    AmazonSageMakerPipelinesIntegrations(): aws_iam.IManagedPolicy;
    /** This policy will be used By SageMaker Unified Studios to create VPC related resources for QuickSight */
    AmazonSageMakerQuickSightVPCPolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon SageMaker via the AWS Management Console and SDK. */
    AmazonSageMakerReadOnly(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CloudWatch Logs and others. */
    AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including SageMaker and others. */
    AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS CodeBuild within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS CodePipeline within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS CloudWatch Events within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline and others. */
    AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS Firehose within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Firehose and others. */
    AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS Glue within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Glue, S3 and others. */
    AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including ECR, S3 and others. */
    AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This Amazon Managed Policy provides the necessary permissions to create and manage SageMaker Training Plans. It allows users to create Training Plans and Reserved Capacities, describe existing Training Plans, and perform search and listing operations. */
    AmazonSageMakerTrainingPlanCreateAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Security Lake and related services needed to administer Security Lake. */
    AmazonSecurityLakeAdministrator(): aws_iam.IManagedPolicy;
    /** Policy for Amazon SecurityLake meta store manager lambda which allows the access to cloudwatch, S3, Glue and SQS. */
    AmazonSecurityLakeMetastoreManager(): aws_iam.IManagedPolicy;
    /** Amazon Security Lake creates IAM roles for third-party custom sources to write data to a data lake and for third-party subscribers to consume data from a data lake, and uses this policy when creating these roles to define the boundary of their permissions. */
    AmazonSecurityLakePermissionsBoundary(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SES via the AWS Management Console. */
    AmazonSESFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon SES via the AWS Management Console. */
    AmazonSESReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows SES to publish Amazon CloudWatch basic monitoring metrics on behalf of your SES resources */
    AmazonSESServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SNS via the AWS Management Console. */
    AmazonSNSFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon SNS via the AWS Management Console. */
    AmazonSNSReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Default policy for Amazon SNS service role. */
    AmazonSNSRole(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SQS via the AWS Management Console. */
    AmazonSQSFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon SQS via the AWS Management Console. */
    AmazonSQSReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to view automation executions and send approval decisions to automation waiting for approval */
    AmazonSSMAutomationApproverAccess(): aws_iam.IManagedPolicy;
    /** Provides permissions for EC2 Automation service to execute activities defined within Automation documents */
    AmazonSSMAutomationRole(): aws_iam.IManagedPolicy;
    /** This policy allows SSM Agent to access Directory Service on behalf of the customer for domain-join the managed instance. */
    AmazonSSMDirectoryServiceAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon SSM. */
    AmazonSSMFullAccess(): aws_iam.IManagedPolicy;
    /**  Service Role to be used for EC2 Maintenance Window */
    AmazonSSMMaintenanceWindowRole(): aws_iam.IManagedPolicy;
    /** This policy enables AWS Systems Manager functionality on EC2 instances. */
    AmazonSSMManagedEC2InstanceDefaultPolicy(): aws_iam.IManagedPolicy;
    /** The policy for Amazon EC2 Role to enable AWS Systems Manager service core functionality. */
    AmazonSSMManagedInstanceCore(): aws_iam.IManagedPolicy;
    /** Provide access to child instances for patch association operation. */
    AmazonSSMPatchAssociation(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon SSM. */
    AmazonSSMReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resources managed or used by Amazon SSM */
    AmazonSSMServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Access to all Amazon Textract APIs */
    AmazonTextractFullAccess(): aws_iam.IManagedPolicy;
    /** Allows Textract to call AWS services on your behalf. */
    AmazonTextractServiceRole(): aws_iam.IManagedPolicy;
    /** Provides full access to manage Amazon Timestream using the AWS Management Console. Note that this policy also grants permissions for certain KMS operations, and operations to manage your saved queries. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Timestream. Note that this policy also grants certain KMS operation access. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    AmazonTimestreamInfluxDBFullAccess(): aws_iam.IManagedPolicy;
    /** Provides administrative access to manage Amazon Timestream InfluxDB instances and parameter groups except marketplace operations. */
    AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess(): aws_iam.IManagedPolicy;
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    AmazonTimestreamInfluxDBServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Timestream. Policy also provides permission to cancel any running query. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Transcribe operations */
    AmazonTranscribeFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to read only operation for Amazon Transcribe */
    AmazonTranscribeReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Verified Permissions */
    AmazonVerifiedPermissionsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to the Verified Permissions service. */
    AmazonVerifiedPermissionsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to create network interfaces and attach them to cross-account resources */
    AmazonVPCCrossAccountNetworkInterfaceOperations(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon VPC via the AWS Management Console. */
    AmazonVPCFullAccess(): aws_iam.IManagedPolicy;
    /** Provides permissions to describe AWS resources, run Network Access Analyzer, and create or delete tags on Network Insights Access Scope and Network Insights Access Scope Analysis. */
    AmazonVPCNetworkAccessAnalyzerFullAccessPolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions to describe AWS resources, run Reachability Analyzer, and create or delete tags on Network Insights Path and Network Insights Analysis. */
    AmazonVPCReachabilityAnalyzerFullAccessPolicy(): aws_iam.IManagedPolicy;
    /** This policy is attached to the role IAMRoleForReachabilityAnalyzerCrossAccountResourceAccess. This role is deployed to the member accounts in an organization when the management account enables trusted access for Reachability Analyzer. It provides permissions to view resources from across your organization using the Reachability Analyzer console. */
    AmazonVPCReachabilityAnalyzerPathComponentReadPolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon VPC via the AWS Management Console. */
    AmazonVPCReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon WorkDocs via the AWS Management Console */
    AmazonWorkDocsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon WorkDocs via the AWS Management Console */
    AmazonWorkDocsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkMail Events */
    AmazonWorkMailEventsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to WorkMail, Directory Service, SES, EC2 and read access to KMS metadata. */
    AmazonWorkMailFullAccess(): aws_iam.IManagedPolicy;
    /** Full access to the WorkMail Message Flow APIs */
    AmazonWorkMailMessageFlowFullAccess(): aws_iam.IManagedPolicy;
    /** Read only access to WorkMail messages for the GetRawMessageContent API */
    AmazonWorkMailMessageFlowReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to WorkMail and SES. */
    AmazonWorkMailReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon WorkSpaces administrative actions via AWS SDK and CLI. */
    AmazonWorkSpacesAdmin(): aws_iam.IManagedPolicy;
    /** Provides administrator access for packaging an application in Amazon WorkSpaces Application Manager. */
    AmazonWorkSpacesApplicationManagerAdminAccess(): aws_iam.IManagedPolicy;
    /** This managed policy provides full administrative access to AWS Certificate Manager Private CA resources in your AWS account for certificate-based authentication. */
    AmazonWorkspacesPCAAccess(): aws_iam.IManagedPolicy;
    /** This policy provides AWS WorkSpaces service access to required customer account resources for launching Workspaces Pools */
    AmazonWorkSpacesPoolServiceAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon WorkSpaces Secure Browser and its dependencies through the AWS Management Console, SDK, and CLI. */
    AmazonWorkSpacesSecureBrowserReadOnly(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon WorkSpaces backend service to perform Workspace Self Service actions */
    AmazonWorkSpacesSelfServiceAccess(): aws_iam.IManagedPolicy;
    /** Provides customer account access to AWS WorkSpaces service for launching a Workspace. */
    AmazonWorkSpacesServiceAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon WorkSpaces Thin Client as well as limited access to required related services */
    AmazonWorkSpacesThinClientFullAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Thin Client Monitoring */
    AmazonWorkSpacesThinClientMonitoringServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon WorkSpaces Thin Client and its dependencies */
    AmazonWorkSpacesThinClientReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon WorkSpaces Web and its dependencies through the AWS Management Console, SDK, and CLI. */
    AmazonWorkSpacesWebReadOnly(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Web */
    AmazonWorkSpacesWebServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Zocalo. */
    AmazonZocaloFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Zocalo */
    AmazonZocaloReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides Amplify full access permissions to deploy Amplify backend resources (AWS AppSync, Amazon Cognito, Amazon S3 and other related services) via the AWS Cloud Development Kit (AWS CDK) */
    AmplifyBackendDeployFullAccess(): aws_iam.IManagedPolicy;
    /** Allows API Gateway to manage associated AWS Resources on behalf of the customer. */
    APIGatewayServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AppIntegrations to manage AppFlow resources and publish CloudWatch metric data on your behalf. */
    AppIntegrationsServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy to enable Application Autoscaling for Amazon AppStream */
    ApplicationAutoScalingForAmazonAppStreamAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Application Discovery Service Continuous Export feature */
    ApplicationDiscoveryServiceContinuousExportServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS AppRunner Networking to manage related AWS resources on your behalf. */
    AppRunnerNetworkingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS AppRunner to manage related AWS resources on your behalf. */
    AppRunnerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AppStudio to manage associated AWS resources on your behalf. */
    AppStudioServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for Amazon Aurora DSQL Service Linked Role */
    AuroraDsqlServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Auto Scaling via the AWS Management Console. */
    AutoScalingConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Auto Scaling via the AWS Management Console. */
    AutoScalingConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Auto Scaling. */
    AutoScalingFullAccess(): aws_iam.IManagedPolicy;
    /** Default policy for the AutoScaling Notification Access service role. */
    AutoScalingNotificationAccessRole(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Auto Scaling. */
    AutoScalingReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Auto Scaling */
    AutoScalingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Default policy for AWS Config service role. Provides permissions required for AWS Config to track changes to your AWS resources. */
    AWSConfigRole(): aws_iam.IManagedPolicy;
    /** Provides permissions to access the SSM Diagnosis S3 bucket for diagnosis and remediation of issues. */
    AWSSSMAutomationDiagnosisBucketPolicy(): aws_iam.IManagedPolicy;
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    AWSSSMDiagnosisAutomationAdministrationRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by diagnosing SSM service health across all nodes. */
    AWSSSMDiagnosisAutomationExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions for operational accounts to diagnose unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide permission for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    AWSSSMRemediationAutomationAdministrationRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by remediating SSM services health across all nodes. */
    AWSSSMRemediationAutomationExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions for operational accounts to Remediate unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows users to access the Account Activity page. */
    AWSAccountActivityAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Account Management. */
    AWSAccountManagementFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Account Management */
    AWSAccountManagementReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows users to access the Account Usage Report page. */
    AWSAccountUsageReportAccess(): aws_iam.IManagedPolicy;
    /** Provides access for the Discovery Agentless Connector to register with AWS Application Discovery Service. */
    AWSAgentlessDiscoveryService(): aws_iam.IManagedPolicy;
    /** Provides full access to the AWS AppFabric service and read only access to dependent services such as S3, Kinesis, KMS. */
    AWSAppFabricFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to the AWS AppFabric */
    AWSAppFabricReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides AppFabric access to AWS resources on your behalf */
    AWSAppFabricServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access AppStream and CloudWatch. */
    AWSApplicationAutoscalingAppStreamFleetPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Cassandra and CloudWatch. */
    AWSApplicationAutoscalingCassandraTablePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Comprehend and CloudWatch. */
    AWSApplicationAutoscalingComprehendEndpointPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access APIGateway and CloudWatch for custom resource scaling */
    AWSApplicationAutoScalingCustomResourcePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access DynamoDB and CloudWatch. */
    AWSApplicationAutoscalingDynamoDBTablePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access EC2 Spot Fleet and CloudWatch. */
    AWSApplicationAutoscalingEC2SpotFleetRequestPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access EC2 Container Service and CloudWatch. */
    AWSApplicationAutoscalingECSServicePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Amazon ElastiCache and Amazon CloudWatch. */
    AWSApplicationAutoscalingElastiCacheRGPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Elastic Map Reduce and CloudWatch. */
    AWSApplicationAutoscalingEMRInstanceGroupPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Managed Streaming for Apache Kafka and CloudWatch. */
    AWSApplicationAutoscalingKafkaClusterPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Lambda and CloudWatch. */
    AWSApplicationAutoscalingLambdaConcurrencyPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Amazon Neptune and Amazon CloudWatch. */
    AWSApplicationAutoscalingNeptuneClusterPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access RDS and CloudWatch. */
    AWSApplicationAutoscalingRDSClusterPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access SageMaker and CloudWatch. */
    AWSApplicationAutoscalingSageMakerEndpointPolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to Application Auto Scaling to access Amazon WorkSpaces and Amazon CloudWatch. */
    AWSApplicationAutoscalingWorkSpacesPoolPolicy(): aws_iam.IManagedPolicy;
    /** Provides access for the Discovery Agent to register with AWS Application Discovery Service. */
    AWSApplicationDiscoveryAgentAccess(): aws_iam.IManagedPolicy;
    /** Allows Application Discovery Service Agentless Collectors to auto update, register, and communicate with Application Discovery Service */
    AWSApplicationDiscoveryAgentlessCollectorAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to view and tag Configuration Items maintained by the AWS Application Discovery Service */
    AWSApplicationDiscoveryServiceFullAccess(): aws_iam.IManagedPolicy;
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    AWSApplicationMigrationAgentInstallationPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows installing and using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    AWSApplicationMigrationAgentPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationAgentPolicyV2(): aws_iam.IManagedPolicy;
    /** This policy allows the Application Migration Service (MGN) Conversion Server, which are EC2 instances launched by Application Migration Service, to communicate with the MGN service. An IAM role with this policy is attached (as an EC2 Instance Profile) by MGN to the MGN Conversion Servers, which are automatically launched and terminated by MGN, when needed. We do not recommend that you attach this policy to your IAM users or roles. MGN Conversion Servers are used by Application Migration Service when users choose to launch Test or Cutover instances using the MGN console, CLI, or API. */
    AWSApplicationMigrationConversionServerPolicy(): aws_iam.IManagedPolicy;
    /** This policy provides Amazon EC2 operations required to use Application Migration Service (MGN) to launch the migrated servers as EC2 instances. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationEC2Access(): aws_iam.IManagedPolicy;
    /** This policy provides permissions to all public APIs of AWS Application Migration Service (MGN), as well as permissions to read KMS key information. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationFullAccess(): aws_iam.IManagedPolicy;
    /** This policy allows AWS Application Migration Service (MGN) to send meta-data about the progress of servers being migrated using MGN to AWS Migration Hub (MGH). MGN automatically creates an IAM role with this policy attached, and assumes this role. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationMGHAccess(): aws_iam.IManagedPolicy;
    /** This policy provides permissions to all read-only public APIs of Application Migration Service (MGN), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the MGN console. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy allows the Application Migration Service (MGN) Replication Servers, which are EC2 instances launched by Application Migration Service - to communicate with the MGN service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Application Migration Service to the MGN Replication Servers which are automatically launched and terminated by MGN, as needed. MGN Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the migration process managed using MGN. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationReplicationServerPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Application Migration Service (AWS MGN) to migrate source servers that run on EC2 (cross-Region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    AWSApplicationMigrationServiceEc2InstancePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS application Migration Service to create and manage AWS resources on your behalf. */
    AWSApplicationMigrationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy provides access to Amazon SSM operations required to use Application Migration Service (MGN) to execute custom post migration command SSM documents. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationSSMAccess(): aws_iam.IManagedPolicy;
    /** This policy allows installing and using the AWS VCenter Client, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS VCenter Client. */
    AWSApplicationMigrationVCenterClientPolicy(): aws_iam.IManagedPolicy;
    /** App Mesh Envoy policy for accessing Virtual Node configuration. */
    AWSAppMeshEnvoyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to the AWS App Mesh APIs and Management Console. */
    AWSAppMeshFullAccess(): aws_iam.IManagedPolicy;
    /** App Mesh Preview Envoy policy for accessing Virtual Node configuration. */
    AWSAppMeshPreviewEnvoyAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by AWS App Mesh */
    AWSAppMeshPreviewServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read-only access to the AWS App Mesh APIs and Management Console. */
    AWSAppMeshReadOnly(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by AWS AppMesh */
    AWSAppMeshServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to all App Runner actions. */
    AWSAppRunnerFullAccess(): aws_iam.IManagedPolicy;
    /** Grants permissions to list and view details about App Runner resources. */
    AWSAppRunnerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** AWS App Runner service policy that grants read permissions to Amazon ECR resources in the customer's account. Use it in a role that is passed to App Runner when creating or updating an App Runner service. */
    AWSAppRunnerServicePolicyForECRAccess(): aws_iam.IManagedPolicy;
    /** Provides administrative access to the AppSync service, though not enough to access via the console. */
    AWSAppSyncAdministrator(): aws_iam.IManagedPolicy;
    /** Provides full invoking access to the AppSync service - both through the console and independently */
    AWSAppSyncInvokeFullAccess(): aws_iam.IManagedPolicy;
    /** Allows AppSync to push logs to user's CloudWatch account. */
    AWSAppSyncPushToCloudWatchLogs(): aws_iam.IManagedPolicy;
    /** Provides access to create, update, and query the schema. */
    AWSAppSyncSchemaAuthor(): aws_iam.IManagedPolicy;
    /** Enables access to AWS services and resources used or managed by AppSync */
    AWSAppSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Artifact read-only access to operations in AWS Organizations. */
    AWSArtifactAccountSync(): aws_iam.IManagedPolicy;
    /** This policy grants full permissions to list, download, accept, and terminate AWS Artifact agreements. It also includes permissions to list and enable AWS service access in the Organization service, as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists and creates one if it doesn't */
    AWSArtifactAgreementsFullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants read-only access to list the AWS Artifact service agreements and to download the accepted agreements.. It also includes permissions to list as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists. */
    AWSArtifactAgreementsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to the AWS Artifact service reports. */
    AWSArtifactReportsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS Artifact to gather information about an organization via AWS Organizations service. */
    AWSArtifactServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides administrative access to enable or disable AWS Audit Manager, update settings, and manage assessments, controls, and frameworks */
    AWSAuditManagerAdministratorAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by AWS Audit Manager */
    AWSAuditManagerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to AWS Auto Scaling to periodically forecast capacity and generate scheduled scaling actions for Auto Scaling groups in a scaling plan */
    AWSAutoScalingPlansEC2AutoScalingPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions for users to create controls and frameworks that define their expectations for AWS Backup resources and activities, and to audit AWS Backup resources and activities against their defined controls and frameworks. This policy grants permissions to AWS Config and similar services to describe user expectations perform the audits. This policy also grants permissions to deliver audit reports to S3 and similar services, and enables users to find and open their audit reports. */
    AWSBackupAuditAccess(): aws_iam.IManagedPolicy;
    /** This policy allows the AWS Backint agent to complete backup data transfer with AWS Backup Storage plane. Attach this policy to roles assumed by EC2 Instances running SAP HANA with the Backint agent. */
    AWSBackupDataTransferAccess(): aws_iam.IManagedPolicy;
    /** This policy is for backup administrators, granting full access to AWS Backup operations, including creating or editing backup plans, assigning AWS resources to backup plans, deleting backups, and restoring backups. */
    AWSBackupFullAccess(): aws_iam.IManagedPolicy;
    /** Provides AWS BackupGateway permission to sync the metadata of Virtual Machines on your behalf */
    AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync(): aws_iam.IManagedPolicy;
    /** This policy grants users permissions to assign AWS resources to backup plans, create on-demand backups, and restore backups. This policy does not allow the user to create or edit backup plans or to delete scheduled backups after they are created. */
    AWSBackupOperatorAccess(): aws_iam.IManagedPolicy;
    /** This policy is for backup administators who use cross-account backup management to manage backups for the organization. */
    AWSBackupOrganizationAdminAccess(): aws_iam.IManagedPolicy;
    /** Provides AWS Backup permission to restore a backup of SAP HANA on Amazon EC2 */
    AWSBackupRestoreAccessForSAPHANA(): aws_iam.IManagedPolicy;
    /** The search operator role has access to create backup indexes, create searches of backup metadata that has been indexed. This policy contains the necessary permissions for these search operator functions. */
    AWSBackupSearchOperatorAccess(): aws_iam.IManagedPolicy;
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceLinkedRolePolicyForBackup(): aws_iam.IManagedPolicy;
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceLinkedRolePolicyForBackupTest(): aws_iam.IManagedPolicy;
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceRolePolicyForBackup(): aws_iam.IManagedPolicy;
    /** Policy containing permissions necessary for AWS Backup to index recovery points. */
    AWSBackupServiceRolePolicyForIndexing(): aws_iam.IManagedPolicy;
    /** Policy containing permissions necessary for AWS Backup to restore individual items in a recovery point */
    AWSBackupServiceRolePolicyForItemRestores(): aws_iam.IManagedPolicy;
    /** Provides AWS Backup permission to perform restores on your behalf across AWS services. This policy includes permissions to create and delete AWS resources, such as EBS volumes, RDS instances, and EFS file systems, which are part of the restore process. */
    AWSBackupServiceRolePolicyForRestores(): aws_iam.IManagedPolicy;
    /** Policy containing permissions necessary for AWS Backup to backup data in any S3 bucket. This includes read access to all S3 objects and any decrypt access for all KMS keys. */
    AWSBackupServiceRolePolicyForS3Backup(): aws_iam.IManagedPolicy;
    /** Policy containing permissions necessary for AWS Backup to restore a S3 backup to a bucket. This includes read/write permissions to all S3 buckets, and permissions to GenerateDataKey and DescribeKey for all KMS keys. */
    AWSBackupServiceRolePolicyForS3Restore(): aws_iam.IManagedPolicy;
    /** Provides full access for AWS Batch resources. */
    AWSBatchFullAccess(): aws_iam.IManagedPolicy;
    /** Policy to enable CloudWatch Event Target for AWS Batch Job Submission */
    AWSBatchServiceEventTargetRole(): aws_iam.IManagedPolicy;
    /** Policy for AWS Batch service role which allows access to related services including EC2, Autoscaling, EC2 Container service and Cloudwatch Logs. */
    AWSBatchServiceRole(): aws_iam.IManagedPolicy;
    /** A service linked role to provide Billing and Cost Management Data Exports access to AWS service data for exporting the data to a target location, such as Amazon S3, on behalf of a customer. */
    AWSBCMDataExportsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Use the AWSBillingConductorFullAccess managed policy to allow complete access to AWS Billing Conductor (ABC) console and APIs. This policy allows users to list, create and delete ABC resources. */
    AWSBillingConductorFullAccess(): aws_iam.IManagedPolicy;
    /** Use the AWSBillingConductorReadOnlyAccess managed policy to allow read only access to AWS Billing Conductor (ABC) console and APIs. This policy grants permission to view and list all ABC resources. It does not include the ability to create or delete resources. */
    AWSBillingConductorReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows users to view bills on the Billing Console. */
    AWSBillingReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy gives permissions to control AWS resources. For example, to start and stop EC2 or RDS instances by executing AWS Systems Manager (SSM) scripts. */
    AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Budgets Actions including using Budgets Actions to control states of running AWS resources via AWS Management Console */
    AWSBudgetsActionsWithAWSResourceControlAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Budgets Console via the AWS Management Console. */
    AWSBudgetsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This IAM policy grants users full access to the AWS BugBust console */
    AWSBugBustFullAccess(): aws_iam.IManagedPolicy;
    /** This IAM policy grants users access to participate in AWS BugBust events */
    AWSBugBustPlayerAccess(): aws_iam.IManagedPolicy;
    /** Grants permissions to AWS BugBust to access resources on your behalf */
    AWSBugBustServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Certificate Manager (ACM) */
    AWSCertificateManagerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides auditor access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAAuditor(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAFullAccess(): aws_iam.IManagedPolicy;
    /** Provides privileged certificate user access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAPrivilegedUser(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAReadOnly(): aws_iam.IManagedPolicy;
    /** Provides certificate user access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAUser(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Certificate Manager (ACM). */
    AWSCertificateManagerReadOnly(): aws_iam.IManagedPolicy;
    /** The Service Linked Role used by AWS Chatbot. */
    AWSChatbotServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows full access to AWS Clean Rooms resources and access to related AWS Services. */
    AWSCleanRoomsFullAccess(): aws_iam.IManagedPolicy;
    /** Allows full access to AWS Clean Rooms resources except for querying in a collaboration and access to related AWS Services. */
    AWSCleanRoomsFullAccessNoQuerying(): aws_iam.IManagedPolicy;
    /** Allows full access to AWS Clean Rooms ML resources and access to related AWS Services. */
    AWSCleanRoomsMLFullAccess(): aws_iam.IManagedPolicy;
    /** Allows read-only access to AWS Clean Rooms ML resources and read-only access to related AWS Clean Rooms resources */
    AWSCleanRoomsMLReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows read-only access to AWS Clean Rooms resources and read-only access to related AWS Glue and Amazon CloudWatch Logs resources. */
    AWSCleanRoomsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides administrator access to AWS Cloud9. */
    AWSCloud9Administrator(): aws_iam.IManagedPolicy;
    /** Provides the ability to be invited into AWS Cloud9 shared development environments. */
    AWSCloud9EnvironmentMember(): aws_iam.IManagedPolicy;
    /** Service Linked Role Policy for AWS Cloud9 */
    AWSCloud9ServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy will be used to attach a role on a InstanceProfile which will allow Cloud9 to use the SSM Session Manager to connect to the instance */
    AWSCloud9SSMInstanceProfile(): aws_iam.IManagedPolicy;
    /** Provides permission to create AWS Cloud9 development environments and to manage owned environments. */
    AWSCloud9User(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CloudFormation. */
    AWSCloudFormationFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS CloudFormation via the AWS Management Console. */
    AWSCloudFormationReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants CloudFront Logger write permissions to CloudWatch Logs. */
    AWSCloudFrontLogger(): aws_iam.IManagedPolicy;
    /** Allows CloudFront to manage EC2 Elastic Network Interfaces and Security Groups on your behalf. */
    AWSCloudFrontVPCOriginServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to all CloudHSM resources. */
    AWSCloudHSMFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all CloudHSM resources. */
    AWSCloudHSMReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Default policy for the AWS CloudHSM service role. */
    AWSCloudHSMRole(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Cloud Map discovery API. */
    AWSCloudMapDiscoverInstanceAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all AWS Cloud Map actions. */
    AWSCloudMapFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to all AWS Cloud Map actions. */
    AWSCloudMapReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides registrant level access to AWS Cloud Map actions. */
    AWSCloudMapRegisterInstanceAccess(): aws_iam.IManagedPolicy;
    /** Grants using AWS CloudShell with all features */
    AWSCloudShellFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CloudTrail. */
    AWSCloudTrailFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS CloudTrail. */
    AWSCloudTrailReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy is used by the service-linked role named AWSServiceRoleForCloudWatchAlarms_ActionSSMIncidents. CloudWatch uses this service-linked role to perform AWS System Manager Incident Manager actions when a CloudWatch alarm goes in to ALARM state. This policy grants permission to start incidents on your behalf. */
    AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CodeArtifact via the AWS Management Console. */
    AWSCodeArtifactAdminAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS CodeArtifact via the AWS Management Console. */
    AWSCodeArtifactReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts, and attach IAMFullAccess to create and manage the service role for CodeBuild. */
    AWSCodeBuildAdminAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS CodeBuild via the AWS Management Console, but does not allow CodeBuild project administration. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    AWSCodeBuildDeveloperAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    AWSCodeBuildReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CodeCommit via the AWS Management Console. */
    AWSCodeCommitFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CodeCommit repositories, but does not allow repository deletion. */
    AWSCodeCommitPowerUser(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS CodeCommit via the AWS Management Console. */
    AWSCodeCommitReadOnly(): aws_iam.IManagedPolicy;
    /** Provides access to register and deploy a revision. */
    AWSCodeDeployDeployerAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to CodeDeploy resources. */
    AWSCodeDeployFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to CodeDeploy resources. */
    AWSCodeDeployReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides CodeDeploy service access to expand tags and interact with Auto Scaling on your behalf. */
    AWSCodeDeployRole(): aws_iam.IManagedPolicy;
    /** Provides CodeDeploy service access to invoke Lambda function on your behalf to perform blue/green deployment through CloudFormation. */
    AWSCodeDeployRoleForCloudFormation(): aws_iam.IManagedPolicy;
    /** Provides CodeDeploy service wide access to perform an ECS blue/green deployment on your behalf. Grants full access to support services, such as  full access to read all S3 objects, invoke all Lambda functions, publish to all SNS topics within the account and update all ECS services. */
    AWSCodeDeployRoleForECS(): aws_iam.IManagedPolicy;
    /**  Provides CodeDeploy service limited access to perform an ECS blue/green deployment on your behalf. */
    AWSCodeDeployRoleForECSLimited(): aws_iam.IManagedPolicy;
    /** Provides CodeDeploy service access to perform a Lambda deployment on your behalf. */
    AWSCodeDeployRoleForLambda(): aws_iam.IManagedPolicy;
    /** Provides CodeDeploy service limited access to perform a Lambda deployment on your behalf. */
    AWSCodeDeployRoleForLambdaLimited(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CodePipeline via the AWS Management Console. */
    AWSCodePipelineFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS CodePipeline via the AWS Management Console. */
    AWSCodePipelineReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to view and approve manual changes for all pipelines */
    AWSCodePipelineApproverAccess(): aws_iam.IManagedPolicy;
    /** Provides access for custom actions to poll for jobs details (including temporary credentials) and report status updates to AWS CodePipeline. */
    AWSCodePipelineCustomActionAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS CodeStar via the AWS Management Console. */
    AWSCodeStarFullAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS CodeStar Notifications to access Amazon CloudWatch Events on your behalf */
    AWSCodeStarNotificationsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** DO NOT USE -  AWS CodeStar Service Role Policy which grants administrative privileges in order for CodeStar to manage IAM and other service resources on behalf of the customer. */
    AWSCodeStarServiceRole(): aws_iam.IManagedPolicy;
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly.  Do NOT remove this policy.  Instead, please follow the instructions specified in the email sent to you regarding this event. */
    AWSCompromisedKeyQuarantine(): aws_iam.IManagedPolicy;
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    AWSCompromisedKeyQuarantineV2(): aws_iam.IManagedPolicy;
    /** Denies access to certain actions, applied by AWS in the event that an IAM user's credentials have been compromised or exposed publicly. The policy aims to limit the potential damage that may be caused by fraud-related activity leading to unauthorized charges, while not impacting the existing resources. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    AWSCompromisedKeyQuarantineV3(): aws_iam.IManagedPolicy;
    /** Allows Config to call AWS services and deploy config resources across organization */
    AWSConfigMultiAccountSetupPolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Config to remediate noncompliant resources on your behalf. */
    AWSConfigRemediationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Config to call read-only AWS Organizations APIs */
    AWSConfigRoleForOrganizations(): aws_iam.IManagedPolicy;
    /** Allows an AWS Lambda function to access the AWS Config API and the configuration snapshots that AWS Config delivers periodically to Amazon S3. This access is required by functions that evaluate configuration changes for custom Config rules. */
    AWSConfigRulesExecutionRole(): aws_iam.IManagedPolicy;
    /** Allows Config to call AWS services and collect resource configurations on your behalf. */
    AWSConfigServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to use AWS Config, including searching by tags on resources, and reading all tags. This does not provide permission to configure AWS Config, which requires administrative privileges. */
    AWSConfigUserAccess(): aws_iam.IManagedPolicy;
    /** Enables broad read/write access to ALL EC2 objects, read/write access to S3 buckets starting with 'import-to-ec2-', and the ability to list all S3 buckets, for the AWS Connector to import VMs on your behalf. */
    AWSConnector(): aws_iam.IManagedPolicy;
    /** Allows AWS Control Tower to call AWS services that provide automated account configuration and centralized governance on your behalf. */
    AWSControlTowerAccountServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resources managed or used by AWS Control Tower */
    AWSControlTowerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to to describe the organization of the account, create S3 buckets for the MAP program and apply tags to it, create a Cost and Usage Report, and describe Cost and Usage Report definitions. */
    AWSCostAndUsageReportAutomationPolicy(): aws_iam.IManagedPolicy;
    /** Gives Data Grant owners access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    AWSDataExchangeDataGrantOwnerFullAccess(): aws_iam.IManagedPolicy;
    /** Gives Data Grant receiver access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    AWSDataExchangeDataGrantReceiverFullAccess(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeFullAccess(): aws_iam.IManagedPolicy;
    /** Grants data provider access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeProviderFullAccess(): aws_iam.IManagedPolicy;
    /** Grants read-only access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. */
    AWSDataExchangeReadOnly(): aws_iam.IManagedPolicy;
    /** Allows AWS Data Exchange to access AWS Services and Resources used or managed by AWS Data Exchange for license management. */
    AWSDataExchangeServiceRolePolicyForLicenseManagement(): aws_iam.IManagedPolicy;
    /** Allows AWS Data Exchange to read data about your AWS Organization to determine eligibility for AWS Data Exchange data grants license distribution. */
    AWSDataExchangeServiceRolePolicyForOrganizationDiscovery(): aws_iam.IManagedPolicy;
    /** Grants data subscriber access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeSubscriberFullAccess(): aws_iam.IManagedPolicy;
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources */
    AWSDataLifecycleManagerServiceRole(): aws_iam.IManagedPolicy;
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources for AMI Management */
    AWSDataLifecycleManagerServiceRoleForAMIManagement(): aws_iam.IManagedPolicy;
    /** Provides Amazon Data Lifecycle Manager permission to perform the Systems Manager actions required to run pre and post scripts on all Amazon EC2 instances. */
    AWSDataLifecycleManagerSSMFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    AWSDataPipelineFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    AWSDataPipelinePowerUser(): aws_iam.IManagedPolicy;
    /** Allows DataSync Discovery to integrate with other AWS services on your behalf. */
    AWSDataSyncDiscoveryServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS DataSync and minimal access to its dependencies */
    AWSDataSyncFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS DataSync */
    AWSDataSyncReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows DataSync to integrate with other AWS services on your behalf */
    AWSDataSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides AWS Deadline Cloud workers with access to run tasks on a farm. */
    AWSDeadlineCloudFleetWorker(): aws_iam.IManagedPolicy;
    /** Provides user workstation access to AWS Deadline Cloud farms with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessFarms(): aws_iam.IManagedPolicy;
    /** Provides user workstation access to AWS Deadline Cloud fleets with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessFleets(): aws_iam.IManagedPolicy;
    /** Provides user workstation access to AWS Deadline Cloud jobs with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessJobs(): aws_iam.IManagedPolicy;
    /** Provides user workstation access to AWS Deadline Cloud queues with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessQueues(): aws_iam.IManagedPolicy;
    /** Provides access for AWS Deadline Cloud worker hosts to join a fleet in a farm. */
    AWSDeadlineCloudWorkerHost(): aws_iam.IManagedPolicy;
    /** This policy specifies permissions required by DeepLens Administrative lambda functions that run on a DeepLens device */
    AWSDeepLensLambdaFunctionAccessPolicy(): aws_iam.IManagedPolicy;
    /** Grants AWS DeepLens access to AWS Services, resources and roles needed by DeepLens and its dependencies including IoT, S3, GreenGrass and AWS Lambda. */
    AWSDeepLensServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** DeepRacer admin access to all actions including toggling between multiuser and single user mode. */
    AWSDeepRacerAccountAdminAccess(): aws_iam.IManagedPolicy;
    /** Allows CloudFormation to create and manage AWS stacks and resources on your behalf. */
    AWSDeepRacerCloudFormationAccessPolicy(): aws_iam.IManagedPolicy;
    /** DeepRacer MultiUser Default user access to use deepracer in multi-user mode */
    AWSDeepRacerDefaultMultiUserAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS DeepRacer. Also provides select access to related services (e.g., S3). */
    AWSDeepRacerFullAccess(): aws_iam.IManagedPolicy;
    /** Allows RoboMaker to create required resources and call AWS services on your behalf. */
    AWSDeepRacerRoboMakerAccessPolicy(): aws_iam.IManagedPolicy;
    /** Allows DeepRacer to create required resources and call AWS services on your behalf. */
    AWSDeepRacerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Deny all access. */
    AWSDenyAll(): aws_iam.IManagedPolicy;
    /** Provides full access to all AWS Device Farm operations. */
    AWSDeviceFarmFullAccess(): aws_iam.IManagedPolicy;
    /** Grant permissions to AWS Device Farm to call EC2 Network APIs on your behalf. */
    AWSDeviceFarmServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grant permissions to AWS Device Farm to call EC2 APIs on your behalf. */
    AWSDeviceFarmTestGridServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Direct Connect via the AWS Management Console. */
    AWSDirectConnectFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Direct Connect via the AWS Management Console. */
    AWSDirectConnectReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides AWS Direct Connect permission to create and manage AWS resources on your behalf. */
    AWSDirectConnectServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Directory Service Data. */
    AWSDirectoryServiceDataFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Directory Service Data */
    AWSDirectoryServiceDataReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Directory Service. */
    AWSDirectoryServiceFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Directory Service. */
    AWSDirectoryServiceReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides write access to AWS resources required for AWS Discovery Continuous Export */
    AWSDiscoveryContinuousExportFirehosePolicy(): aws_iam.IManagedPolicy;
    /** Allows DMS Fleet Advisor to manage CloudWatch metrics on your behalf. */
    AWSDMSFleetAdvisorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants AWS DMS Serverless permissions to create and manage DMS resources in your account on your behalf */
    AWSDMSServerlessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows EC2 CapacityReservation Fleet service to manage Capacity Reservations */
    AWSEC2CapacityReservationFleetRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows EC2 Fleet to launch and manage instances. */
    AWSEC2FleetServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows EC2 Spot Fleet to launch and manage spot fleet instances */
    AWSEC2SpotFleetServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows EC2 Spot to launch and manage spot instances */
    AWSEC2SpotServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy is attached to the IAM role that's attached to your Amazon EC2 Windows Instances to enable the Amazon EC2 VSS solution to create and add tags to Amazon Machine Images (AMI) and EBS Snapshots. */
    AWSEC2VssSnapshotPolicy(): aws_iam.IManagedPolicy;
    /** Enables access to AWS services and resources used or managed by AWS ECR pull through cache */
    AWSECRPullThroughCacheServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide the instance in your custom platform builder environment permission to launch EC2 instance, create EBS snapshot and AMI, stream logs to Amazon CloudWatch Logs, and store artifacts in Amazon S3. */
    AWSElasticBeanstalkCustomPlatformforEC2Role(): aws_iam.IManagedPolicy;
    /** AWS Elastic Beanstalk Service policy for Health Monitoring system */
    AWSElasticBeanstalkEnhancedHealth(): aws_iam.IManagedPolicy;
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to update your resources on your behalf for maintenance purposes. */
    AWSElasticBeanstalkMaintenance(): aws_iam.IManagedPolicy;
    /** This policy is for the AWS Elastic Beanstalk service role used to perform managed updates of Elastic Beanstalk environments. This policy should not be attached to other users or roles. The policy grants broad permissions to create and manage resources across a number of AWS services including AutoScaling, EC2, ECS, Elastic Load Balancing and CloudFormation.  This policy also allows passing of any IAM role usable with those services. */
    AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy(): aws_iam.IManagedPolicy;
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to managed updates. */
    AWSElasticBeanstalkManagedUpdatesServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide the instances in your multicontainer Docker environment access to use the Amazon EC2 Container Service to manage container deployment tasks. */
    AWSElasticBeanstalkMulticontainerDocker(): aws_iam.IManagedPolicy;
    /** Grants read-only permissions. Explicitly allows operators to gain direct access to retrieve information about resources related to AWS Elastic Beanstalk applications. */
    AWSElasticBeanstalkReadOnly(): aws_iam.IManagedPolicy;
    /** AWSElasticBeanstalkRoleCore (Elastic Beanstalk operations role) Allows core operation of a web service environment. */
    AWSElasticBeanstalkRoleCore(): aws_iam.IManagedPolicy;
    /** (Elastic Beanstalk operations role) Allows an environment to manage Amazon CloudWatch Logs log groups. */
    AWSElasticBeanstalkRoleCWL(): aws_iam.IManagedPolicy;
    /** (Elastic Beanstalk operations role) Allows a multicontainer Docker environment to manage Amazon ECS clusters. */
    AWSElasticBeanstalkRoleECS(): aws_iam.IManagedPolicy;
    /** (Elastic Beanstalk operations role) Allows an environment to integrate an Amazon RDS instance. */
    AWSElasticBeanstalkRoleRDS(): aws_iam.IManagedPolicy;
    /** (Elastic Beanstalk operations role) Allows an environment to enable Amazon SNS topic integration. */
    AWSElasticBeanstalkRoleSNS(): aws_iam.IManagedPolicy;
    /** (Elastic Beanstalk operations role) Allows a worker environment tier to create an Amazon DynamoDB table and an Amazon SQS queue. */
    AWSElasticBeanstalkRoleWorkerTier(): aws_iam.IManagedPolicy;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-servicerole.html. AWS Elastic Beanstalk Service role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    AWSElasticBeanstalkService(): aws_iam.IManagedPolicy;
    /** AWS Elastic Beanstalk Service Linked Role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    AWSElasticBeanstalkServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide the instances in your web server environment access to upload log files to Amazon S3. */
    AWSElasticBeanstalkWebTier(): aws_iam.IManagedPolicy;
    /** Provide the instances in your worker environment access to upload log files to Amazon S3, to use Amazon SQS to monitor your application's job queue, to use Amazon DynamoDB to perform leader election, and to Amazon CloudWatch to publish metrics for health monitoring. */
    AWSElasticBeanstalkWorkerTier(): aws_iam.IManagedPolicy;
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide during the installation step of the AWS Replication Agent. */
    AWSElasticDisasterRecoveryAgentInstallationPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows using the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover source servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryAgentPolicy(): aws_iam.IManagedPolicy;
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (DRS), as well as permissions to read KMS key, License Manager, Resource Groups, Elastic Load Balancing, IAM, and EC2 information. Attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (AWS DRS), as well as all public APIs in other AWS services used by AWS DRS Console. Attach this policy to your users or roles. */
    AWSElasticDisasterRecoveryConsoleFullAccessV2(): aws_iam.IManagedPolicy;
    /** This policy is attached to the AWS Elastic Disaster Recovery Conversion server's instance role. This policy allows Elastic Disaster Recovery (DRS) Conversion Servers, which are EC2 instances launched by Elastic Disaster Recovery, to communicate with the DRS service. An IAM role with this policy is attached (as an EC2 Instance Profile) by DRS to the DRS Conversion Servers, which are automatically launched and terminated by DRS, when needed. We do not recommend that you attach this policy to your IAM users or roles. DRS Conversion Servers are used by Elastic Disaster Recovery when users choose to recover source servers using the DRS console, CLI, or API. */
    AWSElasticDisasterRecoveryConversionServerPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support cross-account replication and cross-account failback. */
    AWSElasticDisasterRecoveryCrossAccountReplicationPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Elastic Disaster Recovery (DRS) to recover source servers that run on EC2 (cross-region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    AWSElasticDisasterRecoveryEc2InstancePolicy(): aws_iam.IManagedPolicy;
    /** You can attach the AWSElasticDisasterRecoveryFailbackInstallationPolicy policy to your IAM identities.  This policy allows installing the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. Attach this policy to your IAM users or roles whose credentials you provide when running the Elastic Disaster Recovery Failback Client. */
    AWSElasticDisasterRecoveryFailbackInstallationPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows using the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryFailbackPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows you to use Amazon SSM and additional services required permissions to run post-launch actions in AWS Elastic Disaster Recovery (AWS DRS). Attach this policy to your IAM roles or users. */
    AWSElasticDisasterRecoveryLaunchActionsPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support network replication. */
    AWSElasticDisasterRecoveryNetworkReplicationPolicy(): aws_iam.IManagedPolicy;
    /** You can attach the AWSElasticDisasterRecoveryReadOnlyAccess policy to your IAM identities.  This policy provides permissions to all read-only public APIs of Elastic Disaster Recovery (DRS), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the DRS console. Attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy is attached to the instance role of Elastic Disaster Recovery's Recovery Instance.  This policy allows the Elastic Disaster Recovery (DRS) Recovery Instance, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to be able to failback to their original source infrastructure. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Recovery Instances. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryRecoveryInstancePolicy(): aws_iam.IManagedPolicy;
    /** This policy is attached to the Elastic Disaster Recovery Replication server's instance role. This policy allows the Elastic Disaster Recovery (DRS) Replication Servers, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Replication Servers which are automatically launched and terminated by DRS, as needed. DRS Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the recovery process managed by DRS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryReplicationServerPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Elastic Disaster Recovery to manage AWS resources on your behalf. */
    AWSElasticDisasterRecoveryServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy allows read-only access to AWS Elastic Disaster Recovery (DRS) resources such as source servers and jobs. It also allows creating a converted snapshot and sharing that EBS snapshot with a specific account. */
    AWSElasticDisasterRecoveryStagingAccountPolicy(): aws_iam.IManagedPolicy;
    /** This policy is used by AWS Elastic Disaster Recovery (DRS) to recover source servers into a separate target account and to allow failing back. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryStagingAccountPolicyV2(): aws_iam.IManagedPolicy;
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane - Classic */
    AWSElasticLoadBalancingClassicServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane */
    AWSElasticLoadBalancingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Elemental MediaConnect resources. */
    AWSElementalMediaConnectFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Elemental MediaConnect resources. */
    AWSElementalMediaConnectReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    AWSElementalMediaConvertFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    AWSElementalMediaConvertReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Elemental MediaLive resources */
    AWSElementalMediaLiveFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Elemental MediaLive resources */
    AWSElementalMediaLiveReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Elemental MediaPackage resources */
    AWSElementalMediaPackageFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Elemental MediaPackage resources */
    AWSElementalMediaPackageReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Elemental MediaPackageV2 resources. */
    AWSElementalMediaPackageV2FullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Elemental MediaPackageV2 resources. */
    AWSElementalMediaPackageV2ReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full read and write access to all MediaStore APIs */
    AWSElementalMediaStoreFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only permissions for MediaStore APIs */
    AWSElementalMediaStoreReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Elemental MediaTailor resources */
    AWSElementalMediaTailorFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Elemental MediaTailor resources */
    AWSElementalMediaTailorReadOnly(): aws_iam.IManagedPolicy;
    /** Policy to enable enhanced classic networking management feature. */
    AWSEnhancedClassicNetworkingMangementPolicy(): aws_iam.IManagedPolicy;
    /** Provides console full access to AWS Entity Resolution and related services. */
    AWSEntityResolutionConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Entity Resolution via the AWS Management Console. */
    AWSEntityResolutionConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy grants the Fault Injection Simulator Service permission in EC2 and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorEC2Access(): aws_iam.IManagedPolicy;
    /** This policy grants the Fault Injection Simulator Service permission in ECS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorECSAccess(): aws_iam.IManagedPolicy;
    /** This policy grants the Fault Injection Simulator Service permission in EKS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorEKSAccess(): aws_iam.IManagedPolicy;
    /** This policy grants the Fault Injection Simulator Service permission in EC2 networking and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorNetworkAccess(): aws_iam.IManagedPolicy;
    /** This policy grants the Fault Injection Simulator Service permission in RDS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorRDSAccess(): aws_iam.IManagedPolicy;
    /** This policy grants the Fault Injection Simulator Service permission in SSM and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorSSMAccess(): aws_iam.IManagedPolicy;
    /** Policy to enable access to AWS Service and Resources used or managed by Amazon FinSpace */
    AWSFinSpaceServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Full access for AWS FM Administrator */
    AWSFMAdminFullAccess(): aws_iam.IManagedPolicy;
    /** Read only access for AWS FM Administrator that allows monitoring AWS FM operations */
    AWSFMAdminReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS WAF actions for AWS Firewall Manager member accounts */
    AWSFMMemberReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Managed policy for AWS For Wordpress Plugin */
    AWSForWordPressPluginPolicy(): aws_iam.IManagedPolicy;
    /** Policy which allows AWS Code Connections to sync content from your git repository */
    AWSGitSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to AWS Global Accelerator to manage EC2 Elastic Network Interfaces and Security Groups. */
    AWSGlobalAcceleratorSLRPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Glue via the AWS Management Console */
    AWSGlueConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Glue via the AWS Management Console and access to sagemaker notebook instances. */
    AWSGlueConsoleSageMakerNotebookFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Glue DataBrew via the AWS Management Console. Also provides select access to related services (e.g., S3, KMS, Glue). */
    AwsGlueDataBrewFullAccessPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permission to glue to perform action on user's glue data catalog, this policy also provides permission to ec2 actions to allow glue to create ENI to connect to resources in the VPC, also allow glue to access registered data in lakeformation and permission to access user's cloudwatch */
    AWSGlueDataBrewServiceRole(): aws_iam.IManagedPolicy;
    /** Provides full access to the AWS Glue Schema Registry Service */
    AWSGlueSchemaRegistryFullAccess(): aws_iam.IManagedPolicy;
    /** Provides readonly access to the AWS Glue Schema Registry Service */
    AWSGlueSchemaRegistryReadonlyAccess(): aws_iam.IManagedPolicy;
    /** Policy for AWS Glue service role which allows customer to manage notebook server */
    AWSGlueServiceNotebookRole(): aws_iam.IManagedPolicy;
    /** Policy for AWS Glue service role which allows access to related services including EC2, S3, and Cloudwatch Logs */
    AWSGlueServiceRole(): aws_iam.IManagedPolicy;
    /** Provides permissions that allows users to create and use only the notebook sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    AwsGlueSessionUserRestrictedNotebookPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the notebook sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services. */
    AwsGlueSessionUserRestrictedNotebookServiceRole(): aws_iam.IManagedPolicy;
    /** Provides permissions that allows users to create and use only the interactive sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    AwsGlueSessionUserRestrictedPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the interactive sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services */
    AwsGlueSessionUserRestrictedServiceRole(): aws_iam.IManagedPolicy;
    /** Provides access within Amazon Grafana to create and manage workspaces for the entire organization. */
    AWSGrafanaAccountAdministrator(): aws_iam.IManagedPolicy;
    /** Access to read only operations in Amazon Grafana. */
    AWSGrafanaConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides only the ability to update user and group permissions for AWS Grafana workspaces. */
    AWSGrafanaWorkspacePermissionManagement(): aws_iam.IManagedPolicy;
    /** Provides ability to update IAM Identity Center (IdC) user and group permissions for Amazon Managed Grafana workspaces. */
    AWSGrafanaWorkspacePermissionManagementV2(): aws_iam.IManagedPolicy;
    /** This policy gives full access to the AWS Greengrass configuration, management and deployment actions */
    AWSGreengrassFullAccess(): aws_iam.IManagedPolicy;
    /** This policy gives read only access to the AWS Greengrass configuration, management and deployment actions */
    AWSGreengrassReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Policy for AWS Greengrass service role which allows access to related services including AWS Lambda and AWS IoT thing shadows. */
    AWSGreengrassResourceAccessRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides the Dataflow Endpoint Instance permissions to use the AWS Ground Station Agent */
    AWSGroundStationAgentInstancePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Health to enable the Health event processor feature. */
    AWSHealthEventProcessorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows full access to the AWS Health Apis and Notifications and the Personal Health Dashboard */
    AWSHealthFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Health Imaging service. */
    AWSHealthImagingFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Health Imaging service. */
    AWSHealthImagingReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides the list of actions that are allowed for roles assumed with the IAM Identity Center identity context. AWS Security Token Service (AWS STS) automatically attaches this policy to assumed roles. The identity context is passed as ProvidedContext. */
    AWSIAMIdentityCenterAllowListForIdentityContext(): aws_iam.IManagedPolicy;
    /** Grants full access to the Identity Sync service */
    AWSIdentitySyncFullAccess(): aws_iam.IManagedPolicy;
    /** Read only access to the Identity Sync service */
    AWSIdentitySyncReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to all AWS Image Builder actions and resource scoped access to related AWS services. */
    AWSImageBuilderFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all AWS Image Builder actions. */
    AWSImageBuilderReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read and write access to the jobs created under the AWS account. */
    AWSImportExportFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to the jobs created under the AWS account. */
    AWSImportExportReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants Incident Manager permissions to call other AWS services as a part of managing an incident. */
    AWSIncidentManagerIncidentAccessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to start, view, and update incidents with full access to custom timeline events & related items. Assign this policy to users who will create and resolve incidents. */
    AWSIncidentManagerResolverAccess(): aws_iam.IManagedPolicy;
    /** This policy grants Incident Manager permission to manage incident records and related resources on your behalf. */
    AWSIncidentManagerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS IoT 1-Click. */
    AWSIoT1ClickFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS IoT 1-Click. */
    AWSIoT1ClickReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to IoT Analytics. */
    AWSIoTAnalyticsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to IoT Analytics. */
    AWSIoTAnalyticsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy gives full access to the AWS IoT configuration actions */
    AWSIoTConfigAccess(): aws_iam.IManagedPolicy;
    /** This policy gives read only access to the AWS IoT configuration actions */
    AWSIoTConfigReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy gives full access to the AWS IoT messaging actions */
    AWSIoTDataAccess(): aws_iam.IManagedPolicy;
    /** Provides write access to IoT thing groups and read access to IoT Certificates for execution of ADD_THINGS_TO_THING_GROUP mitigation action */
    AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction(): aws_iam.IManagedPolicy;
    /** Provides read access for IoT and related resources */
    AWSIoTDeviceDefenderAudit(): aws_iam.IManagedPolicy;
    /** Provides access for enabling IoT logging for execution of ENABLE_IOT_LOGGING mitigation action */
    AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction(): aws_iam.IManagedPolicy;
    /** Provides messages publish access to SNS topic for execution of PUBLISH_FINDING_TO_SNS mitigation action */
    AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction(): aws_iam.IManagedPolicy;
    /** Provides write access to IoT policies for execution of REPLACE_DEFAULT_POLICY_VERSION mitigation action */
    AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction(): aws_iam.IManagedPolicy;
    /** Provides write access to IoT CA certificates for execution of  UPDATE_CA_CERTIFICATE mitigation action */
    AWSIoTDeviceDefenderUpdateCACertMitigationAction(): aws_iam.IManagedPolicy;
    /** Provides write access to IoT certificates for execution of UPDATE_DEVICE_CERTIFICATE mitigation action */
    AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction(): aws_iam.IManagedPolicy;
    /** Allows AWS IoT Device Tester to run the FreeRTOS qualification suite by allowing access to services including IoT, S3, and IAM */
    AWSIoTDeviceTesterForFreeRTOSFullAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS IoT Device Tester to run the AWS Greengrass qualification suite by allowing access to related services including Lambda, IoT, API Gateway, IAM */
    AWSIoTDeviceTesterForGreengrassFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to IoT Events. */
    AWSIoTEventsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to IoT Events. */
    AWSIoTEventsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Federation access for IoT Fleet Hub applications */
    AWSIoTFleetHubFederationAccess(): aws_iam.IManagedPolicy;
    /** Grants permissions to AWS Resources and metaData used or managed by AWSIoTFleetwise for auxiliary features */
    AWSIoTFleetwiseServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy gives full access to the AWS IoT configuration and messaging actions */
    AWSIoTFullAccess(): aws_iam.IManagedPolicy;
    /** Allows creation of Amazon CloudWatch Log groups and streaming logs to the groups */
    AWSIoTLogging(): aws_iam.IManagedPolicy;
    /** Provides full access to managed integrations for AWS IoT Device Management and related services. */
    AWSIoTManagedIntegrationsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides managed integrations for AWS IoT Device Management permission to publish logs and metrics on your behalf. */
    AWSIoTManagedIntegrationsRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows access to create AWS IoT Job and describe the AWS code signer job */
    AWSIoTOTAUpdate(): aws_iam.IManagedPolicy;
    /** Allows access to all AWS services supported in AWS IoT Rule Actions */
    AWSIoTRuleActions(): aws_iam.IManagedPolicy;
    /** Provides full access to manage AWS IoT SiteWise using the AWS Management Console. Note this policy also grants access to create and list data stores used with AWS IoT SiteWise (e.g. AWS IoT Analytics), access to list and view AWS IoT Greengrass resources, list and modify AWS Secrets Manager secrets, retrieve AWS IoT thing shadows, list resources with specific tags, and create and use a service-linked role for AWS IoT SiteWise. */
    AWSIoTSiteWiseConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to IoT SiteWise. */
    AWSIoTSiteWiseFullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to access AWS IoT SiteWise assets and asset data, create AWS IoT SiteWise Monitor resources, and list AWS SSO users. */
    AWSIoTSiteWiseMonitorPortalAccess(): aws_iam.IManagedPolicy;
    /** This role grants AWS IoT SiteWise monitor permissions to access your AWS IoT SiteWise assets & asset properties, and create AWS IoT Sitewise projects, dashboards & access policies through AWS IoT SiteWise portals. */
    AWSIoTSiteWiseMonitorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read only access to IoT SiteWise. */
    AWSIoTSiteWiseReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This policy allows users to register things at bulk using AWS IoT StartThingRegistrationTask API */
    AWSIoTThingsRegistration(): aws_iam.IManagedPolicy;
    /** Allows AWS IoT TwinMaker to call other AWS services and to sync their resources on your behalf. */
    AWSIoTTwinMakerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows the associated identity data access to AWS IoT Wireless devices. */
    AWSIoTWirelessDataAccess(): aws_iam.IManagedPolicy;
    /** Allows the associated identity full access to all AWS IoT Wireless operations. */
    AWSIoTWirelessFullAccess(): aws_iam.IManagedPolicy;
    /** Provides IoT Wireless full access to publish to IoT Rules Engine on your behalf. */
    AWSIoTWirelessFullPublishAccess(): aws_iam.IManagedPolicy;
    /** Allows the associated identity access to create, list and describe IoT Certificates */
    AWSIoTWirelessGatewayCertManager(): aws_iam.IManagedPolicy;
    /** Allows the associated identity to create Amazon CloudWatch Logs groups and stream logs to the groups. */
    AWSIoTWirelessLogging(): aws_iam.IManagedPolicy;
    /** Allows the associated identity read only access to AWS IoT wireless. */
    AWSIoTWirelessReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows VPC IP Address Manager to access VPC resources and integrate with AWS Organizations on your behalf. */
    AWSIPAMServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Used by AWS IQ to execute payment requests on behalf of a customer */
    AWSIQContractServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS IQ */
    AWSIQFullAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS IQ to manage the role assumed by AWS IQ experts. */
    AWSIQPermissionServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables access to AWS services and resources required for AWS KMS custom key stores */
    AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables AWS KMS to synchronize the shared properties of multi-Region keys. */
    AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Key Management Service (KMS). */
    AWSKeyManagementServicePowerUser(): aws_iam.IManagedPolicy;
    /** Provides cross account access to Glue resources via Lake Formation. Also grants read access to other required services such as organizations and resource access manager */
    AWSLakeFormationCrossAccountManager(): aws_iam.IManagedPolicy;
    /** Grants administrative access to AWS Lake Formation and related services, such as AWS Glue, to manage data lakes */
    AWSLakeFormationDataAdmin(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    AWSLambdaFullAccess(): aws_iam.IManagedPolicy;
    /** Grants read-only access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    AWSLambdaReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides write permissions to CloudWatch Logs. */
    AWSLambdaBasicExecutionRole(): aws_iam.IManagedPolicy;
    /** Provides list and read access to DynamoDB streams and write permissions to CloudWatch logs. */
    AWSLambdaDynamoDBExecutionRole(): aws_iam.IManagedPolicy;
    /** Provides minimum permissions for a Lambda function to manage ENIs (create, describe, delete) used by a VPC-enabled Lambda Function. */
    AWSLambdaENIManagementAccess(): aws_iam.IManagedPolicy;
    /** Provides Put, Get access to S3 and full access to CloudWatch Logs. */
    AWSLambdaExecute(): aws_iam.IManagedPolicy;
    /** Provides read access to DynamoDB Streams. */
    AWSLambdaInvocationDynamoDB(): aws_iam.IManagedPolicy;
    /** Provides list and read access to Kinesis streams and write permissions to CloudWatch logs. */
    AWSLambdaKinesisExecutionRole(): aws_iam.IManagedPolicy;
    /** Provides permissions required to access MSK Cluster within a VPC, manage ENIs (create, describe, delete) in the VPC and write permissions to CloudWatch Logs. */
    AWSLambdaMSKExecutionRole(): aws_iam.IManagedPolicy;
    /** Grants Lambda Replicator necessary permissions to replicate functions across regions */
    AWSLambdaReplicator(): aws_iam.IManagedPolicy;
    /** Default policy for AWS Lambda service role. */
    AWSLambdaRole(): aws_iam.IManagedPolicy;
    /** Provides receive message, delete message, and read attribute access to SQS queues, and write permissions to CloudWatch logs. */
    AWSLambdaSQSQueueExecutionRole(): aws_iam.IManagedPolicy;
    /** Provides minimum permissions for a Lambda function to execute while accessing a resource within a VPC - create, describe, delete network interfaces and write permissions to CloudWatch Logs. */
    AWSLambdaVPCAccessExecutionRole(): aws_iam.IManagedPolicy;
    /** Provides permissions to allow access to the AWS License Manager API actions required to consume upon licenses that the user has entitlements. */
    AWSLicenseManagerConsumptionPolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS License Manager Linux Subscriptions Service to manage resources on your behalf. */
    AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** AWS License Manager service master account role policy */
    AWSLicenseManagerMasterAccountRolePolicy(): aws_iam.IManagedPolicy;
    /** AWS License Manager service member account role policy */
    AWSLicenseManagerMemberAccountRolePolicy(): aws_iam.IManagedPolicy;
    /** AWS License Manager service default role policy */
    AWSLicenseManagerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS License Manager User Subscriptions Service to manage resources on your behalf. */
    AWSLicenseManagerUserSubscriptionsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS M2 to manage AWS resources on your behalf. */
    AWSM2ServicePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Managed Services to read the values of the tags on AWS resources */
    AWSManagedServicesContactsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** AWS Managed Services - policy to manage detective controls infrastructure */
    AWSManagedServicesDetectiveControlsConfigServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** AWS Managed Services policy to enable AMS event processor feature. */
    AWSManagedServicesEventsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon's AWS Managed Service's Self Service Reporting feature to read AWS Organization data on your behalf to enable organization level aggregated reporting */
    AWSManagedServicesSelfServiceReportingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Managed Services to manage deployment toolkit on your behalf. */
    AWSManagedServicesDeploymentToolkitPolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Marketplace to copy your Amazon Machine Images (AMIs) in order to list them on AWS Marketplace */
    AWSMarketplaceAmiIngestion(): aws_iam.IManagedPolicy;
    /** Allows AWS Marketplace to create and manage seller deployment parameters for the products that you subscribe to on AWS Marketplace. */
    AWSMarketplaceDeploymentServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software, allows users to manage Marketplace software instances from the Marketplace 'Your Software' page, and provides administrative access to EC2. */
    AWSMarketplaceFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read access to AWS Marketplace Entitlements */
    AWSMarketplaceGetEntitlements(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for license management. */
    AWSMarketplaceLicenseManagementServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software */
    AWSMarketplaceManageSubscriptions(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Marketplace Metering. */
    AWSMarketplaceMeteringFullAccess(): aws_iam.IManagedPolicy;
    /** Provides permissions to register a resource and track usage through AWS Marketplace Metering Service. */
    AWSMarketplaceMeteringRegisterUsage(): aws_iam.IManagedPolicy;
    /** Provides full access to all administrative actions for an AWS Marketplace eProcurement integration. */
    AWSMarketplaceProcurementSystemAdminFullAccess(): aws_iam.IManagedPolicy;
    /** Enables access for AWS Marketplace services to purchase order management. */
    AWSMarketplacePurchaseOrdersServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides the ability to review AWS Marketplace subscriptions */
    AWSMarketplaceReadOnly(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for Resale Authorization. */
    AWSMarketplaceResaleAuthorizationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to all seller operations on the AWS Marketplace and other AWS services such as AMI management. */
    AWSMarketplaceSellerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides sellers access to Offers and Agreements management activities. */
    AWSMarketplaceSellerOfferManagement(): aws_iam.IManagedPolicy;
    /** Provides sellers full access to AWS Marketplace Management Products page and other AWS services such as AMI management. */
    AWSMarketplaceSellerProductsFullAccess(): aws_iam.IManagedPolicy;
    /** Provide sellers read-only access to AWS Marketplace Management Products page. */
    AWSMarketplaceSellerProductsReadOnly(): aws_iam.IManagedPolicy;
    /** The default policy that enables access to AWS Services and Resources used or managed by MediaConnect. */
    AWSMediaConnectServicePolicy(): aws_iam.IManagedPolicy;
    /** Allows MediaLive Anywhere to create and manage AWS resources on your behalf. */
    AWSMediaLiveAnywhereServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enable access to AWS Resources used or managed by MediaTailor */
    AWSMediaTailorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy allows AWSMigrationHubService to call AWSApplicationDiscoveryService on behalf of the customer. */
    AWSMigrationHubDiscoveryAccess(): aws_iam.IManagedPolicy;
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    AWSMigrationHubDMSAccess(): aws_iam.IManagedPolicy;
    /** Managed policy to provide the customer access to the Migration Hub Service */
    AWSMigrationHubFullAccess(): aws_iam.IManagedPolicy;
    /** Provides limited access to AWS Migration Hub, AWS Application Discovery Service, Amazon Simple Storage Service and AWS Secrets Manager. This policy also grants full access to AWS Migration Hub Orchestrator service. */
    AWSMigrationHubOrchestratorConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** This policy needs to be attached for SAP and MGN migrated instance for our service to orchestrate instances by downloading scripts from S3 and to fetch secret values inside EC2 instance. */
    AWSMigrationHubOrchestratorInstanceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides limited access to Amazon Simple Storage Service, AWS Secrets Manager and Plugin related actions for AWS Migration Hub Orchestrator. */
    AWSMigrationHubOrchestratorPlugin(): aws_iam.IManagedPolicy;
    /** Provides permissions necessary for Migration Hub Orchestrator to migrate and modernize your on-premises workloads */
    AWSMigrationHubOrchestratorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS Migration Hub Refactor Spaces and other AWS related services except AWS Transit Gateway and EC2 security groups not required when using environments without a network bridge. This policy also excludes permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess(): aws_iam.IManagedPolicy;
    /** Use in the IAM service role passed to the SSM Automation document AWSRefactorSpaces-CreateResources to grant permissions required to run the automation. The policy grants read/write access to EC2 tags in order to track automation progress. When the Refactor Spaces environment's network bridge is enabled, the automation also adds the environment's security group to the EC2 instance to permit traffic from other Refactor Spaces services in the environment. The policy also grants access to the Application Migration Service's post launch actions SSM parameters. */
    AWSMigrationHubRefactorSpacesSSMAutomationPolicy(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS MigrationHub Refactor Spaces, AWS MigrationHub Refactor Spaces console features and other related AWS services except permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    AWSMigrationHubRefactorSpacesFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resources managed or used by AWS Migration Hub Refactor Spaces. */
    AWSMigrationHubRefactorSpacesServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    AWSMigrationHubSMSAccess(): aws_iam.IManagedPolicy;
    /** Grants permissions to allow communication with the AWS Migration Hub Strategy Recommendations service, read/write access to S3 buckets related to the service, Amazon API Gateway access to upload logs and metrics to AWS, AWS Secrets Manager access to fetch credentials, and any related services. */
    AWSMigrationHubStrategyCollector(): aws_iam.IManagedPolicy;
    /** Grants full access to the AWS Migration Hub Strategy Recommendations service and access to related AWS services through the AWS Management Console. */
    AWSMigrationHubStrategyConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Enable access to AWS Resources used or managed by AWS Migration Hub Strategy Recommendations service. */
    AWSMigrationHubStrategyServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to Amazon MSK Replicator to replicate data between MSK Clusters. */
    AWSMSKReplicatorExecutionRole(): aws_iam.IManagedPolicy;
    /** Grants full access to AWS Network Firewall service, including permissions to create, configure, manage, and delete firewall resources, policies, and rule groups. Additionally includes permissions to modify VPC endpoints, S3 bucket policies, CloudWatch Logs configurations, and create service-linked roles for Network Firewall and log delivery services */
    AWSNetworkFirewallFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Network Firewall resources via the AWS Management Console, CLI, and SDKs. This policy allows users to view and monitor firewall configurations, policies, rule groups, and associated resources, without the ability to make changes. */
    AWSNetworkFirewallReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allow AWSNetworkFirewall to create and manage necessary resources for your Firewalls. */
    AWSNetworkFirewallServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allow NetworkManager to access resources associated with your Core Network */
    AWSNetworkManagerCloudWANServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon NetworkManager via the AWS Management Console. */
    AWSNetworkManagerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon NetworkManager via the AWS Management Console. */
    AWSNetworkManagerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allow NetworkManager to access resources associated with your Global Networks */
    AWSNetworkManagerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to manage AWS Config Configuration Recorder, manage AWS Config Configuration Aggregator, create AWS Config Service Linked Role for Configuration Recorder functionality, consume recorder configuration data, and read AWS Organizations data for organizational features. */
    AWSObservabilityAdminServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS OpsWorks. */
    AWSOpsWorksFullAccess(): aws_iam.IManagedPolicy;
    /** Enables OpsWorks instances with the CWLogs integration enabled to ship logs and create required log groups */
    AWSOpsWorksCloudWatchLogs(): aws_iam.IManagedPolicy;
    /** Provides S3 access for instances launched by OpsWorks CM. */
    AWSOpsWorksCMInstanceProfileRole(): aws_iam.IManagedPolicy;
    /** Service Role Policy to be used for Creating OpsWorks CM servers. */
    AWSOpsWorksCMServiceRole(): aws_iam.IManagedPolicy;
    /** Provides access for an Amazon EC2 instance to register with an AWS OpsWorks stack. */
    AWSOpsWorksInstanceRegistration(): aws_iam.IManagedPolicy;
    /** Policy to enable registration of EC2 instances via the OpsWorks CLI */
    AWSOpsWorksRegisterCLIEC2(): aws_iam.IManagedPolicy;
    /** Policy to enable registration of On-Premises instances via the OpsWorks CLI */
    AWSOpsWorksRegisterCLIOnPremises(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Organizations. */
    AWSOrganizationsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Organizations. */
    AWSOrganizationsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** A policy to allow AWS Organizations to share trust with other approved AWS Services for the purpose of simplifying customer configuration. */
    AWSOrganizationsServiceTrustPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions that allow you to install an Outpost server on your on-premises network. */
    AWSOutpostsAuthorizeServerPolicy(): aws_iam.IManagedPolicy;
    /** Service Linked Role policy to enable access to AWS resources managed by AWS Outposts */
    AWSOutpostsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS IoT software on an AWS Panorama Appliance to upload logs to Amazon CloudWatch. */
    AWSPanoramaApplianceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows an AWS Panorama Appliance to upload logs to Amazon CloudWatch, and to get objects from Amazon S3 access points created for use with AWS Panorama. */
    AWSPanoramaApplianceServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Panorama */
    AWSPanoramaFullAccess(): aws_iam.IManagedPolicy;
    /** Allows an AWS Lambda function on an AWS Panorama Appliance to manage resources in Panorama, upload logs and metrics to Amazon CloudWatch, and to manage objects in buckets created for use with Panorama. */
    AWSPanoramaGreengrassGroupRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon SageMaker to manage objects in buckets created for use with AWS Panorama. */
    AWSPanoramaSageMakerRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Panorama to manage resources in AWS IoT, AWS Secrets Manager and AWS Panorama. */
    AWSPanoramaServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Panorama to manage resources in Amazon S3, AWS IoT, AWS IoT GreenGrass, AWS Lambda, Amazon SageMaker, and Amazon CloudWatch Logs, and to pass service roles to AWS IoT, AWS IoT GreenGrass, and Amazon SageMaker. */
    AWSPanoramaServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Partner Central and related AWS Services. */
    AWSPartnerCentralFullAccess(): aws_iam.IManagedPolicy;
    /** Provides necessary access for opportunity management activities. */
    AWSPartnerCentralOpportunityManagement(): aws_iam.IManagedPolicy;
    /** Provides necessary access for developer testing in the Sandbox catalog. */
    AWSPartnerCentralSandboxFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to the ResourceSnapshotJob to read a resource and snapshot it in the target engagement. */
    AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy can be used to grant read-only access to APIs that can read service metadata for services in your AWS account. You can use this policy to provide your partners in the Partner-Led Support Program with access to the services specified in the permissions details section below. */
    AWSPartnerLedSupportReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants permission to AWS PCS compute nodes to connect to AWS PCS clusters. */
    AWSPCSComputeNodePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to PCS to manage resources on your behalf. */
    AWSPCSServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Price List Service. */
    AWSPriceListServiceFullAccess(): aws_iam.IManagedPolicy;
    /** Provides auditor access to AWS Private Certificate Authority */
    AWSPrivateCAAuditor(): aws_iam.IManagedPolicy;
    /** Grants essential permissions for the AWS Private CA Connector for Kubernetes. */
    AWSPrivateCAConnectorForKubernetesPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Private Certificate Authority */
    AWSPrivateCAFullAccess(): aws_iam.IManagedPolicy;
    /** Provides privileged certificate user access to AWS Private Certificate Authority */
    AWSPrivateCAPrivilegedUser(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Private Certificate Authority */
    AWSPrivateCAReadOnly(): aws_iam.IManagedPolicy;
    /** Provides certificate user access to AWS Private Certificate Authority */
    AWSPrivateCAUser(): aws_iam.IManagedPolicy;
    /** Provides full access to all administrative actions for an AWS Private Marketplace. */
    AWSPrivateMarketplaceAdminFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to creating requests in an AWS Private Marketplace. */
    AWSPrivateMarketplaceRequests(): aws_iam.IManagedPolicy;
    /** Allows AWS Private Networks Service to manage resources on behalf of the customer. */
    AWSPrivateNetworksServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Permissions CodeBuild needs to run a build for AWS Proton CodeBuild Provisioning. */
    AWSProtonCodeBuildProvisioningBasicAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS Proton to manage Proton resource provisioning using CodeBuild and other AWS services on your behalf. */
    AWSProtonCodeBuildProvisioningServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to the AWS Proton APIs and Management Console, but does not allow administration of Proton templates or environments. */
    AWSProtonDeveloperAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to the AWS Proton APIs and Management Console. In addition to these permissions, access to Amazon S3 is also needed to register template bundles from your S3 buckets, as well as access to Amazon IAM to create and manage the service roles for Proton. */
    AWSProtonFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to the AWS Proton APIs and Management Console. */
    AWSProtonReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Policy which allows AWS Proton to sync your service, environment and component definitions from your git repository to AWS Proton. */
    AWSProtonServiceGitSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy which allows AWS Proton to sync your git repository contents to Proton or sync Proton contents to your git repositories. */
    AWSProtonSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to view and modify purchase orders on billing console */
    AWSPurchaseOrdersServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** The AWSQuickSetupCFGCPacksPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to deploy AWS Config conformance packs. */
    AWSQuickSetupCFGCPacksPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** Provides permissions for AWS Systems Manager Quick Setup to deploy multiple configuration types. These configuration types create IAM roles and automations that configure frequently used Amazon Web Services services and features with recommended best practices. */
    AWSQuickSetupDeploymentRolePolicy(): aws_iam.IManagedPolicy;
    /** The AWSQuickSetupDevOpsGuruPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure Amazon DevOps Guru. This policy also provides permissions to enable Systems Manager Explorer. */
    AWSQuickSetupDevOpsGuruPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Distributor feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupDistributorPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** This policy grants permissions that allow Systems Manager to run the AWSQuickSetupType-EnableAREX Automation runbook, which enables AWS Resource Explorer for use with Systems Manager. */
    AWSQuickSetupEnableAREXExecutionPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions that allow principals to run the AWSQuickSetupType-EnableDHMC Automation runbook, which enables Default Host Management Configuration. */
    AWSQuickSetupEnableDHMCExecutionPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Quick Setup to deploy the configuration type required to set up just-in-time node access. */
    AWSQuickSetupJITNADeploymentRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants administrative permissions that allow Systems Manager to create a default IAM instance profile for the Quick Setup capability and attach it to Amazon EC2 instances that don't already have an instance. profile attached. */
    AWSQuickSetupManagedInstanceProfileExecutionPolicy(): aws_iam.IManagedPolicy;
    /** This policy provides permissions to enable just-in-time node access for Systems Manager. */
    AWSQuickSetupManageJITNAResourcesExecutionPolicy(): aws_iam.IManagedPolicy;
    /** Provides read-only permissions to access patch baselines that have been configured by an administrator in the current AWS account or organization using Quick Setup. */
    AWSQuickSetupPatchPolicyBaselineAccess(): aws_iam.IManagedPolicy;
    /** Provides permissions that allow Quick Setup to create resources associated with a patch policy configuration. */
    AWSQuickSetupPatchPolicyDeploymentRolePolicy(): aws_iam.IManagedPolicy;
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Patch Manager feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupPatchPolicyPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** The AWSQuickSetupSchedulerPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure scheduled operations on Amazon EC2 instances and other resources. */
    AWSQuickSetupSchedulerPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** This policy grants administrative permssions that allow Quick Setup to create resources that are used during the Systems Manager onboarding process. */
    AWSQuickSetupSSMDeploymentRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions for listing all S3 buckets in an account; and for managing and retrieving information about specific buckets in the principal account that are managed through AWS CloudFormation templates. */
    AWSQuickSetupSSMDeploymentS3BucketRolePolicy(): aws_iam.IManagedPolicy;
    /** Quick Setup creates IAM roles which enable it to configure the Host Manager Quick Setup type on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupSSMHostMgmtPermissionsBoundary(): aws_iam.IManagedPolicy;
    /** The policy grants administrative permissions that allow Quick Setup to run the a AWS CloudFormation custom resource on lifecycle events during Quick Setup deployment in Systems Manager. */
    AWSQuickSetupSSMLifecycleManagementExecutionPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions that allow Systems Manager to create prerequisites such as IAM roles required for Systems Manager onboarding. */
    AWSQuickSetupSSMManageResourcesExecutionPolicy(): aws_iam.IManagedPolicy;
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Export Operations */
    AWSQuickSightAssetBundleExportPolicy(): aws_iam.IManagedPolicy;
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Import Operations */
    AWSQuickSightAssetBundleImportPolicy(): aws_iam.IManagedPolicy;
    /** Quicksight access to Athena API and S3 buckets used for Athena query results */
    AWSQuicksightAthenaAccess(): aws_iam.IManagedPolicy;
    /** Allow QuickSight to describe the RDS resources */
    AWSQuickSightDescribeRDS(): aws_iam.IManagedPolicy;
    /** Allow QuickSight to describe Redshift resources */
    AWSQuickSightDescribeRedshift(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon Elasticsearch resources from Amazon QuickSight */
    AWSQuickSightElasticsearchPolicy(): aws_iam.IManagedPolicy;
    /** Give QuickSight read-only access to IoT Analytics datasets */
    AWSQuickSightIoTAnalyticsAccess(): aws_iam.IManagedPolicy;
    /** Allow QuickSight to list IAM entities */
    AWSQuickSightListIAM(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon OpenSearch resources from Amazon QuickSight */
    AWSQuicksightOpenSearchPolicy(): aws_iam.IManagedPolicy;
    /** Provides access to Amazon SageMaker resources from Amazon QuickSight */
    AWSQuickSightSageMakerPolicy(): aws_iam.IManagedPolicy;
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    AWSQuickSightSecretsManagerWriteAccess(): aws_iam.IManagedPolicy;
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    AWSQuickSightSecretsManagerWritePolicy(): aws_iam.IManagedPolicy;
    /** AWS QuickSight access to AWS Timestream APIs. Customers can attach this policy to AWS QuickSight role to allow retrieval of data and metadata. */
    AWSQuickSightTimestreamPolicy(): aws_iam.IManagedPolicy;
    /** Allows VPC Reachability Analyzer to access AWS resources and integrate with AWS Organizations on your behalf. */
    AWSReachabilityAnalyzerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permission to use AWS services with the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. It is intended to be attached to a local AWS profile. The policy allows uploading application artifacts and downloading the resulting artifacts from Amazon S3. It allows building applications into a container image using AWS CodeBuild and storing and retrieving the images from Amazon Elastic Container Registry (Amazon ECR). And it allows deployment of the application to container services on AWS such as Amazon Elastic Container Service (Amazon ECS), optional creation of VPC resources, optional connection to existing infrastructure such as AWS Directory Service, and other related services. */
    AWSRefactoringToolkitFullAccess(): aws_iam.IManagedPolicy;
    /** This policy is intended to be used by Amazon ECS Tasks created for testing applications in AWS using the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. The policy grants access to download application artifacts from Amazon S3, communicate the status of the Task using AWS Systems Manager, and other required services. */
    AWSRefactoringToolkitSidecarPolicy(): aws_iam.IManagedPolicy;
    /** Provides re:Post Private access to publish CloudWatch metrics data */
    AWSrePostPrivateCloudWatchAccess(): aws_iam.IManagedPolicy;
    /** This policy allows the re:Post Space service to create, manage, and resolve Support cases that are created through the Space application. */
    AWSRepostSpaceSupportOperationsPolicy(): aws_iam.IManagedPolicy;
    /** Policy for AWS Resilience Hub service role which allows access to other AWS services in order to execute assessment. */
    AWSResilienceHubAsssessmentExecutionPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Resource Access Manager */
    AWSResourceAccessManagerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Resource Access Manager. */
    AWSResourceAccessManagerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resource Access Manager APIs needed by a resource share participant. */
    AWSResourceAccessManagerResourceShareParticipantAccess(): aws_iam.IManagedPolicy;
    /** Policy containing Read-only AWS Resource Access Manager access to customers' Organizations structure. It also contains IAM permissions to self-delete the role. */
    AWSResourceAccessManagerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants administrative permissions to access Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    AWSResourceExplorerFullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants administrative permissions to Resource Explorer and grants read-only permissions to other AWS services to support this access. The AWS Organizations administrator needs these permissions to setup and manage multi-account search in the console. */
    AWSResourceExplorerOrganizationsAccess(): aws_iam.IManagedPolicy;
    /** This policy grants read-only permissions to search for and view Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    AWSResourceExplorerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Resource Explorer to view resources and CloudTrail events on your behalf to index your resources for search. */
    AWSResourceExplorerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This is the read only policy for AWS Resource Groups */
    AWSResourceGroupsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS RoboMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, IAM). */
    AWSRoboMakerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS RoboMaker via the AWS Management Console and SDK */
    AWSRoboMakerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** RoboMaker service policy */
    AWSRoboMakerServicePolicy(): aws_iam.IManagedPolicy;
    /** RoboMaker service policy */
    AWSRoboMakerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows IAM Roles Anywhere to publish service/usage metrics to CloudWatch and check the status of Private Certificate Authorities on your behalf. */
    AWSRolesAnywhereServicePolicy(): aws_iam.IManagedPolicy;
    /** Allow Amazon S3 on Outposts service to manage EC2 network resources on your behalf. */
    AWSS3OnOutpostsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Savings Plans service */
    AWSSavingsPlansFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Savings Plans service */
    AWSSavingsPlansReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to use AWS Security Hub. */
    AWSSecurityHubFullAccess(): aws_iam.IManagedPolicy;
    /** Grants permission to enable and manage AWS Security Hub within an organization. Includes enabling the service across the organization, and determining the delegated administrator account for the service. */
    AWSSecurityHubOrganizationsAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Security Hub resources */
    AWSSecurityHubReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** A service-linked role required for AWS Security Hub to access your resources. */
    AWSSecurityHubServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Security Hub to manage AWS Config rules and Security Hub resources in your organization and on your behalf. */
    AWSSecurityHubV2ServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy provides customers with Read and Write permissions to case resources that are created through the Security Incident Response service. */
    AWSSecurityIncidentResponseCaseFullAccess(): aws_iam.IManagedPolicy;
    /** Policy provides customers with Read and Write permissions to all resources associated to the Security Incident Response service. */
    AWSSecurityIncidentResponseFullAccess(): aws_iam.IManagedPolicy;
    /** Policy provides customers with Read-only permissions to all resources associated to the Security Incident Response service. Permission includes access to GetCaseAttachmentDownloadUrl as well for the ability to get case attachment download URLs. */
    AWSSecurityIncidentResponseReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Resources managed or used by Security Incident Response */
    AWSSecurityIncidentResponseServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Security Incident Response to continuously monitor your environment for security threats, tune security services to reduce alert noise, and gather information to investigate potential incidents. */
    AWSSecurityIncidentResponseTriageServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to service catalog admin capabilities */
    AWSServiceCatalogAdminFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Service Catalog admin capabilities */
    AWSServiceCatalogAdminReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Service Catalog App Registry capabilities */
    AWSServiceCatalogAppRegistryFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Service Catalog App Registry capabilites */
    AWSServiceCatalogAppRegistryReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Service Catalog AppRegistry to manage Resource Groups on your behalf */
    AWSServiceCatalogAppRegistryServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to service catalog enduser capabilities */
    AWSServiceCatalogEndUserFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Service Catalog end-user capabilities */
    AWSServiceCatalogEndUserReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** A Service Linked Role Policy for AWS ServiceCatalog to sync with AWS Organizations organization structure */
    AWSServiceCatalogOrgsDataSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** A Service Linked Role for AWS ServiceCatalog to sync Provisioning Artifacts from source repositories */
    AWSServiceCatalogSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Permissions required for managing nodegroups in the customer's account. These policies related to management of the following resources: AutoscalingGroups, SecurityGroups, LaunchTemplates and InstanceProfiles. */
    AWSServiceRoleForAmazonEKSNodegroup(): aws_iam.IManagedPolicy;
    /** This Service Linked Role provides Amazon Q Developer ability to provide usage information. */
    AWSServiceRoleForAmazonQDeveloper(): aws_iam.IManagedPolicy;
    /** This Service-Linked Role provides AWS Transform with the ability to provide usage information. */
    AWSServiceRoleForAWSTransform(): aws_iam.IManagedPolicy;
    /** Provides access to Systems Manager resources used by CloudWatch Alarms */
    AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows CloudWatch to access RDS Performance Insights metrics on your behalf */
    AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** A service-linked role required for Amazon CodeGuru Profiler to send notifications on your behalf. */
    AWSServiceRoleForCodeGuruProfiler(): aws_iam.IManagedPolicy;
    /** This role grants permissions to CodeWhisperer to access data in your account to calculate billing, provides access to create and access security reports in Amazon CodeGuru, and emit data to CloudWatch. */
    AWSServiceRoleForCodeWhispererPolicy(): aws_iam.IManagedPolicy;
    /** Allows EC2 Scheduled Instances to launch and manage spot instances. */
    AWSServiceRoleForEC2ScheduledInstances(): aws_iam.IManagedPolicy;
    /** AWS GroundStation uses this service-linked role to invoke EC2 to find public IPv4 addresses */
    AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy(): aws_iam.IManagedPolicy;
    /** Allows EC2ImageBuilder to call AWS services on your behalf. */
    AWSServiceRoleForImageBuilder(): aws_iam.IManagedPolicy;
    /** Allows AWS IoT SiteWise to provision and manage gateways as well as query data. The policy includes required AWS Greengrass permissions for deploying to groups, AWS Lambda permissions for creating and updating service-prefixed functions, and AWS IoT Analytics permissions for querying data from datastores. */
    AWSServiceRoleForIoTSiteWise(): aws_iam.IManagedPolicy;
    /** Allows Log Delivery service to deliver logs by calling log destination on your behalf. */
    AWSServiceRoleForLogDeliveryPolicy(): aws_iam.IManagedPolicy;
    /** Grants Amazon Monitron permissions to manage AWS resources, including AWS SSO user assignment on your behalf. */
    AWSServiceRoleForMonitronPolicy(): aws_iam.IManagedPolicy;
    /** Provides Cloudwatch access to publish operational and usage metrics and logs for Amazon Neptune */
    AWSServiceRoleForNeptuneGraphPolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions to describe and update Private Marketplace resources and describe AWS Organizations */
    AWSServiceRoleForPrivateMarketplaceAdminPolicy(): aws_iam.IManagedPolicy;
    /** Policy for Procurement Insights to obtain Organization Account details */
    AWSServiceRoleForProcurementInsightsPolicy(): aws_iam.IManagedPolicy;
    /** Provides access to AWS services and resources necessary to migrate service instances into AWS including EC2, S3 and Cloudformation. */
    AWSServiceRoleForSMS(): aws_iam.IManagedPolicy;
    /** Provides access to the User Subscriptions service to your Identity Center resources to automatically update your subscriptions. */
    AWSServiceRoleForUserSubscriptions(): aws_iam.IManagedPolicy;
    /** Provides AWS Backup permissions to create compliance reports on your behalf */
    AWSServiceRolePolicyForBackupReports(): aws_iam.IManagedPolicy;
    /** This policy contains permissions for testing restores and for cleaning up resources created during tests. */
    AWSServiceRolePolicyForBackupRestoreTesting(): aws_iam.IManagedPolicy;
    /** This managed policy provides administrative access to Amazon WorkSpaces to manage EC2 instances in your AWS account */
    AWSServiceRolePolicyForWorkspacesInstances(): aws_iam.IManagedPolicy;
    /** Provides the AWS DDoS Response Team with limited access to your AWS account to assist with DDoS attack mitigation during a high-severity event. */
    AWSShieldDRTAccessPolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Shield to access AWS resources on your behalf to provide DDoS protection. */
    AWSShieldServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to publish metrics and provide insights for your social message sending. */
    AWSSocialMessagingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides AWS Systems Manager for SAP with the permissions needed to manage and integrate SAP software with AWS. */
    AWSSSMForSAPServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for Service Linked Role AWSServiceRoleForAmazonSSM_OpsInsights */
    AWSSSMOpsInsightsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Administrator access for SSO Directory */
    AWSSSODirectoryAdministrator(): aws_iam.IManagedPolicy;
    /** ReadOnly access for SSO Directory */
    AWSSSODirectoryReadOnly(): aws_iam.IManagedPolicy;
    /** Provides access within AWS SSO to manage AWS Organizations master and member accounts and cloud application */
    AWSSSOMasterAccountAdministrator(): aws_iam.IManagedPolicy;
    /** Provides access within AWS SSO to manage AWS Organizations member accounts and cloud application */
    AWSSSOMemberAccountAdministrator(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS SSO configurations. */
    AWSSSOReadOnly(): aws_iam.IManagedPolicy;
    /** Grants AWS SSO permissions to manage AWS resources, including IAM roles, policies and SAML IdP on your behalf. */
    AWSSSOServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions console. For a full console experience, in addition to this policy, a user may need iam:PassRole permission on other IAM roles that can be assumed by the service. */
    AWSStepFunctionsConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions API. For full access, in addition to this policy, a user MUST have iam:PassRole permission on at least one IAM role that can be assumed by the service. */
    AWSStepFunctionsFullAccess(): aws_iam.IManagedPolicy;
    /** An access policy for providing a user/role/etc read only access to the AWS StepFunctions service. */
    AWSStepFunctionsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Storage Gateway via the AWS Management Console. */
    AWSStorageGatewayFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS Storage Gateway via the AWS Management Console. */
    AWSStorageGatewayReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Service-linked role used by AWS Storage Gateway to enable integration of other AWS services with Storage Gateway. */
    AWSStorageGatewayServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** AWSSupplyChainFederationAdminAccess provides AWS Supply Chain federated users access to the AWS Supply Chain application, including the required permissions to perform actions within the AWS Supply Chain application. The policy provides administrative permissions over IAM Identity Center users and groups and is attached to a role created by AWS Supply Chain on your behalf. You shouldn't attach AWSSupplyChainFederationAdminAccess policy to any other IAM entities. */
    AWSSupplyChainFederationAdminAccess(): aws_iam.IManagedPolicy;
    /** Allows users to access the AWS Support Center. */
    AWSSupportAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to the AWS Support App and other required services, such as AWS Support and Service Quotas. This policy includes permissions to use the supporting services so that the user can contact AWS Support for support cases, change service quotas, and create the relevant service-linked roles. */
    AWSSupportAppFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to the AWS Support App. */
    AWSSupportAppReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to supportplans. */
    AWSSupportPlansFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to supportplans. */
    AWSSupportPlansReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS Support to access AWS resources to provide billing, administrative, and support services. */
    AWSSupportServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants AWS Systems Manager (SSM) permission to discover AWS account information. */
    AWSSystemsManagerAccountDiscoveryServicePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to AWS resources managed or used by the AWS Systems Manager change management framework. */
    AWSSystemsManagerChangeManagementServicePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions for AWS Systems Manager Quick Setup to enable and configure AWS Config configuration recording. */
    AWSSystemsManagerEnableConfigRecordingExecutionPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants administrative permissions for enabling Explorer, a capability of AWS Systems Manager. This includes permissions to update related Systems Manager service settings, and to create a service-linked role for Systems Manager. */
    AWSSystemsManagerEnableExplorerExecutionPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Systems Manager for SAP service */
    AWSSystemsManagerForSAPFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS Systems Manager for SAP service */
    AWSSystemsManagerForSAPReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to AWS resources managed or used by the AWS Systems Manager just in time access framework. */
    AWSSystemsManagerJustInTimeAccessServicePolicy(): aws_iam.IManagedPolicy;
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenPolicy allows Systems Manager to generate access tokens used for just-in-time node access. */
    AWSSystemsManagerJustInTimeAccessTokenPolicy(): aws_iam.IManagedPolicy;
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenSessionPolicy allows Systems Manager to apply scoped down permissions to a just-in-time node access session once it is started. */
    AWSSystemsManagerJustInTimeAccessTokenSessionPolicy(): aws_iam.IManagedPolicy;
    /** This policy allows Systems Manager to share a deny-access policy for just-in-time node access from the delegated administrator account to member accounts, and replicate the policy to multiple Regions. */
    AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy(): aws_iam.IManagedPolicy;
    /** Permissions required to collect information about a user for Just-In-Time-Node-Access notifications. */
    AWSSystemsManagerNotificationsServicePolicy(): aws_iam.IManagedPolicy;
    /** IAM role for SSM Explorer to manage OpsData related operations */
    AWSSystemsManagerOpsDataSyncServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants the AWS Portal Asset Server the necessary permissions required for normal operation. */
    AWSThinkboxAssetServerPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants AWS Thinkbox's Deadline software full access to multiple AWS services as required for AWS Portal administration. This includes access to create arbitrary tags on several EC2 resource types. */
    AWSThinkboxAWSPortalAdminPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants the AWS Portal Gateway machine the necessary permissions required for normal operation. */
    AWSThinkboxAWSPortalGatewayPolicy(): aws_iam.IManagedPolicy;
    /** This policy grants the Deadline Workers in AWS Portal the necessary permissions required for normal operation. */
    AWSThinkboxAWSPortalWorkerPolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions required for the operation of AWS Thinkbox's Deadline Resource Tracker.  This includes full access to some EC2 actions, including DeleteFleets and CancelSpotFleetRequests. */
    AWSThinkboxDeadlineResourceTrackerAccessPolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions required to create, destroy, and administer AWS Thinkbox's Deadline Resource Tracker. */
    AWSThinkboxDeadlineResourceTrackerAdminPolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions required for AWS Thinkbox's Deadline Spot Event Plugin.  This includes permission to request, modify, and cancel a spot fleet, as well as limited PassRole permission. */
    AWSThinkboxDeadlineSpotEventPluginAdminPolicy(): aws_iam.IManagedPolicy;
    /** Grant permissions required for an EC2 instance running AWS Thinkbox Deadline Spot Event Plugin Worker software. */
    AWSThinkboxDeadlineSpotEventPluginWorkerPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Transfer via the AWS Management Console */
    AWSTransferConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Transfer Service. */
    AWSTransferFullAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS Transfer full access to create log streams and groups and put log events to your account */
    AWSTransferLoggingAccess(): aws_iam.IManagedPolicy;
    /** Provide readonly access to AWS Transfer services. */
    AWSTransferReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Trusted Advisor Priority. This policy also enables the user to add Trusted Advisor as a trusted service with AWS Organizations and to specify delegated administrator accounts for Trusted Advisor Priority. */
    AWSTrustedAdvisorPriorityFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Trusted Advisor Priority. This includes permission to view the delegated administrator accounts. */
    AWSTrustedAdvisorPriorityReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Service Policy for Trusted Advisor Multi-account Reporting */
    AWSTrustedAdvisorReportingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Access for the AWS Trusted Advisor Service to help reduce cost, increase performance, and improve security of your AWS environment. */
    AWSTrustedAdvisorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS User Notifications to call AWS services on your behalf. */
    AWSUserNotificationsServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access for viewing entitled Vendor Insights resources and managing Vendor Insights subscriptions */
    AWSVendorInsightsAssessorFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access for viewing entitled Vendor Insights resources */
    AWSVendorInsightsAssessorReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access for creating and managing the Vendor Insights resources */
    AWSVendorInsightsVendorFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access for viewing the Vendor Insights resources */
    AWSVendorInsightsVendorReadOnly(): aws_iam.IManagedPolicy;
    /** Allows VPC Lattice to access AWS resources on your behalf. */
    AWSVpcLatticeServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allow Site-to-Site VPN to create and manage resources related to your VPN Connections. */
    AWSVPCS2SVpnServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allow VPC Transit Gateway to create and manage necessary resources for your Transit Gateway VPC Attachments. */
    AWSVPCTransitGatewayServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy to enable AWS Verified Access service to provision endpoints on your behalf */
    AWSVPCVerifiedAccessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list and update Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    AWSWAFConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    AWSWAFConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS WAF actions. */
    AWSWAFFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to AWS WAF actions. */
    AWSWAFReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows WellArchitected to access AWS services and resources that relate to WellArchitected resources on behalf of customers. */
    AWSWellArchitectedDiscoveryServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Well-Architected to access Organizations on your behalf. */
    AWSWellArchitectedOrganizationsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants full administrative permissions to the Wickr service, including the Wickr administrative functions under the AWS Management Console. */
    AWSWickrFullAccess(): aws_iam.IManagedPolicy;
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of X-Ray traces */
    AWSXrayCrossAccountSharingConfiguration(): aws_iam.IManagedPolicy;
    /** Allow the AWS X-Ray Daemon to relay raw trace segments data to the service's API and retrieve sampling data (rules, targets, etc.) to be used by the X-Ray SDK. */
    AWSXRayDaemonWriteAccess(): aws_iam.IManagedPolicy;
    /** AWS X-Ray full access managed policy */
    AWSXrayFullAccess(): aws_iam.IManagedPolicy;
    /** AWS X-Ray read only managed policy */
    AWSXrayReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** AWS X-Ray write only managed policy */
    AWSXrayWriteOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides administrative access for ARC zonal shift practice runs, and access to CloudWatch alarm statuses to monitor practice runs. */
    AWSZonalAutoshiftPracticeRunSLRPolicy(): aws_iam.IManagedPolicy;
    /** Provides access for the AWS Batch service to manage the required resources, including Amazon EC2 and Amazon ECS resources. */
    BatchServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions for billing and cost management. This includes viewing account usage and viewing and modifying budgets and payment methods. */
    Billing(): aws_iam.IManagedPolicy;
    /** Amazon Certificate Manager Service Role Policy */
    CertificateManagerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoint connections. */
    ClientVPNServiceConnectionsRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoints. */
    ClientVPNServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service Role for CloudFormation StackSets (Organization Master Account) */
    CloudFormationStackSetsOrgAdminServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Service Role for CloudFormation StackSets (Organization Member Account) */
    CloudFormationStackSetsOrgMemberServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to the CloudFront console plus the ability to list Amazon S3 buckets via the AWS Management Console. */
    CloudFrontFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to CloudFront distribution configuration information and list distributions via the AWS Management Console. */
    CloudFrontReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS resources used or managed by CloudHSM */
    CloudHSMServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to the Amazon CloudSearch configuration service. */
    CloudSearchFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to the Amazon CloudSearch configuration service. */
    CloudSearchReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** This service linked role allows CloudTrail to get and add resource tags to the resource owner's CloudTrail events. */
    CloudTrailEventContext(): aws_iam.IManagedPolicy;
    /** Permission policy for CloudTrail ServiceLinkedRole */
    CloudTrailServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows CloudWatch to assume CloudWatch-CrossAccountSharing roles in remote accounts on behalf of the current account in order to display data cross-account, cross-region */
    CloudWatchCrossAccountAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to CloudWatch alarms and metrics as well as EC2 metadata. Provides access to Stop, Terminate and Reboot EC2 instances. */
    CloudWatchActionsEC2Access(): aws_iam.IManagedPolicy;
    /** Full permissions required to use AmazonCloudWatchAgent. */
    CloudWatchAgentAdminPolicy(): aws_iam.IManagedPolicy;
    /** Permissions required to use AmazonCloudWatchAgent on servers */
    CloudWatchAgentServerPolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to CloudWatch Application Insights and required dependencies. */
    CloudWatchApplicationInsightsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to CloudWatch Application Insights. */
    CloudWatchApplicationInsightsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Cloudwatch Application Insights Service Linked Role Policy */
    CloudwatchApplicationInsightsServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide full access to CloudWatch Application Signals service and scoped access to the dependencies needed to use and operate this service. */
    CloudWatchApplicationSignalsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to CloudWatch Application Signals service and scoped access to the dependencies needed to use this service */
    CloudWatchApplicationSignalsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Policy grants permission to CloudWatch Application Signals to collect monitoring and tagging data from other relevant AWS services. */
    CloudWatchApplicationSignalsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to the non-CloudWatch APIs used to display CloudWatch Automatic Dashboards, including the contents of objects such as Lambda functions */
    CloudWatchAutomaticDashboardsAccess(): aws_iam.IManagedPolicy;
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch resources */
    CloudWatchCrossAccountSharingConfiguration(): aws_iam.IManagedPolicy;
    /** Allows built-in targets in Amazon CloudWatch Events to perform EC2 actions on your behalf. */
    CloudWatchEventsBuiltInTargetExecutionAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon CloudWatch Events. */
    CloudWatchEventsFullAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon CloudWatch Events to relay events to the streams in AWS Kinesis Streams in your account. */
    CloudWatchEventsInvocationAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon CloudWatch Events. */
    CloudWatchEventsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allow AWS CloudWatch to execute actions on your behalf configured through alarms and events. */
    CloudWatchEventsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to CloudWatch. */
    CloudWatchFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to CloudWatch. */
    CloudWatchFullAccessV2(): aws_iam.IManagedPolicy;
    /** Provides full access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services, such as Amazon CloudWatch, Amazon EC2, Amazon CloudFront, Amazon WorkSpaces, and Elastic Load Balancing, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    CloudWatchInternetMonitorFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services in Amazon CloudWatch, including policies to retrieve information on CloudWatch metrics and to manage log queries, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    CloudWatchInternetMonitorReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Internet Monitor to access EC2, Workspaces, and CloudFront resources, and other required services on your behalf. */
    CloudWatchInternetMonitorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides write access to X-Ray and CloudWatch Application Signals log group. */
    CloudWatchLambdaApplicationSignalsExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy required for the Lambda Insights Extension */
    CloudWatchLambdaInsightsExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch Logs resources */
    CloudWatchLogsCrossAccountSharingConfiguration(): aws_iam.IManagedPolicy;
    /** Provides full access to CloudWatch Logs */
    CloudWatchLogsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to CloudWatch Logs */
    CloudWatchLogsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** You can use this policy in IAM roles that are attached to Amazon EC2 and Amazon EKS instance resources to send telemetry reports (metrics) to a Network Flow Monitor endpoint. */
    CloudWatchNetworkFlowMonitorAgentPublishPolicy(): aws_iam.IManagedPolicy;
    /** You can't attach CloudWatchNetworkFlowMonitorServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor, which publishes network telemetry aggregation results, collected by Network Flow Monitor agents, to CloudWatch. It also allows the service to use AWS Organizations to get information for multi-account scenarios. */
    CloudWatchNetworkFlowMonitorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** You can't attach CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor_Topology, which generates topology snapshots of resources used by Network Flow Monitor in your account. */
    CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows CloudWatch Network Monitor to access and manage EC2 and VPC resources, publish data to CloudWatch and access other required services on your behalf. */
    CloudWatchNetworkMonitorServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy provides user access to view OpenSearch dashboards on the CloudWatch Logs console. */
    CloudWatchOpenSearchDashboardAccess(): aws_iam.IManagedPolicy;
    /** This policy provides user access to create integration with OpenSearch to create, update, delete or view dashboards on the CloudWatch Logs console. */
    CloudWatchOpenSearchDashboardsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to CloudWatch. */
    CloudWatchReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to CloudWatch Synthetics. */
    CloudWatchSyntheticsFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to CloudWatch Synthetics. */
    CloudWatchSyntheticsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Policy for AWS Comprehend service role which allows access to S3 resources for data access */
    ComprehendDataAccessRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Comprehend. */
    ComprehendFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Comprehend Medical */
    ComprehendMedicalFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon Comprehend. */
    ComprehendReadOnly(): aws_iam.IManagedPolicy;
    /** Provides read only access to ComputeOptimizer. */
    ComputeOptimizerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows ComputeOptimizer to call AWS services and collect workload details on your behalf. */
    ComputeOptimizerServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy needed for AWSConfig to create conformance packs */
    ConfigConformsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This managed policy provides admin access to Cost Optimization Hub. */
    CostOptimizationHubAdminAccess(): aws_iam.IManagedPolicy;
    /** This managed policy provides read-only access to Cost Optimization Hub. */
    CostOptimizationHubReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Cost Optimization Hub to retrieve organization information and collect optimization-related data and metadata. */
    CostOptimizationHubServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Connect Customer Profiles to access AWS services and resources on your behalf. */
    CustomerProfilesServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS database services. */
    DatabaseAdministrator(): aws_iam.IManagedPolicy;
    /** Grants permissions to AWS data analytics services. */
    DataScientist(): aws_iam.IManagedPolicy;
    /** This policy allows DAX to create and manage Network interface, Security group, Subnet and Vpc on behalf of customer */
    DAXServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to read-only APIs needed to run EC2 Declarative Policies Account Status Report. */
    DeclarativePoliciesEC2Report(): aws_iam.IManagedPolicy;
    /** Permissions required to support Amazon CloudWatch Contributor Insights for Amazon DynamoDB. */
    DynamoDBCloudWatchContributorInsightsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provide AWS DynamoDB access to KinesisDataStreams */
    DynamoDBKinesisReplicationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Permissions required by DynamoDB for cross-region data replication */
    DynamoDBReplicationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants full access to EC2 Fast Launch actions */
    EC2FastLaunchFullAccess(): aws_iam.IManagedPolicy;
    /** Policy grants ec2fastlaunch to prepare and manage preprovisioned snapshots in customer's account & publish related metrics. */
    EC2FastLaunchServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy granting permissions to EC2 Fleet to launch instances in the future. */
    EC2FleetTimeShiftableServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Permissions need by EC2 Image Builder to perform a cross account distribution. */
    Ec2ImageBuilderCrossAccountDistributionAccess(): aws_iam.IManagedPolicy;
    /** The EC2ImageBuilderLifecycleExecutionPolicy policy grants permissions for Image Builder to perform actions such as deprecate or delete Image Builder image resources and their underlying resources (AMIs, snapshots) to support automated rules for image lifecycle management tasks. */
    EC2ImageBuilderLifecycleExecutionPolicy(): aws_iam.IManagedPolicy;
    /** Allows customers to call EC2 Instance Connect to publish ephemeral keys to their EC2 instances and connect via ssh or the EC2 Instance Connect CLI. */
    EC2InstanceConnect(): aws_iam.IManagedPolicy;
    /** EC2 Instance Connect endpoint policy to manage EC2 Instance Connect endpoints created by the customer */
    Ec2InstanceConnectEndpoint(): aws_iam.IManagedPolicy;
    /** EC2 Instance profile for Image Builder service. */
    EC2InstanceProfileForImageBuilder(): aws_iam.IManagedPolicy;
    /** EC2 Instance profile for building container images with EC2 Image Builder. This policy grants the user broad permissions to upload ECR images. */
    EC2InstanceProfileForImageBuilderECRContainerBuilds(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by ECR Replication */
    ECRReplicationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows actions to be performed when using AWS ECR repository creation templates */
    ECRTemplateServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy allows ElastiCache to manage AWS resources on your behalf as necessary for managing your cache */
    ElastiCacheServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon ElasticLoadBalancing, and limited access to other services necessary to provide ElasticLoadBalancing features. */
    ElasticLoadBalancingFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon ElasticLoadBalancing and dependent services */
    ElasticLoadBalancingReadOnly(): aws_iam.IManagedPolicy;
    /** Access to view purchased assets and download related software and kickstart files */
    ElementalActivationsDownloadSoftwareAccess(): aws_iam.IManagedPolicy;
    /** Full access to view and take action on Elemental Appliances and Software purchased assets */
    ElementalActivationsFullAccess(): aws_iam.IManagedPolicy;
    /** Access to view purchased assets and generate software licenses for pending activations */
    ElementalActivationsGenerateLicenses(): aws_iam.IManagedPolicy;
    /** Read-only access to the detailed list of purchased assets associated to the AWS account of the user */
    ElementalActivationsReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Full access to view and take action on Elemental Appliances and Software quotes and orders */
    ElementalAppliancesSoftwareFullAccess(): aws_iam.IManagedPolicy;
    /** Read-only access to view Elemental Appliances and Software quotes and orders */
    ElementalAppliancesSoftwareReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Full access to view and take action on Elemental Appliance and Software support cases and product support content */
    ElementalSupportCenterFullAccess(): aws_iam.IManagedPolicy;
    /** This policy grants read-only permissions that allow the WAL service for Amazon EMR to find and return the status of a cluster */
    EMRDescribeClusterPolicyForEMRWAL(): aws_iam.IManagedPolicy;
    /** Access policy to allow FM service linked role to perform FM-related actions on FM-managed resources within a customer AWS Organization account. */
    FMSServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon FSx to delete its Service Linked Roles for Amazon S3 access */
    FSxDeleteServiceLinkedRoleAccess(): aws_iam.IManagedPolicy;
    /** Grants the required permissions for compute actions in an Amazon GameLift container fleet, including access to dependencies such as Amazon S3. */
    GameLiftContainerFleetPolicy(): aws_iam.IManagedPolicy;
    /** Policy to allow Gamelift GameServerGroups to manage customer resources */
    GameLiftGameServerGroupPolicy(): aws_iam.IManagedPolicy;
    /** This managed policy grants permission to connect with Amazon Q and utilize the features in the GitLab Duo with Amazon Q integration. */
    GitLabDuoWithAmazonQPermissionsPolicy(): aws_iam.IManagedPolicy;
    /** Allow GlobalAccelerator Users full Access to all APIs */
    GlobalAcceleratorFullAccess(): aws_iam.IManagedPolicy;
    /** Allow GlobalAccelerator Users Access to Read Only APIs */
    GlobalAcceleratorReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read access to the Greengrass OTA Update artifacts in all Greengrass regions */
    GreengrassOTAUpdateArtifactAccess(): aws_iam.IManagedPolicy;
    /** AWS Health policy to enable Organizational View feature */
    HealthOrganizationsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants access to read all access information provided by IAM access advisor such as service last accessed information. */
    IAMAccessAdvisorReadOnly(): aws_iam.IManagedPolicy;
    /** Provides full access to IAM Access Analyzer */
    IAMAccessAnalyzerFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to IAM Access Analyzer resources */
    IAMAccessAnalyzerReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access required to check the presence of root user credentials such as root user password and root user access keys using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    IAMAuditRootUserCredentials(): aws_iam.IManagedPolicy;
    /** Provides access required to create a root user password using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    IAMCreateRootUserPassword(): aws_iam.IManagedPolicy;
    /** Provides access required to delete all root user credentials such as root password and root access keys using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    IAMDeleteRootUserCredentials(): aws_iam.IManagedPolicy;
    /** Provides full access to IAM via the AWS Management Console. */
    IAMFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to IAM via the AWS Management Console. */
    IAMReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows an IAM user to manage their own Service Specific Credentials. */
    IAMSelfManageServiceSpecificCredentials(): aws_iam.IManagedPolicy;
    /** Provides the ability for an IAM user to change their own password. */
    IAMUserChangePassword(): aws_iam.IManagedPolicy;
    /** Provides the ability for an IAM user to manage their own SSH keys. */
    IAMUserSSHKeys(): aws_iam.IManagedPolicy;
    /** Provides full access to Interactive Video Service (IVS), Also included permissions for dependent services, needed for full access to the ivs console. */
    IVSFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to IVS Low-Latency and Real-Time streaming APIs */
    IVSReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Service Linked Role to perform S3 PutObject to recording IVS live streams */
    IVSRecordToS3(): aws_iam.IManagedPolicy;
    /** This policy grants Kafka Connect permission to manage AWS resources on your behalf. */
    KafkaConnectServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** IAM service linked role policy for Kafka. */
    KafkaServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants the required permissions to Amazon Keyspaces for Change Data Capture */
    KeyspacesCDCServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Permissions required by Keyspaces for cross-region data replication */
    KeyspacesReplicationServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy to grant temporary data access to Lake Formation resources */
    LakeFormationDataAccessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for AWS Lex Bot use case */
    LexBotPolicy(): aws_iam.IManagedPolicy;
    /** Policy for AWS Lex Channel use case */
    LexChannelPolicy(): aws_iam.IManagedPolicy;
    /** AWS Lightsail service linked role policy which grants permissions to export resources */
    LightsailExportAccess(): aws_iam.IManagedPolicy;
    /** This policy grants permission to register MediaConnect Gateway Instances to a MediaConnect Gateway. */
    MediaConnectGatewayInstanceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows MediaPackage to publish logs to CloudWatch */
    MediaPackageServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy allows MemoryDB to manage AWS resources on your behalf as necessary for managing your resources. */
    MemoryDBServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    MigrationHubDMSAccessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Migration Hub to call Application Discovery Service on your behalf */
    MigrationHubServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    MigrationHubSMSAccessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy for AWS Monitron service linked role granting access to required customer resources. */
    MonitronServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to Multi-party approval. This policy also includes related permissions to AWS Organizations and AWS IAM Identity for managing approval teams and identity sources. */
    MultiPartyApprovalFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Multi-party approval. This policy also includes related read permission to AWS Organizations and AWS IAM Identity for approval teams and identity sources. */
    MultiPartyApprovalReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to manage Amazon Neptune using the AWS Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Neptune. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to all Amazon Neptune Analytics resources along with read only permissions for dependent services. */
    NeptuneGraphReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Amazon Neptune. Note that this policy also grants access to Amazon RDS resources. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS network resources. */
    NetworkAdministrator(): aws_iam.IManagedPolicy;
    /** Provides permissions for the AWS Shield network security director service linked role to assess specified environments. */
    NetworkSecurityDirectorServiceLinkedRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to CloudWatch Observability Access Manager */
    OAMFullAccess(): aws_iam.IManagedPolicy;
    /** Provides Read Only access to CloudWatch Observability Access Manager */
    OAMReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Amazon OpenSearch Ingestion to describe network resources and write service metrics to cloudwatch */
    OpensearchIngestionSelfManagedVpcePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to associate and dissociate partner central users with IAM roles */
    PartnerCentralAccountManagementUserRoleAssociation(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS services and resources, but does not allow management of Users and groups. */
    PowerUserAccess(): aws_iam.IManagedPolicy;
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q Apps. */
    QAppsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to QBusiness to call QuickSight APIs for the QuickSight plugin */
    QBusinessQuicksightPluginPolicy(): aws_iam.IManagedPolicy;
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q */
    QBusinessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Policy used by QuickSight team to access customer data produced by S3 Storage Management Analytics. */
    QuickSightAccessForS3StorageManagementAnalyticsReadOnly(): aws_iam.IManagedPolicy;
    /** Default policy for the Amazon RDS service role. */
    RDSCloudHsmAuthorizationRole(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS services and resources. */
    ReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides full access to Resource Groups and Tag Editor. */
    ResourceGroupsandTagEditorFullAccess(): aws_iam.IManagedPolicy;
    /** Provides access to use Resource Groups and Tag Editor, but does not allow editing of tags via the Tag Editor. */
    ResourceGroupsandTagEditorReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows AWS Resource Groups to query the AWS services that own your resources to keep the group up-to-date */
    ResourceGroupsServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions to tag and untag all the resources supported by Resource Groups Tagging API. This policy also grants the permissions required to retrieve all tagged, or previously tagged, resources through the Resource Groups Tagging API. */
    ResourceGroupsTaggingAPITagUntagSupportedResources(): aws_iam.IManagedPolicy;
    /** Allows the OpenShift Amazon EBS Container Storage Interface (CSI) Driver Operator to install and maintain the Amazon EBS CSI driver on a Red Hat OpenShift Service on AWS (ROSA) cluster. The Amazon EBS CSI driver allows ROSA clusters to manage the lifecycle of Amazon EBS volumes for persistent volumes. */
    ROSAAmazonEBSCSIDriverOperatorPolicy(): aws_iam.IManagedPolicy;
    /** Allows the OpenShift Cloud Network Config Controller Operator to provision and manage networking resources for use by the Red Hat OpenShift Service on AWS (ROSA) cluster networking overlay. The OpenShift Cloud Network Operator interfaces with AWS APIs on behalf of the network plugins via CustomResourceDefinitions. The operator uses these policy permissions to manage private IP addresses for Amazon EC2 instances as part of the ROSA cluster. */
    ROSACloudNetworkConfigOperatorPolicy(): aws_iam.IManagedPolicy;
    /** Allows Red Hat OpenShift Service on AWS (ROSA) control plane to manage ROSA cluster Amazon EC2 and Amazon Route 53 resources. */
    ROSAControlPlaneOperatorPolicy(): aws_iam.IManagedPolicy;
    /** Allows the OpenShift Image Registry Operator to provision and manage Amazon S3 buckets and objects for use by the Red Hat OpenShift Service on AWS (ROSA) in-cluster image registry to satisfy ROSA storage requirements. The OpenShift Image Registry Operator installs and maintains the internal registry of a Red Hat OpenShift cluster. */
    ROSAImageRegistryOperatorPolicy(): aws_iam.IManagedPolicy;
    /** Allows the OpenShift Ingress Operator to provision and manage load balancers and domain name system (DNS) configurations for Red Hat OpenShift Service on AWS (ROSA) clusters. The policy allows read access to tag values, which the operator filters for Route 53 resources to discover hosted zones. */
    ROSAIngressOperatorPolicy(): aws_iam.IManagedPolicy;
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to manage AWS resources that support ROSA cluster installation. This includes managing instance profiles for ROSA worker nodes. */
    ROSAInstallerPolicy(): aws_iam.IManagedPolicy;
    /** Allows the built-in ROSA AWS Encryption Provider to manage AWS Key Management Service (KMS) keys to support etcd data encryption using a customer provided AWS KMS key. The policy allows encryption and decryption of data using KMS keys. */
    ROSAKMSProviderPolicy(): aws_iam.IManagedPolicy;
    /** Allows the ROSA Kubernetes controller to manage Amazon EC2, Elastic Load Balancing (ELB), and AWS Key Management Service (KMS) resources for a ROSA cluster. */
    ROSAKubeControllerPolicy(): aws_iam.IManagedPolicy;
    /** This policy provides the permissions required to manage the Red Hat OpenShift Service on AWS (ROSA) subscription. */
    ROSAManageSubscription(): aws_iam.IManagedPolicy;
    /** Allows Red Hat OpenShift Service on AWS (ROSA) to manage cluster EC2 instances as worker nodes, including permission to configure security groups and tag instances and volumes. This policy also allows for the use of EC2 instances with disk encryption provided by AWS Key Management Service (KMS) keys. */
    ROSANodePoolManagementPolicy(): aws_iam.IManagedPolicy;
    /** Provides ROSA site reliability engineering (SRE) the permissions needed to initially observe, diagnose, and support AWS resources associated with Red Hat OpenShift Service on AWS (ROSA) clusters, including the ability to change ROSA cluster node state. */
    ROSASRESupportPolicy(): aws_iam.IManagedPolicy;
    /** Allows Red Hat OpenShift Service on AWS (ROSA) worker nodes in your account read-only access to Amazon EC2 instances and AWS Regions for compute node lifecycle management. */
    ROSAWorkerInstancePolicy(): aws_iam.IManagedPolicy;
    /** Service Linked Role Policy for Route 53 Recovery Readiness */
    Route53RecoveryReadinessServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Route53 Resolver */
    Route53ResolverServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by S3 Storage Lens */
    S3StorageLensServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access required to unlock a S3 bucket policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    S3UnlockBucketPolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Bedrock Agents to access Amazon Bedrock models and other resources attached to an agent in SageMaker Studio. */
    SageMakerStudioBedrockAgentServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to an Amazon Bedrock chat agent app's configuration and Amazon Bedrock agent in SageMaker Studio. */
    SageMakerStudioBedrockChatAgentUserRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Bedrock to access Amazon Bedrock models and datasets for evaluation jobs in SageMaker Studio. */
    SageMakerStudioBedrockEvaluationJobServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Bedrock Flows to access Amazon Bedrock models and other resources attached to a flow in SageMaker Studio. */
    SageMakerStudioBedrockFlowServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows AWS Lambda to access an Amazon Bedrock function component's configuration in SageMaker Studio. */
    SageMakerStudioBedrockFunctionExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to configure vector stores and Amazon Bedrock knowledge bases in SageMaker Studio. */
    SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy(): aws_iam.IManagedPolicy;
    /** Allows Amazon Bedrock Knowledge Bases to access Amazon Bedrock models and data sources in SageMaker Studio. */
    SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access to an Amazon Bedrock prompt and its configuration in SageMaker Studio. */
    SageMakerStudioBedrockPromptUserRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy is used by Amazon SageMaker Studio to catalog, discover, govern, share, and analyze data in the Amazon SageMaker Studio domain. */
    SageMakerStudioDomainExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Service role for domain level actions in the portal that are performed by Amazon SageMaker Studio. */
    SageMakerStudioDomainServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    SageMakerStudioEMRInstanceRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    SageMakerStudioEMRServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy provides full access to Amazon SageMaker Unified Studio via the Amazon SageMaker management console. */
    SageMakerStudioFullAccess(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker Studio uses this policy to provision and manage resources in your account. */
    SageMakerStudioProjectProvisioningRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to SageMaker. */
    SageMakerStudioProjectRoleMachineLearningPolicy(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker creates IAM roles for Projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    SageMakerStudioProjectUserRolePermissionsBoundary(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions. */
    SageMakerStudioProjectUserRolePolicy(): aws_iam.IManagedPolicy;
    /** Amazon SageMaker Studio uses this policy when running query executions on federated connections. */
    SageMakerStudioQueryExecutionRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides read/write access to AWS Secrets Manager via the AWS Management Console. Note: this exludes IAM actions, so combine with IAMFullAccess if rotation configuration is required. */
    SecretsManagerReadWrite(): aws_iam.IManagedPolicy;
    /** The security audit template grants access to read security configuration metadata. It is useful for software that audits the configuration of an AWS account. */
    SecurityAudit(): aws_iam.IManagedPolicy;
    /** Provides access to manage resources created by Security Lake. */
    SecurityLakeResourceManagementServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to operate the Amazon Security Lake service on your behalf */
    SecurityLakeServiceLinkedRole(): aws_iam.IManagedPolicy;
    /** Permissions to allow the AWS Server Migration Connector to migrate VMs to EC2. Allows communication with the AWS Server Migration Service, read/write access to S3 buckets starting with 'sms-b-' and 'import-to-ec2-' as well as the buckets used for AWS Server Migration Connector upgrade, AWS Server Migration Connector registration with AWS, and metrics upload to AWS. */
    ServerMigrationConnector(): aws_iam.IManagedPolicy;
    /** Required permissions to use all features of the Server Migration Service Console */
    ServerMigrationServiceConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Permissions to allow the AWS Server Migration Service to create and update relevant AWS resources into the customer's AWS account for launching migrated servers and applications. */
    ServerMigrationServiceLaunchRole(): aws_iam.IManagedPolicy;
    /** Permissions to allow the AWS SMS to run used data validation script and send script success/failure back to SMS */
    ServerMigrationServiceRoleForInstanceValidation(): aws_iam.IManagedPolicy;
    /** Provides full access to Service Quotas */
    ServiceQuotasFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read only access to Service Quotas */
    ServiceQuotasReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Allows Service Quotas to create support cases on your behalf */
    ServiceQuotasServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to the Simple Workflow configuration service. */
    SimpleWorkflowFullAccess(): aws_iam.IManagedPolicy;
    /** Allows SMSVoice to publish metrics to CloudWatch on your behalf */
    SMSVoiceServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Allows split cost allocation data to retrieve AWS Organizations information, if applicable, and collect telemetry data for the split cost allocation data services that the customer has opted in to. */
    SplitCostAllocationDataServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides access required to unlock a SQS queue policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    SQSUnlockQueuePolicy(): aws_iam.IManagedPolicy;
    /** Provides permissions to check Quick Setup configuration health, ensure consistent use of parameters and provisioned resources, and remediate resources when drift is detected. */
    SSMQuickSetupRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to troubleshoot and resolve issues in an AWS account. This policy also enables the user to contact AWS support to create and manage cases. */
    SupportUser(): aws_iam.IManagedPolicy;
    /** Grants full access permissions necessary for resources required for application and development operations. */
    SystemAdministrator(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon Translate. */
    TranslateFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon Translate. */
    TranslateReadOnly(): aws_iam.IManagedPolicy;
    /** This policy grants permissions to view resources and basic metadata across all AWS services. */
    ViewOnlyAccess(): aws_iam.IManagedPolicy;
    /** Default policy for the VM Import/Export service role, for customers using the AWS Connector. The VM Import/Export service assumes a role with this policy to fulfill virtual machine migration requests from the AWS Connector virtual appliance. (Note that the AWS Connector uses the "AWSConnector" managed policy to issue requests on the customer's behalf to the VM Import/Export service.) Provides the ability to create AMIs and EBS snapshots, modify EBS snapshot attributes, make "Describe*" calls on EC2 objects, and read from S3 buckets starting with 'import-to-ec2-'. */
    VMImportExportRoleForAWSConnector(): aws_iam.IManagedPolicy;
    /** Provides full access to Amazon VPC Lattice and access to dependency services. */
    VPCLatticeFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to Amazon VPC Lattice via the AWS Management Console, and limited access to dependency services. */
    VPCLatticeReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Provides access to invoking Amazon VPC Lattice services. */
    VPCLatticeServicesInvokeAccess(): aws_iam.IManagedPolicy;
    /** Creating SLR to write customer's logs to a firehose stream */
    WAFLoggingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Creating SLR to write customer's logs to a firehose stream */
    WAFRegionalLoggingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** This policy creates a service-linked role that allows AWS WAF to write logs to Amazon Kinesis Data Firehose. */
    WAFV2LoggingServiceRolePolicy(): aws_iam.IManagedPolicy;
    /** Provides full access to AWS Well-Architected Tool via the AWS Management Console */
    WellArchitectedConsoleFullAccess(): aws_iam.IManagedPolicy;
    /** Provides read-only access to AWS Well-Architected Tool via the AWS Management Console */
    WellArchitectedConsoleReadOnlyAccess(): aws_iam.IManagedPolicy;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkLink */
    WorkLinkServiceRolePolicy(): aws_iam.IManagedPolicy;
}
