"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsManagedPolicy = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam_floyd_1 = require("./iam-floyd");
/**
 * Provides all AWS managed policies.
 *
 * To get the name, access the static properties of this class, e.g. `AwsManagedPolicy.ReadOnlyAccess`.
 *
 *  To get an `aws_iam.IManagedPolicy` object, call the methods on an instance of the class, e.g. `new AwsManagedPolicy().ReadOnlyAccess()`.
 */
class AwsManagedPolicy extends iam_floyd_1.AwsManagedPolicy {
    /** Allow Access Analyzer to analyze resource metadata */
    AccessAnalyzerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AccessAnalyzerServiceRolePolicy);
    }
    /** Provides full access to AWS services and resources. */
    AdministratorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AdministratorAccess);
    }
    /** Grants account administrative permissions while explicitly allowing direct access to resources needed by Amplify applications. */
    AdministratorAccessAmplify() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AdministratorAccessAmplify);
    }
    /** Grants account administrative permissions. Explicitly allows developers and administrators to gain direct access to resources they need to manage AWS Elastic Beanstalk applications */
    AdministratorAccessAWSElasticBeanstalk() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AdministratorAccessAWSElasticBeanstalk);
    }
    /** Provides ReadOnly permissions required by the Amazon AI Operations Assistant to do analysis on customer AWS resources during investigations. */
    AIOpsAssistantPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsAssistantPolicy);
    }
    /** Grants full access to Amazon AI Operations service and its required permissions via AWS console. It also includes permissions to use identity-aware console sessions. */
    AIOpsConsoleAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsConsoleAdminPolicy);
    }
    /** Grants access to the Amazon AI Operations APIs for creating, updating, and deleting investigations, investigation events, and investigation resources. It also includes ReadOnly access to all AI Operations APIs and to use identity-aware sessions. */
    AIOpsOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsOperatorAccess);
    }
    /** Grants ReadOnly permissions to the Amazon AI Operations service and its required resources. */
    AIOpsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsReadOnlyAccess);
    }
    /** Provide device setup access to AlexaForBusiness services */
    AlexaForBusinessDeviceSetup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessDeviceSetup);
    }
    /** Grants full access to AlexaForBusiness resources and access to related AWS Services */
    AlexaForBusinessFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessFullAccess);
    }
    /** Provide gateway execution access to AlexaForBusiness services */
    AlexaForBusinessGatewayExecution() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessGatewayExecution);
    }
    /** Provide access to Lifesize AVS devices */
    AlexaForBusinessLifesizeDelegatedAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessLifesizeDelegatedAccessPolicy);
    }
    /** This policy enables Alexa for Business to perform automated tasks scheduled by your network profiles. */
    AlexaForBusinessNetworkProfileServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessNetworkProfileServicePolicy);
    }
    /** Provide access to Poly AVS devices */
    AlexaForBusinessPolyDelegatedAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessPolyDelegatedAccessPolicy);
    }
    /** Provide read only access to AlexaForBusiness services */
    AlexaForBusinessReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessReadOnlyAccess);
    }
    /** Provides full access to create/edit/delete APIs in Amazon API Gateway via the AWS Management Console. */
    AmazonAPIGatewayAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAPIGatewayAdministrator);
    }
    /** Provides full access to invoke APIs in Amazon API Gateway. */
    AmazonAPIGatewayInvokeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAPIGatewayInvokeFullAccess);
    }
    /** Allows API Gateway to push logs to user's account. */
    AmazonAPIGatewayPushToCloudWatchLogs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAPIGatewayPushToCloudWatchLogs);
    }
    /** Provides full access to Amazon AppFlow and access to AWS services supported as flow source or destination (S3 and Redshift). Also provides access to KMS for encryption */
    AmazonAppFlowFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppFlowFullAccess);
    }
    /** Provides read only access to Amazon Appflow flows */
    AmazonAppFlowReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppFlowReadOnlyAccess);
    }
    /** Provides full access to Amazon AppStream via the AWS Management Console. */
    AmazonAppStreamFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamFullAccess);
    }
    /** Amazon AppStream 2.0 access to AWS Certificate Manager Private CA in customer accounts for certificate-based authentication */
    AmazonAppStreamPCAAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamPCAAccess);
    }
    /** Provides read only access to Amazon AppStream via the AWS Management Console. */
    AmazonAppStreamReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamReadOnlyAccess);
    }
    /** Default policy for Amazon AppStream service role. */
    AmazonAppStreamServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamServiceAccess);
    }
    /** Provide full access to Amazon Athena and scoped access to the dependencies needed to enable querying, writing results, and data management. */
    AmazonAthenaFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAthenaFullAccess);
    }
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Does not allow access for creating FlowDefinitions against the public-crowd Workteam. */
    AmazonAugmentedAIFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAugmentedAIFullAccess);
    }
    /** Provides access to perform all operations on HumanLoops. */
    AmazonAugmentedAIHumanLoopFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAugmentedAIHumanLoopFullAccess);
    }
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Also provides access to those operations of services that are integrated with Amazon Augmented AI. */
    AmazonAugmentedAIIntegratedAPIAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAugmentedAIIntegratedAPIAccess);
    }
    /** Provides console full administrative access to Aurora DSQL */
    AmazonAuroraDSQLConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAuroraDSQLConsoleFullAccess);
    }
    /** Provides full administrative access to Aurora DSQL */
    AmazonAuroraDSQLFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAuroraDSQLFullAccess);
    }
    /** Provides read only access to Aurora DSQL */
    AmazonAuroraDSQLReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAuroraDSQLReadOnlyAccess);
    }
    /** Provides full access to Amazon Bedrock as well as limited access to related services that are required by it */
    AmazonBedrockFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockFullAccess);
    }
    /** Provides read only access to Amazon Bedrock */
    AmazonBedrockReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockReadOnly);
    }
    /** Defines the maximum permissions of IAM roles that Amazon Bedrock Studio creates for operating Amazon Bedrock Studio resources. */
    AmazonBedrockStudioPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockStudioPermissionsBoundary);
    }
    /** Provides full access to Amazon Braket via the AWS Management Console and SDK. Also provides access to related services (e.g., S3, logs). */
    AmazonBraketFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBraketFullAccess);
    }
    /** Grants access to AWS Services and resources necessary for executing an Amazon Braket Job including S3, Cloudwatch, IAM and Braket */
    AmazonBraketJobsExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBraketJobsExecutionPolicy);
    }
    /** Allows Amazon Braket to create and manage AWS resources on your behalf */
    AmazonBraketServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBraketServiceRolePolicy);
    }
    /** Provides full access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeFullAccess);
    }
    /** Provides read only access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeReadOnly);
    }
    /** Provides access to Amazon Chime SDK operations */
    AmazonChimeSDK() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeSDK);
    }
    /** Managed Policy For Amazon Chime SDK MediaPipelines Service Linked Role */
    AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy);
    }
    /** Allows Amazon Chime SDK Messaging to access AWS resources and enable messaging functionality */
    AmazonChimeSDKMessagingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeSDKMessagingServiceRolePolicy);
    }
    /** Enables access to AWS Resources used or managed by Amazon Chime */
    AmazonChimeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeServiceRolePolicy);
    }
    /** Allows Amazon Chime to access Amazon Transcribe and Amazon Transcribe Medical on your behalf */
    AmazonChimeTranscriptionServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeTranscriptionServiceLinkedRolePolicy);
    }
    /** Provides user management access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeUserManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeUserManagement);
    }
    /** Managed policy for Service Linked Role for Amazon Chime VoiceConnector */
    AmazonChimeVoiceConnectorServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeVoiceConnectorServiceLinkedRolePolicy);
    }
    /** Provides full access to Amazon Cloud Directory Service. */
    AmazonCloudDirectoryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudDirectoryFullAccess);
    }
    /** Provides read only access to Amazon Cloud Directory Service. */
    AmazonCloudDirectoryReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudDirectoryReadOnlyAccess);
    }
    /** Provides full only access to Amazon CloudWatch Evidently. Also provides access to related Amazon S3, Amazon SNS, Amazon CloudWatch, and other related services. */
    AmazonCloudWatchEvidentlyFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchEvidentlyFullAccess);
    }
    /** Provides read only access to Amazon CloudWatch Evidently */
    AmazonCloudWatchEvidentlyReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchEvidentlyReadOnlyAccess);
    }
    /** Allows CloudWatch Evidently Service to manage associated AWS Resources on behalf of the customer */
    AmazonCloudWatchEvidentlyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchEvidentlyServiceRolePolicy);
    }
    /** Grants full access permissions for the Amazon CloudWatch RUM service */
    AmazonCloudWatchRUMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchRUMFullAccess);
    }
    /** Grants read only permissions for the Amazon CloudWatch RUM service */
    AmazonCloudWatchRUMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchRUMReadOnlyAccess);
    }
    /** Grants permission to Amazon CloudWatch RUM Service to publish monitoring data to other relevant AWS services */
    AmazonCloudWatchRUMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchRUMServiceRolePolicy);
    }
    /** Provides full access to Amazon CodeCatalyst */
    AmazonCodeCatalystFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeCatalystFullAccess);
    }
    /** Provides read only access to Amazon CodeCatalyst */
    AmazonCodeCatalystReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeCatalystReadOnlyAccess);
    }
    /** Allows Amazon CodeCatalyst to create, update, and resolve AWS Support cases on your behalf. */
    AmazonCodeCatalystSupportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeCatalystSupportAccess);
    }
    /** Provides access required by Amazon CodeGuru Profiler agent. */
    AmazonCodeGuruProfilerAgentAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruProfilerAgentAccess);
    }
    /** Provides full access to Amazon CodeGuru Profiler. */
    AmazonCodeGuruProfilerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruProfilerFullAccess);
    }
    /** Provides read only access to Amazon CodeGuru Profiler. */
    AmazonCodeGuruProfilerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruProfilerReadOnlyAccess);
    }
    /** Grants full access to Amazon CodeGuru Reviewer and scoped access to required dependencies. */
    AmazonCodeGuruReviewerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruReviewerFullAccess);
    }
    /** Provides read only access to Amazon CodeGuru Reviewer. */
    AmazonCodeGuruReviewerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruReviewerReadOnlyAccess);
    }
    /** A service-linked role required for Amazon CodeGuru Reviewer to access resources on your behalf. */
    AmazonCodeGuruReviewerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruReviewerServiceRolePolicy);
    }
    /** Provides full access to Amazon CodeGuru Security. */
    AmazonCodeGuruSecurityFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruSecurityFullAccess);
    }
    /** Provides access required for working with Amazon CodeGuru Security scans. */
    AmazonCodeGuruSecurityScanAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruSecurityScanAccess);
    }
    /** Provides access to Amazon Cognito APIs to support developer authenticated identities from your authentication backend. */
    AmazonCognitoDeveloperAuthenticatedIdentities() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoDeveloperAuthenticatedIdentities);
    }
    /** Allows Amazon Cognito User Pools service to use your SES identities for email sending */
    AmazonCognitoIdpEmailServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoIdpEmailServiceRolePolicy);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon Cognito User Pools */
    AmazonCognitoIdpServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoIdpServiceRolePolicy);
    }
    /** Provides administrative access to existing Amazon Cognito resources. You will need AWS account admin privileges to create new Cognito resources. */
    AmazonCognitoPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoPowerUser);
    }
    /** Provides read only access to Amazon Cognito resources. */
    AmazonCognitoReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoReadOnly);
    }
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This policy is not intended to be used as a stand alone permission policy. It is used as a guardrail against overly permissive policies attached for roles in an identity pool. Do not attach this policy to any roles, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    AmazonCognitoUnAuthedIdentitiesSessionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoUnAuthedIdentitiesSessionPolicy);
    }
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This does not need to be attached to your unauth role, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    AmazonCognitoUnauthenticatedIdentities() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoUnauthenticatedIdentities);
    }
    /** The purpose of this policy is to grant permissions to AWS Connect users required to use Connect resources. This policy provides full access to AWS Connect resources via the Connect Console and public APIs */
    AmazonConnectFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectFullAccess);
    }
    /** Policy for Amazon Connect Campaigns service linked role */
    AmazonConnectCampaignsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectCampaignsServiceLinkedRolePolicy);
    }
    /** Grants permission to view the Amazon Connect instances in your AWS account. */
    AmazonConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectReadOnlyAccess);
    }
    /** Allows Amazon Connect to create and manage AWS resources on your behalf. */
    AmazonConnectServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectServiceLinkedRolePolicy);
    }
    /** Allows Amazon Connect to synchronize AWS resources across regions on your behalf. */
    AmazonConnectSynchronizationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectSynchronizationServiceRolePolicy);
    }
    /** Provides full access to Amazon Connect Voice ID */
    AmazonConnectVoiceIDFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectVoiceIDFullAccess);
    }
    /** Provides permissions to consume Amazon Bedrock models, including invoking Amazon Bedrock application inference profile created for particular Amazon DataZone domain. */
    AmazonDataZoneBedrockModelConsumptionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneBedrockModelConsumptionPolicy);
    }
    /** Provides permissions to manage Amazon Bedrock model access, including creating, tagging and deleting application inference profiles. */
    AmazonDataZoneBedrockModelManagementPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneBedrockModelManagementPolicy);
    }
    /** Default policy for the Amazon DataZone's DomainExecutionRole service role. This role is used by Amazon DataZone to catalog, discover, govern, share, and analyze data in the Amazon DataZone domain. */
    AmazonDataZoneDomainExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneDomainExecutionRolePolicy);
    }
    /** Amazon DataZone creates IAM roles for Environments to perform data analytics actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    AmazonDataZoneEnvironmentRolePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneEnvironmentRolePermissionsBoundary);
    }
    /** Provides full access to Amazon DataZone via the AWS Management Console as well as limited access to related services that are required by it. */
    AmazonDataZoneFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneFullAccess);
    }
    /** Provides full access to Amazon DataZone, but does not allow the management of domains, users, or associated accounts. */
    AmazonDataZoneFullUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneFullUserAccess);
    }
    /** The policy grants permissions to allow Amazon DataZone to enable publishing and access grants to data. */
    AmazonDataZoneGlueManageAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneGlueManageAccessRolePolicy);
    }
    /** Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across AWS services, including, but not limited to, Amazon Redshift, Amazon Athena, AWS Glue, and AWS Lake Formation. */
    AmazonDataZoneRedshiftGlueProvisioningPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneRedshiftGlueProvisioningPolicy);
    }
    /** This policy gives Amazon DataZone permissions to publish Amazon Redshift data to the catalog. It also gives Amazon DataZone permissions to grant access or revoke access to Amazon Redshift or Amazon Redshift Serverless published assets in the catalog. */
    AmazonDataZoneRedshiftManageAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneRedshiftManageAccessRolePolicy);
    }
    /** The AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary policy is the list of permissions that are permitted on an execution role created in a SageMaker environment provisioned by Amazon DataZone. */
    AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary);
    }
    /** The AmazonDataZoneSageMakerManageAccessRolePolicy policy grants Amazon DataZone the permissions required to grant user access to various resources in the SageMaker environment. */
    AmazonDataZoneSageMakerManageAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneSageMakerManageAccessRolePolicy);
    }
    /** The AmazonDataZoneSageMakerProvisioningRolePolicy policy grants Amazon DataZone the permissions required to interoperate with Amazon SageMaker. */
    AmazonDataZoneSageMakerProvisioningRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneSageMakerProvisioningRolePolicy);
    }
    /**  Provides full access to Amazon Detective service and scoped access to the console UI dependencies */
    AmazonDetectiveFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveFullAccess);
    }
    /** Provides investigator access to Amazon Detective service and scoped access to the console UI dependencies. This policy grants permission to dive into Detective for investigation purposes and limited write access to Guardduty. */
    AmazonDetectiveInvestigatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveInvestigatorAccess);
    }
    /** Provides member access to Amazon Detective service and scoped access to the console UI dependencies. */
    AmazonDetectiveMemberAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveMemberAccess);
    }
    /** Provides Organizations access to manage Delegated administrator for Amazon Detective and scoped access to the console UI dependencies. This also grants permission to create a service-linked role for Detective. */
    AmazonDetectiveOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveOrganizationsAccess);
    }
    /** Allows Amazon Detective to make service calls on your behalf */
    AmazonDetectiveServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveServiceLinkedRolePolicy);
    }
    /** The policy grants full-access to the DevOps Guru console. */
    AmazonDevOpsGuruConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruConsoleFullAccess);
    }
    /** Provides full access to Amazon DevOps Guru. */
    AmazonDevOpsGuruFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruFullAccess);
    }
    /** Provide access to enable and manage Amazon DevOps Guru within an organization. */
    AmazonDevOpsGuruOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruOrganizationsAccess);
    }
    /** Provides read only access to Amazon DevOps Guru Console. */
    AmazonDevOpsGuruReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruReadOnlyAccess);
    }
    /** A service-linked role required for Amazon DevOpsGuru to access your resources. */
    AmazonDevOpsGuruServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruServiceRolePolicy);
    }
    /** Provides access to upload DMS replication logs to cloudwatch logs in customer account. */
    AmazonDMSCloudWatchLogsRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDMSCloudWatchLogsRole);
    }
    /** Provides access to manage S3 settings for Redshift endpoints for DMS. */
    AmazonDMSRedshiftS3Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDMSRedshiftS3Role);
    }
    /** Provides access to manage VPC settings for AWS managed customer configurations */
    AmazonDMSVPCManagementRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDMSVPCManagementRole);
    }
    /** Allows Amazon DocumentDB-Elastic to manage AWS resources on your behalf. */
    AmazonDocDBElasticServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBElasticServiceRolePolicy);
    }
    /** Provides full access to manage Amazon DocumentDB with MongoDB compatibility using the AWS Management Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS and Amazon Neptune. */
    AmazonDocDBConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBConsoleFullAccess);
    }
    /** Provides full access to Amazon DocumentDB Elastic Clusters and other required permissions for its dependencies including EC2, KMS, SecretsManager, CloudWatch and IAM. */
    AmazonDocDBElasticFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBElasticFullAccess);
    }
    /** Provides read-only access to Amazon DocDB-Elastic and CloudWatch metrics. */
    AmazonDocDBElasticReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBElasticReadOnlyAccess);
    }
    /** Provides full access to Amazon DocumentDB with MongoDB compatibility. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS and Amazon Neptune. */
    AmazonDocDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBFullAccess);
    }
    /** Provides read-only access to Amazon DocumentDB with MongoDB compatibility. Note that this policy also grants access to Amazon RDS and Amazon Neptune resources. */
    AmazonDocDBReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBReadOnlyAccess);
    }
    /** Provides access to manage VPC settings for Amazon managed customer configurations */
    AmazonDRSVPCManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDRSVPCManagement);
    }
    /** Provides full access to Amazon DynamoDB via the AWS Management Console. */
    AmazonDynamoDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBFullAccess);
    }
    /** Provides full access to Amazon DynamoDB */
    AmazonDynamoDBFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBFullAccessV2);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBPipeline.html. Provides full access to Amazon DynamoDB including Export/Import using AWS Data Pipeline via the AWS Management Console. */
    AmazonDynamoDBFullAccesswithDataPipeline() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBFullAccesswithDataPipeline);
    }
    /** Provides read only access to Amazon DynamoDB via the AWS Management Console. */
    AmazonDynamoDBReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBReadOnlyAccess);
    }
    /** IAM Policy that allows the CSI driver service account to make calls to related services such as EC2 on your behalf. */
    AmazonEBSCSIDriverPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEBSCSIDriverPolicy);
    }
    /** Provides administrative access to Amazon ECR resources */
    AmazonEC2ContainerRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryFullAccess);
    }
    /** Provides full access to Amazon EC2 Container Registry repositories, but does not allow repository deletion or policy changes. */
    AmazonEC2ContainerRegistryPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryPowerUser);
    }
    /** Provides access to pull images from Amazon EC2 Container Registry repositories. */
    AmazonEC2ContainerRegistryPullOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryPullOnly);
    }
    /** Provides read-only access to Amazon EC2 Container Registry repositories. */
    AmazonEC2ContainerRegistryReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryReadOnly);
    }
    /**   Policy to enable Task Autoscaling for Amazon EC2 Container Service */
    AmazonEC2ContainerServiceAutoscaleRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceAutoscaleRole);
    }
    /** Policy to enable CloudWatch Events for EC2 Container Service */
    AmazonEC2ContainerServiceEventsRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceEventsRole);
    }
    /** Default policy for the Amazon EC2 Role for Amazon EC2 Container Service. */
    AmazonEC2ContainerServiceforEC2Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceforEC2Role);
    }
    /** Default policy for Amazon ECS service role. */
    AmazonEC2ContainerServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceRole);
    }
    /** Provides full access to Amazon EC2 via the AWS Management Console. */
    AmazonEC2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2FullAccess);
    }
    /** Provides read only access to Amazon EC2 via the AWS Management Console. */
    AmazonEC2ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ReadOnlyAccess);
    }
    /** Provides EC2 access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    AmazonEC2RoleforAWSCodeDeploy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeploy);
    }
    /** Provides EC2 limited access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    AmazonEC2RoleforAWSCodeDeployLimited() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeployLimited);
    }
    /** Default policy for the Amazon EC2 Role for Data Pipeline service role. */
    AmazonEC2RoleforDataPipelineRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforDataPipelineRole);
    }
    /** This policy will soon be deprecated. Please use AmazonSSMManagedInstanceCore policy to enable AWS Systems Manager service core functionality on EC2 instances. For more information see https://docs.aws.amazon.com/systems-manager/latest/userguide/setup-instance-profile.html */
    AmazonEC2RoleforSSM() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforSSM);
    }
    /** Managed policy for the Amazon LaunchWizard service role for EC2 */
    AmazonEC2RolePolicyForLaunchWizard() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RolePolicyForLaunchWizard);
    }
    /** Policy to enable Autoscaling for Amazon EC2 Spot Fleet */
    AmazonEC2SpotFleetAutoscaleRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2SpotFleetAutoscaleRole);
    }
    /** Allows EC2 Spot Fleet to request, terminate and tag Spot Instances on your behalf. */
    AmazonEC2SpotFleetTaggingRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2SpotFleetTaggingRole);
    }
    /** Provides administrative access to Amazon ECS resources and enables ECS features through access to other AWS service resources, including VPCs, Auto Scaling groups, and CloudFormation stacks. */
    AmazonECSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSFullAccess);
    }
    /** Policy to enable Amazon ECS Compute to manage your EC2 instances and related resources as part of ECS managed instances */
    AmazonECSComputeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSComputeServiceRolePolicy);
    }
    /** Provides administrative access to Private Certificate Authority, AWS Secrets Manager and other AWS Services required to manage ECS Service Connect TLS features on your behalf. */
    AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity);
    }
    /** Provides access to other AWS service resources required to manage volumes associated with ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForVolumes() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVolumes);
    }
    /** Provides access to other AWS service resources required to manage VPC Lattice feature in ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForVpcLattice() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVpcLattice);
    }
    /** Policy to enable Amazon ECS to manage your cluster. */
    AmazonECSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSServiceRolePolicy);
    }
    /** Provides access to other AWS service resources that are required to run Amazon ECS tasks */
    AmazonECSTaskExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSTaskExecutionRolePolicy);
    }
    /** Provides management access to EFS resources and read access to EC2 */
    AmazonEFSCSIDriverPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEFSCSIDriverPolicy);
    }
    /** This policy provides the Amazon VPC CNI Plugin (amazon-vpc-cni-k8s) the permissions it requires to modify the IP address configuration on your EKS worker nodes. This permission set allows the CNI to list, describe, and modify Elastic Network Interfaces on your behalf. More information on the AWS VPC CNI Plugin is available here: https://github.com/aws/amazon-vpc-cni-k8s */
    AmazonEKSCNIPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSCNIPolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's block storage resources. */
    AmazonEKSBlockStoragePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSBlockStoragePolicy);
    }
    /** This policy provides Kubernetes the permissions it requires to manage resources on your behalf. Kubernetes requires Ec2:CreateTags permissions to place identifying information on EC2 resources including but not limited to Instances, Security Groups, and Elastic Network Interfaces. */
    AmazonEKSClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSClusterPolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's compute resources. */
    AmazonEKSComputePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSComputePolicy);
    }
    /** This policy allows Amazon EKS to manage AWS resources for EKS connector */
    AmazonEKSConnectorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSConnectorServiceRolePolicy);
    }
    /** Provides read only access to view the dashboard in the Amazon EKS console. The dashboard aggregates information about multiple clusters and related resources using AWS Organizations. */
    AmazonEKSDashboardConsoleReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSDashboardConsoleReadOnly);
    }
    /** This policy enables the Amazon EKS Dashboard to access and display organization-wide information. The policy allows the EKS Dashboard service to gather information about your AWS Organizations structure and accounts. */
    AmazonEKSDashboardServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSDashboardServiceRolePolicy);
    }
    /** Provides access to other AWS service resources that are required to run Amazon EKS pods on AWS Fargate */
    AmazonEKSFargatePodExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSFargatePodExecutionRolePolicy);
    }
    /** This policy grants necessary permissions to Amazon EKS to run fargate tasks */
    AmazonEKSForFargateServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSForFargateServiceRolePolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's load balancing resources. */
    AmazonEKSLoadBalancingPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSLoadBalancingPolicy);
    }
    /** This policy provides permissions to EKS local cluster's control-plane instances running in your account to manage resources on your behalf. */
    AmazonEKSLocalOutpostClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSLocalOutpostClusterPolicy);
    }
    /** Allows Amazon EKS Local to call AWS services on your behalf. */
    AmazonEKSLocalOutpostServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSLocalOutpostServiceRolePolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's networking resources. */
    AmazonEKSNetworkingPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSNetworkingPolicy);
    }
    /** This policy allows Amazon Elastic Container Service for Kubernetes to create and manage the necessary resources to operate EKS Clusters. */
    AmazonEKSServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSServicePolicy);
    }
    /** A Service-Linked Role required for Amazon EKS to call AWS services on your behalf. */
    AmazonEKSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSServiceRolePolicy);
    }
    /** Policy used by VPC Resource Controller to manage ENI and IPs for worker nodes. */
    AmazonEKSVPCResourceController() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSVPCResourceController);
    }
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    AmazonEKSWorkerNodeMinimalPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSWorkerNodeMinimalPolicy);
    }
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    AmazonEKSWorkerNodePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSWorkerNodePolicy);
    }
    /** Provides full access to Amazon ElastiCache via the AWS Management Console. */
    AmazonElastiCacheFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElastiCacheFullAccess);
    }
    /** Provides read only access to Amazon ElastiCache via the AWS Management Console. */
    AmazonElastiCacheReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElastiCacheReadOnlyAccess);
    }
    /** Provides administrative access to Amazon ECR Public resources */
    AmazonElasticContainerRegistryPublicFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticContainerRegistryPublicFullAccess);
    }
    /** Provides full access to Amazon ECR Public repositories, but does not allow repository deletion or policy changes. */
    AmazonElasticContainerRegistryPublicPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticContainerRegistryPublicPowerUser);
    }
    /** Provides read-only access to Amazon ECR Public repositories. */
    AmazonElasticContainerRegistryPublicReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticContainerRegistryPublicReadOnly);
    }
    /** Provides root client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemClientFullAccess);
    }
    /** Provides read only client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemClientReadOnlyAccess);
    }
    /** Provides read and write client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientReadWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemClientReadWriteAccess);
    }
    /** Provides full access to Amazon EFS via the AWS Management Console. */
    AmazonElasticFileSystemFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemFullAccess);
    }
    /** Provides read only access to Amazon EFS via the AWS Management Console. */
    AmazonElasticFileSystemReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemReadOnlyAccess);
    }
    /** Allows Amazon Elastic File System to manage AWS resources on your behalf */
    AmazonElasticFileSystemServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemServiceRolePolicy);
    }
    /** Allows customers to use AWS Systems Manager to automatically manage Amazon EFS utilities (amazon-efs-utils) package on their EC2 instances, and use CloudWatchLog to get EFS file system mount success/failure notifications. */
    AmazonElasticFileSystemsUtils() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemsUtils);
    }
    /** Default policy for the Amazon Elastic MapReduce Editors service role. */
    AmazonElasticMapReduceEditorsRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceEditorsRole);
    }
    /** Amazon Elastic MapReduce for Auto Scaling. Role to allow Auto Scaling to add and remove instances from your EMR cluster. */
    AmazonElasticMapReduceforAutoScalingRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceforAutoScalingRole);
    }
    /** Default policy for the Amazon Elastic MapReduce for EC2 service role. */
    AmazonElasticMapReduceforEC2Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceforEC2Role);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html. Provides full access to Amazon Elastic MapReduce and underlying services that it requires such as EC2 and S3 */
    AmazonElasticMapReduceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceFullAccess);
    }
    /** Policy to allow EMR to create, describe and delete EC2 placement groups. */
    AmazonElasticMapReducePlacementGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReducePlacementGroupPolicy);
    }
    /** Provides read only access to Amazon Elastic MapReduce via the AWS Management Console. */
    AmazonElasticMapReduceReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceReadOnlyAccess);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html.  Default policy for the Amazon Elastic MapReduce service role. */
    AmazonElasticMapReduceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceRole);
    }
    /** Allow Amazon Elasticsearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    AmazonElasticsearchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticsearchServiceRolePolicy);
    }
    /** Grants users full access to Elastic Transcoder and the access to associated services that is required for full Elastic Transcoder functionality. */
    AmazonElasticTranscoderFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderFullAccess);
    }
    /** Grants users permission to change presets, submit jobs, and view Elastic Transcoder settings. This policy also grants some read-only access to some other services required to use the Elastic Transcode console, including S3, IAM, and SNS. */
    AmazonElasticTranscoderJobsSubmitter() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderJobsSubmitter);
    }
    /** Grants users read-only access to Elastic Transcoder and list access to related services. */
    AmazonElasticTranscoderReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderReadOnlyAccess);
    }
    /** Default policy for the Amazon Elastic Transcoder service role. */
    AmazonElasticTranscoderRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderRole);
    }
    /** Allows the actions that EMR requires to terminate and delete AWS EC2 resources if the EMR Service role has lost that ability. */
    AmazonEMRCleanupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRCleanupPolicy);
    }
    /** Allows access to other AWS service resources that are required to run Amazon EMR */
    AmazonEMRContainersServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRContainersServiceRolePolicy);
    }
    /** Provides full access to Amazon EMR */
    AmazonEMRFullAccessPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRFullAccessPolicyV2);
    }
    /** Provides read only access to Amazon EMR and the associated CloudWatch Metrics. */
    AmazonEMRReadOnlyAccessPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRReadOnlyAccessPolicyV2);
    }
    /** Allows access to other AWS service resources that are required to run Amazon EMRServerless */
    AmazonEMRServerlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRServerlessServiceRolePolicy);
    }
    /** This policy is used for the Amazon EMR Service Role and should NOT be used for any other IAM users or roles in your account. The policy grants permissions to create and manage resources associated with EMR and related services necessary for the operation of your EMR cluster. */
    AmazonEMRServicePolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRServicePolicyV2);
    }
    /** Provides limited access to the Amazon Cognito configuration service. */
    AmazonESCognitoAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonESCognitoAccess);
    }
    /** Provides full access to the Amazon ES configuration service. */
    AmazonESFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonESFullAccess);
    }
    /** Provides read-only access to the Amazon ES configuration service. */
    AmazonESReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonESReadOnlyAccess);
    }
    /** Allows EventBridge to access Secret Manager resources on your behalf. */
    AmazonEventBridgeApiDestinationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeApiDestinationsServiceRolePolicy);
    }
    /** Provides full access to Amazon EventBridge. */
    AmazonEventBridgeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeFullAccess);
    }
    /** Provides full access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgePipesFullAccess);
    }
    /** Provides read-only and operator (ability to Stop and Start running Pipes) access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgePipesOperatorAccess);
    }
    /** Provides read-only access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgePipesReadOnlyAccess);
    }
    /** Provides read only access to Amazon EventBridge. */
    AmazonEventBridgeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeReadOnlyAccess);
    }
    /** The AmazonEventBridgeSchedulerFullAccess managed policy grants permissions to use all EventBridge Scheduler actions for schedules, and schedule groups. */
    AmazonEventBridgeSchedulerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchedulerFullAccess);
    }
    /** The AmazonEventBridgeSchedulerReadOnlyAccess managed policy grants read-only permissions to view details about your schedules and schedule groups */
    AmazonEventBridgeSchedulerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchedulerReadOnlyAccess);
    }
    /** Provides full access to Amazon EventBridge Schemas. */
    AmazonEventBridgeSchemasFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchemasFullAccess);
    }
    /** Provides read only access to Amazon EventBridge Schemas. */
    AmazonEventBridgeSchemasReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchemasReadOnlyAccess);
    }
    /** Grants permissions to Managed Rules created by Amazon EventBridge schemas. */
    AmazonEventBridgeSchemasServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchemasServiceRolePolicy);
    }
    /** Grants permissions to EVS to manage resources on your behalf */
    AmazonEVSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEVSServiceRolePolicy);
    }
    /** Policy to enable AWS FIS to manage monitoring and resource selection for experiments. */
    AmazonFISServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFISServiceRolePolicy);
    }
    /** Gives access to all actions for Amazon Forecast */
    AmazonForecastFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonForecastFullAccess);
    }
    /** Gives access to all actions for Amazon Fraud Detector */
    AmazonFraudDetectorFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFraudDetectorFullAccessPolicy);
    }
    /** Full Access Policy for Amazon FreeRTOS */
    AmazonFreeRTOSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFreeRTOSFullAccess);
    }
    /** Allows user to access Amazon FreeRTOS OTA Update */
    AmazonFreeRTOSOTAUpdate() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFreeRTOSOTAUpdate);
    }
    /** Provides full access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    AmazonFSxConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxConsoleFullAccess);
    }
    /** Provides read only access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    AmazonFSxConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxConsoleReadOnlyAccess);
    }
    /** Provides full access to Amazon FSx and access to related AWS services. */
    AmazonFSxFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxFullAccess);
    }
    /** Provides read only access to Amazon FSx. */
    AmazonFSxReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxReadOnlyAccess);
    }
    /** Allows Amazon FSx to manage AWS resources on your behalf */
    AmazonFSxServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxServiceRolePolicy);
    }
    /** Provides full access to Amazon Glacier via the AWS Management Console. */
    AmazonGlacierFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGlacierFullAccess);
    }
    /** Provides read only access to Amazon Glacier via the AWS Management Console. */
    AmazonGlacierReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGlacierReadOnlyAccess);
    }
    /** This policy grants access to Amazon Athena and the dependencies needed to enable querying and writing results to s3 from the Amazon Athena plugin in Amazon Grafana. */
    AmazonGrafanaAthenaAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaAthenaAccess);
    }
    /** This policy grants access to Amazon CloudWatch and the dependencies needed to use CloudWatch as a datasource within Amazon Managed Grafana. */
    AmazonGrafanaCloudWatchAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaCloudWatchAccess);
    }
    /** This policy grants scoped access to Amazon Redshift and the dependencies needed to use the Amazon Redshift plugin in Amazon Grafana. */
    AmazonGrafanaRedshiftAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaRedshiftAccess);
    }
    /** Provides access to AWS Resources managed or used by Amazon Grafana. */
    AmazonGrafanaServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaServiceLinkedRolePolicy);
    }
    /** Provides full access to use Amazon GuardDuty. */
    AmazonGuardDutyFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyFullAccess);
    }
    /** Provides full access to use Amazon GuardDuty */
    AmazonGuardDutyFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyFullAccessV2);
    }
    /** GuardDuty malware protection uses the service-linked role (SLR) named AWSServiceRoleForAmazonGuardDutyMalwareProtection. This service-linked role allows GuardDuty malware protection to perform agent-less scans to detect malware. It allows GuardDuty to create snapshots in your account, and share the snapshots with the GuardDuty service account to scan for malware. It evaluates these shared snapshots and includes the retrieved EC2 instance metadata in the GuardDuty Malware Protection findings. The AWSServiceRoleForAmazonGuardDutyMalwareProtection service-linked role trusts the malware-protection.guardduty.amazonaws.com service to assume the role. */
    AmazonGuardDutyMalwareProtectionServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyMalwareProtectionServiceRolePolicy);
    }
    /** Provides read only access to Amazon GuardDuty resources */
    AmazonGuardDutyReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyReadOnlyAccess);
    }
    /** Enable access to AWS Resources used or managed by Amazon Guard Duty */
    AmazonGuardDutyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyServiceRolePolicy);
    }
    /** Provides full access to Amazon HealthLake service. */
    AmazonHealthLakeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHealthLakeFullAccess);
    }
    /** Provides read only access to Amazon HealthLake service. */
    AmazonHealthLakeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHealthLakeReadOnlyAccess);
    }
    /** Provides full access to Honeycode via the AWS Management Console and the SDK. */
    AmazonHoneycodeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeFullAccess);
    }
    /** Provides read only access to Honeycode via the AWS Management Console and the SDK. */
    AmazonHoneycodeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeReadOnlyAccess);
    }
    /** A service-linked role required for Amazon Honeycode to access your resources. */
    AmazonHoneycodeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeServiceRolePolicy);
    }
    /** Provides full access to Honeycode Team Association via the AWS Management Console and the SDK. */
    AmazonHoneycodeTeamAssociationFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeTeamAssociationFullAccess);
    }
    /** Provides read only access to Honeycode Team Association via the AWS Management Console and the SDK. */
    AmazonHoneycodeTeamAssociationReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeTeamAssociationReadOnlyAccess);
    }
    /** Provides full access to Honeycode Workbook via the AWS Management Console and the SDK. */
    AmazonHoneycodeWorkbookFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeWorkbookFullAccess);
    }
    /** Provides read only access to Honeycode Workbook via the AWS Management Console and the SDK. */
    AmazonHoneycodeWorkbookReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeWorkbookReadOnlyAccess);
    }
    /** Grants Amazon Inspector access to AWS Services needed to perform agent-less security assessments */
    AmazonInspector2AgentlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2AgentlessServiceRolePolicy);
    }
    /** Provides full access to Amazon Inspector and access to other related services such as organizations. */
    AmazonInspector2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2FullAccess);
    }
    /** This is a managed policy that customer should attach to their roles to communicate with inspector service for CIS scans */
    AmazonInspector2ManagedCisPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2ManagedCisPolicy);
    }
    /** Provides read only access to the Amazon inspector2 service and relevant support services */
    AmazonInspector2ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2ReadOnlyAccess);
    }
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    AmazonInspector2ServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2ServiceRolePolicy);
    }
    /** Provides full access to Amazon Inspector. */
    AmazonInspectorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspectorFullAccess);
    }
    /** Provides read only access to Amazon Inspector. */
    AmazonInspectorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspectorReadOnlyAccess);
    }
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    AmazonInspectorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspectorServiceRolePolicy);
    }
    /** Provides full access to Amazon Kendra via the AWS Management Console. */
    AmazonKendraFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKendraFullAccess);
    }
    /** Provides read only access to Amazon Kendra via the AWS Management Console. */
    AmazonKendraReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKendraReadOnlyAccess);
    }
    /** Provide full access to Amazon Keyspaces */
    AmazonKeyspacesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKeyspacesFullAccess);
    }
    /** Provide read only access to Amazon Keyspaces */
    AmazonKeyspacesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKeyspacesReadOnlyAccess);
    }
    /** Provide read only access to Amazon Keyspaces and related AWS services. */
    AmazonKeyspacesReadOnlyAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKeyspacesReadOnlyAccessV2);
    }
    /** Provides full access to Amazon Kinesis Analytics via the AWS Management Console. */
    AmazonKinesisAnalyticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisAnalyticsFullAccess);
    }
    /** Provides read-only access to Amazon Kinesis Analytics via the AWS Management Console. */
    AmazonKinesisAnalyticsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisAnalyticsReadOnly);
    }
    /** Provides full access to all Amazon Kinesis Firehose Delivery Streams. */
    AmazonKinesisFirehoseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisFirehoseFullAccess);
    }
    /** Provides read only access to all Amazon Kinesis Firehose Delivery Streams. */
    AmazonKinesisFirehoseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisFirehoseReadOnlyAccess);
    }
    /** Provides full access to all streams via the AWS Management Console. */
    AmazonKinesisFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisFullAccess);
    }
    /** Provides read only access to all streams via the AWS Management Console. */
    AmazonKinesisReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisReadOnlyAccess);
    }
    /** Provides full access to Amazon Kinesis Video Streams via the AWS Management Console. */
    AmazonKinesisVideoStreamsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisVideoStreamsFullAccess);
    }
    /** Provides read only access to AWS Kinesis Video Streams via the AWS Management Console. */
    AmazonKinesisVideoStreamsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisVideoStreamsReadOnlyAccess);
    }
    /** Full access to AWS Launch wizard and other required services. */
    AmazonLaunchWizardFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLaunchWizardFullAccessV2);
    }
    /** This policy allows customers to call Lex runtime from channels */
    AmazonLexChannelsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexChannelsAccess);
    }
    /** Provides full access to Amazon Lex via the AWS Management Console.  Also provides access to create Lex Service Linked Roles and grant Lex permissions to invoke a limited set of Lambda functions. */
    AmazonLexFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexFullAccess);
    }
    /** Provides read-only access to Amazon Lex. */
    AmazonLexReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexReadOnly);
    }
    /** Allows Amazon Lex to replicate Lex resources across regions on your behalf. */
    AmazonLexReplicationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexReplicationPolicy);
    }
    /** Provides access to Amazon Lex conversational APIs. */
    AmazonLexRunBotsOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexRunBotsOnly);
    }
    /** Provides Lex V2 bots access to call other AWS services on your behalf. */
    AmazonLexV2BotPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexV2BotPolicy);
    }
    /** Provides full access to Amazon Lookout for Equipment operations */
    AmazonLookoutEquipmentFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutEquipmentFullAccess);
    }
    /** Provides read only access to Amazon Lookout for Equipments */
    AmazonLookoutEquipmentReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutEquipmentReadOnlyAccess);
    }
    /** Gives access to all actions for Amazon Lookout for Metrics */
    AmazonLookoutMetricsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutMetricsFullAccess);
    }
    /** Gives access to all read-only actions for Amazon Lookout for Metrics */
    AmazonLookoutMetricsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutMetricsReadOnlyAccess);
    }
    /** Provides full access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    AmazonLookoutVisionConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionConsoleFullAccess);
    }
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    AmazonLookoutVisionConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionConsoleReadOnlyAccess);
    }
    /** Provides full access to Amazon Lookout for Vision and scoped access to required dependencies. */
    AmazonLookoutVisionFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionFullAccess);
    }
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required dependencies. */
    AmazonLookoutVisionReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionReadOnlyAccess);
    }
    /** Grants users permission to request Amazon Machine Learning batch predictions. */
    AmazonMachineLearningBatchPredictionsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningBatchPredictionsAccess);
    }
    /** Provides create access for non-prediction Amazon Machine Learning resources. */
    AmazonMachineLearningCreateOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningCreateOnlyAccess);
    }
    /** Provides full access to Amazon Machine Learning resources. */
    AmazonMachineLearningFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningFullAccess);
    }
    /** Grants users permission to create and delete the real-time endpoint for Amazon Machine Learning models. */
    AmazonMachineLearningManageRealTimeEndpointOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningManageRealTimeEndpointOnlyAccess);
    }
    /** Provides read only access to Amazon Machine Learning resources. */
    AmazonMachineLearningReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningReadOnlyAccess);
    }
    /** Grants users permission to request Amazon Machine Learning real-time predictions. */
    AmazonMachineLearningRealTimePredictionOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningRealTimePredictionOnlyAccess);
    }
    /** Allows Machine Learning to configure and use your Redshift Clusters and S3 Staging Locations for Redshift Data Source. */
    AmazonMachineLearningRoleforRedshiftDataSourceV3() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningRoleforRedshiftDataSourceV3);
    }
    /** Provides full access to Amazon Macie. */
    AmazonMacieFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieFullAccess);
    }
    /** Grants permission to create the service-linked role of Amazon Macie. */
    AmazonMacieHandshakeRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieHandshakeRole);
    }
    /** Provides readonly access to Amazon Macie. */
    AmazonMacieReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieReadOnlyAccess);
    }
    /** Grants Macie read-only access to resource dependencies in your account in order to enable data analysis. */
    AmazonMacieServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieServiceRole);
    }
    /** Service linked role for Amazon Macie */
    AmazonMacieServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieServiceRolePolicy);
    }
    /** Provides full access to Amazon Managed Blockchain via the AWS Management Console */
    AmazonManagedBlockchainConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainConsoleFullAccess);
    }
    /** Provides full access to Amazon Managed Blockchain. */
    AmazonManagedBlockchainFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainFullAccess);
    }
    /** Provides read-only access to Amazon Managed Blockchain. */
    AmazonManagedBlockchainReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon Managed Blockchain */
    AmazonManagedBlockchainServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainServiceRolePolicy);
    }
    /** Provide full access to Amazon Managed Apache Cassandra Service */
    AmazonMCSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMCSFullAccess);
    }
    /** Provide read only access to Amazon Managed Apache Cassandra Service */
    AmazonMCSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMCSReadOnlyAccess);
    }
    /** Provides full access to all APIs in Amazon Mechanical Turk. */
    AmazonMechanicalTurkFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMechanicalTurkFullAccess);
    }
    /** Provides access to read only APIs in Amazon Mechanical Turk. */
    AmazonMechanicalTurkReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMechanicalTurkReadOnly);
    }
    /** Provides full access to Amazon MemoryDB via the AWS Management Console. */
    AmazonMemoryDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMemoryDBFullAccess);
    }
    /** Provides read only access to Amazon MemoryDB via the AWS Management Console. */
    AmazonMemoryDBReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMemoryDBReadOnlyAccess);
    }
    /** Provides read only access to all reports including financial data for all application resources. */
    AmazonMobileAnalyticsFinancialReportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsFinancialReportAccess);
    }
    /** Provides full access to all application resources. */
    AmazonMobileAnalyticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsFullAccess);
    }
    /** Provides read only access to non financial reports for all application resources. */
    AmazonMobileAnalyticsNonFinancialReportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsNonFinancialReportAccess);
    }
    /** Provides write only access to put event data for all application resources. (Recommended for SDK integration) */
    AmazonMobileAnalyticsWriteOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsWriteOnlyAccess);
    }
    /** Provides full access to manage Amazon Monitron */
    AmazonMonitronFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMonitronFullAccess);
    }
    /** Provides full access to AmazonMQ via our API/SDK. */
    AmazonMQApiFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQApiFullAccess);
    }
    /** Provides read only access to AmazonMQ via our API/SDK. */
    AmazonMQApiReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQApiReadOnlyAccess);
    }
    /** Provides full access to AmazonMQ via the AWS Management Console. */
    AmazonMQFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQFullAccess);
    }
    /** Provides read only access to AmazonMQ via the AWS Management Console. */
    AmazonMQReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQReadOnlyAccess);
    }
    /** Service Linked Role Policy for AWS Amazon MQ */
    AmazonMQServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQServiceRolePolicy);
    }
    /** Provide readonly access to Amazon MSK Connect */
    AmazonMSKConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMSKConnectReadOnlyAccess);
    }
    /** Provide full access to Amazon MSK and other required permissions for its dependencies. */
    AmazonMSKFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMSKFullAccess);
    }
    /** Provide readonly access to Amazon MSK */
    AmazonMSKReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMSKReadOnlyAccess);
    }
    /** The Service Linked Role used by Amazon Managed Workflows for Apache Airflow. */
    AmazonMWAAServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMWAAServiceRolePolicy);
    }
    /** This policy grants access to resources needed by Nimble Studio Launch Profile workers. Attach this policy to EC2 instances created by Nimble Studio Builder. */
    AmazonNimbleStudioLaunchProfileWorker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonNimbleStudioLaunchProfileWorker);
    }
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio admin and related studio resources in other services. Attach this policy to the Admin role associated with your studio. */
    AmazonNimbleStudioStudioAdmin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonNimbleStudioStudioAdmin);
    }
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio user and related studio resources in other services. Attach this policy to the User role associated with your studio. */
    AmazonNimbleStudioStudioUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonNimbleStudioStudioUser);
    }
    /** Allows Oracle Database@AWS to manage AWS resources on your behalf. */
    AmazonODBServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonODBServiceRolePolicy);
    }
    /** Provides full access to Amazon Omics and other required AWS Services. This policy allows the user to view and accept RAM share invitations to access resources outside of the user's AWS account. */
    AmazonOmicsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOmicsFullAccess);
    }
    /** Provide read only access to Amazon Omics */
    AmazonOmicsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOmicsReadOnlyAccess);
    }
    /** This policy grants administrative permissions that allow access to all Amazon One Enterprise resources and operations. */
    AmazonOneEnterpriseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOneEnterpriseFullAccess);
    }
    /** This policy grants limited read and write permissions that allow device installation and activation. */
    AmazonOneEnterpriseInstallerAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOneEnterpriseInstallerAccess);
    }
    /** This policy grants read only permissions to all Amazon One Enterprise resources and operations. */
    AmazonOneEnterpriseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOneEnterpriseReadOnlyAccess);
    }
    /** Provides access to Amazon OpenSearch Dashboards Service to access other AWS services such as CloudWatch on your behalf */
    AmazonOpenSearchDashboardsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchDashboardsServiceRolePolicy);
    }
    /** Allows OpenSearch DirectQuery Service to access AWS Glue APIs for creating resources on your behalf. */
    AmazonOpenSearchDirectQueryGlueCreateAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchDirectQueryGlueCreateAccess);
    }
    /** Allows Amazon OpenSearch Ingestion to access other AWS services on your behalf. */
    AmazonOpenSearchIngestionFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchIngestionFullAccess);
    }
    /** Provides read only access to the Amazon OpenSearch Ingestion Service */
    AmazonOpenSearchIngestionReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchIngestionReadOnlyAccess);
    }
    /** Allows Amazon OpenSearch Ingestion Service to access other AWS services on your behalf. */
    AmazonOpenSearchIngestionServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchIngestionServiceRolePolicy);
    }
    /** Allow Amazon OpenSearch Serverless to access other AWS services such as CloudWatch APIs on your behalf. */
    AmazonOpenSearchServerlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServerlessServiceRolePolicy);
    }
    /** Provides access to the Amazon Cognito configuration service. */
    AmazonOpenSearchServiceCognitoAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceCognitoAccess);
    }
    /** Provides full access to the Amazon OpenSearch Service configuration service. */
    AmazonOpenSearchServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceFullAccess);
    }
    /** Provides read-only access to the Amazon OpenSearch Service configuration service. */
    AmazonOpenSearchServiceReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceReadOnlyAccess);
    }
    /** Allow Amazon OpenSearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    AmazonOpenSearchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceRolePolicy);
    }
    /** Provides full access to Amazon Personalize via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, CloudWatch). */
    AmazonPersonalizeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPersonalizeFullAccess);
    }
    /** Grants full access to Amazon Polly service and resources. */
    AmazonPollyFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPollyFullAccess);
    }
    /** Grants read-only access to Amazon Polly resources. */
    AmazonPollyReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPollyReadOnlyAccess);
    }
    /** Grants full access to AWS Managed Prometheus resources in the AWS console */
    AmazonPrometheusConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusConsoleFullAccess);
    }
    /** Grants full access to AWS Managed Prometheus resources */
    AmazonPrometheusFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusFullAccess);
    }
    /** Grants access to run queries against AWS Managed Prometheus resources */
    AmazonPrometheusQueryAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusQueryAccess);
    }
    /** Grants write only access to AWS Managed Prometheus workspaces */
    AmazonPrometheusRemoteWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusRemoteWriteAccess);
    }
    /** Provides access to AWS Resources managed or used by Amazon Managed Service for Prometheus Collector */
    AmazonPrometheusScraperServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusScraperServiceRolePolicy);
    }
    /** Provides developer access to enable interactions with Amazon Q */
    AmazonQDeveloperAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQDeveloperAccess);
    }
    /** Provides full access to enable interactions with Amazon Q */
    AmazonQFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQFullAccess);
    }
    /** Provides full access to Amazon QLDB via the AWS Management Console. */
    AmazonQLDBConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQLDBConsoleFullAccess);
    }
    /** Provides full access to Amazon QLDB via the service API. */
    AmazonQLDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQLDBFullAccess);
    }
    /** Provides read only access to Amazon QLDB. */
    AmazonQLDBReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQLDBReadOnly);
    }
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    AmazonRDSBetaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSBetaServiceRolePolicy);
    }
    /** Allows Amazon RDS Custom to perform various automation actions and database management tasks through an EC2 instance profile. */
    AmazonRDSCustomInstanceProfileRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSCustomInstanceProfileRolePolicy);
    }
    /** Amazon RDS Custom Preview Service Role Policy */
    AmazonRDSCustomPreviewServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSCustomPreviewServiceRolePolicy);
    }
    /** Allows Amazon RDS Custom to manage AWS resources on your behalf. */
    AmazonRDSCustomServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSCustomServiceRolePolicy);
    }
    /** Allows full access to use the RDS data APIs, secret store APIs for RDS database credentials, and DB console query management APIs to execute SQL statements on Aurora Serverless clusters in the AWS account. */
    AmazonRDSDataFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSDataFullAccess);
    }
    /** Allow RDS to access Directory Service Managed AD on behalf of the customer for domain-joined SQL Server DB instances. */
    AmazonRDSDirectoryServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSDirectoryServiceAccess);
    }
    /** Provides access to Cloudwatch for RDS Enhanced Monitoring */
    AmazonRDSEnhancedMonitoringRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSEnhancedMonitoringRole);
    }
    /** Provides full access to Amazon RDS via the AWS Management Console. */
    AmazonRDSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSFullAccess);
    }
    /** Provides full access to RDS Performance Insights via the AWS Management Console */
    AmazonRDSPerformanceInsightsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSPerformanceInsightsFullAccess);
    }
    /** Read-Only policy for RDS Performance Insights */
    AmazonRDSPerformanceInsightsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSPerformanceInsightsReadOnly);
    }
    /** Amazon RDS Preview Service Role Policy */
    AmazonRDSPreviewServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSPreviewServiceRolePolicy);
    }
    /** Provides read only access to Amazon RDS via the AWS Management Console. */
    AmazonRDSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSReadOnlyAccess);
    }
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    AmazonRDSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSServiceRolePolicy);
    }
    /** This policy includes permissions to run SQL commands to copy, load, unload, query, and analyze data on Amazon Redshift. The policy also grants permissions to run select statements for related services, such as Amazon S3, Amazon CloudWatch logs, Amazon SageMaker, or AWS Glue. */
    AmazonRedshiftAllCommandsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftAllCommandsFullAccess);
    }
    /** This policy provides full access to Amazon Redshift Data APIs. This policy also grants scoped access to other required services. */
    AmazonRedshiftDataFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftDataFullAccess);
    }
    /** Provides full access to Amazon Redshift via the AWS Management Console. */
    AmazonRedshiftFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftFullAccess);
    }
    /** Provides full access to the Amazon Redshift Query Editor and to saved queries via the AWS Management Console. */
    AmazonRedshiftQueryEditor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditor);
    }
    /** Grants full access to the Amazon Redshift Query Editor V2 operations and resources. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters, read keys and aliases in AWS KMS and manage the Query Editor V2 secrets in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2FullAccess);
    }
    /** Grants the ability to work with Amazon Redshift Query Editor V2 without sharing resources. The granted principal can only read, update and delete its own resources but cannot share them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2NoSharing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2NoSharing);
    }
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with limited sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read the resources shared with its team but cannot update them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2ReadSharing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadSharing);
    }
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read and update the resources shared with its team. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2ReadWriteSharing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadWriteSharing);
    }
    /** Provides read only access to Amazon Redshift via the AWS Management Console. */
    AmazonRedshiftReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftReadOnlyAccess);
    }
    /** Allows Amazon Redshift to call AWS services on your behalf */
    AmazonRedshiftServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftServiceLinkedRolePolicy);
    }
    /** This policy specifies rekognition and s3 permissions required by Amazon Rekognition Custom Labels feature. */
    AmazonRekognitionCustomLabelsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionCustomLabelsFullAccess);
    }
    /** Access to all Amazon Rekognition APIs */
    AmazonRekognitionFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionFullAccess);
    }
    /** Access to all Read rekognition APIs */
    AmazonRekognitionReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionReadOnlyAccess);
    }
    /** Allows Rekognition to call AWS services on your behalf. */
    AmazonRekognitionServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionServiceRole);
    }
    /** Provides full access to all Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53AutoNamingFullAccess);
    }
    /** Provides read-only access to all Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53AutoNamingReadOnlyAccess);
    }
    /** Provides registrant level access to Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingRegistrantAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53AutoNamingRegistrantAccess);
    }
    /** Provides full access to all Route53 Domains actions and Create Hosted Zone to allow Hosted Zone creation as part of domain registrations. */
    AmazonRoute53DomainsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53DomainsFullAccess);
    }
    /** Provides access to Route53 Domains list and actions. */
    AmazonRoute53DomainsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53DomainsReadOnlyAccess);
    }
    /** Provides full access to all Amazon Route 53 via the AWS Management Console. */
    AmazonRoute53FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53FullAccess);
    }
    /** This policy grants full access to Amazon Route 53 Profile resources. */
    AmazonRoute53ProfilesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ProfilesFullAccess);
    }
    /** This policy grants read-only access to Amazon Route 53 Profile resources. */
    AmazonRoute53ProfilesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ProfilesReadOnlyAccess);
    }
    /** Provides read only access to all Amazon Route 53 via the AWS Management Console. */
    AmazonRoute53ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ReadOnlyAccess);
    }
    /** Provides full access to Amazon Route 53 Recovery Cluster */
    AmazonRoute53RecoveryClusterFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryClusterFullAccess);
    }
    /** Provides read only access to Amazon Route 53 Recovery Cluster */
    AmazonRoute53RecoveryClusterReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryClusterReadOnlyAccess);
    }
    /** Provides full access to Amazon Route 53 Recovery Control Config */
    AmazonRoute53RecoveryControlConfigFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryControlConfigFullAccess);
    }
    /** Provides read only access to Amazon Route 53 Recovery Control Config */
    AmazonRoute53RecoveryControlConfigReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryControlConfigReadOnlyAccess);
    }
    /** Provides full access to Amazon Route 53 Recovery Readiness */
    AmazonRoute53RecoveryReadinessFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryReadinessFullAccess);
    }
    /** Provides read only access to Amazon Route 53 Recovery Readiness */
    AmazonRoute53RecoveryReadinessReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryReadinessReadOnlyAccess);
    }
    /** Full access policy for Route 53 Resolver */
    AmazonRoute53ResolverFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ResolverFullAccess);
    }
    /** Read only policy for Route 53 Resolver */
    AmazonRoute53ResolverReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ResolverReadOnlyAccess);
    }
    /** Provides full access to all buckets via the AWS Management Console. */
    AmazonS3FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3FullAccess);
    }
    /** Provides AWS Lambda functions permissions to interact with Amazon S3 Object Lambda. Also grants Lambda permissions to write to CloudWatch Logs. */
    AmazonS3ObjectLambdaExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3ObjectLambdaExecutionRolePolicy);
    }
    /** Provides full access to Amazon S3 on Outposts via the AWS Management Console. */
    AmazonS3OutpostsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3OutpostsFullAccess);
    }
    /** Provides read only access to Amazon S3 on Outposts via the AWS Management Console. */
    AmazonS3OutpostsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3OutpostsReadOnlyAccess);
    }
    /** Provides read only access to all buckets via the AWS Management Console. */
    AmazonS3ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3ReadOnlyAccess);
    }
    /** Provides full access to all S3 table buckets. */
    AmazonS3TablesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3TablesFullAccess);
    }
    /** This managed policy grants AWS Lake Formation permissions to act on all table buckets, namespaces, and tables within the account. */
    AmazonS3TablesLakeFormationServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3TablesLakeFormationServiceRole);
    }
    /** Provides read only access to all S3 table buckets. */
    AmazonS3TablesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3TablesReadOnlyAccess);
    }
    /** Service role policy used by the AWS Service Catalog service to provision products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CodePipeline, CodeBuild, CodeCommit, Glue, CloudFormation, etc,. */
    AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy);
    }
    /** Provides permissions for Amazon SageMaker Canvas to use AI services to support ready to use AI solutions. This policy will add more mutating permissions for services as Amazon SageMaker Canvas adds support. */
    AmazonSageMakerCanvasAIServicesAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasAIServicesAccess);
    }
    /** This policy grants permissions to use Amazon Bedrock in SageMaker Canvas by providing access to downstream services such as S3. */
    AmazonSageMakerCanvasBedrockAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasBedrockAccess);
    }
    /** Provides full access to Amazon SageMaker resources and operations for data preparation in Canvas. The policy also provides select access to related services (e.g., S3, IAM, KMS, RDS, CloudWatch Logs, Redshift, Athena, Glue, EventBridge, Secrets Manager). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    AmazonSageMakerCanvasDataPrepFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasDataPrepFullAccess);
    }
    /** Allows Amazon SageMaker Canvas to create, manage and view endpoint details for endpoints created through Canvas. Allows Amazon SageMaker Canvas to retrieve endpoint invocation metrics from CloudWatch. */
    AmazonSageMakerCanvasDirectDeployAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasDirectDeployAccess);
    }
    /** This policy grants permissions to Amazon EMR Serverless for services such as S3, used by Amazon SageMaker Canvas for large data processing. */
    AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy);
    }
    /** This policy grants permissions commonly needed to use SageMaker Canvas with Amazon Forecast. */
    AmazonSageMakerCanvasForecastAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasForecastAccess);
    }
    /** Provides full access to Amazon SageMaker Canvas resources and operations. The policy also provides select access to related services (e.g., S3, IAM, VPC, ECR, CloudWatch Logs, Redshift, Secrets Manager, and Forecast). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    AmazonSageMakerCanvasFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasFullAccess);
    }
    /** Provides permissions for Amazon SageMaker Canvas to use the SageMaker Data Science Assistant service. The Data Science Assistant currently uses both Amazon SageMaker and Amazon Q Developer to process user prompts. */
    AmazonSageMakerCanvasSMDataScienceAssistantAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasSMDataScienceAssistantAccess);
    }
    /** This policy grants permissions commonly needed to use Amazon SageMaker Cluster. */
    AmazonSageMakerClusterInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerClusterInstanceRolePolicy);
    }
    /** Managed policy for Service Linked Role for Amazon SageMaker Core Services */
    AmazonSageMakerCoreServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCoreServiceRolePolicy);
    }
    /** Provides permissions necessary for SageMaker Edge to create and manage a device fleet for the customer using the default cloud connection. */
    AmazonSageMakerEdgeDeviceFleetPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerEdgeDeviceFleetPolicy);
    }
    /** Provides permissions required to enable the offline store for an Amazon SageMaker FeatureStore feature group. */
    AmazonSageMakerFeatureStoreAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerFeatureStoreAccess);
    }
    /** Provides full access to Amazon SageMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, ECR, CloudWatch Logs). */
    AmazonSageMakerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerFullAccess);
    }
    /** This policy provide access to services that are commonly needed to use SageMaker geospatial. */
    AmazonSageMakerGeospatialExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerGeospatialExecutionRole);
    }
    /** This policy grants permissions that allow full access to Amazon SageMaker Geospatial through the AWS Management Console and SDK. */
    AmazonSageMakerGeospatialFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerGeospatialFullAccess);
    }
    /** Provides access to AWS services that are required to run SageMaker GroundTruth Labeling job */
    AmazonSageMakerGroundTruthExecution() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerGroundTruthExecution);
    }
    /** This policy grants permissions to Amazon SageMaker HyperPod to related AWS services such as Amazon EKS, Amazon CloudWatch etc. */
    AmazonSageMakerHyperPodServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerHyperPodServiceRolePolicy);
    }
    /** Provides access to create Amazon Augmented AI FlowDefinition resources against any Workteam. */
    AmazonSageMakerMechanicalTurkAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerMechanicalTurkAccess);
    }
    /** This AWS managed policy grants permissions needed to use all Amazon SageMaker Governance features. The policy also provides select access to related services (e.g., S3, KMS). */
    AmazonSageMakerModelGovernanceUseAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerModelGovernanceUseAccess);
    }
    /** This is a new managed policy for Model Registry in Sagemaker. This policy is a standalone policy that can be attached to the user role to access Model Registry related functionalities in Sagemaker. */
    AmazonSageMakerModelRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerModelRegistryFullAccess);
    }
    /** Managed policy for Service Linked Role for Amazon SageMaker Notebooks */
    AmazonSageMakerNotebooksServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerNotebooksServiceRolePolicy);
    }
    /** Enables Amazon SageMaker partner app users to access applications, list available applications, launch application web UIs, and connect via the application SDK. */
    AmazonSageMakerPartnerAppsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerAppsFullAccess);
    }
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Lambda and others. */
    AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy);
    }
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including Lambda, APIGateway and others. */
    AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy);
    }
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Secrets Manager and others. */
    AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy);
    }
    /** This Amazon Managed Policy grants permissions commonly needed for use with Callback steps and Lambda steps in SageMaker Model Building Pipelines. It is added to the AmazonSageMaker-ExecutionRole that can be created when setting up SageMaker Studio. It can also be attached to any other role that will be used for authoring or executing pipelines. */
    AmazonSageMakerPipelinesIntegrations() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPipelinesIntegrations);
    }
    /** This policy will be used By SageMaker Unified Studios to create VPC related resources for QuickSight */
    AmazonSageMakerQuickSightVPCPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerQuickSightVPCPolicy);
    }
    /** Provides read only access to Amazon SageMaker via the AWS Management Console and SDK. */
    AmazonSageMakerReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerReadOnly);
    }
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CloudWatch Logs and others. */
    AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy);
    }
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including SageMaker and others. */
    AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy);
    }
    /** Service role policy used by the AWS CodeBuild within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy);
    }
    /** Service role policy used by the AWS CodePipeline within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy);
    }
    /** Service role policy used by the AWS CloudWatch Events within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline and others. */
    AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy);
    }
    /** Service role policy used by the AWS Firehose within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Firehose and others. */
    AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy);
    }
    /** Service role policy used by the AWS Glue within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Glue, S3 and others. */
    AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy);
    }
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including ECR, S3 and others. */
    AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy);
    }
    /** This Amazon Managed Policy provides the necessary permissions to create and manage SageMaker Training Plans. It allows users to create Training Plans and Reserved Capacities, describe existing Training Plans, and perform search and listing operations. */
    AmazonSageMakerTrainingPlanCreateAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerTrainingPlanCreateAccess);
    }
    /** Provides full access to Amazon Security Lake and related services needed to administer Security Lake. */
    AmazonSecurityLakeAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSecurityLakeAdministrator);
    }
    /** Policy for Amazon SecurityLake meta store manager lambda which allows the access to cloudwatch, S3, Glue and SQS. */
    AmazonSecurityLakeMetastoreManager() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSecurityLakeMetastoreManager);
    }
    /** Amazon Security Lake creates IAM roles for third-party custom sources to write data to a data lake and for third-party subscribers to consume data from a data lake, and uses this policy when creating these roles to define the boundary of their permissions. */
    AmazonSecurityLakePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSecurityLakePermissionsBoundary);
    }
    /** Provides full access to Amazon SES via the AWS Management Console. */
    AmazonSESFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSESFullAccess);
    }
    /** Provides read only access to Amazon SES via the AWS Management Console. */
    AmazonSESReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSESReadOnlyAccess);
    }
    /** Allows SES to publish Amazon CloudWatch basic monitoring metrics on behalf of your SES resources */
    AmazonSESServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSESServiceRolePolicy);
    }
    /** Provides full access to Amazon SNS via the AWS Management Console. */
    AmazonSNSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSNSFullAccess);
    }
    /** Provides read only access to Amazon SNS via the AWS Management Console. */
    AmazonSNSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSNSReadOnlyAccess);
    }
    /** Default policy for Amazon SNS service role. */
    AmazonSNSRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSNSRole);
    }
    /** Provides full access to Amazon SQS via the AWS Management Console. */
    AmazonSQSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSQSFullAccess);
    }
    /** Provides read only access to Amazon SQS via the AWS Management Console. */
    AmazonSQSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSQSReadOnlyAccess);
    }
    /** Provides access to view automation executions and send approval decisions to automation waiting for approval */
    AmazonSSMAutomationApproverAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMAutomationApproverAccess);
    }
    /** Provides permissions for EC2 Automation service to execute activities defined within Automation documents */
    AmazonSSMAutomationRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMAutomationRole);
    }
    /** This policy allows SSM Agent to access Directory Service on behalf of the customer for domain-join the managed instance. */
    AmazonSSMDirectoryServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMDirectoryServiceAccess);
    }
    /** Provides full access to Amazon SSM. */
    AmazonSSMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMFullAccess);
    }
    /**  Service Role to be used for EC2 Maintenance Window */
    AmazonSSMMaintenanceWindowRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMMaintenanceWindowRole);
    }
    /** This policy enables AWS Systems Manager functionality on EC2 instances. */
    AmazonSSMManagedEC2InstanceDefaultPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMManagedEC2InstanceDefaultPolicy);
    }
    /** The policy for Amazon EC2 Role to enable AWS Systems Manager service core functionality. */
    AmazonSSMManagedInstanceCore() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMManagedInstanceCore);
    }
    /** Provide access to child instances for patch association operation. */
    AmazonSSMPatchAssociation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMPatchAssociation);
    }
    /** Provides read only access to Amazon SSM. */
    AmazonSSMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMReadOnlyAccess);
    }
    /** Provides access to AWS Resources managed or used by Amazon SSM */
    AmazonSSMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMServiceRolePolicy);
    }
    /** Access to all Amazon Textract APIs */
    AmazonTextractFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTextractFullAccess);
    }
    /** Allows Textract to call AWS services on your behalf. */
    AmazonTextractServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTextractServiceRole);
    }
    /** Provides full access to manage Amazon Timestream using the AWS Management Console. Note that this policy also grants permissions for certain KMS operations, and operations to manage your saved queries. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamConsoleFullAccess);
    }
    /** Provides full access to Amazon Timestream. Note that this policy also grants certain KMS operation access. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamFullAccess);
    }
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    AmazonTimestreamInfluxDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccess);
    }
    /** Provides administrative access to manage Amazon Timestream InfluxDB instances and parameter groups except marketplace operations. */
    AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess);
    }
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    AmazonTimestreamInfluxDBServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamInfluxDBServiceRolePolicy);
    }
    /** Provides read only access to Amazon Timestream. Policy also provides permission to cancel any running query. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamReadOnlyAccess);
    }
    /** Provides full access to Amazon Transcribe operations */
    AmazonTranscribeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTranscribeFullAccess);
    }
    /** Provides access to read only operation for Amazon Transcribe */
    AmazonTranscribeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTranscribeReadOnlyAccess);
    }
    /** Provides full access to Verified Permissions */
    AmazonVerifiedPermissionsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVerifiedPermissionsFullAccess);
    }
    /** Provides read-only access to the Verified Permissions service. */
    AmazonVerifiedPermissionsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVerifiedPermissionsReadOnlyAccess);
    }
    /** Provides access to create network interfaces and attach them to cross-account resources */
    AmazonVPCCrossAccountNetworkInterfaceOperations() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCCrossAccountNetworkInterfaceOperations);
    }
    /** Provides full access to Amazon VPC via the AWS Management Console. */
    AmazonVPCFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCFullAccess);
    }
    /** Provides permissions to describe AWS resources, run Network Access Analyzer, and create or delete tags on Network Insights Access Scope and Network Insights Access Scope Analysis. */
    AmazonVPCNetworkAccessAnalyzerFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCNetworkAccessAnalyzerFullAccessPolicy);
    }
    /** Provides permissions to describe AWS resources, run Reachability Analyzer, and create or delete tags on Network Insights Path and Network Insights Analysis. */
    AmazonVPCReachabilityAnalyzerFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCReachabilityAnalyzerFullAccessPolicy);
    }
    /** This policy is attached to the role IAMRoleForReachabilityAnalyzerCrossAccountResourceAccess. This role is deployed to the member accounts in an organization when the management account enables trusted access for Reachability Analyzer. It provides permissions to view resources from across your organization using the Reachability Analyzer console. */
    AmazonVPCReachabilityAnalyzerPathComponentReadPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCReachabilityAnalyzerPathComponentReadPolicy);
    }
    /** Provides read only access to Amazon VPC via the AWS Management Console. */
    AmazonVPCReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCReadOnlyAccess);
    }
    /** Provides full access to Amazon WorkDocs via the AWS Management Console */
    AmazonWorkDocsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkDocsFullAccess);
    }
    /** Provides read only access to Amazon WorkDocs via the AWS Management Console */
    AmazonWorkDocsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkDocsReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkMail Events */
    AmazonWorkMailEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailEventsServiceRolePolicy);
    }
    /** Provides full access to WorkMail, Directory Service, SES, EC2 and read access to KMS metadata. */
    AmazonWorkMailFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailFullAccess);
    }
    /** Full access to the WorkMail Message Flow APIs */
    AmazonWorkMailMessageFlowFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailMessageFlowFullAccess);
    }
    /** Read only access to WorkMail messages for the GetRawMessageContent API */
    AmazonWorkMailMessageFlowReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailMessageFlowReadOnlyAccess);
    }
    /** Provides read only access to WorkMail and SES. */
    AmazonWorkMailReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailReadOnlyAccess);
    }
    /** Provides access to Amazon WorkSpaces administrative actions via AWS SDK and CLI. */
    AmazonWorkSpacesAdmin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesAdmin);
    }
    /** Provides administrator access for packaging an application in Amazon WorkSpaces Application Manager. */
    AmazonWorkSpacesApplicationManagerAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesApplicationManagerAdminAccess);
    }
    /** This managed policy provides full administrative access to AWS Certificate Manager Private CA resources in your AWS account for certificate-based authentication. */
    AmazonWorkspacesPCAAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkspacesPCAAccess);
    }
    /** This policy provides AWS WorkSpaces service access to required customer account resources for launching Workspaces Pools */
    AmazonWorkSpacesPoolServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesPoolServiceAccess);
    }
    /** Provides read-only access to Amazon WorkSpaces Secure Browser and its dependencies through the AWS Management Console, SDK, and CLI. */
    AmazonWorkSpacesSecureBrowserReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesSecureBrowserReadOnly);
    }
    /** Provides access to Amazon WorkSpaces backend service to perform Workspace Self Service actions */
    AmazonWorkSpacesSelfServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesSelfServiceAccess);
    }
    /** Provides customer account access to AWS WorkSpaces service for launching a Workspace. */
    AmazonWorkSpacesServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesServiceAccess);
    }
    /** Provides full access to Amazon WorkSpaces Thin Client as well as limited access to required related services */
    AmazonWorkSpacesThinClientFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesThinClientFullAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Thin Client Monitoring */
    AmazonWorkSpacesThinClientMonitoringServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesThinClientMonitoringServiceRolePolicy);
    }
    /** Provides read-only access to Amazon WorkSpaces Thin Client and its dependencies */
    AmazonWorkSpacesThinClientReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesThinClientReadOnlyAccess);
    }
    /** Provides read-only access to Amazon WorkSpaces Web and its dependencies through the AWS Management Console, SDK, and CLI. */
    AmazonWorkSpacesWebReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesWebReadOnly);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Web */
    AmazonWorkSpacesWebServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesWebServiceRolePolicy);
    }
    /** Provides full access to Amazon Zocalo. */
    AmazonZocaloFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonZocaloFullAccess);
    }
    /** Provides read only access to Amazon Zocalo */
    AmazonZocaloReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonZocaloReadOnlyAccess);
    }
    /** Provides Amplify full access permissions to deploy Amplify backend resources (AWS AppSync, Amazon Cognito, Amazon S3 and other related services) via the AWS Cloud Development Kit (AWS CDK) */
    AmplifyBackendDeployFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmplifyBackendDeployFullAccess);
    }
    /** Allows API Gateway to manage associated AWS Resources on behalf of the customer. */
    APIGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.APIGatewayServiceRolePolicy);
    }
    /** Allows AppIntegrations to manage AppFlow resources and publish CloudWatch metric data on your behalf. */
    AppIntegrationsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppIntegrationsServiceLinkedRolePolicy);
    }
    /** Policy to enable Application Autoscaling for Amazon AppStream */
    ApplicationAutoScalingForAmazonAppStreamAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ApplicationAutoScalingForAmazonAppStreamAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Application Discovery Service Continuous Export feature */
    ApplicationDiscoveryServiceContinuousExportServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ApplicationDiscoveryServiceContinuousExportServiceRolePolicy);
    }
    /** Allows AWS AppRunner Networking to manage related AWS resources on your behalf. */
    AppRunnerNetworkingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppRunnerNetworkingServiceRolePolicy);
    }
    /** Allows AWS AppRunner to manage related AWS resources on your behalf. */
    AppRunnerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppRunnerServiceRolePolicy);
    }
    /** Allows AppStudio to manage associated AWS resources on your behalf. */
    AppStudioServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppStudioServiceRolePolicy);
    }
    /** Policy for Amazon Aurora DSQL Service Linked Role */
    AuroraDsqlServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AuroraDsqlServiceLinkedRolePolicy);
    }
    /** Provides full access to Auto Scaling via the AWS Management Console. */
    AutoScalingConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingConsoleFullAccess);
    }
    /** Provides read-only access to Auto Scaling via the AWS Management Console. */
    AutoScalingConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingConsoleReadOnlyAccess);
    }
    /** Provides full access to Auto Scaling. */
    AutoScalingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingFullAccess);
    }
    /** Default policy for the AutoScaling Notification Access service role. */
    AutoScalingNotificationAccessRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingNotificationAccessRole);
    }
    /** Provides read-only access to Auto Scaling. */
    AutoScalingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Auto Scaling */
    AutoScalingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingServiceRolePolicy);
    }
    /** Default policy for AWS Config service role. Provides permissions required for AWS Config to track changes to your AWS resources. */
    AWSConfigRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRole);
    }
    /** Provides permissions to access the SSM Diagnosis S3 bucket for diagnosis and remediation of issues. */
    AWSSSMAutomationDiagnosisBucketPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMAutomationDiagnosisBucketPolicy);
    }
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    AWSSSMDiagnosisAutomationAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMDiagnosisAutomationAdministrationRolePolicy);
    }
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by diagnosing SSM service health across all nodes. */
    AWSSSMDiagnosisAutomationExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMDiagnosisAutomationExecutionRolePolicy);
    }
    /** Provides permissions for operational accounts to diagnose unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy);
    }
    /** Provide permission for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    AWSSSMRemediationAutomationAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMRemediationAutomationAdministrationRolePolicy);
    }
    /** Provides permissions for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by remediating SSM services health across all nodes. */
    AWSSSMRemediationAutomationExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMRemediationAutomationExecutionRolePolicy);
    }
    /** Provides permissions for operational accounts to Remediate unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy);
    }
    /** Allows users to access the Account Activity page. */
    AWSAccountActivityAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountActivityAccess);
    }
    /** Provides full access to AWS Account Management. */
    AWSAccountManagementFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountManagementFullAccess);
    }
    /** Provides read-only access to AWS Account Management */
    AWSAccountManagementReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountManagementReadOnlyAccess);
    }
    /** Allows users to access the Account Usage Report page. */
    AWSAccountUsageReportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountUsageReportAccess);
    }
    /** Provides access for the Discovery Agentless Connector to register with AWS Application Discovery Service. */
    AWSAgentlessDiscoveryService() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAgentlessDiscoveryService);
    }
    /** Provides full access to the AWS AppFabric service and read only access to dependent services such as S3, Kinesis, KMS. */
    AWSAppFabricFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppFabricFullAccess);
    }
    /** Provides read only access to the AWS AppFabric */
    AWSAppFabricReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppFabricReadOnlyAccess);
    }
    /** Provides AppFabric access to AWS resources on your behalf */
    AWSAppFabricServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppFabricServiceRolePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access AppStream and CloudWatch. */
    AWSApplicationAutoscalingAppStreamFleetPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingAppStreamFleetPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Cassandra and CloudWatch. */
    AWSApplicationAutoscalingCassandraTablePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingCassandraTablePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Comprehend and CloudWatch. */
    AWSApplicationAutoscalingComprehendEndpointPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingComprehendEndpointPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access APIGateway and CloudWatch for custom resource scaling */
    AWSApplicationAutoScalingCustomResourcePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoScalingCustomResourcePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access DynamoDB and CloudWatch. */
    AWSApplicationAutoscalingDynamoDBTablePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingDynamoDBTablePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access EC2 Spot Fleet and CloudWatch. */
    AWSApplicationAutoscalingEC2SpotFleetRequestPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingEC2SpotFleetRequestPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access EC2 Container Service and CloudWatch. */
    AWSApplicationAutoscalingECSServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingECSServicePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Amazon ElastiCache and Amazon CloudWatch. */
    AWSApplicationAutoscalingElastiCacheRGPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingElastiCacheRGPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Elastic Map Reduce and CloudWatch. */
    AWSApplicationAutoscalingEMRInstanceGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingEMRInstanceGroupPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Managed Streaming for Apache Kafka and CloudWatch. */
    AWSApplicationAutoscalingKafkaClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingKafkaClusterPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Lambda and CloudWatch. */
    AWSApplicationAutoscalingLambdaConcurrencyPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingLambdaConcurrencyPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Amazon Neptune and Amazon CloudWatch. */
    AWSApplicationAutoscalingNeptuneClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingNeptuneClusterPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access RDS and CloudWatch. */
    AWSApplicationAutoscalingRDSClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingRDSClusterPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access SageMaker and CloudWatch. */
    AWSApplicationAutoscalingSageMakerEndpointPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingSageMakerEndpointPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Amazon WorkSpaces and Amazon CloudWatch. */
    AWSApplicationAutoscalingWorkSpacesPoolPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingWorkSpacesPoolPolicy);
    }
    /** Provides access for the Discovery Agent to register with AWS Application Discovery Service. */
    AWSApplicationDiscoveryAgentAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationDiscoveryAgentAccess);
    }
    /** Allows Application Discovery Service Agentless Collectors to auto update, register, and communicate with Application Discovery Service */
    AWSApplicationDiscoveryAgentlessCollectorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationDiscoveryAgentlessCollectorAccess);
    }
    /** Provides full access to view and tag Configuration Items maintained by the AWS Application Discovery Service */
    AWSApplicationDiscoveryServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationDiscoveryServiceFullAccess);
    }
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    AWSApplicationMigrationAgentInstallationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationAgentInstallationPolicy);
    }
    /** This policy allows installing and using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    AWSApplicationMigrationAgentPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationAgentPolicy);
    }
    /** This policy allows using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationAgentPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationAgentPolicyV2);
    }
    /** This policy allows the Application Migration Service (MGN) Conversion Server, which are EC2 instances launched by Application Migration Service, to communicate with the MGN service. An IAM role with this policy is attached (as an EC2 Instance Profile) by MGN to the MGN Conversion Servers, which are automatically launched and terminated by MGN, when needed. We do not recommend that you attach this policy to your IAM users or roles. MGN Conversion Servers are used by Application Migration Service when users choose to launch Test or Cutover instances using the MGN console, CLI, or API. */
    AWSApplicationMigrationConversionServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationConversionServerPolicy);
    }
    /** This policy provides Amazon EC2 operations required to use Application Migration Service (MGN) to launch the migrated servers as EC2 instances. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationEC2Access() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationEC2Access);
    }
    /** This policy provides permissions to all public APIs of AWS Application Migration Service (MGN), as well as permissions to read KMS key information. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationFullAccess);
    }
    /** This policy allows AWS Application Migration Service (MGN) to send meta-data about the progress of servers being migrated using MGN to AWS Migration Hub (MGH). MGN automatically creates an IAM role with this policy attached, and assumes this role. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationMGHAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationMGHAccess);
    }
    /** This policy provides permissions to all read-only public APIs of Application Migration Service (MGN), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the MGN console. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationReadOnlyAccess);
    }
    /** This policy allows the Application Migration Service (MGN) Replication Servers, which are EC2 instances launched by Application Migration Service - to communicate with the MGN service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Application Migration Service to the MGN Replication Servers which are automatically launched and terminated by MGN, as needed. MGN Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the migration process managed using MGN. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationReplicationServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationReplicationServerPolicy);
    }
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Application Migration Service (AWS MGN) to migrate source servers that run on EC2 (cross-Region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    AWSApplicationMigrationServiceEc2InstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationServiceEc2InstancePolicy);
    }
    /** Allows AWS application Migration Service to create and manage AWS resources on your behalf. */
    AWSApplicationMigrationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationServiceRolePolicy);
    }
    /** This policy provides access to Amazon SSM operations required to use Application Migration Service (MGN) to execute custom post migration command SSM documents. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationSSMAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationSSMAccess);
    }
    /** This policy allows installing and using the AWS VCenter Client, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS VCenter Client. */
    AWSApplicationMigrationVCenterClientPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationVCenterClientPolicy);
    }
    /** App Mesh Envoy policy for accessing Virtual Node configuration. */
    AWSAppMeshEnvoyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshEnvoyAccess);
    }
    /** Provides full access to the AWS App Mesh APIs and Management Console. */
    AWSAppMeshFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshFullAccess);
    }
    /** App Mesh Preview Envoy policy for accessing Virtual Node configuration. */
    AWSAppMeshPreviewEnvoyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshPreviewEnvoyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS App Mesh */
    AWSAppMeshPreviewServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshPreviewServiceRolePolicy);
    }
    /** Provides read-only access to the AWS App Mesh APIs and Management Console. */
    AWSAppMeshReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshReadOnly);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS AppMesh */
    AWSAppMeshServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshServiceRolePolicy);
    }
    /** Grants permissions to all App Runner actions. */
    AWSAppRunnerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppRunnerFullAccess);
    }
    /** Grants permissions to list and view details about App Runner resources. */
    AWSAppRunnerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppRunnerReadOnlyAccess);
    }
    /** AWS App Runner service policy that grants read permissions to Amazon ECR resources in the customer's account. Use it in a role that is passed to App Runner when creating or updating an App Runner service. */
    AWSAppRunnerServicePolicyForECRAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppRunnerServicePolicyForECRAccess);
    }
    /** Provides administrative access to the AppSync service, though not enough to access via the console. */
    AWSAppSyncAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncAdministrator);
    }
    /** Provides full invoking access to the AppSync service - both through the console and independently */
    AWSAppSyncInvokeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncInvokeFullAccess);
    }
    /** Allows AppSync to push logs to user's CloudWatch account. */
    AWSAppSyncPushToCloudWatchLogs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncPushToCloudWatchLogs);
    }
    /** Provides access to create, update, and query the schema. */
    AWSAppSyncSchemaAuthor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncSchemaAuthor);
    }
    /** Enables access to AWS services and resources used or managed by AppSync */
    AWSAppSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncServiceRolePolicy);
    }
    /** Allows AWS Artifact read-only access to operations in AWS Organizations. */
    AWSArtifactAccountSync() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactAccountSync);
    }
    /** This policy grants full permissions to list, download, accept, and terminate AWS Artifact agreements. It also includes permissions to list and enable AWS service access in the Organization service, as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists and creates one if it doesn't */
    AWSArtifactAgreementsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactAgreementsFullAccess);
    }
    /** This policy grants read-only access to list the AWS Artifact service agreements and to download the accepted agreements.. It also includes permissions to list as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists. */
    AWSArtifactAgreementsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactAgreementsReadOnlyAccess);
    }
    /** Provides read-only access to the AWS Artifact service reports. */
    AWSArtifactReportsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactReportsReadOnlyAccess);
    }
    /** Allows AWS Artifact to gather information about an organization via AWS Organizations service. */
    AWSArtifactServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactServiceRolePolicy);
    }
    /** Provides administrative access to enable or disable AWS Audit Manager, update settings, and manage assessments, controls, and frameworks */
    AWSAuditManagerAdministratorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAuditManagerAdministratorAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS Audit Manager */
    AWSAuditManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAuditManagerServiceRolePolicy);
    }
    /** Policy granting permissions to AWS Auto Scaling to periodically forecast capacity and generate scheduled scaling actions for Auto Scaling groups in a scaling plan */
    AWSAutoScalingPlansEC2AutoScalingPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAutoScalingPlansEC2AutoScalingPolicy);
    }
    /** This policy grants permissions for users to create controls and frameworks that define their expectations for AWS Backup resources and activities, and to audit AWS Backup resources and activities against their defined controls and frameworks. This policy grants permissions to AWS Config and similar services to describe user expectations perform the audits. This policy also grants permissions to deliver audit reports to S3 and similar services, and enables users to find and open their audit reports. */
    AWSBackupAuditAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupAuditAccess);
    }
    /** This policy allows the AWS Backint agent to complete backup data transfer with AWS Backup Storage plane. Attach this policy to roles assumed by EC2 Instances running SAP HANA with the Backint agent. */
    AWSBackupDataTransferAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupDataTransferAccess);
    }
    /** This policy is for backup administrators, granting full access to AWS Backup operations, including creating or editing backup plans, assigning AWS resources to backup plans, deleting backups, and restoring backups. */
    AWSBackupFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupFullAccess);
    }
    /** Provides AWS BackupGateway permission to sync the metadata of Virtual Machines on your behalf */
    AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync);
    }
    /** This policy grants users permissions to assign AWS resources to backup plans, create on-demand backups, and restore backups. This policy does not allow the user to create or edit backup plans or to delete scheduled backups after they are created. */
    AWSBackupOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupOperatorAccess);
    }
    /** This policy is for backup administators who use cross-account backup management to manage backups for the organization. */
    AWSBackupOrganizationAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupOrganizationAdminAccess);
    }
    /** Provides AWS Backup permission to restore a backup of SAP HANA on Amazon EC2 */
    AWSBackupRestoreAccessForSAPHANA() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupRestoreAccessForSAPHANA);
    }
    /** The search operator role has access to create backup indexes, create searches of backup metadata that has been indexed. This policy contains the necessary permissions for these search operator functions. */
    AWSBackupSearchOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupSearchOperatorAccess);
    }
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceLinkedRolePolicyForBackup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackup);
    }
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceLinkedRolePolicyForBackupTest() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackupTest);
    }
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceRolePolicyForBackup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForBackup);
    }
    /** Policy containing permissions necessary for AWS Backup to index recovery points. */
    AWSBackupServiceRolePolicyForIndexing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForIndexing);
    }
    /** Policy containing permissions necessary for AWS Backup to restore individual items in a recovery point */
    AWSBackupServiceRolePolicyForItemRestores() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForItemRestores);
    }
    /** Provides AWS Backup permission to perform restores on your behalf across AWS services. This policy includes permissions to create and delete AWS resources, such as EBS volumes, RDS instances, and EFS file systems, which are part of the restore process. */
    AWSBackupServiceRolePolicyForRestores() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForRestores);
    }
    /** Policy containing permissions necessary for AWS Backup to backup data in any S3 bucket. This includes read access to all S3 objects and any decrypt access for all KMS keys. */
    AWSBackupServiceRolePolicyForS3Backup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Backup);
    }
    /** Policy containing permissions necessary for AWS Backup to restore a S3 backup to a bucket. This includes read/write permissions to all S3 buckets, and permissions to GenerateDataKey and DescribeKey for all KMS keys. */
    AWSBackupServiceRolePolicyForS3Restore() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Restore);
    }
    /** Provides full access for AWS Batch resources. */
    AWSBatchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchFullAccess);
    }
    /** Policy to enable CloudWatch Event Target for AWS Batch Job Submission */
    AWSBatchServiceEventTargetRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchServiceEventTargetRole);
    }
    /** Policy for AWS Batch service role which allows access to related services including EC2, Autoscaling, EC2 Container service and Cloudwatch Logs. */
    AWSBatchServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchServiceRole);
    }
    /** A service linked role to provide Billing and Cost Management Data Exports access to AWS service data for exporting the data to a target location, such as Amazon S3, on behalf of a customer. */
    AWSBCMDataExportsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBCMDataExportsServiceRolePolicy);
    }
    /** Use the AWSBillingConductorFullAccess managed policy to allow complete access to AWS Billing Conductor (ABC) console and APIs. This policy allows users to list, create and delete ABC resources. */
    AWSBillingConductorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingConductorFullAccess);
    }
    /** Use the AWSBillingConductorReadOnlyAccess managed policy to allow read only access to AWS Billing Conductor (ABC) console and APIs. This policy grants permission to view and list all ABC resources. It does not include the ability to create or delete resources. */
    AWSBillingConductorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingConductorReadOnlyAccess);
    }
    /** Allows users to view bills on the Billing Console. */
    AWSBillingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingReadOnlyAccess);
    }
    /** This policy gives permissions to control AWS resources. For example, to start and stop EC2 or RDS instances by executing AWS Systems Manager (SSM) scripts. */
    AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM);
    }
    /** Provides full access to AWS Budgets Actions including using Budgets Actions to control states of running AWS resources via AWS Management Console */
    AWSBudgetsActionsWithAWSResourceControlAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBudgetsActionsWithAWSResourceControlAccess);
    }
    /** Provides read only access to AWS Budgets Console via the AWS Management Console. */
    AWSBudgetsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBudgetsReadOnlyAccess);
    }
    /** This IAM policy grants users full access to the AWS BugBust console */
    AWSBugBustFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBugBustFullAccess);
    }
    /** This IAM policy grants users access to participate in AWS BugBust events */
    AWSBugBustPlayerAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBugBustPlayerAccess);
    }
    /** Grants permissions to AWS BugBust to access resources on your behalf */
    AWSBugBustServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBugBustServiceRolePolicy);
    }
    /** Provides full access to AWS Certificate Manager (ACM) */
    AWSCertificateManagerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerFullAccess);
    }
    /** Provides auditor access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAAuditor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAAuditor);
    }
    /** Provides full access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAFullAccess);
    }
    /** Provides privileged certificate user access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAPrivilegedUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAPrivilegedUser);
    }
    /** Provides read only access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAReadOnly);
    }
    /** Provides certificate user access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAUser);
    }
    /** Provides read only access to AWS Certificate Manager (ACM). */
    AWSCertificateManagerReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerReadOnly);
    }
    /** The Service Linked Role used by AWS Chatbot. */
    AWSChatbotServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSChatbotServiceLinkedRolePolicy);
    }
    /** Allows full access to AWS Clean Rooms resources and access to related AWS Services. */
    AWSCleanRoomsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsFullAccess);
    }
    /** Allows full access to AWS Clean Rooms resources except for querying in a collaboration and access to related AWS Services. */
    AWSCleanRoomsFullAccessNoQuerying() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsFullAccessNoQuerying);
    }
    /** Allows full access to AWS Clean Rooms ML resources and access to related AWS Services. */
    AWSCleanRoomsMLFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsMLFullAccess);
    }
    /** Allows read-only access to AWS Clean Rooms ML resources and read-only access to related AWS Clean Rooms resources */
    AWSCleanRoomsMLReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsMLReadOnlyAccess);
    }
    /** Allows read-only access to AWS Clean Rooms resources and read-only access to related AWS Glue and Amazon CloudWatch Logs resources. */
    AWSCleanRoomsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsReadOnlyAccess);
    }
    /** Provides administrator access to AWS Cloud9. */
    AWSCloud9Administrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9Administrator);
    }
    /** Provides the ability to be invited into AWS Cloud9 shared development environments. */
    AWSCloud9EnvironmentMember() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9EnvironmentMember);
    }
    /** Service Linked Role Policy for AWS Cloud9 */
    AWSCloud9ServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9ServiceRolePolicy);
    }
    /** This policy will be used to attach a role on a InstanceProfile which will allow Cloud9 to use the SSM Session Manager to connect to the instance */
    AWSCloud9SSMInstanceProfile() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9SSMInstanceProfile);
    }
    /** Provides permission to create AWS Cloud9 development environments and to manage owned environments. */
    AWSCloud9User() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9User);
    }
    /** Provides full access to AWS CloudFormation. */
    AWSCloudFormationFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFormationFullAccess);
    }
    /** Provides access to AWS CloudFormation via the AWS Management Console. */
    AWSCloudFormationReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFormationReadOnlyAccess);
    }
    /** Grants CloudFront Logger write permissions to CloudWatch Logs. */
    AWSCloudFrontLogger() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFrontLogger);
    }
    /** Allows CloudFront to manage EC2 Elastic Network Interfaces and Security Groups on your behalf. */
    AWSCloudFrontVPCOriginServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFrontVPCOriginServiceRolePolicy);
    }
    /** Provides full access to all CloudHSM resources. */
    AWSCloudHSMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudHSMFullAccess);
    }
    /** Provides read only access to all CloudHSM resources. */
    AWSCloudHSMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudHSMReadOnlyAccess);
    }
    /** Default policy for the AWS CloudHSM service role. */
    AWSCloudHSMRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudHSMRole);
    }
    /** Provides access to AWS Cloud Map discovery API. */
    AWSCloudMapDiscoverInstanceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapDiscoverInstanceAccess);
    }
    /** Provides full access to all AWS Cloud Map actions. */
    AWSCloudMapFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapFullAccess);
    }
    /** Provides read-only access to all AWS Cloud Map actions. */
    AWSCloudMapReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapReadOnlyAccess);
    }
    /** Provides registrant level access to AWS Cloud Map actions. */
    AWSCloudMapRegisterInstanceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapRegisterInstanceAccess);
    }
    /** Grants using AWS CloudShell with all features */
    AWSCloudShellFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudShellFullAccess);
    }
    /** Provides full access to AWS CloudTrail. */
    AWSCloudTrailFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudTrailFullAccess);
    }
    /** Provides read only access to AWS CloudTrail. */
    AWSCloudTrailReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudTrailReadOnlyAccess);
    }
    /** This policy is used by the service-linked role named AWSServiceRoleForCloudWatchAlarms_ActionSSMIncidents. CloudWatch uses this service-linked role to perform AWS System Manager Incident Manager actions when a CloudWatch alarm goes in to ALARM state. This policy grants permission to start incidents on your behalf. */
    AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy);
    }
    /** Provides full access to AWS CodeArtifact via the AWS Management Console. */
    AWSCodeArtifactAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeArtifactAdminAccess);
    }
    /** Provides read only access to AWS CodeArtifact via the AWS Management Console. */
    AWSCodeArtifactReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeArtifactReadOnlyAccess);
    }
    /** Provides full access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts, and attach IAMFullAccess to create and manage the service role for CodeBuild. */
    AWSCodeBuildAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeBuildAdminAccess);
    }
    /** Provides access to AWS CodeBuild via the AWS Management Console, but does not allow CodeBuild project administration. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    AWSCodeBuildDeveloperAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeBuildDeveloperAccess);
    }
    /** Provides read only access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    AWSCodeBuildReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeBuildReadOnlyAccess);
    }
    /** Provides full access to AWS CodeCommit via the AWS Management Console. */
    AWSCodeCommitFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeCommitFullAccess);
    }
    /** Provides full access to AWS CodeCommit repositories, but does not allow repository deletion. */
    AWSCodeCommitPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeCommitPowerUser);
    }
    /** Provides read only access to AWS CodeCommit via the AWS Management Console. */
    AWSCodeCommitReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeCommitReadOnly);
    }
    /** Provides access to register and deploy a revision. */
    AWSCodeDeployDeployerAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployDeployerAccess);
    }
    /** Provides full access to CodeDeploy resources. */
    AWSCodeDeployFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployFullAccess);
    }
    /** Provides read only access to CodeDeploy resources. */
    AWSCodeDeployReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployReadOnlyAccess);
    }
    /** Provides CodeDeploy service access to expand tags and interact with Auto Scaling on your behalf. */
    AWSCodeDeployRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRole);
    }
    /** Provides CodeDeploy service access to invoke Lambda function on your behalf to perform blue/green deployment through CloudFormation. */
    AWSCodeDeployRoleForCloudFormation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForCloudFormation);
    }
    /** Provides CodeDeploy service wide access to perform an ECS blue/green deployment on your behalf. Grants full access to support services, such as  full access to read all S3 objects, invoke all Lambda functions, publish to all SNS topics within the account and update all ECS services. */
    AWSCodeDeployRoleForECS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForECS);
    }
    /**  Provides CodeDeploy service limited access to perform an ECS blue/green deployment on your behalf. */
    AWSCodeDeployRoleForECSLimited() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForECSLimited);
    }
    /** Provides CodeDeploy service access to perform a Lambda deployment on your behalf. */
    AWSCodeDeployRoleForLambda() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForLambda);
    }
    /** Provides CodeDeploy service limited access to perform a Lambda deployment on your behalf. */
    AWSCodeDeployRoleForLambdaLimited() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForLambdaLimited);
    }
    /** Provides full access to AWS CodePipeline via the AWS Management Console. */
    AWSCodePipelineFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineFullAccess);
    }
    /** Provides read only access to AWS CodePipeline via the AWS Management Console. */
    AWSCodePipelineReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineReadOnlyAccess);
    }
    /** Provides access to view and approve manual changes for all pipelines */
    AWSCodePipelineApproverAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineApproverAccess);
    }
    /** Provides access for custom actions to poll for jobs details (including temporary credentials) and report status updates to AWS CodePipeline. */
    AWSCodePipelineCustomActionAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineCustomActionAccess);
    }
    /** Provides full access to AWS CodeStar via the AWS Management Console. */
    AWSCodeStarFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeStarFullAccess);
    }
    /** Allows AWS CodeStar Notifications to access Amazon CloudWatch Events on your behalf */
    AWSCodeStarNotificationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeStarNotificationsServiceRolePolicy);
    }
    /** DO NOT USE -  AWS CodeStar Service Role Policy which grants administrative privileges in order for CodeStar to manage IAM and other service resources on behalf of the customer. */
    AWSCodeStarServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeStarServiceRole);
    }
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly.  Do NOT remove this policy.  Instead, please follow the instructions specified in the email sent to you regarding this event. */
    AWSCompromisedKeyQuarantine() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCompromisedKeyQuarantine);
    }
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    AWSCompromisedKeyQuarantineV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCompromisedKeyQuarantineV2);
    }
    /** Denies access to certain actions, applied by AWS in the event that an IAM user's credentials have been compromised or exposed publicly. The policy aims to limit the potential damage that may be caused by fraud-related activity leading to unauthorized charges, while not impacting the existing resources. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    AWSCompromisedKeyQuarantineV3() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCompromisedKeyQuarantineV3);
    }
    /** Allows Config to call AWS services and deploy config resources across organization */
    AWSConfigMultiAccountSetupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigMultiAccountSetupPolicy);
    }
    /** Allows AWS Config to remediate noncompliant resources on your behalf. */
    AWSConfigRemediationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRemediationServiceRolePolicy);
    }
    /** Allows AWS Config to call read-only AWS Organizations APIs */
    AWSConfigRoleForOrganizations() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRoleForOrganizations);
    }
    /** Allows an AWS Lambda function to access the AWS Config API and the configuration snapshots that AWS Config delivers periodically to Amazon S3. This access is required by functions that evaluate configuration changes for custom Config rules. */
    AWSConfigRulesExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRulesExecutionRole);
    }
    /** Allows Config to call AWS services and collect resource configurations on your behalf. */
    AWSConfigServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigServiceRolePolicy);
    }
    /** Provides access to use AWS Config, including searching by tags on resources, and reading all tags. This does not provide permission to configure AWS Config, which requires administrative privileges. */
    AWSConfigUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigUserAccess);
    }
    /** Enables broad read/write access to ALL EC2 objects, read/write access to S3 buckets starting with 'import-to-ec2-', and the ability to list all S3 buckets, for the AWS Connector to import VMs on your behalf. */
    AWSConnector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConnector);
    }
    /** Allows AWS Control Tower to call AWS services that provide automated account configuration and centralized governance on your behalf. */
    AWSControlTowerAccountServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSControlTowerAccountServiceRolePolicy);
    }
    /** Provides access to AWS Resources managed or used by AWS Control Tower */
    AWSControlTowerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSControlTowerServiceRolePolicy);
    }
    /** Grants permissions to to describe the organization of the account, create S3 buckets for the MAP program and apply tags to it, create a Cost and Usage Report, and describe Cost and Usage Report definitions. */
    AWSCostAndUsageReportAutomationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCostAndUsageReportAutomationPolicy);
    }
    /** Gives Data Grant owners access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    AWSDataExchangeDataGrantOwnerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeDataGrantOwnerFullAccess);
    }
    /** Gives Data Grant receiver access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    AWSDataExchangeDataGrantReceiverFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeDataGrantReceiverFullAccess);
    }
    /** Grants full access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeFullAccess);
    }
    /** Grants data provider access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeProviderFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeProviderFullAccess);
    }
    /** Grants read-only access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. */
    AWSDataExchangeReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeReadOnly);
    }
    /** Allows AWS Data Exchange to access AWS Services and Resources used or managed by AWS Data Exchange for license management. */
    AWSDataExchangeServiceRolePolicyForLicenseManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForLicenseManagement);
    }
    /** Allows AWS Data Exchange to read data about your AWS Organization to determine eligibility for AWS Data Exchange data grants license distribution. */
    AWSDataExchangeServiceRolePolicyForOrganizationDiscovery() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForOrganizationDiscovery);
    }
    /** Grants data subscriber access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeSubscriberFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeSubscriberFullAccess);
    }
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources */
    AWSDataLifecycleManagerServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataLifecycleManagerServiceRole);
    }
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources for AMI Management */
    AWSDataLifecycleManagerServiceRoleForAMIManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataLifecycleManagerServiceRoleForAMIManagement);
    }
    /** Provides Amazon Data Lifecycle Manager permission to perform the Systems Manager actions required to run pre and post scripts on all Amazon EC2 instances. */
    AWSDataLifecycleManagerSSMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataLifecycleManagerSSMFullAccess);
    }
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    AWSDataPipelineFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataPipelineFullAccess);
    }
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    AWSDataPipelinePowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataPipelinePowerUser);
    }
    /** Allows DataSync Discovery to integrate with other AWS services on your behalf. */
    AWSDataSyncDiscoveryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncDiscoveryServiceRolePolicy);
    }
    /** Provides full access to AWS DataSync and minimal access to its dependencies */
    AWSDataSyncFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncFullAccess);
    }
    /** Provides read-only access to AWS DataSync */
    AWSDataSyncReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncReadOnlyAccess);
    }
    /** Allows DataSync to integrate with other AWS services on your behalf */
    AWSDataSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncServiceRolePolicy);
    }
    /** Provides AWS Deadline Cloud workers with access to run tasks on a farm. */
    AWSDeadlineCloudFleetWorker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudFleetWorker);
    }
    /** Provides user workstation access to AWS Deadline Cloud farms with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessFarms() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessFarms);
    }
    /** Provides user workstation access to AWS Deadline Cloud fleets with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessFleets() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessFleets);
    }
    /** Provides user workstation access to AWS Deadline Cloud jobs with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessJobs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessJobs);
    }
    /** Provides user workstation access to AWS Deadline Cloud queues with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessQueues() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessQueues);
    }
    /** Provides access for AWS Deadline Cloud worker hosts to join a fleet in a farm. */
    AWSDeadlineCloudWorkerHost() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudWorkerHost);
    }
    /** This policy specifies permissions required by DeepLens Administrative lambda functions that run on a DeepLens device */
    AWSDeepLensLambdaFunctionAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepLensLambdaFunctionAccessPolicy);
    }
    /** Grants AWS DeepLens access to AWS Services, resources and roles needed by DeepLens and its dependencies including IoT, S3, GreenGrass and AWS Lambda. */
    AWSDeepLensServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepLensServiceRolePolicy);
    }
    /** DeepRacer admin access to all actions including toggling between multiuser and single user mode. */
    AWSDeepRacerAccountAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerAccountAdminAccess);
    }
    /** Allows CloudFormation to create and manage AWS stacks and resources on your behalf. */
    AWSDeepRacerCloudFormationAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerCloudFormationAccessPolicy);
    }
    /** DeepRacer MultiUser Default user access to use deepracer in multi-user mode */
    AWSDeepRacerDefaultMultiUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerDefaultMultiUserAccess);
    }
    /** Provides full access to AWS DeepRacer. Also provides select access to related services (e.g., S3). */
    AWSDeepRacerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerFullAccess);
    }
    /** Allows RoboMaker to create required resources and call AWS services on your behalf. */
    AWSDeepRacerRoboMakerAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerRoboMakerAccessPolicy);
    }
    /** Allows DeepRacer to create required resources and call AWS services on your behalf. */
    AWSDeepRacerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerServiceRolePolicy);
    }
    /** Deny all access. */
    AWSDenyAll() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDenyAll);
    }
    /** Provides full access to all AWS Device Farm operations. */
    AWSDeviceFarmFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeviceFarmFullAccess);
    }
    /** Grant permissions to AWS Device Farm to call EC2 Network APIs on your behalf. */
    AWSDeviceFarmServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeviceFarmServiceRolePolicy);
    }
    /** Grant permissions to AWS Device Farm to call EC2 APIs on your behalf. */
    AWSDeviceFarmTestGridServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeviceFarmTestGridServiceRolePolicy);
    }
    /** Provides full access to AWS Direct Connect via the AWS Management Console. */
    AWSDirectConnectFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectConnectFullAccess);
    }
    /** Provides read only access to AWS Direct Connect via the AWS Management Console. */
    AWSDirectConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectConnectReadOnlyAccess);
    }
    /** Provides AWS Direct Connect permission to create and manage AWS resources on your behalf. */
    AWSDirectConnectServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectConnectServiceRolePolicy);
    }
    /** Provides full access to AWS Directory Service Data. */
    AWSDirectoryServiceDataFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceDataFullAccess);
    }
    /** Provides read-only access to AWS Directory Service Data */
    AWSDirectoryServiceDataReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceDataReadOnlyAccess);
    }
    /** Provides full access to AWS Directory Service. */
    AWSDirectoryServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceFullAccess);
    }
    /** Provides read only access to AWS Directory Service. */
    AWSDirectoryServiceReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceReadOnlyAccess);
    }
    /** Provides write access to AWS resources required for AWS Discovery Continuous Export */
    AWSDiscoveryContinuousExportFirehosePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDiscoveryContinuousExportFirehosePolicy);
    }
    /** Allows DMS Fleet Advisor to manage CloudWatch metrics on your behalf. */
    AWSDMSFleetAdvisorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDMSFleetAdvisorServiceRolePolicy);
    }
    /** Grants AWS DMS Serverless permissions to create and manage DMS resources in your account on your behalf */
    AWSDMSServerlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDMSServerlessServiceRolePolicy);
    }
    /** Allows EC2 CapacityReservation Fleet service to manage Capacity Reservations */
    AWSEC2CapacityReservationFleetRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2CapacityReservationFleetRolePolicy);
    }
    /** Allows EC2 Fleet to launch and manage instances. */
    AWSEC2FleetServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2FleetServiceRolePolicy);
    }
    /** Allows EC2 Spot Fleet to launch and manage spot fleet instances */
    AWSEC2SpotFleetServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2SpotFleetServiceRolePolicy);
    }
    /** Allows EC2 Spot to launch and manage spot instances */
    AWSEC2SpotServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2SpotServiceRolePolicy);
    }
    /** This policy is attached to the IAM role that's attached to your Amazon EC2 Windows Instances to enable the Amazon EC2 VSS solution to create and add tags to Amazon Machine Images (AMI) and EBS Snapshots. */
    AWSEC2VssSnapshotPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2VssSnapshotPolicy);
    }
    /** Enables access to AWS services and resources used or managed by AWS ECR pull through cache */
    AWSECRPullThroughCacheServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSECRPullThroughCacheServiceRolePolicy);
    }
    /** Provide the instance in your custom platform builder environment permission to launch EC2 instance, create EBS snapshot and AMI, stream logs to Amazon CloudWatch Logs, and store artifacts in Amazon S3. */
    AWSElasticBeanstalkCustomPlatformforEC2Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkCustomPlatformforEC2Role);
    }
    /** AWS Elastic Beanstalk Service policy for Health Monitoring system */
    AWSElasticBeanstalkEnhancedHealth() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkEnhancedHealth);
    }
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to update your resources on your behalf for maintenance purposes. */
    AWSElasticBeanstalkMaintenance() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkMaintenance);
    }
    /** This policy is for the AWS Elastic Beanstalk service role used to perform managed updates of Elastic Beanstalk environments. This policy should not be attached to other users or roles. The policy grants broad permissions to create and manage resources across a number of AWS services including AutoScaling, EC2, ECS, Elastic Load Balancing and CloudFormation.  This policy also allows passing of any IAM role usable with those services. */
    AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy);
    }
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to managed updates. */
    AWSElasticBeanstalkManagedUpdatesServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesServiceRolePolicy);
    }
    /** Provide the instances in your multicontainer Docker environment access to use the Amazon EC2 Container Service to manage container deployment tasks. */
    AWSElasticBeanstalkMulticontainerDocker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkMulticontainerDocker);
    }
    /** Grants read-only permissions. Explicitly allows operators to gain direct access to retrieve information about resources related to AWS Elastic Beanstalk applications. */
    AWSElasticBeanstalkReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkReadOnly);
    }
    /** AWSElasticBeanstalkRoleCore (Elastic Beanstalk operations role) Allows core operation of a web service environment. */
    AWSElasticBeanstalkRoleCore() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleCore);
    }
    /** (Elastic Beanstalk operations role) Allows an environment to manage Amazon CloudWatch Logs log groups. */
    AWSElasticBeanstalkRoleCWL() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleCWL);
    }
    /** (Elastic Beanstalk operations role) Allows a multicontainer Docker environment to manage Amazon ECS clusters. */
    AWSElasticBeanstalkRoleECS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleECS);
    }
    /** (Elastic Beanstalk operations role) Allows an environment to integrate an Amazon RDS instance. */
    AWSElasticBeanstalkRoleRDS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleRDS);
    }
    /** (Elastic Beanstalk operations role) Allows an environment to enable Amazon SNS topic integration. */
    AWSElasticBeanstalkRoleSNS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleSNS);
    }
    /** (Elastic Beanstalk operations role) Allows a worker environment tier to create an Amazon DynamoDB table and an Amazon SQS queue. */
    AWSElasticBeanstalkRoleWorkerTier() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleWorkerTier);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-servicerole.html. AWS Elastic Beanstalk Service role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    AWSElasticBeanstalkService() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkService);
    }
    /** AWS Elastic Beanstalk Service Linked Role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    AWSElasticBeanstalkServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkServiceRolePolicy);
    }
    /** Provide the instances in your web server environment access to upload log files to Amazon S3. */
    AWSElasticBeanstalkWebTier() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkWebTier);
    }
    /** Provide the instances in your worker environment access to upload log files to Amazon S3, to use Amazon SQS to monitor your application's job queue, to use Amazon DynamoDB to perform leader election, and to Amazon CloudWatch to publish metrics for health monitoring. */
    AWSElasticBeanstalkWorkerTier() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkWorkerTier);
    }
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide during the installation step of the AWS Replication Agent. */
    AWSElasticDisasterRecoveryAgentInstallationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryAgentInstallationPolicy);
    }
    /** This policy allows using the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover source servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryAgentPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryAgentPolicy);
    }
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (DRS), as well as permissions to read KMS key, License Manager, Resource Groups, Elastic Load Balancing, IAM, and EC2 information. Attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccess);
    }
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (AWS DRS), as well as all public APIs in other AWS services used by AWS DRS Console. Attach this policy to your users or roles. */
    AWSElasticDisasterRecoveryConsoleFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccessV2);
    }
    /** This policy is attached to the AWS Elastic Disaster Recovery Conversion server's instance role. This policy allows Elastic Disaster Recovery (DRS) Conversion Servers, which are EC2 instances launched by Elastic Disaster Recovery, to communicate with the DRS service. An IAM role with this policy is attached (as an EC2 Instance Profile) by DRS to the DRS Conversion Servers, which are automatically launched and terminated by DRS, when needed. We do not recommend that you attach this policy to your IAM users or roles. DRS Conversion Servers are used by Elastic Disaster Recovery when users choose to recover source servers using the DRS console, CLI, or API. */
    AWSElasticDisasterRecoveryConversionServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryConversionServerPolicy);
    }
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support cross-account replication and cross-account failback. */
    AWSElasticDisasterRecoveryCrossAccountReplicationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryCrossAccountReplicationPolicy);
    }
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Elastic Disaster Recovery (DRS) to recover source servers that run on EC2 (cross-region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    AWSElasticDisasterRecoveryEc2InstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryEc2InstancePolicy);
    }
    /** You can attach the AWSElasticDisasterRecoveryFailbackInstallationPolicy policy to your IAM identities.  This policy allows installing the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. Attach this policy to your IAM users or roles whose credentials you provide when running the Elastic Disaster Recovery Failback Client. */
    AWSElasticDisasterRecoveryFailbackInstallationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackInstallationPolicy);
    }
    /** This policy allows using the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryFailbackPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackPolicy);
    }
    /** This policy allows you to use Amazon SSM and additional services required permissions to run post-launch actions in AWS Elastic Disaster Recovery (AWS DRS). Attach this policy to your IAM roles or users. */
    AWSElasticDisasterRecoveryLaunchActionsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryLaunchActionsPolicy);
    }
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support network replication. */
    AWSElasticDisasterRecoveryNetworkReplicationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryNetworkReplicationPolicy);
    }
    /** You can attach the AWSElasticDisasterRecoveryReadOnlyAccess policy to your IAM identities.  This policy provides permissions to all read-only public APIs of Elastic Disaster Recovery (DRS), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the DRS console. Attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryReadOnlyAccess);
    }
    /** This policy is attached to the instance role of Elastic Disaster Recovery's Recovery Instance.  This policy allows the Elastic Disaster Recovery (DRS) Recovery Instance, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to be able to failback to their original source infrastructure. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Recovery Instances. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryRecoveryInstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryRecoveryInstancePolicy);
    }
    /** This policy is attached to the Elastic Disaster Recovery Replication server's instance role. This policy allows the Elastic Disaster Recovery (DRS) Replication Servers, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Replication Servers which are automatically launched and terminated by DRS, as needed. DRS Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the recovery process managed by DRS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryReplicationServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryReplicationServerPolicy);
    }
    /** This policy allows Elastic Disaster Recovery to manage AWS resources on your behalf. */
    AWSElasticDisasterRecoveryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryServiceRolePolicy);
    }
    /** This policy allows read-only access to AWS Elastic Disaster Recovery (DRS) resources such as source servers and jobs. It also allows creating a converted snapshot and sharing that EBS snapshot with a specific account. */
    AWSElasticDisasterRecoveryStagingAccountPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicy);
    }
    /** This policy is used by AWS Elastic Disaster Recovery (DRS) to recover source servers into a separate target account and to allow failing back. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryStagingAccountPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicyV2);
    }
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane - Classic */
    AWSElasticLoadBalancingClassicServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticLoadBalancingClassicServiceRolePolicy);
    }
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane */
    AWSElasticLoadBalancingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticLoadBalancingServiceRolePolicy);
    }
    /** Provides full access to AWS Elemental MediaConnect resources. */
    AWSElementalMediaConnectFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConnectFullAccess);
    }
    /** Provides read-only access to AWS Elemental MediaConnect resources. */
    AWSElementalMediaConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConnectReadOnlyAccess);
    }
    /** Provides full access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    AWSElementalMediaConvertFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConvertFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    AWSElementalMediaConvertReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConvertReadOnly);
    }
    /** Provides full access to AWS Elemental MediaLive resources */
    AWSElementalMediaLiveFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaLiveFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaLive resources */
    AWSElementalMediaLiveReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaLiveReadOnly);
    }
    /** Provides full access to AWS Elemental MediaPackage resources */
    AWSElementalMediaPackageFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaPackage resources */
    AWSElementalMediaPackageReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageReadOnly);
    }
    /** Provides full access to AWS Elemental MediaPackageV2 resources. */
    AWSElementalMediaPackageV2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageV2FullAccess);
    }
    /** Provides read-only access to AWS Elemental MediaPackageV2 resources. */
    AWSElementalMediaPackageV2ReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageV2ReadOnly);
    }
    /** Provides full read and write access to all MediaStore APIs */
    AWSElementalMediaStoreFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaStoreFullAccess);
    }
    /** Provides read-only permissions for MediaStore APIs */
    AWSElementalMediaStoreReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaStoreReadOnly);
    }
    /** Provides full access to AWS Elemental MediaTailor resources */
    AWSElementalMediaTailorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaTailorFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaTailor resources */
    AWSElementalMediaTailorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaTailorReadOnly);
    }
    /** Policy to enable enhanced classic networking management feature. */
    AWSEnhancedClassicNetworkingMangementPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEnhancedClassicNetworkingMangementPolicy);
    }
    /** Provides console full access to AWS Entity Resolution and related services. */
    AWSEntityResolutionConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEntityResolutionConsoleFullAccess);
    }
    /** Provides read-only access to AWS Entity Resolution via the AWS Management Console. */
    AWSEntityResolutionConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEntityResolutionConsoleReadOnlyAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in EC2 and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorEC2Access() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorEC2Access);
    }
    /** This policy grants the Fault Injection Simulator Service permission in ECS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorECSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorECSAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in EKS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorEKSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorEKSAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in EC2 networking and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorNetworkAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorNetworkAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in RDS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorRDSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorRDSAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in SSM and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorSSMAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorSSMAccess);
    }
    /** Policy to enable access to AWS Service and Resources used or managed by Amazon FinSpace */
    AWSFinSpaceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFinSpaceServiceRolePolicy);
    }
    /** Full access for AWS FM Administrator */
    AWSFMAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFMAdminFullAccess);
    }
    /** Read only access for AWS FM Administrator that allows monitoring AWS FM operations */
    AWSFMAdminReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFMAdminReadOnlyAccess);
    }
    /** Provides read only access to AWS WAF actions for AWS Firewall Manager member accounts */
    AWSFMMemberReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFMMemberReadOnlyAccess);
    }
    /** Managed policy for AWS For Wordpress Plugin */
    AWSForWordPressPluginPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSForWordPressPluginPolicy);
    }
    /** Policy which allows AWS Code Connections to sync content from your git repository */
    AWSGitSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGitSyncServiceRolePolicy);
    }
    /** Policy granting permissions to AWS Global Accelerator to manage EC2 Elastic Network Interfaces and Security Groups. */
    AWSGlobalAcceleratorSLRPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlobalAcceleratorSLRPolicy);
    }
    /** Provides full access to AWS Glue via the AWS Management Console */
    AWSGlueConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueConsoleFullAccess);
    }
    /** Provides full access to AWS Glue via the AWS Management Console and access to sagemaker notebook instances. */
    AWSGlueConsoleSageMakerNotebookFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueConsoleSageMakerNotebookFullAccess);
    }
    /** Provides full access to AWS Glue DataBrew via the AWS Management Console. Also provides select access to related services (e.g., S3, KMS, Glue). */
    AwsGlueDataBrewFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueDataBrewFullAccessPolicy);
    }
    /** This policy grants permission to glue to perform action on user's glue data catalog, this policy also provides permission to ec2 actions to allow glue to create ENI to connect to resources in the VPC, also allow glue to access registered data in lakeformation and permission to access user's cloudwatch */
    AWSGlueDataBrewServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueDataBrewServiceRole);
    }
    /** Provides full access to the AWS Glue Schema Registry Service */
    AWSGlueSchemaRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueSchemaRegistryFullAccess);
    }
    /** Provides readonly access to the AWS Glue Schema Registry Service */
    AWSGlueSchemaRegistryReadonlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueSchemaRegistryReadonlyAccess);
    }
    /** Policy for AWS Glue service role which allows customer to manage notebook server */
    AWSGlueServiceNotebookRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueServiceNotebookRole);
    }
    /** Policy for AWS Glue service role which allows access to related services including EC2, S3, and Cloudwatch Logs */
    AWSGlueServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueServiceRole);
    }
    /** Provides permissions that allows users to create and use only the notebook sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    AwsGlueSessionUserRestrictedNotebookPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookPolicy);
    }
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the notebook sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services. */
    AwsGlueSessionUserRestrictedNotebookServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookServiceRole);
    }
    /** Provides permissions that allows users to create and use only the interactive sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    AwsGlueSessionUserRestrictedPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedPolicy);
    }
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the interactive sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services */
    AwsGlueSessionUserRestrictedServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedServiceRole);
    }
    /** Provides access within Amazon Grafana to create and manage workspaces for the entire organization. */
    AWSGrafanaAccountAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaAccountAdministrator);
    }
    /** Access to read only operations in Amazon Grafana. */
    AWSGrafanaConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaConsoleReadOnlyAccess);
    }
    /** Provides only the ability to update user and group permissions for AWS Grafana workspaces. */
    AWSGrafanaWorkspacePermissionManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagement);
    }
    /** Provides ability to update IAM Identity Center (IdC) user and group permissions for Amazon Managed Grafana workspaces. */
    AWSGrafanaWorkspacePermissionManagementV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagementV2);
    }
    /** This policy gives full access to the AWS Greengrass configuration, management and deployment actions */
    AWSGreengrassFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGreengrassFullAccess);
    }
    /** This policy gives read only access to the AWS Greengrass configuration, management and deployment actions */
    AWSGreengrassReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGreengrassReadOnlyAccess);
    }
    /** Policy for AWS Greengrass service role which allows access to related services including AWS Lambda and AWS IoT thing shadows. */
    AWSGreengrassResourceAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGreengrassResourceAccessRolePolicy);
    }
    /** Provides the Dataflow Endpoint Instance permissions to use the AWS Ground Station Agent */
    AWSGroundStationAgentInstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGroundStationAgentInstancePolicy);
    }
    /** Allows AWS Health to enable the Health event processor feature. */
    AWSHealthEventProcessorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthEventProcessorServiceRolePolicy);
    }
    /** Allows full access to the AWS Health Apis and Notifications and the Personal Health Dashboard */
    AWSHealthFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthFullAccess);
    }
    /** Provides full access to AWS Health Imaging service. */
    AWSHealthImagingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthImagingFullAccess);
    }
    /** Provides read only access to AWS Health Imaging service. */
    AWSHealthImagingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthImagingReadOnlyAccess);
    }
    /** Provides the list of actions that are allowed for roles assumed with the IAM Identity Center identity context. AWS Security Token Service (AWS STS) automatically attaches this policy to assumed roles. The identity context is passed as ProvidedContext. */
    AWSIAMIdentityCenterAllowListForIdentityContext() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIAMIdentityCenterAllowListForIdentityContext);
    }
    /** Grants full access to the Identity Sync service */
    AWSIdentitySyncFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIdentitySyncFullAccess);
    }
    /** Read only access to the Identity Sync service */
    AWSIdentitySyncReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIdentitySyncReadOnlyAccess);
    }
    /** Provides full access to all AWS Image Builder actions and resource scoped access to related AWS services. */
    AWSImageBuilderFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImageBuilderFullAccess);
    }
    /** Provides read only access to all AWS Image Builder actions. */
    AWSImageBuilderReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImageBuilderReadOnlyAccess);
    }
    /** Provides read and write access to the jobs created under the AWS account. */
    AWSImportExportFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImportExportFullAccess);
    }
    /** Provides read only access to the jobs created under the AWS account. */
    AWSImportExportReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImportExportReadOnlyAccess);
    }
    /** Grants Incident Manager permissions to call other AWS services as a part of managing an incident. */
    AWSIncidentManagerIncidentAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIncidentManagerIncidentAccessServiceRolePolicy);
    }
    /** This policy grants permissions to start, view, and update incidents with full access to custom timeline events & related items. Assign this policy to users who will create and resolve incidents. */
    AWSIncidentManagerResolverAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIncidentManagerResolverAccess);
    }
    /** This policy grants Incident Manager permission to manage incident records and related resources on your behalf. */
    AWSIncidentManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIncidentManagerServiceRolePolicy);
    }
    /** Provides full access to AWS IoT 1-Click. */
    AWSIoT1ClickFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoT1ClickFullAccess);
    }
    /** Provides read only access to AWS IoT 1-Click. */
    AWSIoT1ClickReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoT1ClickReadOnlyAccess);
    }
    /** Provides full access to IoT Analytics. */
    AWSIoTAnalyticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTAnalyticsFullAccess);
    }
    /** Provides read only access to IoT Analytics. */
    AWSIoTAnalyticsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTAnalyticsReadOnlyAccess);
    }
    /** This policy gives full access to the AWS IoT configuration actions */
    AWSIoTConfigAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTConfigAccess);
    }
    /** This policy gives read only access to the AWS IoT configuration actions */
    AWSIoTConfigReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTConfigReadOnlyAccess);
    }
    /** This policy gives full access to the AWS IoT messaging actions */
    AWSIoTDataAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDataAccess);
    }
    /** Provides write access to IoT thing groups and read access to IoT Certificates for execution of ADD_THINGS_TO_THING_GROUP mitigation action */
    AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction);
    }
    /** Provides read access for IoT and related resources */
    AWSIoTDeviceDefenderAudit() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderAudit);
    }
    /** Provides access for enabling IoT logging for execution of ENABLE_IOT_LOGGING mitigation action */
    AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction);
    }
    /** Provides messages publish access to SNS topic for execution of PUBLISH_FINDING_TO_SNS mitigation action */
    AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction);
    }
    /** Provides write access to IoT policies for execution of REPLACE_DEFAULT_POLICY_VERSION mitigation action */
    AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction);
    }
    /** Provides write access to IoT CA certificates for execution of  UPDATE_CA_CERTIFICATE mitigation action */
    AWSIoTDeviceDefenderUpdateCACertMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderUpdateCACertMitigationAction);
    }
    /** Provides write access to IoT certificates for execution of UPDATE_DEVICE_CERTIFICATE mitigation action */
    AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction);
    }
    /** Allows AWS IoT Device Tester to run the FreeRTOS qualification suite by allowing access to services including IoT, S3, and IAM */
    AWSIoTDeviceTesterForFreeRTOSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceTesterForFreeRTOSFullAccess);
    }
    /** Allows AWS IoT Device Tester to run the AWS Greengrass qualification suite by allowing access to related services including Lambda, IoT, API Gateway, IAM */
    AWSIoTDeviceTesterForGreengrassFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceTesterForGreengrassFullAccess);
    }
    /** Provides full access to IoT Events. */
    AWSIoTEventsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTEventsFullAccess);
    }
    /** Provides read only access to IoT Events. */
    AWSIoTEventsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTEventsReadOnlyAccess);
    }
    /** Federation access for IoT Fleet Hub applications */
    AWSIoTFleetHubFederationAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTFleetHubFederationAccess);
    }
    /** Grants permissions to AWS Resources and metaData used or managed by AWSIoTFleetwise for auxiliary features */
    AWSIoTFleetwiseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTFleetwiseServiceRolePolicy);
    }
    /** This policy gives full access to the AWS IoT configuration and messaging actions */
    AWSIoTFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTFullAccess);
    }
    /** Allows creation of Amazon CloudWatch Log groups and streaming logs to the groups */
    AWSIoTLogging() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTLogging);
    }
    /** Provides full access to managed integrations for AWS IoT Device Management and related services. */
    AWSIoTManagedIntegrationsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTManagedIntegrationsFullAccess);
    }
    /** Provides managed integrations for AWS IoT Device Management permission to publish logs and metrics on your behalf. */
    AWSIoTManagedIntegrationsRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTManagedIntegrationsRolePolicy);
    }
    /** Allows access to create AWS IoT Job and describe the AWS code signer job */
    AWSIoTOTAUpdate() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTOTAUpdate);
    }
    /** Allows access to all AWS services supported in AWS IoT Rule Actions */
    AWSIoTRuleActions() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTRuleActions);
    }
    /** Provides full access to manage AWS IoT SiteWise using the AWS Management Console. Note this policy also grants access to create and list data stores used with AWS IoT SiteWise (e.g. AWS IoT Analytics), access to list and view AWS IoT Greengrass resources, list and modify AWS Secrets Manager secrets, retrieve AWS IoT thing shadows, list resources with specific tags, and create and use a service-linked role for AWS IoT SiteWise. */
    AWSIoTSiteWiseConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseConsoleFullAccess);
    }
    /** Provides full access to IoT SiteWise. */
    AWSIoTSiteWiseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseFullAccess);
    }
    /** This policy grants permissions to access AWS IoT SiteWise assets and asset data, create AWS IoT SiteWise Monitor resources, and list AWS SSO users. */
    AWSIoTSiteWiseMonitorPortalAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseMonitorPortalAccess);
    }
    /** This role grants AWS IoT SiteWise monitor permissions to access your AWS IoT SiteWise assets & asset properties, and create AWS IoT Sitewise projects, dashboards & access policies through AWS IoT SiteWise portals. */
    AWSIoTSiteWiseMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseMonitorServiceRolePolicy);
    }
    /** Provides read only access to IoT SiteWise. */
    AWSIoTSiteWiseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseReadOnlyAccess);
    }
    /** This policy allows users to register things at bulk using AWS IoT StartThingRegistrationTask API */
    AWSIoTThingsRegistration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTThingsRegistration);
    }
    /** Allows AWS IoT TwinMaker to call other AWS services and to sync their resources on your behalf. */
    AWSIoTTwinMakerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTTwinMakerServiceRolePolicy);
    }
    /** Allows the associated identity data access to AWS IoT Wireless devices. */
    AWSIoTWirelessDataAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessDataAccess);
    }
    /** Allows the associated identity full access to all AWS IoT Wireless operations. */
    AWSIoTWirelessFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessFullAccess);
    }
    /** Provides IoT Wireless full access to publish to IoT Rules Engine on your behalf. */
    AWSIoTWirelessFullPublishAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessFullPublishAccess);
    }
    /** Allows the associated identity access to create, list and describe IoT Certificates */
    AWSIoTWirelessGatewayCertManager() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessGatewayCertManager);
    }
    /** Allows the associated identity to create Amazon CloudWatch Logs groups and stream logs to the groups. */
    AWSIoTWirelessLogging() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessLogging);
    }
    /** Allows the associated identity read only access to AWS IoT wireless. */
    AWSIoTWirelessReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessReadOnlyAccess);
    }
    /** Allows VPC IP Address Manager to access VPC resources and integrate with AWS Organizations on your behalf. */
    AWSIPAMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIPAMServiceRolePolicy);
    }
    /** Used by AWS IQ to execute payment requests on behalf of a customer */
    AWSIQContractServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIQContractServiceRolePolicy);
    }
    /** Provides full access to AWS IQ */
    AWSIQFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIQFullAccess);
    }
    /** Allows AWS IQ to manage the role assumed by AWS IQ experts. */
    AWSIQPermissionServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIQPermissionServiceRolePolicy);
    }
    /** Enables access to AWS services and resources required for AWS KMS custom key stores */
    AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy);
    }
    /** Enables AWS KMS to synchronize the shared properties of multi-Region keys. */
    AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy);
    }
    /** Provides access to AWS Key Management Service (KMS). */
    AWSKeyManagementServicePowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSKeyManagementServicePowerUser);
    }
    /** Provides cross account access to Glue resources via Lake Formation. Also grants read access to other required services such as organizations and resource access manager */
    AWSLakeFormationCrossAccountManager() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLakeFormationCrossAccountManager);
    }
    /** Grants administrative access to AWS Lake Formation and related services, such as AWS Glue, to manage data lakes */
    AWSLakeFormationDataAdmin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLakeFormationDataAdmin);
    }
    /** Grants full access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    AWSLambdaFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaFullAccess);
    }
    /** Grants read-only access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    AWSLambdaReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaReadOnlyAccess);
    }
    /** Provides write permissions to CloudWatch Logs. */
    AWSLambdaBasicExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaBasicExecutionRole);
    }
    /** Provides list and read access to DynamoDB streams and write permissions to CloudWatch logs. */
    AWSLambdaDynamoDBExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaDynamoDBExecutionRole);
    }
    /** Provides minimum permissions for a Lambda function to manage ENIs (create, describe, delete) used by a VPC-enabled Lambda Function. */
    AWSLambdaENIManagementAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaENIManagementAccess);
    }
    /** Provides Put, Get access to S3 and full access to CloudWatch Logs. */
    AWSLambdaExecute() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaExecute);
    }
    /** Provides read access to DynamoDB Streams. */
    AWSLambdaInvocationDynamoDB() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaInvocationDynamoDB);
    }
    /** Provides list and read access to Kinesis streams and write permissions to CloudWatch logs. */
    AWSLambdaKinesisExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaKinesisExecutionRole);
    }
    /** Provides permissions required to access MSK Cluster within a VPC, manage ENIs (create, describe, delete) in the VPC and write permissions to CloudWatch Logs. */
    AWSLambdaMSKExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaMSKExecutionRole);
    }
    /** Grants Lambda Replicator necessary permissions to replicate functions across regions */
    AWSLambdaReplicator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaReplicator);
    }
    /** Default policy for AWS Lambda service role. */
    AWSLambdaRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaRole);
    }
    /** Provides receive message, delete message, and read attribute access to SQS queues, and write permissions to CloudWatch logs. */
    AWSLambdaSQSQueueExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaSQSQueueExecutionRole);
    }
    /** Provides minimum permissions for a Lambda function to execute while accessing a resource within a VPC - create, describe, delete network interfaces and write permissions to CloudWatch Logs. */
    AWSLambdaVPCAccessExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaVPCAccessExecutionRole);
    }
    /** Provides permissions to allow access to the AWS License Manager API actions required to consume upon licenses that the user has entitlements. */
    AWSLicenseManagerConsumptionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerConsumptionPolicy);
    }
    /** Allows AWS License Manager Linux Subscriptions Service to manage resources on your behalf. */
    AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy);
    }
    /** AWS License Manager service master account role policy */
    AWSLicenseManagerMasterAccountRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerMasterAccountRolePolicy);
    }
    /** AWS License Manager service member account role policy */
    AWSLicenseManagerMemberAccountRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerMemberAccountRolePolicy);
    }
    /** AWS License Manager service default role policy */
    AWSLicenseManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerServiceRolePolicy);
    }
    /** Allows AWS License Manager User Subscriptions Service to manage resources on your behalf. */
    AWSLicenseManagerUserSubscriptionsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerUserSubscriptionsServiceRolePolicy);
    }
    /** Allows AWS M2 to manage AWS resources on your behalf. */
    AWSM2ServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSM2ServicePolicy);
    }
    /** Allows AWS Managed Services to read the values of the tags on AWS resources */
    AWSManagedServicesContactsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesContactsServiceRolePolicy);
    }
    /** AWS Managed Services - policy to manage detective controls infrastructure */
    AWSManagedServicesDetectiveControlsConfigServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesDetectiveControlsConfigServiceRolePolicy);
    }
    /** AWS Managed Services policy to enable AMS event processor feature. */
    AWSManagedServicesEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesEventsServiceRolePolicy);
    }
    /** Allows Amazon's AWS Managed Service's Self Service Reporting feature to read AWS Organization data on your behalf to enable organization level aggregated reporting */
    AWSManagedServicesSelfServiceReportingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesSelfServiceReportingServiceRolePolicy);
    }
    /** Allows AWS Managed Services to manage deployment toolkit on your behalf. */
    AWSManagedServicesDeploymentToolkitPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesDeploymentToolkitPolicy);
    }
    /** Allows AWS Marketplace to copy your Amazon Machine Images (AMIs) in order to list them on AWS Marketplace */
    AWSMarketplaceAmiIngestion() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceAmiIngestion);
    }
    /** Allows AWS Marketplace to create and manage seller deployment parameters for the products that you subscribe to on AWS Marketplace. */
    AWSMarketplaceDeploymentServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceDeploymentServiceRolePolicy);
    }
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software, allows users to manage Marketplace software instances from the Marketplace 'Your Software' page, and provides administrative access to EC2. */
    AWSMarketplaceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceFullAccess);
    }
    /** Provides read access to AWS Marketplace Entitlements */
    AWSMarketplaceGetEntitlements() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceGetEntitlements);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for license management. */
    AWSMarketplaceLicenseManagementServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceLicenseManagementServiceRolePolicy);
    }
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software */
    AWSMarketplaceManageSubscriptions() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceManageSubscriptions);
    }
    /** Provides full access to AWS Marketplace Metering. */
    AWSMarketplaceMeteringFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceMeteringFullAccess);
    }
    /** Provides permissions to register a resource and track usage through AWS Marketplace Metering Service. */
    AWSMarketplaceMeteringRegisterUsage() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceMeteringRegisterUsage);
    }
    /** Provides full access to all administrative actions for an AWS Marketplace eProcurement integration. */
    AWSMarketplaceProcurementSystemAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceProcurementSystemAdminFullAccess);
    }
    /** Enables access for AWS Marketplace services to purchase order management. */
    AWSMarketplacePurchaseOrdersServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplacePurchaseOrdersServiceRolePolicy);
    }
    /** Provides the ability to review AWS Marketplace subscriptions */
    AWSMarketplaceReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceReadOnly);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for Resale Authorization. */
    AWSMarketplaceResaleAuthorizationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceResaleAuthorizationServiceRolePolicy);
    }
    /** Provides full access to all seller operations on the AWS Marketplace and other AWS services such as AMI management. */
    AWSMarketplaceSellerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerFullAccess);
    }
    /** Provides sellers access to Offers and Agreements management activities. */
    AWSMarketplaceSellerOfferManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerOfferManagement);
    }
    /** Provides sellers full access to AWS Marketplace Management Products page and other AWS services such as AMI management. */
    AWSMarketplaceSellerProductsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerProductsFullAccess);
    }
    /** Provide sellers read-only access to AWS Marketplace Management Products page. */
    AWSMarketplaceSellerProductsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerProductsReadOnly);
    }
    /** The default policy that enables access to AWS Services and Resources used or managed by MediaConnect. */
    AWSMediaConnectServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMediaConnectServicePolicy);
    }
    /** Allows MediaLive Anywhere to create and manage AWS resources on your behalf. */
    AWSMediaLiveAnywhereServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMediaLiveAnywhereServiceRolePolicy);
    }
    /** Enable access to AWS Resources used or managed by MediaTailor */
    AWSMediaTailorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMediaTailorServiceRolePolicy);
    }
    /** Policy allows AWSMigrationHubService to call AWSApplicationDiscoveryService on behalf of the customer. */
    AWSMigrationHubDiscoveryAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubDiscoveryAccess);
    }
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    AWSMigrationHubDMSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubDMSAccess);
    }
    /** Managed policy to provide the customer access to the Migration Hub Service */
    AWSMigrationHubFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubFullAccess);
    }
    /** Provides limited access to AWS Migration Hub, AWS Application Discovery Service, Amazon Simple Storage Service and AWS Secrets Manager. This policy also grants full access to AWS Migration Hub Orchestrator service. */
    AWSMigrationHubOrchestratorConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorConsoleFullAccess);
    }
    /** This policy needs to be attached for SAP and MGN migrated instance for our service to orchestrate instances by downloading scripts from S3 and to fetch secret values inside EC2 instance. */
    AWSMigrationHubOrchestratorInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorInstanceRolePolicy);
    }
    /** Provides limited access to Amazon Simple Storage Service, AWS Secrets Manager and Plugin related actions for AWS Migration Hub Orchestrator. */
    AWSMigrationHubOrchestratorPlugin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorPlugin);
    }
    /** Provides permissions necessary for Migration Hub Orchestrator to migrate and modernize your on-premises workloads */
    AWSMigrationHubOrchestratorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorServiceRolePolicy);
    }
    /** Grants full access to AWS Migration Hub Refactor Spaces and other AWS related services except AWS Transit Gateway and EC2 security groups not required when using environments without a network bridge. This policy also excludes permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess);
    }
    /** Use in the IAM service role passed to the SSM Automation document AWSRefactorSpaces-CreateResources to grant permissions required to run the automation. The policy grants read/write access to EC2 tags in order to track automation progress. When the Refactor Spaces environment's network bridge is enabled, the automation also adds the environment's security group to the EC2 instance to permit traffic from other Refactor Spaces services in the environment. The policy also grants access to the Application Migration Service's post launch actions SSM parameters. */
    AWSMigrationHubRefactorSpacesSSMAutomationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesSSMAutomationPolicy);
    }
    /** Grants full access to AWS MigrationHub Refactor Spaces, AWS MigrationHub Refactor Spaces console features and other related AWS services except permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    AWSMigrationHubRefactorSpacesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesFullAccess);
    }
    /** Provides access to AWS Resources managed or used by AWS Migration Hub Refactor Spaces. */
    AWSMigrationHubRefactorSpacesServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesServiceRolePolicy);
    }
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    AWSMigrationHubSMSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubSMSAccess);
    }
    /** Grants permissions to allow communication with the AWS Migration Hub Strategy Recommendations service, read/write access to S3 buckets related to the service, Amazon API Gateway access to upload logs and metrics to AWS, AWS Secrets Manager access to fetch credentials, and any related services. */
    AWSMigrationHubStrategyCollector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubStrategyCollector);
    }
    /** Grants full access to the AWS Migration Hub Strategy Recommendations service and access to related AWS services through the AWS Management Console. */
    AWSMigrationHubStrategyConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubStrategyConsoleFullAccess);
    }
    /** Enable access to AWS Resources used or managed by AWS Migration Hub Strategy Recommendations service. */
    AWSMigrationHubStrategyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubStrategyServiceRolePolicy);
    }
    /** Grants permissions to Amazon MSK Replicator to replicate data between MSK Clusters. */
    AWSMSKReplicatorExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMSKReplicatorExecutionRole);
    }
    /** Grants full access to AWS Network Firewall service, including permissions to create, configure, manage, and delete firewall resources, policies, and rule groups. Additionally includes permissions to modify VPC endpoints, S3 bucket policies, CloudWatch Logs configurations, and create service-linked roles for Network Firewall and log delivery services */
    AWSNetworkFirewallFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkFirewallFullAccess);
    }
    /** Provides read-only access to AWS Network Firewall resources via the AWS Management Console, CLI, and SDKs. This policy allows users to view and monitor firewall configurations, policies, rule groups, and associated resources, without the ability to make changes. */
    AWSNetworkFirewallReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkFirewallReadOnlyAccess);
    }
    /** Allow AWSNetworkFirewall to create and manage necessary resources for your Firewalls. */
    AWSNetworkFirewallServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkFirewallServiceRolePolicy);
    }
    /** Allow NetworkManager to access resources associated with your Core Network */
    AWSNetworkManagerCloudWANServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerCloudWANServiceRolePolicy);
    }
    /** Provides full access to Amazon NetworkManager via the AWS Management Console. */
    AWSNetworkManagerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerFullAccess);
    }
    /** Provides read only access to Amazon NetworkManager via the AWS Management Console. */
    AWSNetworkManagerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerReadOnlyAccess);
    }
    /** Allow NetworkManager to access resources associated with your Global Networks */
    AWSNetworkManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerServiceRolePolicy);
    }
    /** Provides access to manage AWS Config Configuration Recorder, manage AWS Config Configuration Aggregator, create AWS Config Service Linked Role for Configuration Recorder functionality, consume recorder configuration data, and read AWS Organizations data for organizational features. */
    AWSObservabilityAdminServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSObservabilityAdminServiceRolePolicy);
    }
    /** Provides full access to AWS OpsWorks. */
    AWSOpsWorksFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksFullAccess);
    }
    /** Enables OpsWorks instances with the CWLogs integration enabled to ship logs and create required log groups */
    AWSOpsWorksCloudWatchLogs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksCloudWatchLogs);
    }
    /** Provides S3 access for instances launched by OpsWorks CM. */
    AWSOpsWorksCMInstanceProfileRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksCMInstanceProfileRole);
    }
    /** Service Role Policy to be used for Creating OpsWorks CM servers. */
    AWSOpsWorksCMServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksCMServiceRole);
    }
    /** Provides access for an Amazon EC2 instance to register with an AWS OpsWorks stack. */
    AWSOpsWorksInstanceRegistration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksInstanceRegistration);
    }
    /** Policy to enable registration of EC2 instances via the OpsWorks CLI */
    AWSOpsWorksRegisterCLIEC2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksRegisterCLIEC2);
    }
    /** Policy to enable registration of On-Premises instances via the OpsWorks CLI */
    AWSOpsWorksRegisterCLIOnPremises() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOpsWorksRegisterCLIOnPremises);
    }
    /** Provides full access to AWS Organizations. */
    AWSOrganizationsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOrganizationsFullAccess);
    }
    /** Provides read-only access to AWS Organizations. */
    AWSOrganizationsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOrganizationsReadOnlyAccess);
    }
    /** A policy to allow AWS Organizations to share trust with other approved AWS Services for the purpose of simplifying customer configuration. */
    AWSOrganizationsServiceTrustPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOrganizationsServiceTrustPolicy);
    }
    /** This policy grants permissions that allow you to install an Outpost server on your on-premises network. */
    AWSOutpostsAuthorizeServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOutpostsAuthorizeServerPolicy);
    }
    /** Service Linked Role policy to enable access to AWS resources managed by AWS Outposts */
    AWSOutpostsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOutpostsServiceRolePolicy);
    }
    /** Allows AWS IoT software on an AWS Panorama Appliance to upload logs to Amazon CloudWatch. */
    AWSPanoramaApplianceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaApplianceRolePolicy);
    }
    /** Allows an AWS Panorama Appliance to upload logs to Amazon CloudWatch, and to get objects from Amazon S3 access points created for use with AWS Panorama. */
    AWSPanoramaApplianceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaApplianceServiceRolePolicy);
    }
    /** Provides full access to AWS Panorama */
    AWSPanoramaFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaFullAccess);
    }
    /** Allows an AWS Lambda function on an AWS Panorama Appliance to manage resources in Panorama, upload logs and metrics to Amazon CloudWatch, and to manage objects in buckets created for use with Panorama. */
    AWSPanoramaGreengrassGroupRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaGreengrassGroupRolePolicy);
    }
    /** Allows Amazon SageMaker to manage objects in buckets created for use with AWS Panorama. */
    AWSPanoramaSageMakerRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaSageMakerRolePolicy);
    }
    /** Allows AWS Panorama to manage resources in AWS IoT, AWS Secrets Manager and AWS Panorama. */
    AWSPanoramaServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaServiceLinkedRolePolicy);
    }
    /** Allows AWS Panorama to manage resources in Amazon S3, AWS IoT, AWS IoT GreenGrass, AWS Lambda, Amazon SageMaker, and Amazon CloudWatch Logs, and to pass service roles to AWS IoT, AWS IoT GreenGrass, and Amazon SageMaker. */
    AWSPanoramaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaServiceRolePolicy);
    }
    /** Provides full access to AWS Partner Central and related AWS Services. */
    AWSPartnerCentralFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralFullAccess);
    }
    /** Provides necessary access for opportunity management activities. */
    AWSPartnerCentralOpportunityManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralOpportunityManagement);
    }
    /** Provides necessary access for developer testing in the Sandbox catalog. */
    AWSPartnerCentralSandboxFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralSandboxFullAccess);
    }
    /** Provides access to the ResourceSnapshotJob to read a resource and snapshot it in the target engagement. */
    AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy);
    }
    /** This policy can be used to grant read-only access to APIs that can read service metadata for services in your AWS account. You can use this policy to provide your partners in the Partner-Led Support Program with access to the services specified in the permissions details section below. */
    AWSPartnerLedSupportReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerLedSupportReadOnlyAccess);
    }
    /** Grants permission to AWS PCS compute nodes to connect to AWS PCS clusters. */
    AWSPCSComputeNodePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPCSComputeNodePolicy);
    }
    /** Grants permissions to PCS to manage resources on your behalf. */
    AWSPCSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPCSServiceRolePolicy);
    }
    /** Provides full access to AWS Price List Service. */
    AWSPriceListServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPriceListServiceFullAccess);
    }
    /** Provides auditor access to AWS Private Certificate Authority */
    AWSPrivateCAAuditor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAAuditor);
    }
    /** Grants essential permissions for the AWS Private CA Connector for Kubernetes. */
    AWSPrivateCAConnectorForKubernetesPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAConnectorForKubernetesPolicy);
    }
    /** Provides full access to AWS Private Certificate Authority */
    AWSPrivateCAFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAFullAccess);
    }
    /** Provides privileged certificate user access to AWS Private Certificate Authority */
    AWSPrivateCAPrivilegedUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAPrivilegedUser);
    }
    /** Provides read only access to AWS Private Certificate Authority */
    AWSPrivateCAReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAReadOnly);
    }
    /** Provides certificate user access to AWS Private Certificate Authority */
    AWSPrivateCAUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAUser);
    }
    /** Provides full access to all administrative actions for an AWS Private Marketplace. */
    AWSPrivateMarketplaceAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateMarketplaceAdminFullAccess);
    }
    /** Provides access to creating requests in an AWS Private Marketplace. */
    AWSPrivateMarketplaceRequests() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateMarketplaceRequests);
    }
    /** Allows AWS Private Networks Service to manage resources on behalf of the customer. */
    AWSPrivateNetworksServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateNetworksServiceRolePolicy);
    }
    /** Permissions CodeBuild needs to run a build for AWS Proton CodeBuild Provisioning. */
    AWSProtonCodeBuildProvisioningBasicAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonCodeBuildProvisioningBasicAccess);
    }
    /** Allows AWS Proton to manage Proton resource provisioning using CodeBuild and other AWS services on your behalf. */
    AWSProtonCodeBuildProvisioningServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonCodeBuildProvisioningServiceRolePolicy);
    }
    /** Provides access to the AWS Proton APIs and Management Console, but does not allow administration of Proton templates or environments. */
    AWSProtonDeveloperAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonDeveloperAccess);
    }
    /** Provides full access to the AWS Proton APIs and Management Console. In addition to these permissions, access to Amazon S3 is also needed to register template bundles from your S3 buckets, as well as access to Amazon IAM to create and manage the service roles for Proton. */
    AWSProtonFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonFullAccess);
    }
    /** Provides read only access to the AWS Proton APIs and Management Console. */
    AWSProtonReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonReadOnlyAccess);
    }
    /** Policy which allows AWS Proton to sync your service, environment and component definitions from your git repository to AWS Proton. */
    AWSProtonServiceGitSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonServiceGitSyncServiceRolePolicy);
    }
    /** Policy which allows AWS Proton to sync your git repository contents to Proton or sync Proton contents to your git repositories. */
    AWSProtonSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonSyncServiceRolePolicy);
    }
    /** Grants permissions to view and modify purchase orders on billing console */
    AWSPurchaseOrdersServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPurchaseOrdersServiceRolePolicy);
    }
    /** The AWSQuickSetupCFGCPacksPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to deploy AWS Config conformance packs. */
    AWSQuickSetupCFGCPacksPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupCFGCPacksPermissionsBoundary);
    }
    /** Provides permissions for AWS Systems Manager Quick Setup to deploy multiple configuration types. These configuration types create IAM roles and automations that configure frequently used Amazon Web Services services and features with recommended best practices. */
    AWSQuickSetupDeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupDeploymentRolePolicy);
    }
    /** The AWSQuickSetupDevOpsGuruPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure Amazon DevOps Guru. This policy also provides permissions to enable Systems Manager Explorer. */
    AWSQuickSetupDevOpsGuruPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupDevOpsGuruPermissionsBoundary);
    }
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Distributor feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupDistributorPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupDistributorPermissionsBoundary);
    }
    /** This policy grants permissions that allow Systems Manager to run the AWSQuickSetupType-EnableAREX Automation runbook, which enables AWS Resource Explorer for use with Systems Manager. */
    AWSQuickSetupEnableAREXExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupEnableAREXExecutionPolicy);
    }
    /** This policy grants permissions that allow principals to run the AWSQuickSetupType-EnableDHMC Automation runbook, which enables Default Host Management Configuration. */
    AWSQuickSetupEnableDHMCExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupEnableDHMCExecutionPolicy);
    }
    /** This policy allows Quick Setup to deploy the configuration type required to set up just-in-time node access. */
    AWSQuickSetupJITNADeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupJITNADeploymentRolePolicy);
    }
    /** This policy grants administrative permissions that allow Systems Manager to create a default IAM instance profile for the Quick Setup capability and attach it to Amazon EC2 instances that don't already have an instance. profile attached. */
    AWSQuickSetupManagedInstanceProfileExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupManagedInstanceProfileExecutionPolicy);
    }
    /** This policy provides permissions to enable just-in-time node access for Systems Manager. */
    AWSQuickSetupManageJITNAResourcesExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupManageJITNAResourcesExecutionPolicy);
    }
    /** Provides read-only permissions to access patch baselines that have been configured by an administrator in the current AWS account or organization using Quick Setup. */
    AWSQuickSetupPatchPolicyBaselineAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupPatchPolicyBaselineAccess);
    }
    /** Provides permissions that allow Quick Setup to create resources associated with a patch policy configuration. */
    AWSQuickSetupPatchPolicyDeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupPatchPolicyDeploymentRolePolicy);
    }
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Patch Manager feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupPatchPolicyPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupPatchPolicyPermissionsBoundary);
    }
    /** The AWSQuickSetupSchedulerPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure scheduled operations on Amazon EC2 instances and other resources. */
    AWSQuickSetupSchedulerPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSchedulerPermissionsBoundary);
    }
    /** This policy grants administrative permssions that allow Quick Setup to create resources that are used during the Systems Manager onboarding process. */
    AWSQuickSetupSSMDeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMDeploymentRolePolicy);
    }
    /** This policy grants permissions for listing all S3 buckets in an account; and for managing and retrieving information about specific buckets in the principal account that are managed through AWS CloudFormation templates. */
    AWSQuickSetupSSMDeploymentS3BucketRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMDeploymentS3BucketRolePolicy);
    }
    /** Quick Setup creates IAM roles which enable it to configure the Host Manager Quick Setup type on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupSSMHostMgmtPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMHostMgmtPermissionsBoundary);
    }
    /** The policy grants administrative permissions that allow Quick Setup to run the a AWS CloudFormation custom resource on lifecycle events during Quick Setup deployment in Systems Manager. */
    AWSQuickSetupSSMLifecycleManagementExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMLifecycleManagementExecutionPolicy);
    }
    /** This policy grants permissions that allow Systems Manager to create prerequisites such as IAM roles required for Systems Manager onboarding. */
    AWSQuickSetupSSMManageResourcesExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMManageResourcesExecutionPolicy);
    }
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Export Operations */
    AWSQuickSightAssetBundleExportPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightAssetBundleExportPolicy);
    }
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Import Operations */
    AWSQuickSightAssetBundleImportPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightAssetBundleImportPolicy);
    }
    /** Quicksight access to Athena API and S3 buckets used for Athena query results */
    AWSQuicksightAthenaAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuicksightAthenaAccess);
    }
    /** Allow QuickSight to describe the RDS resources */
    AWSQuickSightDescribeRDS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightDescribeRDS);
    }
    /** Allow QuickSight to describe Redshift resources */
    AWSQuickSightDescribeRedshift() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightDescribeRedshift);
    }
    /** Provides access to Amazon Elasticsearch resources from Amazon QuickSight */
    AWSQuickSightElasticsearchPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightElasticsearchPolicy);
    }
    /** Give QuickSight read-only access to IoT Analytics datasets */
    AWSQuickSightIoTAnalyticsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightIoTAnalyticsAccess);
    }
    /** Allow QuickSight to list IAM entities */
    AWSQuickSightListIAM() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightListIAM);
    }
    /** Provides access to Amazon OpenSearch resources from Amazon QuickSight */
    AWSQuicksightOpenSearchPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuicksightOpenSearchPolicy);
    }
    /** Provides access to Amazon SageMaker resources from Amazon QuickSight */
    AWSQuickSightSageMakerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightSageMakerPolicy);
    }
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    AWSQuickSightSecretsManagerWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightSecretsManagerWriteAccess);
    }
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    AWSQuickSightSecretsManagerWritePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightSecretsManagerWritePolicy);
    }
    /** AWS QuickSight access to AWS Timestream APIs. Customers can attach this policy to AWS QuickSight role to allow retrieval of data and metadata. */
    AWSQuickSightTimestreamPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightTimestreamPolicy);
    }
    /** Allows VPC Reachability Analyzer to access AWS resources and integrate with AWS Organizations on your behalf. */
    AWSReachabilityAnalyzerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSReachabilityAnalyzerServiceRolePolicy);
    }
    /** This policy grants permission to use AWS services with the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. It is intended to be attached to a local AWS profile. The policy allows uploading application artifacts and downloading the resulting artifacts from Amazon S3. It allows building applications into a container image using AWS CodeBuild and storing and retrieving the images from Amazon Elastic Container Registry (Amazon ECR). And it allows deployment of the application to container services on AWS such as Amazon Elastic Container Service (Amazon ECS), optional creation of VPC resources, optional connection to existing infrastructure such as AWS Directory Service, and other related services. */
    AWSRefactoringToolkitFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRefactoringToolkitFullAccess);
    }
    /** This policy is intended to be used by Amazon ECS Tasks created for testing applications in AWS using the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. The policy grants access to download application artifacts from Amazon S3, communicate the status of the Task using AWS Systems Manager, and other required services. */
    AWSRefactoringToolkitSidecarPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRefactoringToolkitSidecarPolicy);
    }
    /** Provides re:Post Private access to publish CloudWatch metrics data */
    AWSrePostPrivateCloudWatchAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSrePostPrivateCloudWatchAccess);
    }
    /** This policy allows the re:Post Space service to create, manage, and resolve Support cases that are created through the Space application. */
    AWSRepostSpaceSupportOperationsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRepostSpaceSupportOperationsPolicy);
    }
    /** Policy for AWS Resilience Hub service role which allows access to other AWS services in order to execute assessment. */
    AWSResilienceHubAsssessmentExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResilienceHubAsssessmentExecutionPolicy);
    }
    /** Provides full access to AWS Resource Access Manager */
    AWSResourceAccessManagerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerFullAccess);
    }
    /** Provides read only access to AWS Resource Access Manager. */
    AWSResourceAccessManagerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerReadOnlyAccess);
    }
    /** Provides access to AWS Resource Access Manager APIs needed by a resource share participant. */
    AWSResourceAccessManagerResourceShareParticipantAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerResourceShareParticipantAccess);
    }
    /** Policy containing Read-only AWS Resource Access Manager access to customers' Organizations structure. It also contains IAM permissions to self-delete the role. */
    AWSResourceAccessManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerServiceRolePolicy);
    }
    /** This policy grants administrative permissions to access Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    AWSResourceExplorerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerFullAccess);
    }
    /** This policy grants administrative permissions to Resource Explorer and grants read-only permissions to other AWS services to support this access. The AWS Organizations administrator needs these permissions to setup and manage multi-account search in the console. */
    AWSResourceExplorerOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerOrganizationsAccess);
    }
    /** This policy grants read-only permissions to search for and view Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    AWSResourceExplorerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerReadOnlyAccess);
    }
    /** Allows Resource Explorer to view resources and CloudTrail events on your behalf to index your resources for search. */
    AWSResourceExplorerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerServiceRolePolicy);
    }
    /** This is the read only policy for AWS Resource Groups */
    AWSResourceGroupsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceGroupsReadOnlyAccess);
    }
    /** Provides full access to AWS RoboMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, IAM). */
    AWSRoboMakerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerFullAccess);
    }
    /** Provides read only access to AWS RoboMaker via the AWS Management Console and SDK */
    AWSRoboMakerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerReadOnlyAccess);
    }
    /** RoboMaker service policy */
    AWSRoboMakerServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerServicePolicy);
    }
    /** RoboMaker service policy */
    AWSRoboMakerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerServiceRolePolicy);
    }
    /** Allows IAM Roles Anywhere to publish service/usage metrics to CloudWatch and check the status of Private Certificate Authorities on your behalf. */
    AWSRolesAnywhereServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRolesAnywhereServicePolicy);
    }
    /** Allow Amazon S3 on Outposts service to manage EC2 network resources on your behalf. */
    AWSS3OnOutpostsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSS3OnOutpostsServiceRolePolicy);
    }
    /** Provides full access to Savings Plans service */
    AWSSavingsPlansFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSavingsPlansFullAccess);
    }
    /** Provides read only access to Savings Plans service */
    AWSSavingsPlansReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSavingsPlansReadOnlyAccess);
    }
    /** Provides full access to use AWS Security Hub. */
    AWSSecurityHubFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubFullAccess);
    }
    /** Grants permission to enable and manage AWS Security Hub within an organization. Includes enabling the service across the organization, and determining the delegated administrator account for the service. */
    AWSSecurityHubOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubOrganizationsAccess);
    }
    /** Provides read only access to AWS Security Hub resources */
    AWSSecurityHubReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubReadOnlyAccess);
    }
    /** A service-linked role required for AWS Security Hub to access your resources. */
    AWSSecurityHubServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubServiceRolePolicy);
    }
    /** This policy allows Security Hub to manage AWS Config rules and Security Hub resources in your organization and on your behalf. */
    AWSSecurityHubV2ServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubV2ServiceRolePolicy);
    }
    /** Policy provides customers with Read and Write permissions to case resources that are created through the Security Incident Response service. */
    AWSSecurityIncidentResponseCaseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseCaseFullAccess);
    }
    /** Policy provides customers with Read and Write permissions to all resources associated to the Security Incident Response service. */
    AWSSecurityIncidentResponseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseFullAccess);
    }
    /** Policy provides customers with Read-only permissions to all resources associated to the Security Incident Response service. Permission includes access to GetCaseAttachmentDownloadUrl as well for the ability to get case attachment download URLs. */
    AWSSecurityIncidentResponseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseReadOnlyAccess);
    }
    /** Provides access to AWS Resources managed or used by Security Incident Response */
    AWSSecurityIncidentResponseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseServiceRolePolicy);
    }
    /** Provides access to AWS Security Incident Response to continuously monitor your environment for security threats, tune security services to reduce alert noise, and gather information to investigate potential incidents. */
    AWSSecurityIncidentResponseTriageServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseTriageServiceRolePolicy);
    }
    /** Provides full access to service catalog admin capabilities */
    AWSServiceCatalogAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAdminFullAccess);
    }
    /** Provides read-only access to Service Catalog admin capabilities */
    AWSServiceCatalogAdminReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAdminReadOnlyAccess);
    }
    /** Provides full access to Service Catalog App Registry capabilities */
    AWSServiceCatalogAppRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAppRegistryFullAccess);
    }
    /** Provides read-only access to Service Catalog App Registry capabilites */
    AWSServiceCatalogAppRegistryReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAppRegistryReadOnlyAccess);
    }
    /** Allows Service Catalog AppRegistry to manage Resource Groups on your behalf */
    AWSServiceCatalogAppRegistryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAppRegistryServiceRolePolicy);
    }
    /** Provides full access to service catalog enduser capabilities */
    AWSServiceCatalogEndUserFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogEndUserFullAccess);
    }
    /** Provides read-only access to Service Catalog end-user capabilities */
    AWSServiceCatalogEndUserReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogEndUserReadOnlyAccess);
    }
    /** A Service Linked Role Policy for AWS ServiceCatalog to sync with AWS Organizations organization structure */
    AWSServiceCatalogOrgsDataSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogOrgsDataSyncServiceRolePolicy);
    }
    /** A Service Linked Role for AWS ServiceCatalog to sync Provisioning Artifacts from source repositories */
    AWSServiceCatalogSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogSyncServiceRolePolicy);
    }
    /** Permissions required for managing nodegroups in the customer's account. These policies related to management of the following resources: AutoscalingGroups, SecurityGroups, LaunchTemplates and InstanceProfiles. */
    AWSServiceRoleForAmazonEKSNodegroup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForAmazonEKSNodegroup);
    }
    /** This Service Linked Role provides Amazon Q Developer ability to provide usage information. */
    AWSServiceRoleForAmazonQDeveloper() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForAmazonQDeveloper);
    }
    /** This Service-Linked Role provides AWS Transform with the ability to provide usage information. */
    AWSServiceRoleForAWSTransform() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForAWSTransform);
    }
    /** Provides access to Systems Manager resources used by CloudWatch Alarms */
    AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy);
    }
    /** Allows CloudWatch to access RDS Performance Insights metrics on your behalf */
    AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy);
    }
    /** A service-linked role required for Amazon CodeGuru Profiler to send notifications on your behalf. */
    AWSServiceRoleForCodeGuruProfiler() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCodeGuruProfiler);
    }
    /** This role grants permissions to CodeWhisperer to access data in your account to calculate billing, provides access to create and access security reports in Amazon CodeGuru, and emit data to CloudWatch. */
    AWSServiceRoleForCodeWhispererPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCodeWhispererPolicy);
    }
    /** Allows EC2 Scheduled Instances to launch and manage spot instances. */
    AWSServiceRoleForEC2ScheduledInstances() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForEC2ScheduledInstances);
    }
    /** AWS GroundStation uses this service-linked role to invoke EC2 to find public IPv4 addresses */
    AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy);
    }
    /** Allows EC2ImageBuilder to call AWS services on your behalf. */
    AWSServiceRoleForImageBuilder() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForImageBuilder);
    }
    /** Allows AWS IoT SiteWise to provision and manage gateways as well as query data. The policy includes required AWS Greengrass permissions for deploying to groups, AWS Lambda permissions for creating and updating service-prefixed functions, and AWS IoT Analytics permissions for querying data from datastores. */
    AWSServiceRoleForIoTSiteWise() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForIoTSiteWise);
    }
    /** Allows Log Delivery service to deliver logs by calling log destination on your behalf. */
    AWSServiceRoleForLogDeliveryPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForLogDeliveryPolicy);
    }
    /** Grants Amazon Monitron permissions to manage AWS resources, including AWS SSO user assignment on your behalf. */
    AWSServiceRoleForMonitronPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForMonitronPolicy);
    }
    /** Provides Cloudwatch access to publish operational and usage metrics and logs for Amazon Neptune */
    AWSServiceRoleForNeptuneGraphPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForNeptuneGraphPolicy);
    }
    /** Provides permissions to describe and update Private Marketplace resources and describe AWS Organizations */
    AWSServiceRoleForPrivateMarketplaceAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForPrivateMarketplaceAdminPolicy);
    }
    /** Policy for Procurement Insights to obtain Organization Account details */
    AWSServiceRoleForProcurementInsightsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForProcurementInsightsPolicy);
    }
    /** Provides access to AWS services and resources necessary to migrate service instances into AWS including EC2, S3 and Cloudformation. */
    AWSServiceRoleForSMS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForSMS);
    }
    /** Provides access to the User Subscriptions service to your Identity Center resources to automatically update your subscriptions. */
    AWSServiceRoleForUserSubscriptions() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForUserSubscriptions);
    }
    /** Provides AWS Backup permissions to create compliance reports on your behalf */
    AWSServiceRolePolicyForBackupReports() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRolePolicyForBackupReports);
    }
    /** This policy contains permissions for testing restores and for cleaning up resources created during tests. */
    AWSServiceRolePolicyForBackupRestoreTesting() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRolePolicyForBackupRestoreTesting);
    }
    /** This managed policy provides administrative access to Amazon WorkSpaces to manage EC2 instances in your AWS account */
    AWSServiceRolePolicyForWorkspacesInstances() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRolePolicyForWorkspacesInstances);
    }
    /** Provides the AWS DDoS Response Team with limited access to your AWS account to assist with DDoS attack mitigation during a high-severity event. */
    AWSShieldDRTAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSShieldDRTAccessPolicy);
    }
    /** Allows AWS Shield to access AWS resources on your behalf to provide DDoS protection. */
    AWSShieldServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSShieldServiceRolePolicy);
    }
    /** Provides access to publish metrics and provide insights for your social message sending. */
    AWSSocialMessagingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSocialMessagingServiceRolePolicy);
    }
    /** Provides AWS Systems Manager for SAP with the permissions needed to manage and integrate SAP software with AWS. */
    AWSSSMForSAPServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMForSAPServiceLinkedRolePolicy);
    }
    /** Policy for Service Linked Role AWSServiceRoleForAmazonSSM_OpsInsights */
    AWSSSMOpsInsightsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMOpsInsightsServiceRolePolicy);
    }
    /** Administrator access for SSO Directory */
    AWSSSODirectoryAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSODirectoryAdministrator);
    }
    /** ReadOnly access for SSO Directory */
    AWSSSODirectoryReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSODirectoryReadOnly);
    }
    /** Provides access within AWS SSO to manage AWS Organizations master and member accounts and cloud application */
    AWSSSOMasterAccountAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOMasterAccountAdministrator);
    }
    /** Provides access within AWS SSO to manage AWS Organizations member accounts and cloud application */
    AWSSSOMemberAccountAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOMemberAccountAdministrator);
    }
    /** Provides read only access to AWS SSO configurations. */
    AWSSSOReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOReadOnly);
    }
    /** Grants AWS SSO permissions to manage AWS resources, including IAM roles, policies and SAML IdP on your behalf. */
    AWSSSOServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOServiceRolePolicy);
    }
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions console. For a full console experience, in addition to this policy, a user may need iam:PassRole permission on other IAM roles that can be assumed by the service. */
    AWSStepFunctionsConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStepFunctionsConsoleFullAccess);
    }
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions API. For full access, in addition to this policy, a user MUST have iam:PassRole permission on at least one IAM role that can be assumed by the service. */
    AWSStepFunctionsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStepFunctionsFullAccess);
    }
    /** An access policy for providing a user/role/etc read only access to the AWS StepFunctions service. */
    AWSStepFunctionsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStepFunctionsReadOnlyAccess);
    }
    /** Provides full access to AWS Storage Gateway via the AWS Management Console. */
    AWSStorageGatewayFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStorageGatewayFullAccess);
    }
    /** Provides access to AWS Storage Gateway via the AWS Management Console. */
    AWSStorageGatewayReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStorageGatewayReadOnlyAccess);
    }
    /** Service-linked role used by AWS Storage Gateway to enable integration of other AWS services with Storage Gateway. */
    AWSStorageGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStorageGatewayServiceRolePolicy);
    }
    /** AWSSupplyChainFederationAdminAccess provides AWS Supply Chain federated users access to the AWS Supply Chain application, including the required permissions to perform actions within the AWS Supply Chain application. The policy provides administrative permissions over IAM Identity Center users and groups and is attached to a role created by AWS Supply Chain on your behalf. You shouldn't attach AWSSupplyChainFederationAdminAccess policy to any other IAM entities. */
    AWSSupplyChainFederationAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupplyChainFederationAdminAccess);
    }
    /** Allows users to access the AWS Support Center. */
    AWSSupportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportAccess);
    }
    /** Provides full access to the AWS Support App and other required services, such as AWS Support and Service Quotas. This policy includes permissions to use the supporting services so that the user can contact AWS Support for support cases, change service quotas, and create the relevant service-linked roles. */
    AWSSupportAppFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportAppFullAccess);
    }
    /** Provides read-only access to the AWS Support App. */
    AWSSupportAppReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportAppReadOnlyAccess);
    }
    /** Provides full access to supportplans. */
    AWSSupportPlansFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportPlansFullAccess);
    }
    /** Provides read-only access to supportplans. */
    AWSSupportPlansReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportPlansReadOnlyAccess);
    }
    /** Allows AWS Support to access AWS resources to provide billing, administrative, and support services. */
    AWSSupportServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportServiceRolePolicy);
    }
    /** Grants AWS Systems Manager (SSM) permission to discover AWS account information. */
    AWSSystemsManagerAccountDiscoveryServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerAccountDiscoveryServicePolicy);
    }
    /** Provides access to AWS resources managed or used by the AWS Systems Manager change management framework. */
    AWSSystemsManagerChangeManagementServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerChangeManagementServicePolicy);
    }
    /** Provides permissions for AWS Systems Manager Quick Setup to enable and configure AWS Config configuration recording. */
    AWSSystemsManagerEnableConfigRecordingExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerEnableConfigRecordingExecutionPolicy);
    }
    /** This policy grants administrative permissions for enabling Explorer, a capability of AWS Systems Manager. This includes permissions to update related Systems Manager service settings, and to create a service-linked role for Systems Manager. */
    AWSSystemsManagerEnableExplorerExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerEnableExplorerExecutionPolicy);
    }
    /** Provides full access to AWS Systems Manager for SAP service */
    AWSSystemsManagerForSAPFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerForSAPFullAccess);
    }
    /** Provides read only access to AWS Systems Manager for SAP service */
    AWSSystemsManagerForSAPReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerForSAPReadOnlyAccess);
    }
    /** Provides access to AWS resources managed or used by the AWS Systems Manager just in time access framework. */
    AWSSystemsManagerJustInTimeAccessServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessServicePolicy);
    }
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenPolicy allows Systems Manager to generate access tokens used for just-in-time node access. */
    AWSSystemsManagerJustInTimeAccessTokenPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenPolicy);
    }
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenSessionPolicy allows Systems Manager to apply scoped down permissions to a just-in-time node access session once it is started. */
    AWSSystemsManagerJustInTimeAccessTokenSessionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenSessionPolicy);
    }
    /** This policy allows Systems Manager to share a deny-access policy for just-in-time node access from the delegated administrator account to member accounts, and replicate the policy to multiple Regions. */
    AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy);
    }
    /** Permissions required to collect information about a user for Just-In-Time-Node-Access notifications. */
    AWSSystemsManagerNotificationsServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerNotificationsServicePolicy);
    }
    /** IAM role for SSM Explorer to manage OpsData related operations */
    AWSSystemsManagerOpsDataSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerOpsDataSyncServiceRolePolicy);
    }
    /** This policy grants the AWS Portal Asset Server the necessary permissions required for normal operation. */
    AWSThinkboxAssetServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAssetServerPolicy);
    }
    /** This policy grants AWS Thinkbox's Deadline software full access to multiple AWS services as required for AWS Portal administration. This includes access to create arbitrary tags on several EC2 resource types. */
    AWSThinkboxAWSPortalAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAWSPortalAdminPolicy);
    }
    /** This policy grants the AWS Portal Gateway machine the necessary permissions required for normal operation. */
    AWSThinkboxAWSPortalGatewayPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAWSPortalGatewayPolicy);
    }
    /** This policy grants the Deadline Workers in AWS Portal the necessary permissions required for normal operation. */
    AWSThinkboxAWSPortalWorkerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAWSPortalWorkerPolicy);
    }
    /** Grants permissions required for the operation of AWS Thinkbox's Deadline Resource Tracker.  This includes full access to some EC2 actions, including DeleteFleets and CancelSpotFleetRequests. */
    AWSThinkboxDeadlineResourceTrackerAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAccessPolicy);
    }
    /** Grants permissions required to create, destroy, and administer AWS Thinkbox's Deadline Resource Tracker. */
    AWSThinkboxDeadlineResourceTrackerAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAdminPolicy);
    }
    /** Grants permissions required for AWS Thinkbox's Deadline Spot Event Plugin.  This includes permission to request, modify, and cancel a spot fleet, as well as limited PassRole permission. */
    AWSThinkboxDeadlineSpotEventPluginAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginAdminPolicy);
    }
    /** Grant permissions required for an EC2 instance running AWS Thinkbox Deadline Spot Event Plugin Worker software. */
    AWSThinkboxDeadlineSpotEventPluginWorkerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginWorkerPolicy);
    }
    /** Provides full access to AWS Transfer via the AWS Management Console */
    AWSTransferConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferConsoleFullAccess);
    }
    /** Provides full access to AWS Transfer Service. */
    AWSTransferFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferFullAccess);
    }
    /** Allows AWS Transfer full access to create log streams and groups and put log events to your account */
    AWSTransferLoggingAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferLoggingAccess);
    }
    /** Provide readonly access to AWS Transfer services. */
    AWSTransferReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferReadOnlyAccess);
    }
    /** Provides full access to AWS Trusted Advisor Priority. This policy also enables the user to add Trusted Advisor as a trusted service with AWS Organizations and to specify delegated administrator accounts for Trusted Advisor Priority. */
    AWSTrustedAdvisorPriorityFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorPriorityFullAccess);
    }
    /** Provides read-only access to AWS Trusted Advisor Priority. This includes permission to view the delegated administrator accounts. */
    AWSTrustedAdvisorPriorityReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorPriorityReadOnlyAccess);
    }
    /** Service Policy for Trusted Advisor Multi-account Reporting */
    AWSTrustedAdvisorReportingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorReportingServiceRolePolicy);
    }
    /** Access for the AWS Trusted Advisor Service to help reduce cost, increase performance, and improve security of your AWS environment. */
    AWSTrustedAdvisorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorServiceRolePolicy);
    }
    /** Allows AWS User Notifications to call AWS services on your behalf. */
    AWSUserNotificationsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSUserNotificationsServiceLinkedRolePolicy);
    }
    /** Provides full access for viewing entitled Vendor Insights resources and managing Vendor Insights subscriptions */
    AWSVendorInsightsAssessorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsAssessorFullAccess);
    }
    /** Provides read-only access for viewing entitled Vendor Insights resources */
    AWSVendorInsightsAssessorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsAssessorReadOnly);
    }
    /** Provides full access for creating and managing the Vendor Insights resources */
    AWSVendorInsightsVendorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsVendorFullAccess);
    }
    /** Provides read-only access for viewing the Vendor Insights resources */
    AWSVendorInsightsVendorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsVendorReadOnly);
    }
    /** Allows VPC Lattice to access AWS resources on your behalf. */
    AWSVpcLatticeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVpcLatticeServiceRolePolicy);
    }
    /** Allow Site-to-Site VPN to create and manage resources related to your VPN Connections. */
    AWSVPCS2SVpnServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVPCS2SVpnServiceRolePolicy);
    }
    /** Allow VPC Transit Gateway to create and manage necessary resources for your Transit Gateway VPC Attachments. */
    AWSVPCTransitGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVPCTransitGatewayServiceRolePolicy);
    }
    /** Policy to enable AWS Verified Access service to provision endpoints on your behalf */
    AWSVPCVerifiedAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVPCVerifiedAccessServiceRolePolicy);
    }
    /** Provides full access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list and update Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    AWSWAFConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFConsoleFullAccess);
    }
    /** Provides read-only access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    AWSWAFConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFConsoleReadOnlyAccess);
    }
    /** Provides full access to AWS WAF actions. */
    AWSWAFFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFFullAccess);
    }
    /** Provides read only access to AWS WAF actions. */
    AWSWAFReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFReadOnlyAccess);
    }
    /** Allows WellArchitected to access AWS services and resources that relate to WellArchitected resources on behalf of customers. */
    AWSWellArchitectedDiscoveryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWellArchitectedDiscoveryServiceRolePolicy);
    }
    /** Allows Well-Architected to access Organizations on your behalf. */
    AWSWellArchitectedOrganizationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWellArchitectedOrganizationsServiceRolePolicy);
    }
    /** This policy grants full administrative permissions to the Wickr service, including the Wickr administrative functions under the AWS Management Console. */
    AWSWickrFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWickrFullAccess);
    }
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of X-Ray traces */
    AWSXrayCrossAccountSharingConfiguration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayCrossAccountSharingConfiguration);
    }
    /** Allow the AWS X-Ray Daemon to relay raw trace segments data to the service's API and retrieve sampling data (rules, targets, etc.) to be used by the X-Ray SDK. */
    AWSXRayDaemonWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXRayDaemonWriteAccess);
    }
    /** AWS X-Ray full access managed policy */
    AWSXrayFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayFullAccess);
    }
    /** AWS X-Ray read only managed policy */
    AWSXrayReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayReadOnlyAccess);
    }
    /** AWS X-Ray write only managed policy */
    AWSXrayWriteOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayWriteOnlyAccess);
    }
    /** Provides administrative access for ARC zonal shift practice runs, and access to CloudWatch alarm statuses to monitor practice runs. */
    AWSZonalAutoshiftPracticeRunSLRPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSZonalAutoshiftPracticeRunSLRPolicy);
    }
    /** Provides access for the AWS Batch service to manage the required resources, including Amazon EC2 and Amazon ECS resources. */
    BatchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.BatchServiceRolePolicy);
    }
    /** Grants permissions for billing and cost management. This includes viewing account usage and viewing and modifying budgets and payment methods. */
    Billing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Billing);
    }
    /** Amazon Certificate Manager Service Role Policy */
    CertificateManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CertificateManagerServiceRolePolicy);
    }
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoint connections. */
    ClientVPNServiceConnectionsRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ClientVPNServiceConnectionsRolePolicy);
    }
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoints. */
    ClientVPNServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ClientVPNServiceRolePolicy);
    }
    /** Service Role for CloudFormation StackSets (Organization Master Account) */
    CloudFormationStackSetsOrgAdminServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFormationStackSetsOrgAdminServiceRolePolicy);
    }
    /** Service Role for CloudFormation StackSets (Organization Member Account) */
    CloudFormationStackSetsOrgMemberServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFormationStackSetsOrgMemberServiceRolePolicy);
    }
    /** Provides full access to the CloudFront console plus the ability to list Amazon S3 buckets via the AWS Management Console. */
    CloudFrontFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFrontFullAccess);
    }
    /** Provides access to CloudFront distribution configuration information and list distributions via the AWS Management Console. */
    CloudFrontReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFrontReadOnlyAccess);
    }
    /** Enables access to AWS resources used or managed by CloudHSM */
    CloudHSMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudHSMServiceRolePolicy);
    }
    /** Provides full access to the Amazon CloudSearch configuration service. */
    CloudSearchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudSearchFullAccess);
    }
    /** Provides read only access to the Amazon CloudSearch configuration service. */
    CloudSearchReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudSearchReadOnlyAccess);
    }
    /** This service linked role allows CloudTrail to get and add resource tags to the resource owner's CloudTrail events. */
    CloudTrailEventContext() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudTrailEventContext);
    }
    /** Permission policy for CloudTrail ServiceLinkedRole */
    CloudTrailServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudTrailServiceRolePolicy);
    }
    /** Allows CloudWatch to assume CloudWatch-CrossAccountSharing roles in remote accounts on behalf of the current account in order to display data cross-account, cross-region */
    CloudWatchCrossAccountAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchCrossAccountAccess);
    }
    /** Provides read-only access to CloudWatch alarms and metrics as well as EC2 metadata. Provides access to Stop, Terminate and Reboot EC2 instances. */
    CloudWatchActionsEC2Access() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchActionsEC2Access);
    }
    /** Full permissions required to use AmazonCloudWatchAgent. */
    CloudWatchAgentAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchAgentAdminPolicy);
    }
    /** Permissions required to use AmazonCloudWatchAgent on servers */
    CloudWatchAgentServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchAgentServerPolicy);
    }
    /** Provides full access to CloudWatch Application Insights and required dependencies. */
    CloudWatchApplicationInsightsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationInsightsFullAccess);
    }
    /** Provides read only access to CloudWatch Application Insights. */
    CloudWatchApplicationInsightsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationInsightsReadOnlyAccess);
    }
    /** Cloudwatch Application Insights Service Linked Role Policy */
    CloudwatchApplicationInsightsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudwatchApplicationInsightsServiceLinkedRolePolicy);
    }
    /** Provide full access to CloudWatch Application Signals service and scoped access to the dependencies needed to use and operate this service. */
    CloudWatchApplicationSignalsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationSignalsFullAccess);
    }
    /** Provides read only access to CloudWatch Application Signals service and scoped access to the dependencies needed to use this service */
    CloudWatchApplicationSignalsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationSignalsReadOnlyAccess);
    }
    /** Policy grants permission to CloudWatch Application Signals to collect monitoring and tagging data from other relevant AWS services. */
    CloudWatchApplicationSignalsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationSignalsServiceRolePolicy);
    }
    /** Provides access to the non-CloudWatch APIs used to display CloudWatch Automatic Dashboards, including the contents of objects such as Lambda functions */
    CloudWatchAutomaticDashboardsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchAutomaticDashboardsAccess);
    }
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch resources */
    CloudWatchCrossAccountSharingConfiguration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchCrossAccountSharingConfiguration);
    }
    /** Allows built-in targets in Amazon CloudWatch Events to perform EC2 actions on your behalf. */
    CloudWatchEventsBuiltInTargetExecutionAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsBuiltInTargetExecutionAccess);
    }
    /** Provides full access to Amazon CloudWatch Events. */
    CloudWatchEventsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsFullAccess);
    }
    /** Allows Amazon CloudWatch Events to relay events to the streams in AWS Kinesis Streams in your account. */
    CloudWatchEventsInvocationAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsInvocationAccess);
    }
    /** Provides read only access to Amazon CloudWatch Events. */
    CloudWatchEventsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsReadOnlyAccess);
    }
    /** Allow AWS CloudWatch to execute actions on your behalf configured through alarms and events. */
    CloudWatchEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsServiceRolePolicy);
    }
    /** Provides full access to CloudWatch. */
    CloudWatchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchFullAccess);
    }
    /** Provides full access to CloudWatch. */
    CloudWatchFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchFullAccessV2);
    }
    /** Provides full access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services, such as Amazon CloudWatch, Amazon EC2, Amazon CloudFront, Amazon WorkSpaces, and Elastic Load Balancing, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    CloudWatchInternetMonitorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchInternetMonitorFullAccess);
    }
    /** Provides read only access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services in Amazon CloudWatch, including policies to retrieve information on CloudWatch metrics and to manage log queries, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    CloudWatchInternetMonitorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchInternetMonitorReadOnlyAccess);
    }
    /** Allows Internet Monitor to access EC2, Workspaces, and CloudFront resources, and other required services on your behalf. */
    CloudWatchInternetMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchInternetMonitorServiceRolePolicy);
    }
    /** Provides write access to X-Ray and CloudWatch Application Signals log group. */
    CloudWatchLambdaApplicationSignalsExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLambdaApplicationSignalsExecutionRolePolicy);
    }
    /** Policy required for the Lambda Insights Extension */
    CloudWatchLambdaInsightsExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLambdaInsightsExecutionRolePolicy);
    }
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch Logs resources */
    CloudWatchLogsCrossAccountSharingConfiguration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLogsCrossAccountSharingConfiguration);
    }
    /** Provides full access to CloudWatch Logs */
    CloudWatchLogsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLogsFullAccess);
    }
    /** Provides read only access to CloudWatch Logs */
    CloudWatchLogsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLogsReadOnlyAccess);
    }
    /** You can use this policy in IAM roles that are attached to Amazon EC2 and Amazon EKS instance resources to send telemetry reports (metrics) to a Network Flow Monitor endpoint. */
    CloudWatchNetworkFlowMonitorAgentPublishPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkFlowMonitorAgentPublishPolicy);
    }
    /** You can't attach CloudWatchNetworkFlowMonitorServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor, which publishes network telemetry aggregation results, collected by Network Flow Monitor agents, to CloudWatch. It also allows the service to use AWS Organizations to get information for multi-account scenarios. */
    CloudWatchNetworkFlowMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkFlowMonitorServiceRolePolicy);
    }
    /** You can't attach CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor_Topology, which generates topology snapshots of resources used by Network Flow Monitor in your account. */
    CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy);
    }
    /** Allows CloudWatch Network Monitor to access and manage EC2 and VPC resources, publish data to CloudWatch and access other required services on your behalf. */
    CloudWatchNetworkMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkMonitorServiceRolePolicy);
    }
    /** This policy provides user access to view OpenSearch dashboards on the CloudWatch Logs console. */
    CloudWatchOpenSearchDashboardAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchOpenSearchDashboardAccess);
    }
    /** This policy provides user access to create integration with OpenSearch to create, update, delete or view dashboards on the CloudWatch Logs console. */
    CloudWatchOpenSearchDashboardsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchOpenSearchDashboardsFullAccess);
    }
    /** Provides read only access to CloudWatch. */
    CloudWatchReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchReadOnlyAccess);
    }
    /** Provides full access to CloudWatch Synthetics. */
    CloudWatchSyntheticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchSyntheticsFullAccess);
    }
    /** Provides read only access to CloudWatch Synthetics. */
    CloudWatchSyntheticsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchSyntheticsReadOnlyAccess);
    }
    /** Policy for AWS Comprehend service role which allows access to S3 resources for data access */
    ComprehendDataAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendDataAccessRolePolicy);
    }
    /** Provides full access to Amazon Comprehend. */
    ComprehendFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendFullAccess);
    }
    /** Provides full access to Amazon Comprehend Medical */
    ComprehendMedicalFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendMedicalFullAccess);
    }
    /** Provides read-only access to Amazon Comprehend. */
    ComprehendReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendReadOnly);
    }
    /** Provides read only access to ComputeOptimizer. */
    ComputeOptimizerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComputeOptimizerReadOnlyAccess);
    }
    /** Allows ComputeOptimizer to call AWS services and collect workload details on your behalf. */
    ComputeOptimizerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComputeOptimizerServiceRolePolicy);
    }
    /** Policy needed for AWSConfig to create conformance packs */
    ConfigConformsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ConfigConformsServiceRolePolicy);
    }
    /** This managed policy provides admin access to Cost Optimization Hub. */
    CostOptimizationHubAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CostOptimizationHubAdminAccess);
    }
    /** This managed policy provides read-only access to Cost Optimization Hub. */
    CostOptimizationHubReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CostOptimizationHubReadOnlyAccess);
    }
    /** Allows Cost Optimization Hub to retrieve organization information and collect optimization-related data and metadata. */
    CostOptimizationHubServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CostOptimizationHubServiceRolePolicy);
    }
    /** Allows Amazon Connect Customer Profiles to access AWS services and resources on your behalf. */
    CustomerProfilesServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CustomerProfilesServiceLinkedRolePolicy);
    }
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS database services. */
    DatabaseAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DatabaseAdministrator);
    }
    /** Grants permissions to AWS data analytics services. */
    DataScientist() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DataScientist);
    }
    /** This policy allows DAX to create and manage Network interface, Security group, Subnet and Vpc on behalf of customer */
    DAXServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DAXServiceRolePolicy);
    }
    /** Provides access to read-only APIs needed to run EC2 Declarative Policies Account Status Report. */
    DeclarativePoliciesEC2Report() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DeclarativePoliciesEC2Report);
    }
    /** Permissions required to support Amazon CloudWatch Contributor Insights for Amazon DynamoDB. */
    DynamoDBCloudWatchContributorInsightsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DynamoDBCloudWatchContributorInsightsServiceRolePolicy);
    }
    /** Provide AWS DynamoDB access to KinesisDataStreams */
    DynamoDBKinesisReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DynamoDBKinesisReplicationServiceRolePolicy);
    }
    /** Permissions required by DynamoDB for cross-region data replication */
    DynamoDBReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DynamoDBReplicationServiceRolePolicy);
    }
    /** This policy grants full access to EC2 Fast Launch actions */
    EC2FastLaunchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2FastLaunchFullAccess);
    }
    /** Policy grants ec2fastlaunch to prepare and manage preprovisioned snapshots in customer's account & publish related metrics. */
    EC2FastLaunchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2FastLaunchServiceRolePolicy);
    }
    /** Policy granting permissions to EC2 Fleet to launch instances in the future. */
    EC2FleetTimeShiftableServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2FleetTimeShiftableServiceRolePolicy);
    }
    /** Permissions need by EC2 Image Builder to perform a cross account distribution. */
    Ec2ImageBuilderCrossAccountDistributionAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Ec2ImageBuilderCrossAccountDistributionAccess);
    }
    /** The EC2ImageBuilderLifecycleExecutionPolicy policy grants permissions for Image Builder to perform actions such as deprecate or delete Image Builder image resources and their underlying resources (AMIs, snapshots) to support automated rules for image lifecycle management tasks. */
    EC2ImageBuilderLifecycleExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2ImageBuilderLifecycleExecutionPolicy);
    }
    /** Allows customers to call EC2 Instance Connect to publish ephemeral keys to their EC2 instances and connect via ssh or the EC2 Instance Connect CLI. */
    EC2InstanceConnect() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2InstanceConnect);
    }
    /** EC2 Instance Connect endpoint policy to manage EC2 Instance Connect endpoints created by the customer */
    Ec2InstanceConnectEndpoint() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Ec2InstanceConnectEndpoint);
    }
    /** EC2 Instance profile for Image Builder service. */
    EC2InstanceProfileForImageBuilder() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2InstanceProfileForImageBuilder);
    }
    /** EC2 Instance profile for building container images with EC2 Image Builder. This policy grants the user broad permissions to upload ECR images. */
    EC2InstanceProfileForImageBuilderECRContainerBuilds() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2InstanceProfileForImageBuilderECRContainerBuilds);
    }
    /** Enables access to AWS Services and Resources used or managed by ECR Replication */
    ECRReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ECRReplicationServiceRolePolicy);
    }
    /** Allows actions to be performed when using AWS ECR repository creation templates */
    ECRTemplateServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ECRTemplateServiceRolePolicy);
    }
    /** This policy allows ElastiCache to manage AWS resources on your behalf as necessary for managing your cache */
    ElastiCacheServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElastiCacheServiceRolePolicy);
    }
    /** Provides full access to Amazon ElasticLoadBalancing, and limited access to other services necessary to provide ElasticLoadBalancing features. */
    ElasticLoadBalancingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElasticLoadBalancingFullAccess);
    }
    /** Provides read only access to Amazon ElasticLoadBalancing and dependent services */
    ElasticLoadBalancingReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElasticLoadBalancingReadOnly);
    }
    /** Access to view purchased assets and download related software and kickstart files */
    ElementalActivationsDownloadSoftwareAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsDownloadSoftwareAccess);
    }
    /** Full access to view and take action on Elemental Appliances and Software purchased assets */
    ElementalActivationsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsFullAccess);
    }
    /** Access to view purchased assets and generate software licenses for pending activations */
    ElementalActivationsGenerateLicenses() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsGenerateLicenses);
    }
    /** Read-only access to the detailed list of purchased assets associated to the AWS account of the user */
    ElementalActivationsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsReadOnlyAccess);
    }
    /** Full access to view and take action on Elemental Appliances and Software quotes and orders */
    ElementalAppliancesSoftwareFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalAppliancesSoftwareFullAccess);
    }
    /** Read-only access to view Elemental Appliances and Software quotes and orders */
    ElementalAppliancesSoftwareReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalAppliancesSoftwareReadOnlyAccess);
    }
    /** Full access to view and take action on Elemental Appliance and Software support cases and product support content */
    ElementalSupportCenterFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalSupportCenterFullAccess);
    }
    /** This policy grants read-only permissions that allow the WAL service for Amazon EMR to find and return the status of a cluster */
    EMRDescribeClusterPolicyForEMRWAL() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EMRDescribeClusterPolicyForEMRWAL);
    }
    /** Access policy to allow FM service linked role to perform FM-related actions on FM-managed resources within a customer AWS Organization account. */
    FMSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.FMSServiceRolePolicy);
    }
    /** Allows Amazon FSx to delete its Service Linked Roles for Amazon S3 access */
    FSxDeleteServiceLinkedRoleAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.FSxDeleteServiceLinkedRoleAccess);
    }
    /** Grants the required permissions for compute actions in an Amazon GameLift container fleet, including access to dependencies such as Amazon S3. */
    GameLiftContainerFleetPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GameLiftContainerFleetPolicy);
    }
    /** Policy to allow Gamelift GameServerGroups to manage customer resources */
    GameLiftGameServerGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GameLiftGameServerGroupPolicy);
    }
    /** This managed policy grants permission to connect with Amazon Q and utilize the features in the GitLab Duo with Amazon Q integration. */
    GitLabDuoWithAmazonQPermissionsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GitLabDuoWithAmazonQPermissionsPolicy);
    }
    /** Allow GlobalAccelerator Users full Access to all APIs */
    GlobalAcceleratorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GlobalAcceleratorFullAccess);
    }
    /** Allow GlobalAccelerator Users Access to Read Only APIs */
    GlobalAcceleratorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GlobalAcceleratorReadOnlyAccess);
    }
    /** Provides read access to the Greengrass OTA Update artifacts in all Greengrass regions */
    GreengrassOTAUpdateArtifactAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GreengrassOTAUpdateArtifactAccess);
    }
    /** AWS Health policy to enable Organizational View feature */
    HealthOrganizationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.HealthOrganizationsServiceRolePolicy);
    }
    /** This policy grants access to read all access information provided by IAM access advisor such as service last accessed information. */
    IAMAccessAdvisorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAccessAdvisorReadOnly);
    }
    /** Provides full access to IAM Access Analyzer */
    IAMAccessAnalyzerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAccessAnalyzerFullAccess);
    }
    /** Provides read only access to IAM Access Analyzer resources */
    IAMAccessAnalyzerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAccessAnalyzerReadOnlyAccess);
    }
    /** Provides access required to check the presence of root user credentials such as root user password and root user access keys using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    IAMAuditRootUserCredentials() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAuditRootUserCredentials);
    }
    /** Provides access required to create a root user password using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    IAMCreateRootUserPassword() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMCreateRootUserPassword);
    }
    /** Provides access required to delete all root user credentials such as root password and root access keys using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    IAMDeleteRootUserCredentials() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMDeleteRootUserCredentials);
    }
    /** Provides full access to IAM via the AWS Management Console. */
    IAMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMFullAccess);
    }
    /** Provides read only access to IAM via the AWS Management Console. */
    IAMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMReadOnlyAccess);
    }
    /** Allows an IAM user to manage their own Service Specific Credentials. */
    IAMSelfManageServiceSpecificCredentials() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMSelfManageServiceSpecificCredentials);
    }
    /** Provides the ability for an IAM user to change their own password. */
    IAMUserChangePassword() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMUserChangePassword);
    }
    /** Provides the ability for an IAM user to manage their own SSH keys. */
    IAMUserSSHKeys() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMUserSSHKeys);
    }
    /** Provides full access to Interactive Video Service (IVS), Also included permissions for dependent services, needed for full access to the ivs console. */
    IVSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IVSFullAccess);
    }
    /** Provides read-only access to IVS Low-Latency and Real-Time streaming APIs */
    IVSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IVSReadOnlyAccess);
    }
    /** Service Linked Role to perform S3 PutObject to recording IVS live streams */
    IVSRecordToS3() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IVSRecordToS3);
    }
    /** This policy grants Kafka Connect permission to manage AWS resources on your behalf. */
    KafkaConnectServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KafkaConnectServiceRolePolicy);
    }
    /** IAM service linked role policy for Kafka. */
    KafkaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KafkaServiceRolePolicy);
    }
    /** Grants the required permissions to Amazon Keyspaces for Change Data Capture */
    KeyspacesCDCServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KeyspacesCDCServiceRolePolicy);
    }
    /** Permissions required by Keyspaces for cross-region data replication */
    KeyspacesReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KeyspacesReplicationServiceRolePolicy);
    }
    /** Policy to grant temporary data access to Lake Formation resources */
    LakeFormationDataAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LakeFormationDataAccessServiceRolePolicy);
    }
    /** Policy for AWS Lex Bot use case */
    LexBotPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LexBotPolicy);
    }
    /** Policy for AWS Lex Channel use case */
    LexChannelPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LexChannelPolicy);
    }
    /** AWS Lightsail service linked role policy which grants permissions to export resources */
    LightsailExportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LightsailExportAccess);
    }
    /** This policy grants permission to register MediaConnect Gateway Instances to a MediaConnect Gateway. */
    MediaConnectGatewayInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MediaConnectGatewayInstanceRolePolicy);
    }
    /** Allows MediaPackage to publish logs to CloudWatch */
    MediaPackageServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MediaPackageServiceRolePolicy);
    }
    /** This policy allows MemoryDB to manage AWS resources on your behalf as necessary for managing your resources. */
    MemoryDBServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MemoryDBServiceRolePolicy);
    }
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    MigrationHubDMSAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MigrationHubDMSAccessServiceRolePolicy);
    }
    /** Allows Migration Hub to call Application Discovery Service on your behalf */
    MigrationHubServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MigrationHubServiceRolePolicy);
    }
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    MigrationHubSMSAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MigrationHubSMSAccessServiceRolePolicy);
    }
    /** Policy for AWS Monitron service linked role granting access to required customer resources. */
    MonitronServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MonitronServiceRolePolicy);
    }
    /** Provides full access to Multi-party approval. This policy also includes related permissions to AWS Organizations and AWS IAM Identity for managing approval teams and identity sources. */
    MultiPartyApprovalFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MultiPartyApprovalFullAccess);
    }
    /** Provides read-only access to Multi-party approval. This policy also includes related read permission to AWS Organizations and AWS IAM Identity for approval teams and identity sources. */
    MultiPartyApprovalReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MultiPartyApprovalReadOnlyAccess);
    }
    /** Provides full access to manage Amazon Neptune using the AWS Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneConsoleFullAccess);
    }
    /** Provides full access to Amazon Neptune. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneFullAccess);
    }
    /** Provides read only access to all Amazon Neptune Analytics resources along with read only permissions for dependent services. */
    NeptuneGraphReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneGraphReadOnlyAccess);
    }
    /** Provides read only access to Amazon Neptune. Note that this policy also grants access to Amazon RDS resources. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneReadOnlyAccess);
    }
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS network resources. */
    NetworkAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NetworkAdministrator);
    }
    /** Provides permissions for the AWS Shield network security director service linked role to assess specified environments. */
    NetworkSecurityDirectorServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NetworkSecurityDirectorServiceLinkedRolePolicy);
    }
    /** Provides full access to CloudWatch Observability Access Manager */
    OAMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.OAMFullAccess);
    }
    /** Provides Read Only access to CloudWatch Observability Access Manager */
    OAMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.OAMReadOnlyAccess);
    }
    /** Allows Amazon OpenSearch Ingestion to describe network resources and write service metrics to cloudwatch */
    OpensearchIngestionSelfManagedVpcePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.OpensearchIngestionSelfManagedVpcePolicy);
    }
    /** Provides access to associate and dissociate partner central users with IAM roles */
    PartnerCentralAccountManagementUserRoleAssociation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.PartnerCentralAccountManagementUserRoleAssociation);
    }
    /** Provides full access to AWS services and resources, but does not allow management of Users and groups. */
    PowerUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.PowerUserAccess);
    }
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q Apps. */
    QAppsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QAppsServiceRolePolicy);
    }
    /** Grants permissions to QBusiness to call QuickSight APIs for the QuickSight plugin */
    QBusinessQuicksightPluginPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QBusinessQuicksightPluginPolicy);
    }
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q */
    QBusinessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QBusinessServiceRolePolicy);
    }
    /** Policy used by QuickSight team to access customer data produced by S3 Storage Management Analytics. */
    QuickSightAccessForS3StorageManagementAnalyticsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QuickSightAccessForS3StorageManagementAnalyticsReadOnly);
    }
    /** Default policy for the Amazon RDS service role. */
    RDSCloudHsmAuthorizationRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.RDSCloudHsmAuthorizationRole);
    }
    /** Provides read-only access to AWS services and resources. */
    ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ReadOnlyAccess);
    }
    /** Provides full access to Resource Groups and Tag Editor. */
    ResourceGroupsandTagEditorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsandTagEditorFullAccess);
    }
    /** Provides access to use Resource Groups and Tag Editor, but does not allow editing of tags via the Tag Editor. */
    ResourceGroupsandTagEditorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsandTagEditorReadOnlyAccess);
    }
    /** Allows AWS Resource Groups to query the AWS services that own your resources to keep the group up-to-date */
    ResourceGroupsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsServiceRolePolicy);
    }
    /** Provides permissions to tag and untag all the resources supported by Resource Groups Tagging API. This policy also grants the permissions required to retrieve all tagged, or previously tagged, resources through the Resource Groups Tagging API. */
    ResourceGroupsTaggingAPITagUntagSupportedResources() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsTaggingAPITagUntagSupportedResources);
    }
    /** Allows the OpenShift Amazon EBS Container Storage Interface (CSI) Driver Operator to install and maintain the Amazon EBS CSI driver on a Red Hat OpenShift Service on AWS (ROSA) cluster. The Amazon EBS CSI driver allows ROSA clusters to manage the lifecycle of Amazon EBS volumes for persistent volumes. */
    ROSAAmazonEBSCSIDriverOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAAmazonEBSCSIDriverOperatorPolicy);
    }
    /** Allows the OpenShift Cloud Network Config Controller Operator to provision and manage networking resources for use by the Red Hat OpenShift Service on AWS (ROSA) cluster networking overlay. The OpenShift Cloud Network Operator interfaces with AWS APIs on behalf of the network plugins via CustomResourceDefinitions. The operator uses these policy permissions to manage private IP addresses for Amazon EC2 instances as part of the ROSA cluster. */
    ROSACloudNetworkConfigOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSACloudNetworkConfigOperatorPolicy);
    }
    /** Allows Red Hat OpenShift Service on AWS (ROSA) control plane to manage ROSA cluster Amazon EC2 and Amazon Route 53 resources. */
    ROSAControlPlaneOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAControlPlaneOperatorPolicy);
    }
    /** Allows the OpenShift Image Registry Operator to provision and manage Amazon S3 buckets and objects for use by the Red Hat OpenShift Service on AWS (ROSA) in-cluster image registry to satisfy ROSA storage requirements. The OpenShift Image Registry Operator installs and maintains the internal registry of a Red Hat OpenShift cluster. */
    ROSAImageRegistryOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAImageRegistryOperatorPolicy);
    }
    /** Allows the OpenShift Ingress Operator to provision and manage load balancers and domain name system (DNS) configurations for Red Hat OpenShift Service on AWS (ROSA) clusters. The policy allows read access to tag values, which the operator filters for Route 53 resources to discover hosted zones. */
    ROSAIngressOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAIngressOperatorPolicy);
    }
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to manage AWS resources that support ROSA cluster installation. This includes managing instance profiles for ROSA worker nodes. */
    ROSAInstallerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAInstallerPolicy);
    }
    /** Allows the built-in ROSA AWS Encryption Provider to manage AWS Key Management Service (KMS) keys to support etcd data encryption using a customer provided AWS KMS key. The policy allows encryption and decryption of data using KMS keys. */
    ROSAKMSProviderPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAKMSProviderPolicy);
    }
    /** Allows the ROSA Kubernetes controller to manage Amazon EC2, Elastic Load Balancing (ELB), and AWS Key Management Service (KMS) resources for a ROSA cluster. */
    ROSAKubeControllerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAKubeControllerPolicy);
    }
    /** This policy provides the permissions required to manage the Red Hat OpenShift Service on AWS (ROSA) subscription. */
    ROSAManageSubscription() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAManageSubscription);
    }
    /** Allows Red Hat OpenShift Service on AWS (ROSA) to manage cluster EC2 instances as worker nodes, including permission to configure security groups and tag instances and volumes. This policy also allows for the use of EC2 instances with disk encryption provided by AWS Key Management Service (KMS) keys. */
    ROSANodePoolManagementPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSANodePoolManagementPolicy);
    }
    /** Provides ROSA site reliability engineering (SRE) the permissions needed to initially observe, diagnose, and support AWS resources associated with Red Hat OpenShift Service on AWS (ROSA) clusters, including the ability to change ROSA cluster node state. */
    ROSASRESupportPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSASRESupportPolicy);
    }
    /** Allows Red Hat OpenShift Service on AWS (ROSA) worker nodes in your account read-only access to Amazon EC2 instances and AWS Regions for compute node lifecycle management. */
    ROSAWorkerInstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAWorkerInstancePolicy);
    }
    /** Service Linked Role Policy for Route 53 Recovery Readiness */
    Route53RecoveryReadinessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Route53RecoveryReadinessServiceRolePolicy);
    }
    /** Enables access to AWS Services and Resources used or managed by Route53 Resolver */
    Route53ResolverServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Route53ResolverServiceRolePolicy);
    }
    /** Enables access to AWS Services and Resources used or managed by S3 Storage Lens */
    S3StorageLensServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.S3StorageLensServiceRolePolicy);
    }
    /** Provides access required to unlock a S3 bucket policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    S3UnlockBucketPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.S3UnlockBucketPolicy);
    }
    /** Allows Amazon Bedrock Agents to access Amazon Bedrock models and other resources attached to an agent in SageMaker Studio. */
    SageMakerStudioBedrockAgentServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockAgentServiceRolePolicy);
    }
    /** Provides access to an Amazon Bedrock chat agent app's configuration and Amazon Bedrock agent in SageMaker Studio. */
    SageMakerStudioBedrockChatAgentUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockChatAgentUserRolePolicy);
    }
    /** Allows Amazon Bedrock to access Amazon Bedrock models and datasets for evaluation jobs in SageMaker Studio. */
    SageMakerStudioBedrockEvaluationJobServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockEvaluationJobServiceRolePolicy);
    }
    /** Allows Amazon Bedrock Flows to access Amazon Bedrock models and other resources attached to a flow in SageMaker Studio. */
    SageMakerStudioBedrockFlowServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockFlowServiceRolePolicy);
    }
    /** Allows AWS Lambda to access an Amazon Bedrock function component's configuration in SageMaker Studio. */
    SageMakerStudioBedrockFunctionExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockFunctionExecutionRolePolicy);
    }
    /** Provides access to configure vector stores and Amazon Bedrock knowledge bases in SageMaker Studio. */
    SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy);
    }
    /** Allows Amazon Bedrock Knowledge Bases to access Amazon Bedrock models and data sources in SageMaker Studio. */
    SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy);
    }
    /** Provides access to an Amazon Bedrock prompt and its configuration in SageMaker Studio. */
    SageMakerStudioBedrockPromptUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockPromptUserRolePolicy);
    }
    /** This policy is used by Amazon SageMaker Studio to catalog, discover, govern, share, and analyze data in the Amazon SageMaker Studio domain. */
    SageMakerStudioDomainExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioDomainExecutionRolePolicy);
    }
    /** Service role for domain level actions in the portal that are performed by Amazon SageMaker Studio. */
    SageMakerStudioDomainServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioDomainServiceRolePolicy);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    SageMakerStudioEMRInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioEMRInstanceRolePolicy);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    SageMakerStudioEMRServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioEMRServiceRolePolicy);
    }
    /** This policy provides full access to Amazon SageMaker Unified Studio via the Amazon SageMaker management console. */
    SageMakerStudioFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioFullAccess);
    }
    /** Amazon SageMaker Studio uses this policy to provision and manage resources in your account. */
    SageMakerStudioProjectProvisioningRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectProvisioningRolePolicy);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to SageMaker. */
    SageMakerStudioProjectRoleMachineLearningPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectRoleMachineLearningPolicy);
    }
    /** Amazon SageMaker creates IAM roles for Projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    SageMakerStudioProjectUserRolePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectUserRolePermissionsBoundary);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions. */
    SageMakerStudioProjectUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectUserRolePolicy);
    }
    /** Amazon SageMaker Studio uses this policy when running query executions on federated connections. */
    SageMakerStudioQueryExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioQueryExecutionRolePolicy);
    }
    /** Provides read/write access to AWS Secrets Manager via the AWS Management Console. Note: this exludes IAM actions, so combine with IAMFullAccess if rotation configuration is required. */
    SecretsManagerReadWrite() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecretsManagerReadWrite);
    }
    /** The security audit template grants access to read security configuration metadata. It is useful for software that audits the configuration of an AWS account. */
    SecurityAudit() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecurityAudit);
    }
    /** Provides access to manage resources created by Security Lake. */
    SecurityLakeResourceManagementServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecurityLakeResourceManagementServiceRolePolicy);
    }
    /** This policy grants permissions to operate the Amazon Security Lake service on your behalf */
    SecurityLakeServiceLinkedRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecurityLakeServiceLinkedRole);
    }
    /** Permissions to allow the AWS Server Migration Connector to migrate VMs to EC2. Allows communication with the AWS Server Migration Service, read/write access to S3 buckets starting with 'sms-b-' and 'import-to-ec2-' as well as the buckets used for AWS Server Migration Connector upgrade, AWS Server Migration Connector registration with AWS, and metrics upload to AWS. */
    ServerMigrationConnector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationConnector);
    }
    /** Required permissions to use all features of the Server Migration Service Console */
    ServerMigrationServiceConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationServiceConsoleFullAccess);
    }
    /** Permissions to allow the AWS Server Migration Service to create and update relevant AWS resources into the customer's AWS account for launching migrated servers and applications. */
    ServerMigrationServiceLaunchRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationServiceLaunchRole);
    }
    /** Permissions to allow the AWS SMS to run used data validation script and send script success/failure back to SMS */
    ServerMigrationServiceRoleForInstanceValidation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationServiceRoleForInstanceValidation);
    }
    /** Provides full access to Service Quotas */
    ServiceQuotasFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServiceQuotasFullAccess);
    }
    /** Provides read only access to Service Quotas */
    ServiceQuotasReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServiceQuotasReadOnlyAccess);
    }
    /** Allows Service Quotas to create support cases on your behalf */
    ServiceQuotasServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServiceQuotasServiceRolePolicy);
    }
    /** Provides full access to the Simple Workflow configuration service. */
    SimpleWorkflowFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SimpleWorkflowFullAccess);
    }
    /** Allows SMSVoice to publish metrics to CloudWatch on your behalf */
    SMSVoiceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SMSVoiceServiceRolePolicy);
    }
    /** Allows split cost allocation data to retrieve AWS Organizations information, if applicable, and collect telemetry data for the split cost allocation data services that the customer has opted in to. */
    SplitCostAllocationDataServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SplitCostAllocationDataServiceRolePolicy);
    }
    /** Provides access required to unlock a SQS queue policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    SQSUnlockQueuePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SQSUnlockQueuePolicy);
    }
    /** Provides permissions to check Quick Setup configuration health, ensure consistent use of parameters and provisioned resources, and remediate resources when drift is detected. */
    SSMQuickSetupRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SSMQuickSetupRolePolicy);
    }
    /** This policy grants permissions to troubleshoot and resolve issues in an AWS account. This policy also enables the user to contact AWS support to create and manage cases. */
    SupportUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SupportUser);
    }
    /** Grants full access permissions necessary for resources required for application and development operations. */
    SystemAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SystemAdministrator);
    }
    /** Provides full access to Amazon Translate. */
    TranslateFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.TranslateFullAccess);
    }
    /** Provides read-only access to Amazon Translate. */
    TranslateReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.TranslateReadOnly);
    }
    /** This policy grants permissions to view resources and basic metadata across all AWS services. */
    ViewOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ViewOnlyAccess);
    }
    /** Default policy for the VM Import/Export service role, for customers using the AWS Connector. The VM Import/Export service assumes a role with this policy to fulfill virtual machine migration requests from the AWS Connector virtual appliance. (Note that the AWS Connector uses the "AWSConnector" managed policy to issue requests on the customer's behalf to the VM Import/Export service.) Provides the ability to create AMIs and EBS snapshots, modify EBS snapshot attributes, make "Describe*" calls on EC2 objects, and read from S3 buckets starting with 'import-to-ec2-'. */
    VMImportExportRoleForAWSConnector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VMImportExportRoleForAWSConnector);
    }
    /** Provides full access to Amazon VPC Lattice and access to dependency services. */
    VPCLatticeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VPCLatticeFullAccess);
    }
    /** Provides read-only access to Amazon VPC Lattice via the AWS Management Console, and limited access to dependency services. */
    VPCLatticeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VPCLatticeReadOnlyAccess);
    }
    /** Provides access to invoking Amazon VPC Lattice services. */
    VPCLatticeServicesInvokeAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VPCLatticeServicesInvokeAccess);
    }
    /** Creating SLR to write customer's logs to a firehose stream */
    WAFLoggingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WAFLoggingServiceRolePolicy);
    }
    /** Creating SLR to write customer's logs to a firehose stream */
    WAFRegionalLoggingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WAFRegionalLoggingServiceRolePolicy);
    }
    /** This policy creates a service-linked role that allows AWS WAF to write logs to Amazon Kinesis Data Firehose. */
    WAFV2LoggingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WAFV2LoggingServiceRolePolicy);
    }
    /** Provides full access to AWS Well-Architected Tool via the AWS Management Console */
    WellArchitectedConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WellArchitectedConsoleFullAccess);
    }
    /** Provides read-only access to AWS Well-Architected Tool via the AWS Management Console */
    WellArchitectedConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WellArchitectedConsoleReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkLink */
    WorkLinkServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WorkLinkServiceRolePolicy);
    }
}
exports.AwsManagedPolicy = AwsManagedPolicy;
//# sourceMappingURL=data:application/json;base64,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