import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [a4b](https://docs.aws.amazon.com/service-authorization/latest/reference/list_alexaforbusiness.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class A4b extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a skill with the organization under the customer's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ApproveSkill.html
     */
    toApproveSkill(): this;
    /**
     * Grants permission to associate a contact with a given address book
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateContactWithAddressBook.html
     */
    toAssociateContactWithAddressBook(): this;
    /**
     * Grants permission to associate a device with the specified network profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateDeviceWithNetworkProfile.html
     */
    toAssociateDeviceWithNetworkProfile(): this;
    /**
     * Grants permission to associate device with given room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateDeviceWithRoom.html
     */
    toAssociateDeviceWithRoom(): this;
    /**
     * Grants permission to associate the skill group with given room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateSkillGroupWithRoom.html
     */
    toAssociateSkillGroupWithRoom(): this;
    /**
     * Grants permission to associate a skill with a skill group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateSkillWithSkillGroup.html
     */
    toAssociateSkillWithSkillGroup(): this;
    /**
     * Grants permission to make a private skill available for enrolled users to enable on their devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateSkillWithUsers.html
     */
    toAssociateSkillWithUsers(): this;
    /**
     * Grants permission to complete the operation of registering an Alexa device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/ag/manage-devices.html
     */
    toCompleteRegistration(): this;
    /**
     * Grants permission to create an address book with the specified details
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateAddressBook.html
     */
    toCreateAddressBook(): this;
    /**
     * Grants permission to create a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateBusinessReportSchedule.html
     */
    toCreateBusinessReportSchedule(): this;
    /**
     * Grants permission to add a new conference provider under the user's AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateConferenceProvider.html
     */
    toCreateConferenceProvider(): this;
    /**
     * Grants permission to create a contact with the specified details
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateContact.html
     */
    toCreateContact(): this;
    /**
     * Grants permission to create a gateway group with the specified details
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateGatewayGroup.html
     */
    toCreateGatewayGroup(): this;
    /**
     * Grants permission to create a network profile with the specified details
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateNetworkProfile.html
     */
    toCreateNetworkProfile(): this;
    /**
     * Grants permission to create a new profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to create room with the specified details
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateRoom.html
     */
    toCreateRoom(): this;
    /**
     * Grants permission to create a skill group with given name and description
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateSkillGroup.html
     */
    toCreateSkillGroup(): this;
    /**
     * Grants permission to create a user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to delete an address book by the address book ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteAddressBook.html
     */
    toDeleteAddressBook(): this;
    /**
     * Grants permission to delete the recurring report delivery schedule with the specified schedule ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteBusinessReportSchedule.html
     */
    toDeleteBusinessReportSchedule(): this;
    /**
     * Grants permission to delete a conference provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteConferenceProvider.html
     */
    toDeleteConferenceProvider(): this;
    /**
     * Grants permission to delete a contact by the contact ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteContact.html
     */
    toDeleteContact(): this;
    /**
     * Grants permission to remove a device from Alexa For Business
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteDevice.html
     */
    toDeleteDevice(): this;
    /**
     * Grants permission to delete the device's entire previous history of voice input data and associated response data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteDeviceUsageData.html
     */
    toDeleteDeviceUsageData(): this;
    /**
     * Grants permission to delete a gateway group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteGatewayGroup.html
     */
    toDeleteGatewayGroup(): this;
    /**
     * Grants permission to delete a network profile by the network profile ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteNetworkProfile.html
     */
    toDeleteNetworkProfile(): this;
    /**
     * Grants permission to delete profile by profile ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteRoom.html
     */
    toDeleteRoom(): this;
    /**
     * Grants permission to delete a parameter from a skill and room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteRoomSkillParameter.html
     */
    toDeleteRoomSkillParameter(): this;
    /**
     * Grants permission to unlink a third-party account from a skill
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteSkillAuthorization.html
     */
    toDeleteSkillAuthorization(): this;
    /**
     * Grants permission to delete skill group with skill group ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteSkillGroup.html
     */
    toDeleteSkillGroup(): this;
    /**
     * Grants permission to delete a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to disassociate a contact from a given address book
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateContactFromAddressBook.html
     */
    toDisassociateContactFromAddressBook(): this;
    /**
     * Grants permission to disassociate device from its current room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateDeviceFromRoom.html
     */
    toDisassociateDeviceFromRoom(): this;
    /**
     * Grants permission to disassociate a skill from a skill group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateSkillFromSkillGroup.html
     */
    toDisassociateSkillFromSkillGroup(): this;
    /**
     * Grants permission to make a private skill unavailable for enrolled users and prevent them from enabling it on their devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateSkillFromUsers.html
     */
    toDisassociateSkillFromUsers(): this;
    /**
     * Grants permission to disassociate the skill group from given room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateSkillGroupFromRoom.html
     */
    toDisassociateSkillGroupFromRoom(): this;
    /**
     * Grants permission to forget smart home appliances associated to a room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ForgetSmartHomeAppliances.html
     */
    toForgetSmartHomeAppliances(): this;
    /**
     * Grants permission to get the address book details by the address book ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetAddressBook.html
     */
    toGetAddressBook(): this;
    /**
     * Grants permission to retrieve the existing conference preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetConferencePreference.html
     */
    toGetConferencePreference(): this;
    /**
     * Grants permission to get details about a specific conference provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetConferenceProvider.html
     */
    toGetConferenceProvider(): this;
    /**
     * Grants permission to get the contact details by the contact ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetContact.html
     */
    toGetContact(): this;
    /**
     * Grants permission to get device details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetDevice.html
     */
    toGetDevice(): this;
    /**
     * Grants permission to retrieve the details of a gateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetGateway.html
     */
    toGetGateway(): this;
    /**
     * Grants permission to retrieve the details of a gateway group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetGatewayGroup.html
     */
    toGetGatewayGroup(): this;
    /**
     * Grants permission to retrieve the configured values for the user enrollment invitation email template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetInvitationConfiguration.html
     */
    toGetInvitationConfiguration(): this;
    /**
     * Grants permission to get the network profile details by the network profile ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetNetworkProfile.html
     */
    toGetNetworkProfile(): this;
    /**
     * Grants permission to get profile when provided with Profile ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetProfile.html
     */
    toGetProfile(): this;
    /**
     * Grants permission to get room details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetRoom.html
     */
    toGetRoom(): this;
    /**
     * Grants permission to get an existing parameter that has been set for a skill and room
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetRoomSkillParameter.html
     */
    toGetRoomSkillParameter(): this;
    /**
     * Grants permission to get skill group details with skill group ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetSkillGroup.html
     */
    toGetSkillGroup(): this;
    /**
     * Grants permission to list the details of the schedules that a user configured
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListBusinessReportSchedules.html
     */
    toListBusinessReportSchedules(): this;
    /**
     * Grants permission to list conference providers under a specific AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListConferenceProviders.html
     */
    toListConferenceProviders(): this;
    /**
     * Grants permission to list the device event history, including device connection status, for up to 30 days
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListDeviceEvents.html
     */
    toListDeviceEvents(): this;
    /**
     * Grants permission to list gateway group summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListGatewayGroups.html
     */
    toListGatewayGroups(): this;
    /**
     * Grants permission to list gateway summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListGateways.html
     */
    toListGateways(): this;
    /**
     * Grants permission to list skills
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSkills.html
     */
    toListSkills(): this;
    /**
     * Grants permission to list all categories in the Alexa skill store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSkillsStoreCategories.html
     */
    toListSkillsStoreCategories(): this;
    /**
     * Grants permission to list all skills in the Alexa skill store by category
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSkillsStoreSkillsByCategory.html
     */
    toListSkillsStoreSkillsByCategory(): this;
    /**
     * Grants permission to list all of the smart home appliances associated with a room
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSmartHomeAppliances.html
     */
    toListSmartHomeAppliances(): this;
    /**
     * Grants permission to list all tags on a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permission to set the conference preferences on a specific conference provider at the account level
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutConferencePreference.html
     */
    toPutConferencePreference(): this;
    /**
     * Grants permission to publish Alexa device setup events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/ag/manage-devices.html
     */
    toPutDeviceSetupEvents(): this;
    /**
     * Grants permission to configure the email template for the user enrollment invitation with the specified attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutInvitationConfiguration.html
     */
    toPutInvitationConfiguration(): this;
    /**
     * Grants permission to put a room specific parameter for a skill
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutRoomSkillParameter.html
     */
    toPutRoomSkillParameter(): this;
    /**
     * Grants permission to link a user's account to a third-party skill provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutSkillAuthorization.html
     */
    toPutSkillAuthorization(): this;
    /**
     * Grants permission to register an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RegisterAVSDevice.html
     */
    toRegisterAVSDevice(): this;
    /**
     * Grants permission to register an Alexa device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/ag/manage-devices.html
     */
    toRegisterDevice(): this;
    /**
     * Grants permission to disassociate a skill from the organization under a user's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RejectSkill.html
     */
    toRejectSkill(): this;
    /**
     * Grants permission to resolve room information
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ResolveRoom.html
     */
    toResolveRoom(): this;
    /**
     * Grants permission to revoke an invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RevokeInvitation.html
     */
    toRevokeInvitation(): this;
    /**
     * Grants permission to search address books and list the ones that meet a set of filter and sort criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchAddressBooks.html
     */
    toSearchAddressBooks(): this;
    /**
     * Grants permission to search contacts and list the ones that meet a set of filter and sort criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchContacts.html
     */
    toSearchContacts(): this;
    /**
     * Grants permission to search for devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchDevices.html
     */
    toSearchDevices(): this;
    /**
     * Grants permission to search network profiles and list the ones that meet a set of filter and sort criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchNetworkProfiles.html
     */
    toSearchNetworkProfiles(): this;
    /**
     * Grants permission to search for profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchProfiles.html
     */
    toSearchProfiles(): this;
    /**
     * Grants permission to search for rooms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchRooms.html
     */
    toSearchRooms(): this;
    /**
     * Grants permission to search for skill groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchSkillGroups.html
     */
    toSearchSkillGroups(): this;
    /**
     * Grants permission to search for users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchUsers.html
     */
    toSearchUsers(): this;
    /**
     * Grants permission to trigger an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SendAnnouncement.html
     */
    toSendAnnouncement(): this;
    /**
     * Grants permission to send an invitation to a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SendInvitation.html
     */
    toSendInvitation(): this;
    /**
     * Grants permission to restore the device and its account to its known, default settings by clearing all information and settings set by its previous users
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_StartDeviceSync.html
     */
    toStartDeviceSync(): this;
    /**
     * Grants permission to initiate the discovery of any smart home appliances associated with the room
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_StartSmartHomeApplianceDiscovery.html
     */
    toStartSmartHomeApplianceDiscovery(): this;
    /**
     * Grants permission to add metadata tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove metadata tags from a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update address book details by the address book ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateAddressBook.html
     */
    toUpdateAddressBook(): this;
    /**
     * Grants permission to update the configuration of the report delivery schedule with the specified schedule ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateBusinessReportSchedule.html
     */
    toUpdateBusinessReportSchedule(): this;
    /**
     * Grants permission to update an existing conference provider's settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateConferenceProvider.html
     */
    toUpdateConferenceProvider(): this;
    /**
     * Grants permission to update the contact details by the contact ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateContact.html
     */
    toUpdateContact(): this;
    /**
     * Grants permission to update device name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateDevice.html
     */
    toUpdateDevice(): this;
    /**
     * Grants permission to update the details of a gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateGateway.html
     */
    toUpdateGateway(): this;
    /**
     * Grants permission to update the details of a gateway group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateGatewayGroup.html
     */
    toUpdateGatewayGroup(): this;
    /**
     * Grants permission to update a network profile by the network profile ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateNetworkProfile.html
     */
    toUpdateNetworkProfile(): this;
    /**
     * Grants permission to update an existing profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    /**
     * Grants permission to update room details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateRoom.html
     */
    toUpdateRoom(): this;
    /**
     * Grants permission to update skill group details with skill group ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateSkillGroup.html
     */
    toUpdateSkillGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Profile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProfile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type room to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Room.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRoom(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Device.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type skillgroup to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SkillGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSkillgroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UserData.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type addressbook to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AddressBook.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAddressbook(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type conferenceprovider to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ConferenceProvider.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConferenceprovider(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type contact to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Contact.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onContact(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type schedule to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_BusinessReportSchedule.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSchedule(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type networkprofile to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_NetworkProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNetworkprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type gateway to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Gateway.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGateway(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type gatewaygroup to the statement
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GatewayGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGatewaygroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters actions based on the Amazon Id in the request
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RegisterAVSDevice.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAmazonId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on the device type in the request
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchDevices.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFiltersDeviceType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on the allowed set of values for each of the tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAddressBook()
     * - .toCreateBusinessReportSchedule()
     * - .toCreateConferenceProvider()
     * - .toCreateContact()
     * - .toCreateGatewayGroup()
     * - .toCreateNetworkProfile()
     * - .toCreateProfile()
     * - .toCreateRoom()
     * - .toCreateSkillGroup()
     * - .toCreateUser()
     * - .toRegisterAVSDevice()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on tag-value assoicated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - room
     * - device
     * - user
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAddressBook()
     * - .toCreateBusinessReportSchedule()
     * - .toCreateConferenceProvider()
     * - .toCreateContact()
     * - .toCreateGatewayGroup()
     * - .toCreateNetworkProfile()
     * - .toCreateProfile()
     * - .toCreateRoom()
     * - .toCreateSkillGroup()
     * - .toCreateUser()
     * - .toRegisterAVSDevice()
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [a4b](https://docs.aws.amazon.com/service-authorization/latest/reference/list_alexaforbusiness.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
