import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [appstudio](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappstudio.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Appstudio extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to describe the account's current status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/
     */
    toGetAccountStatus(): this;
    /**
     * Grants permission to fetch status of a enablement job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/
     */
    toGetEnablementJobStatus(): this;
    /**
     * Grants permission to submit a enablement job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/
     */
    toStartEnablementJob(): this;
    /**
     * Grants permission to rollback an enablement job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/
     */
    toStartRollbackEnablementJob(): this;
    /**
     * Grants permission to start a team deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/
     */
    toStartTeamDeployment(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/concepts.html#concepts-instance
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onInstance(instanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/concepts.html#concepts-application
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type connector to the statement
     *
     * https://docs.aws.amazon.com/appstudio/latest/userguide/concepts.html#concepts-connector
     *
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConnector(connectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [appstudio](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappstudio.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
