import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [dsql](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonauroradsql.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Dsql extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add a peer cluster to a multi-Region cluster
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - dsql:PutMultiRegionProperties
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_CreateCluster.html
     */
    toAddPeerCluster(): this;
    /**
     * Grants permission to create new clusters
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_CreateCluster.html
     */
    toCreateCluster(): this;
    /**
     * Grants permission to create multi-Region clusters. Creating multi-Region clusters also requires CreateCluster permission in each specified Region. **This action is deprecated as of 05/09/2025 and will be removed on 05/21/2025.**
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifWitnessRegion()
     *
     * Dependent actions:
     * - dsql:CreateCluster
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_CreateMultiRegionClusters.html
     */
    toCreateMultiRegionClusters(): this;
    /**
     * Grants permission to connect to the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/userguide/accessing-sql-clients.html
     */
    toDbConnect(): this;
    /**
     * Grants permission to connect to the database with admin role. Connecting with any other role requires DbConnect permission
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/userguide/accessing-sql-clients.html
     */
    toDbConnectAdmin(): this;
    /**
     * Grants permission to delete a cluster and all of its data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_DeleteCluster.html
     */
    toDeleteCluster(): this;
    /**
     * Grants permission to delete multi-Region clusters. Deleting multi-Region clusters also requires DeleteCluster permission in each specified Region. **This action is deprecated as of 05/09/2025 and will be removed on 05/21/2025.**
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - dsql:DeleteCluster
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_DeleteMultiRegionClusters.html
     */
    toDeleteMultiRegionClusters(): this;
    /**
     * Grants permission to get information about a cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_GetCluster.html
     */
    toGetCluster(): this;
    /**
     * Grants permission to retrieve the VPC endpoint service name for a cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_GetVpcEndpointServiceName.html
     */
    toGetVpcEndpointServiceName(): this;
    /**
     * Grants permission to retrieve a list of clusters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_ListClusters.html
     */
    toListClusters(): this;
    /**
     * Grants permission to list all tags on an Aurora DSQL resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to update multi-Region properties of a cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_CreateCluster.html
     */
    toPutMultiRegionProperties(): this;
    /**
     * Grants permission to configure and update the witness Region of a multi-Region cluster
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - dsql:PutMultiRegionProperties
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_CreateCluster.html
     */
    toPutWitnessRegion(): this;
    /**
     * Grants permission to remove a peer cluster from a multi-Region cluster
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - dsql:PutMultiRegionProperties
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_UpdateCluster.html
     */
    toRemovePeerCluster(): this;
    /**
     * Grants permission to add tags to Aurora DSQL resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from Aurora DSQL resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify cluster attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/API_UpdateCluster.html
     */
    toUpdateCluster(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Cluster to the statement
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/userguide/what-is-aurora-dsql.html
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCluster()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - Cluster
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCluster()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the witness region of linked clusters
     *
     * https://docs.aws.amazon.com/aurora-dsql/latest/APIReference/using-iam-condition-keys.html#using-iam-condition-keys-create-mr-cluster-witness
     *
     * Applies to actions:
     * - .toCreateMultiRegionClusters()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWitnessRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [dsql](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonauroradsql.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
