import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [b2bi](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsb2bdatainterchange.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class B2bi extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a capability
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_CreateCapability.html
     */
    toCreateCapability(): this;
    /**
     * Grants permission to create a partnership
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_CreatePartnership.html
     */
    toCreatePartnership(): this;
    /**
     * Grants permission to create a profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to generate a starter JSONATA/XSLT template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_CreateStarterMappingTemplate.html
     */
    toCreateStarterMappingTemplate(): this;
    /**
     * Grants permission to create a transformer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_CreateTransformer.html
     */
    toCreateTransformer(): this;
    /**
     * Grants permission to delete a capability
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_DeleteCapability.html
     */
    toDeleteCapability(): this;
    /**
     * Grants permission to delete an partnership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_DeletePartnership.html
     */
    toDeletePartnership(): this;
    /**
     * Grants permission to delete a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete a transformer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_DeleteTransformer.html
     */
    toDeleteTransformer(): this;
    /**
     * Grants permission to generate a starter JSONATA/XSLT mapping template from Amazon Bedrock
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GenerateMapping.html
     */
    toGenerateMapping(): this;
    /**
     * Grants permission to get a capability
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetCapability.html
     */
    toGetCapability(): this;
    /**
     * Grants permission to get a partnership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetPartnership.html
     */
    toGetPartnership(): this;
    /**
     * Grants permission to get a profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetProfile.html
     */
    toGetProfile(): this;
    /**
     * Grants permission to get a transformer
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetTransformer.html
     */
    toGetTransformer(): this;
    /**
     * Grants permission to get a transformer job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetTransformerJob.html
     */
    toGetTransformerJob(): this;
    /**
     * Grants permission to list all capabilities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_ListCapabilities.html
     */
    toListCapabilities(): this;
    /**
     * Grants permission to list all partnerships
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_ListPartnerships.html
     */
    toListPartnerships(): this;
    /**
     * Grants permission to list all profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to list tags for a B2Bi resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all transformers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_ListTransformers.html
     */
    toListTransformers(): this;
    /**
     * Grants permission to transformer a document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_StartTransformerJob.html
     */
    toStartTransformerJob(): this;
    /**
     * Grants permission to tag a B2Bi resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to convert a JSON/XML to an edi document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_TestConversion.html
     */
    toTestConversion(): this;
    /**
     * Grants permission to map a sample file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_TestMapping.html
     */
    toTestMapping(): this;
    /**
     * Grants permission to parse an edi document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_TestParsing.html
     */
    toTestParsing(): this;
    /**
     * Grants permission to untag a B2Bi resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a capability
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_UpdateCapability.html
     */
    toUpdateCapability(): this;
    /**
     * Grants permission to update a partnership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_UpdatePartnership.html
     */
    toUpdatePartnership(): this;
    /**
     * Grants permission to update a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    /**
     * Grants permission to update a transformer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/b2bi/latest/APIReference/API_UpdateTransformer.html
     */
    toUpdateTransformer(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/b2bi/latest/userguide/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type capability to the statement
     *
     * https://docs.aws.amazon.com/b2bi/latest/userguide/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCapability(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type partnership to the statement
     *
     * https://docs.aws.amazon.com/b2bi/latest/userguide/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPartnership(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transformer to the statement
     *
     * https://docs.aws.amazon.com/b2bi/latest/userguide/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTransformer(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCapability()
     * - .toCreatePartnership()
     * - .toCreateProfile()
     * - .toCreateTransformer()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - profile
     * - capability
     * - partnership
     * - transformer
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCapability()
     * - .toCreatePartnership()
     * - .toCreateProfile()
     * - .toCreateTransformer()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [b2bi](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsb2bdatainterchange.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
