import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [backup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackup.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Backup extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel a legal hold
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CancelLegalHold.html
     */
    toCancelLegalHold(): this;
    /**
     * Grants permission to copy from a backup vault
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCopyTargets()
     * - .ifCopyTargetOrgPaths()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/vaults.html.html
     */
    toCopyFromBackupVault(): this;
    /**
     * Grants permission to copy into a backup vault
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/vaults.html
     */
    toCopyIntoBackupVault(): this;
    /**
     * Grants permission to create a new backup plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupPlan.html
     */
    toCreateBackupPlan(): this;
    /**
     * Grants permission to create a new resource assignment in a backup plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupSelection.html
     */
    toCreateBackupSelection(): this;
    /**
     * Grants permission to create a new backup vault
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     */
    toCreateBackupVault(): this;
    /**
     * Grants permission to create a new framework
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateFramework.html
     */
    toCreateFramework(): this;
    /**
     * Grants permission to create a new legal hold
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateLegalHold.html
     */
    toCreateLegalHold(): this;
    /**
     * Grants permission to create a new logically air-gapped backup vault, a logical container where backups are stored
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifMinRetentionDays()
     * - .ifMaxRetentionDays()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateLogicallyAirGappedBackupVault.html
     */
    toCreateLogicallyAirGappedBackupVault(): this;
    /**
     * Grants permission to create a new report plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifFrameworkArns()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateReportPlan.html
     */
    toCreateReportPlan(): this;
    /**
     * Grants permission to create a new restore testing plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateRestoreTestingPlan.html
     */
    toCreateRestoreTestingPlan(): this;
    /**
     * Grants permission to create a new resource assignment in a restore testing plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateRestoreTestingSelection.html
     */
    toCreateRestoreTestingSelection(): this;
    /**
     * Grants permission to delete a backup plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupPlan.html
     */
    toDeleteBackupPlan(): this;
    /**
     * Grants permission to delete a resource assignment from a backup plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupSelection.html
     */
    toDeleteBackupSelection(): this;
    /**
     * Grants permission to delete a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVault.html
     */
    toDeleteBackupVault(): this;
    /**
     * Grants permission to delete backup vault access policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultAccessPolicy.html
     */
    toDeleteBackupVaultAccessPolicy(): this;
    /**
     * Grants permission to remove the lock configuration from a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultLockConfiguration.html
     */
    toDeleteBackupVaultLockConfiguration(): this;
    /**
     * Grants permission to remove the notifications from a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultNotifications.html
     */
    toDeleteBackupVaultNotifications(): this;
    /**
     * Grants permission to delete backup vault sharing policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/logicallyairgappedvault.html
     */
    toDeleteBackupVaultSharingPolicy(): this;
    /**
     * Grants permission to delete a framework
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteFramework.html
     */
    toDeleteFramework(): this;
    /**
     * Grants permission to delete a recovery point from a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteRecoveryPoint.html
     */
    toDeleteRecoveryPoint(): this;
    /**
     * Grants permission to delete a report plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteReportPlan.html
     */
    toDeleteReportPlan(): this;
    /**
     * Grants permission to delete a restore testing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteRestoreTestingPlan.html
     */
    toDeleteRestoreTestingPlan(): this;
    /**
     * Grants permission to delete a resource assignment from a restore testing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteRestoreTestingSelection.html
     */
    toDeleteRestoreTestingSelection(): this;
    /**
     * Grants permission to describe a backup job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeBackupJob.html
     */
    toDescribeBackupJob(): this;
    /**
     * Grants permission to describe a new backup vault with the specified name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeBackupVault.html
     */
    toDescribeBackupVault(): this;
    /**
     * Grants permission to describe a copy job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeCopyJob.html
     */
    toDescribeCopyJob(): this;
    /**
     * Grants permission to describe a framework with the specified name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeFramework.html
     */
    toDescribeFramework(): this;
    /**
     * Grants permission to describe global settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeGlobalSettings.html
     */
    toDescribeGlobalSettings(): this;
    /**
     * Grants permission to describe a protected resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeProtectedResource.html
     */
    toDescribeProtectedResource(): this;
    /**
     * Grants permission to describe a recovery point
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRecoveryPoint.html
     */
    toDescribeRecoveryPoint(): this;
    /**
     * Grants permission to describe region settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRegionSettings.html
     */
    toDescribeRegionSettings(): this;
    /**
     * Grants permission to describe a report job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeReportJob.html
     */
    toDescribeReportJob(): this;
    /**
     * Grants permission to describe a report plan with the specified name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeReportPlan.html
     */
    toDescribeReportPlan(): this;
    /**
     * Grants permission to describe a restore job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRestoreJob.html
     */
    toDescribeRestoreJob(): this;
    /**
     * Grants permission to disassociate a recovery point from a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DisassociateRecoveryPoint.html
     */
    toDisassociateRecoveryPoint(): this;
    /**
     * Grants permission to disassociate a recovery point from its parent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DisassociateRecoveryPointFromParent.html
     */
    toDisassociateRecoveryPointFromParent(): this;
    /**
     * Grants permission to export a backup plan as a JSON
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ExportBackupPlanTemplate.html
     */
    toExportBackupPlanTemplate(): this;
    /**
     * Grants permission to get a backup plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlan.html
     */
    toGetBackupPlan(): this;
    /**
     * Grants permission to transform a JSON to a backup plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlanFromJSON.html
     */
    toGetBackupPlanFromJSON(): this;
    /**
     * Grants permission to transform a template to a backup plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlanFromTemplate.html
     */
    toGetBackupPlanFromTemplate(): this;
    /**
     * Grants permission to get a backup plan resource assignment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupSelection.html
     */
    toGetBackupSelection(): this;
    /**
     * Grants permission to get backup vault access policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupVaultAccessPolicy.html
     */
    toGetBackupVaultAccessPolicy(): this;
    /**
     * Grants permission to get backup vault notifications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupVaultNotifications.html
     */
    toGetBackupVaultNotifications(): this;
    /**
     * Grants permission to get backup vault sharing policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/logicallyairgappedvault.html
     */
    toGetBackupVaultSharingPolicy(): this;
    /**
     * Grants permission to get a legal hold
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetLegalHold.html
     */
    toGetLegalHold(): this;
    /**
     * Grants permission to get indexing details for a recovery point
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRecoveryPointIndexDetails.html
     */
    toGetRecoveryPointIndexDetails(): this;
    /**
     * Grants permission to get recovery point restore metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRecoveryPointRestoreMetadata.html
     */
    toGetRecoveryPointRestoreMetadata(): this;
    /**
     * Grants permission to get the restore metadata associated with a restore job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRestoreJobMetadata.html
     */
    toGetRestoreJobMetadata(): this;
    /**
     * Grants permission to get inferred metadata generated by restore testing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRestoreTestingInferredMetadata.html
     */
    toGetRestoreTestingInferredMetadata(): this;
    /**
     * Grants permission to get a restore testing plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRestoreTestingPlan.html
     */
    toGetRestoreTestingPlan(): this;
    /**
     * Grants permission to get a restore testing plan resource assignment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRestoreTestingSelection.html
     */
    toGetRestoreTestingSelection(): this;
    /**
     * Grants permission to get supported resource types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetSupportedResourceTypes.html
     */
    toGetSupportedResourceTypes(): this;
    /**
     * Grants permission to list backup job summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobSummaries.html
     */
    toListBackupJobSummaries(): this;
    /**
     * Grants permission to list backup jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html
     */
    toListBackupJobs(): this;
    /**
     * Grants permission to list backup plan templates provided by AWS Backup
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlanTemplates.html
     */
    toListBackupPlanTemplates(): this;
    /**
     * Grants permission to list backup plan versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlanVersions.html
     */
    toListBackupPlanVersions(): this;
    /**
     * Grants permission to list backup plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlans.html
     */
    toListBackupPlans(): this;
    /**
     * Grants permission to list resource assignments for a specific backup plan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupSelections.html
     */
    toListBackupSelections(): this;
    /**
     * Grants permission to list backup vaults
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupVaults.html
     */
    toListBackupVaults(): this;
    /**
     * Grants permission to list copy job summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListCopyJobSummaries.html
     */
    toListCopyJobSummaries(): this;
    /**
     * Grants permission to list copy jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListCopyJobs.html
     */
    toListCopyJobs(): this;
    /**
     * Grants permission to list frameworks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListFrameworks.html
     */
    toListFrameworks(): this;
    /**
     * Grants permission to get list indexed recovery points
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListIndexedRecoveryPoints.html
     */
    toListIndexedRecoveryPoints(): this;
    /**
     * Grants permission to list indexed recovery points to search
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListIndexedRecoveryPointsForSearch.html
     */
    toListIndexedRecoveryPointsForSearch(): this;
    /**
     * Grants permission to list legal holds
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListLegalHolds.html
     */
    toListLegalHolds(): this;
    /**
     * Grants permission to list protected resources by AWS Backup
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListProtectedResources.html
     */
    toListProtectedResources(): this;
    /**
     * Grants permission to list protected resources inside a backup vault
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListProtectedResourcesByBackupVault.html
     */
    toListProtectedResourcesByBackupVault(): this;
    /**
     * Grants permission to list recovery points inside a backup vault
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByBackupVault.html
     */
    toListRecoveryPointsByBackupVault(): this;
    /**
     * Grants permission to list recovery points by legal hold
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByLegalHold.html
     */
    toListRecoveryPointsByLegalHold(): this;
    /**
     * Grants permission to list recovery points for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByResource.html
     */
    toListRecoveryPointsByResource(): this;
    /**
     * Grants permission to list report jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListReportJobs.html
     */
    toListReportJobs(): this;
    /**
     * Grants permission to list report plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListReportPlans.html
     */
    toListReportPlans(): this;
    /**
     * Grants permission to list restore job summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreJobSummaries.html
     */
    toListRestoreJobSummaries(): this;
    /**
     * Grants permission to list restore jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreJobs.html
     */
    toListRestoreJobs(): this;
    /**
     * Grants permission to list restore jobs for a protected resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreJobsByProtectedResource.html
     */
    toListRestoreJobsByProtectedResource(): this;
    /**
     * Grants permission to list restore testing plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreTestingPlans.html
     */
    toListRestoreTestingPlans(): this;
    /**
     * Grants permission to list resource assignments for a specific restore testing plan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreTestingSelections.html
     */
    toListRestoreTestingSelections(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permission to add an access policy to the backup vault
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultAccessPolicy.html
     */
    toPutBackupVaultAccessPolicy(): this;
    /**
     * Grants permission to add a lock configuration to the backup vault
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeableForDays()
     * - .ifMinRetentionDays()
     * - .ifMaxRetentionDays()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultLockConfiguration.html
     */
    toPutBackupVaultLockConfiguration(): this;
    /**
     * Grants permission to add an SNS topic to the backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html
     */
    toPutBackupVaultNotifications(): this;
    /**
     * Grants permission to add a sharing policy to the backup vault
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/logicallyairgappedvault.html
     */
    toPutBackupVaultSharingPolicy(): this;
    /**
     * Grants permission to put a restore validation result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutRestoreValidationResult.html
     */
    toPutRestoreValidationResult(): this;
    /**
     * Grants permission to search a recovery point
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_SearchRecoveryPoint.html
     */
    toSearchRecoveryPoint(): this;
    /**
     * Grants permission to start a new backup job
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartBackupJob.html
     */
    toStartBackupJob(): this;
    /**
     * Grants permission to copy a backup from a source backup vault to a destination backup vault
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     */
    toStartCopyJob(): this;
    /**
     * Grants permission to start a new report job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartReportJob.html
     */
    toStartReportJob(): this;
    /**
     * Grants permission to start a new restore job
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartRestoreJob.html
     */
    toStartRestoreJob(): this;
    /**
     * Grants permission to stop a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StopBackupJob.html
     */
    toStopBackupJob(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a backup plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html
     */
    toUpdateBackupPlan(): this;
    /**
     * Grants permission to update a framework
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateFramework.html
     */
    toUpdateFramework(): this;
    /**
     * Grants permission to update the current global settings for the AWS Account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateGlobalSettings.html
     */
    toUpdateGlobalSettings(): this;
    /**
     * Grants permission to update recovery point index settings
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifIndex()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRecoveryPointIndexSettings.html
     */
    toUpdateRecoveryPointIndexSettings(): this;
    /**
     * Grants permission to update the lifecycle of the recovery point
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRecoveryPointLifecycle.html
     */
    toUpdateRecoveryPointLifecycle(): this;
    /**
     * Grants permission to update the current service opt-in settings for the Region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html
     */
    toUpdateRegionSettings(): this;
    /**
     * Grants permission to update a report plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFrameworkArns()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateReportPlan.html
     */
    toUpdateReportPlan(): this;
    /**
     * Grants permission to update a restore testing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRestoreTestingPlan.html
     */
    toUpdateRestoreTestingPlan(): this;
    /**
     * Grants permission to update a resource assignment in a restore testing plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRestoreTestingSelection.html
     */
    toUpdateRestoreTestingSelection(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type backupVault to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/vaults.html
     *
     * @param backupVaultName - Identifier for the backupVaultName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBackupVault(backupVaultName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type backupPlan to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/about-backup-plans.html
     *
     * @param backupPlanId - Identifier for the backupPlanId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBackupPlan(backupPlanId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recoveryPoint to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/recovery-points.html
     *
     * @param recoveryPointId - Identifier for the recoveryPointId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecoveryPoint(recoveryPointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type framework to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/working-with-audit-frameworks.html
     *
     * @param frameworkName - Identifier for the frameworkName.
     * @param frameworkId - Identifier for the frameworkId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFramework(frameworkName: string, frameworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reportPlan to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/create-report-plan-api.html
     *
     * @param reportPlanName - Identifier for the reportPlanName.
     * @param reportPlanId - Identifier for the reportPlanId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReportPlan(reportPlanName: string, reportPlanId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type legalHold to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/legalhold.html
     *
     * @param legalHoldId - Identifier for the legalHoldId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLegalHold(legalHoldId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type restoreTestingPlan to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing.html
     *
     * @param restoreTestingPlanName - Identifier for the restoreTestingPlanName.
     * @param restoreTestingPlanId - Identifier for the restoreTestingPlanId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRestoreTestingPlan(restoreTestingPlanName: string, restoreTestingPlanId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the allowed set of values for each of the tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCopyIntoBackupVault()
     * - .toCreateBackupPlan()
     * - .toCreateBackupVault()
     * - .toCreateFramework()
     * - .toCreateLegalHold()
     * - .toCreateLogicallyAirGappedBackupVault()
     * - .toCreateReportPlan()
     * - .toCreateRestoreTestingPlan()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - backupVault
     * - backupPlan
     * - recoveryPoint
     * - framework
     * - reportPlan
     * - legalHold
     * - restoreTestingPlan
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateBackupPlan()
     * - .toCreateBackupVault()
     * - .toCreateFramework()
     * - .toCreateLegalHold()
     * - .toCreateLogicallyAirGappedBackupVault()
     * - .toCreateReportPlan()
     * - .toCreateRestoreTestingPlan()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the value of the ChangeableForDays parameter
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toPutBackupVaultLockConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifChangeableForDays(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the organization unit
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCopyFromBackupVault()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCopyTargetOrgPaths(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of an backup vault
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCopyFromBackupVault()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifCopyTargets(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the Framework ARNs
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCreateReportPlan()
     * - .toUpdateReportPlan()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFrameworkArns(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the value of Index parameter
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toUpdateRecoveryPointIndexSettings()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIndex(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the value of the MaxRetentionDays parameter
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCreateLogicallyAirGappedBackupVault()
     * - .toPutBackupVaultLockConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifMaxRetentionDays(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the value of the MinRetentionDays parameter
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCreateLogicallyAirGappedBackupVault()
     * - .toPutBackupVaultLockConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifMinRetentionDays(value: number | number[], operator?: Operator | string): this;
    /**
     * Statement provider for service [backup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackup.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
