import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Chatbot extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a resource with a configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_AssociateToConfiguration.html
     */
    toAssociateToConfiguration(): this;
    /**
     * Grants permission to create an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_CreateChimeWebhookConfiguration.html
     */
    toCreateChimeWebhookConfiguration(): this;
    /**
     * Grants permission to create a custom action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_CreateCustomAction.html
     */
    toCreateCustomAction(): this;
    /**
     * Grants permission to create an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_CreateMicrosoftTeamsChannelConfiguration.html
     */
    toCreateMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to create an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_CreateSlackChannelConfiguration.html
     */
    toCreateSlackChannelConfiguration(): this;
    /**
     * Grants permission to delete an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteChimeWebhookConfiguration.html
     */
    toDeleteChimeWebhookConfiguration(): this;
    /**
     * Grants permission to delete a custom action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteCustomAction.html
     */
    toDeleteCustomAction(): this;
    /**
     * Grants permission to delete an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteMicrosoftTeamsChannelConfiguration.html
     */
    toDeleteMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to delete the Microsoft Teams configured with AWS Chatbot in an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteMicrosoftTeamsConfiguredTeam.html
     */
    toDeleteMicrosoftTeamsConfiguredTeam(): this;
    /**
     * Grants permission to delete an AWS Chatbot Microsoft Teams User Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteMicrosoftTeamsUserIdentity.html
     */
    toDeleteMicrosoftTeamsUserIdentity(): this;
    /**
     * Grants permission to delete an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteSlackChannelConfiguration.html
     */
    toDeleteSlackChannelConfiguration(): this;
    /**
     * Grants permission to delete an AWS Chatbot Slack User Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteSlackUserIdentity.html
     */
    toDeleteSlackUserIdentity(): this;
    /**
     * Grants permission to delete the Slack workspace authorization with AWS Chatbot, associated with an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DeleteSlackWorkspaceAuthorization.html
     */
    toDeleteSlackWorkspaceAuthorization(): this;
    /**
     * Grants permission to list all AWS Chatbot Chime Webhook Configurations in an AWS Account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DescribeChimeWebhookConfigurations.html
     */
    toDescribeChimeWebhookConfigurations(): this;
    /**
     * Grants permission to list all AWS Chatbot Slack Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DescribeSlackChannelConfigurations.html
     */
    toDescribeSlackChannelConfigurations(): this;
    /**
     * Grants permission to list all public Slack channels in the Slack workspace connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_Operations.html
     */
    toDescribeSlackChannels(): this;
    /**
     * Grants permission to describe AWS Chatbot Slack User Identities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DescribeSlackUserIdentities.html
     */
    toDescribeSlackUserIdentities(): this;
    /**
     * Grants permission to list all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DescribeSlackWorkspaces.html
     */
    toDescribeSlackWorkspaces(): this;
    /**
     * Grants permission to disassociate a resource from a configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_DisassociateFromConfiguration.html
     */
    toDisassociateFromConfiguration(): this;
    /**
     * Grants permission to retrieve AWS Chatbot account preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_GetAccountPreferences.html
     */
    toGetAccountPreferences(): this;
    /**
     * Grants permission to get a custom action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_GetCustomAction.html
     */
    toGetCustomAction(): this;
    /**
     * Grants permission to get a single AWS Chatbot Microsoft Teams Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_GetMicrosoftTeamsChannelConfiguration.html
     */
    toGetMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to generate OAuth parameters to request Microsoft Teams OAuth code to be used by the AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_Operations.html
     */
    toGetMicrosoftTeamsOauthParameters(): this;
    /**
     * Grants permission to generate OAuth parameters to request Slack OAuth code to be used by the AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_Operations.html
     */
    toGetSlackOauthParameters(): this;
    /**
     * Grants permission to list resources associated with a configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_ListAssociations.html
     */
    toListAssociations(): this;
    /**
     * Grants permission to list custom actions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_ListCustomActions.html
     */
    toListCustomActions(): this;
    /**
     * Grants permission to list all AWS Chatbot Microsoft Teams Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_ListMicrosoftTeamsChannelConfigurations.html
     */
    toListMicrosoftTeamsChannelConfigurations(): this;
    /**
     * Grants permission to list all Microsoft Teams connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_ListMicrosoftTeamsConfiguredTeams.html
     */
    toListMicrosoftTeamsConfiguredTeams(): this;
    /**
     * Grants permission to describe AWS Chatbot Microsoft Teams User Identities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_ListMicrosoftTeamsUserIdentities.html
     */
    toListMicrosoftTeamsUserIdentities(): this;
    /**
     * Grants permission to List all tags associated with the AWS Chatbot Channel Configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to redeem previously generated parameters with Microsoft APIs, to acquire OAuth tokens to be used by the AWS Chatbot service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_Operations.html
     */
    toRedeemMicrosoftTeamsOauthCode(): this;
    /**
     * Grants permission to redeem previously generated parameters with Slack API, to acquire OAuth tokens to be used by the AWS Chatbot service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_Operations.html
     */
    toRedeemSlackOauthCode(): this;
    /**
     * Grants permission to create tags on AWS Chatbot Channel Configuration
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags on AWS Chatbot Channel Configuration
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update AWS Chatbot account preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_UpdateAccountPreferences.html
     */
    toUpdateAccountPreferences(): this;
    /**
     * Grants permission to update an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_UpdateChimeWebhookConfiguration.html
     */
    toUpdateChimeWebhookConfiguration(): this;
    /**
     * Grants permission to update a custom action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_UpdateCustomAction.html
     */
    toUpdateCustomAction(): this;
    /**
     * Grants permission to update an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_UpdateMicrosoftTeamsChannelConfiguration.html
     */
    toUpdateMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to update an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/APIReference/API_UpdateSlackChannelConfiguration.html
     */
    toUpdateSlackChannelConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ChatbotConfiguration to the statement
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     *
     * @param configurationType - Identifier for the configurationType.
     * @param chatbotConfigurationName - Identifier for the chatbotConfigurationName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChatbotConfiguration(configurationType: string, chatbotConfigurationName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type custom-action to the statement
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     *
     * @param actionName - Identifier for the actionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCustomAction(actionName: string, account?: string, partition?: string): this;
    /**
     * Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
