import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [application-signals](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchapplicationsignals.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ApplicationSignals extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to batch retrieve a service level objective budget report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_BatchGetServiceLevelObjectiveBudgetReport.html
     */
    toBatchGetServiceLevelObjectiveBudgetReport(): this;
    /**
     * Grants permission to add or remove exclusion windows from Amazon CloudWatch SLOs
     *
     * Access Level: Write
     */
    toBatchUpdateExclusionWindows(): this;
    /**
     * Grants permission to create a service level objective
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_CreateServiceLevelObjective.html
     */
    toCreateServiceLevelObjective(): this;
    /**
     * Grants permission to delete a service level objective
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_DeleteServiceLevelObjective.html
     */
    toDeleteServiceLevelObjective(): this;
    /**
     * Grants permission to retrieve information about a service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_GetService.html
     */
    toGetService(): this;
    /**
     * Grants permission to retrieve information about service level objective
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_GetServiceLevelObjective.html
     */
    toGetServiceLevelObjective(): this;
    /**
     * Grants permission to share Application Signals resources with a monitoring account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account-Setup.html#CloudWatch-Unified-Cross-Account-Setup-permissions
     */
    toLink(): this;
    /**
     * Grants permission to list entities associated with other entities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Application_Signals_Permissions.html
     */
    toListObservedEntities(): this;
    /**
     * Grants permission to list service dependencies
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_ListServiceDependencies.html
     */
    toListServiceDependencies(): this;
    /**
     * Grants permission to list service dependents
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_ListServiceDependents.html
     */
    toListServiceDependents(): this;
    /**
     * Grants permission to list exclusion windows for an Amazon CloudWatch SLO
     *
     * Access Level: List
     */
    toListServiceLevelObjectiveExclusionWindows(): this;
    /**
     * Grants permission to list service level objectives
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_ListServiceLevelObjectives.html
     */
    toListServiceLevelObjectives(): this;
    /**
     * Grants permission to list service operations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_ListServiceOperations.html
     */
    toListServiceOperations(): this;
    /**
     * Grants permission to list services
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_ListServices.html
     */
    toListServices(): this;
    /**
     * Grants permission to list tags for an Amazon CloudWatch SLO
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to enable CloudWatch discovery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_StartDiscovery.html
     */
    toStartDiscovery(): this;
    /**
     * Grants permission to add tags to an Amazon CloudWatch SLO
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag to an Amazon CloudWatch SLO
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a service level objective
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/applicationsignals/latest/APIReference/API_UpdateServiceLevelObjective.html
     */
    toUpdateServiceLevelObjective(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type slo to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html
     *
     * @param sloName - Identifier for the sloName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSlo(sloName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the allowed set of values for each of the tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateServiceLevelObjective()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag-value associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - slo
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateServiceLevelObjective()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [application-signals](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchapplicationsignals.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
