import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Observabilityadmin extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_GetTelemetryEvaluationStatus.html
     */
    toGetTelemetryEvaluationStatus(): this;
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_GetTelemetryEvaluationStatusForOrganization.html
     */
    toGetTelemetryEvaluationStatusForOrganization(): this;
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_ListResourceTelemetry.html
     */
    toListResourceTelemetry(): this;
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with accounts in the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_ListResourceTelemetryForOrganization.html
     */
    toListResourceTelemetryForOrganization(): this;
    /**
     * Grants permission to start the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StartTelemetryEvaluation.html
     */
    toStartTelemetryEvaluation(): this;
    /**
     * Grants permission to start the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StartTelemetryEvaluationForOrganization.html
     */
    toStartTelemetryEvaluationForOrganization(): this;
    /**
     * Grants permission to stop the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StopTelemetryEvaluation.html
     */
    toStopTelemetryEvaluation(): this;
    /**
     * Grants permission to stop the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ObservabilityAdmin/latest/APIReference/API_StopTelemetryEvaluationForOrganization.html
     */
    toStopTelemetryEvaluationForOrganization(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
