import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [codecatalyst](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodecatalyst.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Codecatalyst extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept a request to connect this account to an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toAcceptConnection(): this;
    /**
     * Grants permission to associate an IAM role to a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toAssociateIamRoleToConnection(): this;
    /**
     * Grants permission to associate an IAM Identity Center application with an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toAssociateIdentityCenterApplicationToSpace(): this;
    /**
     * Grants permission to associate an identity with an IAM Identity Center application for an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toAssociateIdentityToIdentityCenterApplication(): this;
    /**
     * Grants permission to associate multiple identities with an IAM Identity Center application for an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toBatchAssociateIdentitiesToIdentityCenterApplication(): this;
    /**
     * Grants permission to disassociate multiple identities from an IAM Identity Center application for an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toBatchDisassociateIdentitiesFromIdentityCenterApplication(): this;
    /**
     * Grants permission to create an IAM Identity Center application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toCreateIdentityCenterApplication(): this;
    /**
     * Grants permission to create an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toCreateSpace(): this;
    /**
     * Grants permission to create an administrator role assignment for a given Amazon CodeCatalyst space and IAM Identity Center application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toCreateSpaceAdminRoleAssignment(): this;
    /**
     * Grants permission to delete a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toDeleteConnection(): this;
    /**
     * Grants permission to delete an IAM Identity Center application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toDeleteIdentityCenterApplication(): this;
    /**
     * Grants permission to disassociate an IAM role from a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toDisassociateIamRoleFromConnection(): this;
    /**
     * Grants permission to disassociate an IAM Identity Center application from an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toDisassociateIdentityCenterApplicationFromSpace(): this;
    /**
     * Grants permission to disassociate an identity from an IAM Identity Center application for an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toDisassociateIdentityFromIdentityCenterApplication(): this;
    /**
     * Grants permission to describe the billing authorization for a connection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toGetBillingAuthorization(): this;
    /**
     * Grants permission to get a connection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toGetConnection(): this;
    /**
     * Grants permission to get information about an IAM Identity Center application
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toGetIdentityCenterApplication(): this;
    /**
     * Grants permission to get a pending request to connect this account to an Amazon CodeCatalyst space
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toGetPendingConnection(): this;
    /**
     * Grants permission to list connections that are not pending
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toListConnections(): this;
    /**
     * Grants permission to list IAM roles associated with a connection
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toListIamRolesForConnection(): this;
    /**
     * Grants permission to view a list of all IAM Identity Center applications in the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toListIdentityCenterApplications(): this;
    /**
     * Grants permission to view a list of IAM Identity Center applications by Amazon CodeCatalyst space
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toListIdentityCenterApplicationsForSpace(): this;
    /**
     * Grants permission to view a list of Amazon CodeCatalyst spaces by IAM Identity Center application
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toListSpacesForIdentityCenterApplication(): this;
    /**
     * Grants permission to list tags for an Amazon CodeCatalyst resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update the billing authorization for a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toPutBillingAuthorization(): this;
    /**
     * Grants permission to reject a request to connect this account to an Amazon CodeCatalyst space
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toRejectConnection(): this;
    /**
     * Grants permission to synchronize an IAM Identity Center application with the backing identity store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toSynchronizeIdentityCenterApplication(): this;
    /**
     * Grants permission to tag an Amazon CodeCatalyst resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toTagResource(): this;
    /**
     * Grants permission to untag an Amazon CodeCatalyst resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-connections
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an IAM Identity Center application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/security-iam.html#permissions-reference-applications
     */
    toUpdateIdentityCenterApplication(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type connections to the statement
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     *
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnections(connectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type identity-center-applications to the statement
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     *
     * @param identityCenterApplicationId - Identifier for the identityCenterApplicationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIdentityCenterApplications(identityCenterApplicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type space to the statement
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     *
     * @param spaceId - Identifier for the spaceId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSpace(spaceId: string, partition?: string): this;
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     *
     * @param spaceId - Identifier for the spaceId.
     * @param projectId - Identifier for the projectId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProject(spaceId: string, projectId: string, partition?: string): this;
    /**
     * Filters access by a tag's key and value in a request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAcceptConnection()
     * - .toCreateIdentityCenterApplication()
     * - .toCreateSpace()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toAssociateIamRoleToConnection()
     * - .toAssociateIdentityCenterApplicationToSpace()
     * - .toAssociateIdentityToIdentityCenterApplication()
     * - .toBatchAssociateIdentitiesToIdentityCenterApplication()
     * - .toBatchDisassociateIdentitiesFromIdentityCenterApplication()
     * - .toCreateSpaceAdminRoleAssignment()
     * - .toDeleteConnection()
     * - .toDeleteIdentityCenterApplication()
     * - .toDisassociateIamRoleFromConnection()
     * - .toDisassociateIdentityCenterApplicationFromSpace()
     * - .toDisassociateIdentityFromIdentityCenterApplication()
     * - .toGetBillingAuthorization()
     * - .toGetConnection()
     * - .toGetIdentityCenterApplication()
     * - .toListIamRolesForConnection()
     * - .toListSpacesForIdentityCenterApplication()
     * - .toListTagsForResource()
     * - .toPutBillingAuthorization()
     * - .toSynchronizeIdentityCenterApplication()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateIdentityCenterApplication()
     *
     * Applies to resource types:
     * - connections
     * - identity-center-applications
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys in a request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAcceptConnection()
     * - .toCreateIdentityCenterApplication()
     * - .toCreateSpace()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [codecatalyst](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodecatalyst.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
