import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [controlcatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontrolcatalog.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Controlcatalog extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to return details about a specific control
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_GetControl.html
     */
    toGetControl(): this;
    /**
     * Grants permission to return a paginated list of common controls from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html
     */
    toListCommonControls(): this;
    /**
     * Grants permission to return a paginated list of all available controls in the AWS Control Catalog library
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListControls.html
     */
    toListControls(): this;
    /**
     * Grants permission to return a paginated list of domains from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html
     */
    toListDomains(): this;
    /**
     * Grants permission to return a paginated list of objectives from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html
     */
    toListObjectives(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type common-control to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_CommonControlSummary.html
     *
     * @param commonControlId - Identifier for the commonControlId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCommonControl(commonControlId: string, partition?: string): this;
    /**
     * Adds a resource of type control to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ControlSummary.html
     *
     * @param controlId - Identifier for the controlId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onControl(controlId: string, partition?: string): this;
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_DomainSummary.html
     *
     * @param domainId - Identifier for the domainId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDomain(domainId: string, partition?: string): this;
    /**
     * Adds a resource of type objective to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ObjectiveSummary.html
     *
     * @param objectiveId - Identifier for the objectiveId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onObjective(objectiveId: string, partition?: string): this;
    /**
     * Statement provider for service [controlcatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontrolcatalog.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
