"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dbqms = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Dbqms extends shared_1.PolicyStatement {
    /**
     * Grants permission to create a new favorite query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     */
    toCreateFavoriteQuery() {
        return this.to('CreateFavoriteQuery');
    }
    /**
     * Grants permission to add a query to the history
     *
     * Access Level: Write
     */
    toCreateQueryHistory() {
        return this.to('CreateQueryHistory');
    }
    /**
     * Grants permission to create a new query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateTab
     */
    toCreateTab() {
        return this.to('CreateTab');
    }
    /**
     * Grants permission to delete saved queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     */
    toDeleteFavoriteQueries() {
        return this.to('DeleteFavoriteQueries');
    }
    /**
     * Grants permission to delete a historical query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     */
    toDeleteQueryHistory() {
        return this.to('DeleteQueryHistory');
    }
    /**
     * Grants permission to delete query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteTab
     */
    toDeleteTab() {
        return this.to('DeleteTab');
    }
    /**
     * Grants permission to list saved queries and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     */
    toDescribeFavoriteQueries() {
        return this.to('DescribeFavoriteQueries');
    }
    /**
     * Grants permission to list history of queries that were run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     */
    toDescribeQueryHistory() {
        return this.to('DescribeQueryHistory');
    }
    /**
     * Grants permission to list query tabs and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeTabs
     */
    toDescribeTabs() {
        return this.to('DescribeTabs');
    }
    /**
     * Grants permission to retrieve favorite or history query string by id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     */
    toGetQueryString() {
        return this.to('GetQueryString');
    }
    /**
     * Grants permission to update saved query and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     */
    toUpdateFavoriteQuery() {
        return this.to('UpdateFavoriteQuery');
    }
    /**
     * Grants permission to update the query history
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     */
    toUpdateQueryHistory() {
        return this.to('UpdateQueryHistory');
    }
    /**
     * Grants permission to update query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateTab
     */
    toUpdateTab() {
        return this.to('UpdateTab');
    }
    /**
     * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'dbqms';
        this.accessLevelList = {
            Write: [
                'CreateFavoriteQuery',
                'CreateQueryHistory',
                'CreateTab',
                'DeleteFavoriteQueries',
                'DeleteQueryHistory',
                'DeleteTab',
                'UpdateFavoriteQuery',
                'UpdateQueryHistory',
                'UpdateTab'
            ],
            List: [
                'DescribeFavoriteQueries',
                'DescribeQueryHistory',
                'DescribeTabs'
            ],
            Read: [
                'GetQueryString'
            ]
        };
    }
}
exports.Dbqms = Dbqms;
//# sourceMappingURL=data:application/json;base64,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