import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [dataexchange](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdataexchange.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Dataexchange extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept a data grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_AcceptDataGrant.html
     */
    toAcceptDataGrant(): this;
    /**
     * Grants permission to cancel a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_CancelJob.html
     */
    toCancelJob(): this;
    /**
     * Grants permission to create an asset (for example, in a Job)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/api-permissions-ref.html
     */
    toCreateAsset(): this;
    /**
     * Grants permission to create a data grant
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - dataexchange:PublishToDataGrant
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_CreateDataGrant.html
     */
    toCreateDataGrant(): this;
    /**
     * Grants permission to create a data set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_CreateDataSet.html
     */
    toCreateDataSet(): this;
    /**
     * Grants permission to create an event action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_CreateEventAction.html
     */
    toCreateEventAction(): this;
    /**
     * Grants permission to create a job to import or export assets
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifJobType()
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_CreateJob.html
     */
    toCreateJob(): this;
    /**
     * Grants permission to create a revision
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_CreateRevision.html
     */
    toCreateRevision(): this;
    /**
     * Grants permission to delete an asset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_DeleteAsset.html
     */
    toDeleteAsset(): this;
    /**
     * Grants permission to delete a data grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_DeleteDataGrant.html
     */
    toDeleteDataGrant(): this;
    /**
     * Grants permission to delete a data set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_DeleteDataSet.html
     */
    toDeleteDataSet(): this;
    /**
     * Grants permission to delete an event action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_DeleteEventAction.html
     */
    toDeleteEventAction(): this;
    /**
     * Grants permission to delete a revision
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_DeleteRevision.html
     */
    toDeleteRevision(): this;
    /**
     * Grants permission to get information about an asset and to export it (for example, in a Job)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetAsset.html
     */
    toGetAsset(): this;
    /**
     * Grants permission to get a data grant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetDataGrant.html
     */
    toGetDataGrant(): this;
    /**
     * Grants permission to get information about a data set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetDataSet.html
     */
    toGetDataSet(): this;
    /**
     * Grants permission to get an event action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetEventAction.html
     */
    toGetEventAction(): this;
    /**
     * Grants permission to get information about a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetJob.html
     */
    toGetJob(): this;
    /**
     * Grants permission to get a received data grant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetReceivedDataGrant.html
     */
    toGetReceivedDataGrant(): this;
    /**
     * Grants permission to get information about a revision
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_GetRevision.html
     */
    toGetRevision(): this;
    /**
     * Grants permission to list data grants for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListDataGrants.html
     */
    toListDataGrants(): this;
    /**
     * Grants permission to list the revisions of a data set
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListDataSetRevisions.html
     */
    toListDataSetRevisions(): this;
    /**
     * Grants permission to list data sets for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListDataSets.html
     */
    toListDataSets(): this;
    /**
     * Grants permission to list event actions for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListEventActions.html
     */
    toListEventActions(): this;
    /**
     * Grants permission to list jobs for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListJobs.html
     */
    toListJobs(): this;
    /**
     * Grants permission to list received data grants for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListReceivedDataGrants.html
     */
    toListReceivedDataGrants(): this;
    /**
     * Grants permission to get list the assets of a revision
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListRevisionAssets.html
     */
    toListRevisionAssets(): this;
    /**
     * Grants permission to list the tags that you associated with the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to publish a data set to a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/api-permissions-ref.html
     */
    toPublishDataSet(): this;
    /**
     * Grants permission to publish a data set to a data grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/api-permissions-ref.html
     */
    toPublishToDataGrant(): this;
    /**
     * Grants permission to revoke subscriber access to a revision
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_RevokeRevision.html
     */
    toRevokeRevision(): this;
    /**
     * Grants permission to send a request to an API asset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_SendApiAsset.html
     */
    toSendApiAsset(): this;
    /**
     * Grants permission to send a notification to subscribers of a data set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_SendDataSetNotification.html
     */
    toSendDataSetNotification(): this;
    /**
     * Grants permission to start a job
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - dataexchange:CreateAsset
     * - dataexchange:DeleteDataSet
     * - dataexchange:GetAsset
     * - dataexchange:GetDataSet
     * - dataexchange:GetRevision
     * - dataexchange:PublishDataSet
     * - redshift:AuthorizeDataShare
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_StartJob.html
     */
    toStartJob(): this;
    /**
     * Grants permission to add one or more tags to a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags from a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to get update information about an asset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_UpdateAsset.html
     */
    toUpdateAsset(): this;
    /**
     * Grants permission to update information about a data set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_UpdateDataSet.html
     */
    toUpdateDataSet(): this;
    /**
     * Grants permission to update information for an event action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_UpdateEventAction.html
     */
    toUpdateEventAction(): this;
    /**
     * Grants permission to update information about a revision
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - dataexchange:PublishDataSet
     * - dataexchange:PublishToDataGrant
     *
     * https://docs.aws.amazon.com/data-exchange/latest/apireference/API_UpdateRevision.html
     */
    toUpdateRevision(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type jobs to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifJobType()
     */
    onJobs(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-sets to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSets(dataSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type entitled-data-sets to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEntitledDataSets(dataSetId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type revisions to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html#revisions
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param revisionId - Identifier for the revisionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRevisions(dataSetId: string, revisionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type entitled-revisions to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html#revisions
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param revisionId - Identifier for the revisionId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEntitledRevisions(dataSetId: string, revisionId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type assets to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html#assets
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param revisionId - Identifier for the revisionId.
     * @param assetId - Identifier for the assetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAssets(dataSetId: string, revisionId: string, assetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type entitled-assets to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html#assets
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param revisionId - Identifier for the revisionId.
     * @param assetId - Identifier for the assetId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEntitledAssets(dataSetId: string, revisionId: string, assetId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type event-actions to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html
     *
     * @param eventActionId - Identifier for the eventActionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEventActions(eventActionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-grants to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html
     *
     * @param dataGrantId - Identifier for the dataGrantId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataGrants(dataGrantId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the allowed set of values for each of the mandatory tags in the create request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toCreateDataGrant()
     * - .toCreateDataSet()
     * - .toCreateRevision()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag value associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to resource types:
     * - data-sets
     * - revisions
     * - data-grants
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of mandatory tags in the create request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toCreateDataGrant()
     * - .toCreateDataSet()
     * - .toCreateRevision()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the specified job type
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/access-control.html
     *
     * Applies to actions:
     * - .toCreateJob()
     *
     * Applies to resource types:
     * - jobs
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifJobType(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [dataexchange](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdataexchange.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
