import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [ds-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdirectoryservicedata.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class DsData extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add a member to a group on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifMemberName()
     * - .ifRealm()
     * - .ifMemberRealm()
     * - .ifIdentifier()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_AddGroupMember.html
     */
    toAddGroupMember(): this;
    /**
     * Grants permission to create a group on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_CreateGroup.html
     */
    toCreateGroup(): this;
    /**
     * Grants permission to create a user on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to delete a group on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to delete a user on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to describe a group on a directory
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_DescribeGroup.html
     */
    toDescribeGroup(): this;
    /**
     * Grants permission to describe a user on a directory
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_DescribeUser.html
     */
    toDescribeUser(): this;
    /**
     * Grants permission to disable a user on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_DisableUser.html
     */
    toDisableUser(): this;
    /**
     * Grants permission to list members in a group on a directory
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifRealm()
     * - .ifMemberRealm()
     * - .ifIdentifier()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_ListGroupMembers.html
     */
    toListGroupMembers(): this;
    /**
     * Grants permission to list groups on a directory
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Grants permission to list the groups that a member is in on a directory
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifRealm()
     * - .ifMemberRealm()
     * - .ifIdentifier()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_ListGroupsForMember.html
     */
    toListGroupsForMember(): this;
    /**
     * Grants permission to list users on a directory
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Grants permission to remove a member from a group on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifMemberName()
     * - .ifRealm()
     * - .ifMemberRealm()
     * - .ifIdentifier()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_RemoveGroupMember.html
     */
    toRemoveGroupMember(): this;
    /**
     * Grants permission to search for groups on a directory
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds-data:DescribeGroup
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_SearchGroups.html
     */
    toSearchGroups(): this;
    /**
     * Grants permission to search for users on a directory
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds-data:DescribeUser
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_SearchUsers.html
     */
    toSearchUsers(): this;
    /**
     * Grants permission to update a group on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_UpdateGroup.html
     */
    toUpdateGroup(): this;
    /**
     * Grants permission to update a user on a directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSAMAccountName()
     * - .ifIdentifier()
     * - .ifRealm()
     *
     * Dependent actions:
     * - ds:AccessDSData
     *
     * https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/API_UpdateUser.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type directory to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/IAM_Auth_Access_Overview.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDirectory(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the AWS DS Resource being acted upon
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - directory
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the type of identifier provided in the request (i.e. SAM Account Name)
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/iam_dsdata-condition-keys.html#dsdata_condition-Identifier
     *
     * Applies to actions:
     * - .toAddGroupMember()
     * - .toCreateGroup()
     * - .toCreateUser()
     * - .toDeleteGroup()
     * - .toDeleteUser()
     * - .toDescribeGroup()
     * - .toDescribeUser()
     * - .toDisableUser()
     * - .toListGroupMembers()
     * - .toListGroupsForMember()
     * - .toRemoveGroupMember()
     * - .toUpdateGroup()
     * - .toUpdateUser()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIdentifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the directory SAM Account Name included in the MemberName input of the request
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/iam_dsdata-condition-keys.html#dsdata_condition-MemberName
     *
     * Applies to actions:
     * - .toAddGroupMember()
     * - .toRemoveGroupMember()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMemberName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the directory realm name included in the MemberRealm input of the request
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/iam_dsdata-condition-keys.html#dsdata_condition-MemberRealm
     *
     * Applies to actions:
     * - .toAddGroupMember()
     * - .toListGroupMembers()
     * - .toListGroupsForMember()
     * - .toRemoveGroupMember()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMemberRealm(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the directory realm name for the request
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/iam_dsdata-condition-keys.html#dsdata_condition-Realm
     *
     * Applies to actions:
     * - .toAddGroupMember()
     * - .toCreateGroup()
     * - .toCreateUser()
     * - .toDeleteGroup()
     * - .toDeleteUser()
     * - .toDescribeGroup()
     * - .toDescribeUser()
     * - .toDisableUser()
     * - .toListGroupMembers()
     * - .toListGroups()
     * - .toListGroupsForMember()
     * - .toListUsers()
     * - .toRemoveGroupMember()
     * - .toSearchGroups()
     * - .toSearchUsers()
     * - .toUpdateGroup()
     * - .toUpdateUser()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRealm(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the directory SAM Account Name included in the SAMAccountName input of the request
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/iam_dsdata-condition-keys.html#dsdata_condition-SAMAccountName
     *
     * Applies to actions:
     * - .toAddGroupMember()
     * - .toCreateGroup()
     * - .toCreateUser()
     * - .toDeleteGroup()
     * - .toDeleteUser()
     * - .toDescribeGroup()
     * - .toDescribeUser()
     * - .toDisableUser()
     * - .toListGroupMembers()
     * - .toListGroupsForMember()
     * - .toRemoveGroupMember()
     * - .toUpdateGroup()
     * - .toUpdateUser()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSAMAccountName(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [ds-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdirectoryservicedata.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
