import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mediaconnect extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add outputs to an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-outputs.html
     */
    toAddBridgeOutputs(): this;
    /**
     * Grants permission to add sources to an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-sources.html
     */
    toAddBridgeSources(): this;
    /**
     * Grants permission to add media streams to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-mediastreams.html
     */
    toAddFlowMediaStreams(): this;
    /**
     * Grants permission to add outputs to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs.html
     */
    toAddFlowOutputs(): this;
    /**
     * Grants permission to add sources to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source.html
     */
    toAddFlowSources(): this;
    /**
     * Grants permission to add VPC interfaces to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-vpcinterfaces.html
     */
    toAddFlowVpcInterfaces(): this;
    /**
     * Grants permission to create bridges
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges.html
     */
    toCreateBridge(): this;
    /**
     * Grants permission to create flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     */
    toCreateFlow(): this;
    /**
     * Grants permission to create gateways
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateways.html
     */
    toCreateGateway(): this;
    /**
     * Grants permission to delete bridges
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn.html
     */
    toDeleteBridge(): this;
    /**
     * Grants permission to delete flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     */
    toDeleteFlow(): this;
    /**
     * Grants permission to delete gateways
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateways-gatewayarn.html
     */
    toDeleteGateway(): this;
    /**
     * Grants permission to deregister gateway instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateway-instances-gatewayinstancearn.html
     */
    toDeregisterGatewayInstance(): this;
    /**
     * Grants permission to display the details of a bridge
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn.html
     */
    toDescribeBridge(): this;
    /**
     * Grants permission to display the details of a flow including the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     */
    toDescribeFlow(): this;
    /**
     * Grants permission to view information about the flow's source transport stream and programs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-metadata.html
     */
    toDescribeFlowSourceMetadata(): this;
    /**
     * Grants permission to view flow's source thumbnail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-thumbnail.html
     */
    toDescribeFlowSourceThumbnail(): this;
    /**
     * Grants permission to display the details of a gateway including the gateway ARN, name, and CIDR blocks, as well as details about the networks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateways-gatewayarn.html
     */
    toDescribeGateway(): this;
    /**
     * Grants permission to display the details of a gateway instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateway-instances-gatewayinstancearn.html
     */
    toDescribeGatewayInstance(): this;
    /**
     * Grants permission to display the details of an offering
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-offerings-offeringarn.html
     */
    toDescribeOffering(): this;
    /**
     * Grants permission to display the details of a reservation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-reservations-reservationarn.html
     */
    toDescribeReservation(): this;
    /**
     * Grants permission to discover gateway poll endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     */
    toDiscoverGatewayPollEndpoint(): this;
    /**
     * Grants permission to grant entitlements on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements.html
     */
    toGrantFlowEntitlements(): this;
    /**
     * Grants permission to display a list of bridges that are associated with this account and an optionally specified Arn
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges.html
     */
    toListBridges(): this;
    /**
     * Grants permission to display a list of all entitlements that have been granted to the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-entitlements.html
     */
    toListEntitlements(): this;
    /**
     * Grants permission to display a list of flows that are associated with this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     */
    toListFlows(): this;
    /**
     * Grants permission to display a list of instances that are associated with this gateway
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateway-instances.html
     */
    toListGatewayInstances(): this;
    /**
     * Grants permission to display a list of gateways that are associated with this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateways.html
     */
    toListGateways(): this;
    /**
     * Grants permission to display a list of all offerings that are available to the account in the current AWS Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-offerings.html
     */
    toListOfferings(): this;
    /**
     * Grants permission to display a list of all reservations that have been purchased by the account in the current AWS Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-reservations.html
     */
    toListReservations(): this;
    /**
     * Grants permission to display a list of all tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/tags-resourcearn.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to poll gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     */
    toPollGateway(): this;
    /**
     * Grants permission to purchase an offering
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-offerings-offeringarn.html
     */
    toPurchaseOffering(): this;
    /**
     * Grants permission to remove an output of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-outputs-outputname.html
     */
    toRemoveBridgeOutput(): this;
    /**
     * Grants permission to remove a source of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-sources-sourcename.html
     */
    toRemoveBridgeSource(): this;
    /**
     * Grants permission to remove media streams from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-mediastreams-mediastreamname.html
     */
    toRemoveFlowMediaStream(): this;
    /**
     * Grants permission to remove outputs from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs-outputarn.html
     */
    toRemoveFlowOutput(): this;
    /**
     * Grants permission to remove sources from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-sourcearn.html
     */
    toRemoveFlowSource(): this;
    /**
     * Grants permission to remove VPC interfaces from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-vpcinterfaces-vpcinterfacename.html
     */
    toRemoveFlowVpcInterface(): this;
    /**
     * Grants permission to revoke entitlements on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements-entitlementarn.html
     */
    toRevokeFlowEntitlement(): this;
    /**
     * Grants permission to start flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-start-flowarn.html
     */
    toStartFlow(): this;
    /**
     * Grants permission to stop flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-stop-flowarn.html
     */
    toStopFlow(): this;
    /**
     * Grants permission to submit gateway state change
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     */
    toSubmitGatewayStateChange(): this;
    /**
     * Grants permission to associate tags with resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/tags-resourcearn.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/tags-resourcearn.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update bridges
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn.html
     */
    toUpdateBridge(): this;
    /**
     * Grants permission to update an output of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-outputs-outputname.html
     */
    toUpdateBridgeOutput(): this;
    /**
     * Grants permission to update a source of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-sources-sourcename.html
     */
    toUpdateBridgeSource(): this;
    /**
     * Grants permission to update the state of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-bridges-bridgearn-state.html
     */
    toUpdateBridgeState(): this;
    /**
     * Grants permission to update flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     */
    toUpdateFlow(): this;
    /**
     * Grants permission to update entitlements on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements-entitlementarn.html
     */
    toUpdateFlowEntitlement(): this;
    /**
     * Grants permission to update media streams on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-mediastreams-mediastreamname.html
     */
    toUpdateFlowMediaStream(): this;
    /**
     * Grants permission to update outputs on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs-outputarn.html
     */
    toUpdateFlowOutput(): this;
    /**
     * Grants permission to update the source of any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-sourcearn.html
     */
    toUpdateFlowSource(): this;
    /**
     * Grants permission to update the configuration of an existing Gateway Instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-gateway-instances-gatewayinstancearn.html
     */
    toUpdateGatewayInstance(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Entitlement to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/entitlements.html
     *
     * @param flowId - Identifier for the flowId.
     * @param entitlementName - Identifier for the entitlementName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEntitlement(flowId: string, entitlementName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Flow to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/flows.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFlow(flowId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Output to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/outputs.html
     *
     * @param outputId - Identifier for the outputId.
     * @param outputName - Identifier for the outputName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOutput(outputId: string, outputName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Source to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/sources.html
     *
     * @param sourceId - Identifier for the sourceId.
     * @param sourceName - Identifier for the sourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSource(sourceId: string, sourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Gateway to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/gateway.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param gatewayName - Identifier for the gatewayName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGateway(gatewayId: string, gatewayName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Bridge to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/gateway-components-bridges.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBridge(flowId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type GatewayInstance to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/gateway-components-instances.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param gatewayName - Identifier for the gatewayName.
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGatewayInstance(gatewayId: string, gatewayName: string, instanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
