import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [scheduler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgescheduler.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Scheduler extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_CreateSchedule.html
     */
    toCreateSchedule(): this;
    /**
     * Grants permission to create an Amazon EventBridge Scheduler schedule group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_CreateScheduleGroup.html
     */
    toCreateScheduleGroup(): this;
    /**
     * Grants permission to delete an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_DeleteSchedule.html
     */
    toDeleteSchedule(): this;
    /**
     * Grants permission to delete an Amazon EventBridge Scheduler schedule group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - scheduler:DeleteSchedule
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_DeleteScheduleGroup.html
     */
    toDeleteScheduleGroup(): this;
    /**
     * Grants permission to view details about an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_GetSchedule.html
     */
    toGetSchedule(): this;
    /**
     * Grants permission to view details about an Amazon EventBridge Scheduler schedule group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_GetScheduleGroup.html
     */
    toGetScheduleGroup(): this;
    /**
     * Grants permission to list the Amazon EventBridge Scheduler schedule groups in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_ListScheduleGroups.html
     */
    toListScheduleGroups(): this;
    /**
     * Grants permission to list the Amazon EventBridge Scheduler schedules in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_ListSchedules.html
     */
    toListSchedules(): this;
    /**
     * Grants permission to lists tag for an Amazon EventBridge Scheduler resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to tag an Amazon EventBridge Scheduler resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag an Amazon EventBridge Scheduler resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/scheduler/latest/APIReference/API_UpdateSchedule.html
     */
    toUpdateSchedule(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type schedule-group to the statement
     *
     * https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-group.html
     *
     * @param groupName - Identifier for the groupName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScheduleGroup(groupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type schedule to the statement
     *
     * https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule.html
     *
     * @param groupName - Identifier for the groupName.
     * @param scheduleName - Identifier for the scheduleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSchedule(groupName: string, scheduleName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateScheduleGroup()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateSchedule()
     * - .toDeleteSchedule()
     * - .toDeleteScheduleGroup()
     * - .toGetSchedule()
     * - .toGetScheduleGroup()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateSchedule()
     *
     * Applies to resource types:
     * - schedule-group
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateScheduleGroup()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [scheduler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgescheduler.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
