import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [finspace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfinspace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Finspace extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to connect to a kdb cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/interacting-with-kdb-clusters.html
     */
    toConnectKxCluster(): this;
    /**
     * Grants permission to create a FinSpace environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateEnvironment.html
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to create a changeset for a kdb database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxChangeset.html
     */
    toCreateKxChangeset(): this;
    /**
     * Grants permission to create a cluster in a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:DescribeSubnets
     * - finspace:MountKxDatabase
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxCluster.html
     */
    toCreateKxCluster(): this;
    /**
     * Grants permission to create a kdb database in a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxDatabase.html
     */
    toCreateKxDatabase(): this;
    /**
     * Grants permission to create a dataview in a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxDataview.html
     */
    toCreateKxDataview(): this;
    /**
     * Grants permission to create a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxEnvironment.html
     */
    toCreateKxEnvironment(): this;
    /**
     * Grants permission to create a scaling group in a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxScalingGroup.html
     */
    toCreateKxScalingGroup(): this;
    /**
     * Grants permission to create a user in a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxUser.html
     */
    toCreateKxUser(): this;
    /**
     * Grants permission to create a volume in a managed kdb environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateKxVolume.html
     */
    toCreateKxVolume(): this;
    /**
     * Grants permission to create a FinSpace user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to delete a FinSpace environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteEnvironment.html
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to delete a kdb cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxCluster.html
     */
    toDeleteKxCluster(): this;
    /**
     * Grants permission to delete a node from a kdb cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxClusterNode.html
     */
    toDeleteKxClusterNode(): this;
    /**
     * Grants permission to delete a kdb database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxDatabase.html
     */
    toDeleteKxDatabase(): this;
    /**
     * Grants permission to delete a dataview in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxDataview.html
     */
    toDeleteKxDataview(): this;
    /**
     * Grants permission to delete a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxEnvironment.html
     */
    toDeleteKxEnvironment(): this;
    /**
     * Grants permission to delete a scaling group in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxScalingGroup.html
     */
    toDeleteKxScalingGroup(): this;
    /**
     * Grants permission to delete a kdb user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxUser.html
     */
    toDeleteKxUser(): this;
    /**
     * Grants permission to delete a volume in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteKxVolume.html
     */
    toDeleteKxVolume(): this;
    /**
     * Grants permission to describe a FinSpace environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetEnvironment.html
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to describe a changeset for a kdb database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxChangeset.html
     */
    toGetKxChangeset(): this;
    /**
     * Grants permission to describe a cluster in a managed kdb environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxCluster.html
     */
    toGetKxCluster(): this;
    /**
     * Grants permission to retrieve a connection string for kdb clusters
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - finspace:ConnectKxCluster
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxConnectionString.html
     */
    toGetKxConnectionString(): this;
    /**
     * Grants permission to describe a kdb database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxDatabase.html
     */
    toGetKxDatabase(): this;
    /**
     * Grants permission to describe a databiew in a managed kdb environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxDataview.html
     */
    toGetKxDataview(): this;
    /**
     * Grants permission to describe a managed kdb environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxEnvironment.html
     */
    toGetKxEnvironment(): this;
    /**
     * Grants permission to describe a scaling group in a managed kdb environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxScalingGroup.html
     */
    toGetKxScalingGroup(): this;
    /**
     * Grants permission to describe a kdb user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxUser.html
     */
    toGetKxUser(): this;
    /**
     * Grants permission to describe a volume in a managed kdb environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetKxVolume.html
     */
    toGetKxVolume(): this;
    /**
     * Grants permission to request status of the loading of sample data bundle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toGetLoadSampleDataSetGroupIntoEnvironmentStatus(): this;
    /**
     * Grants permission to describe a FinSpace user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toGetUser(): this;
    /**
     * Grants permission to list FinSpace environments in the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListEnvironments.html
     */
    toListEnvironments(): this;
    /**
     * Grants permission to list changesets for a kdb database
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxChangesets.html
     */
    toListKxChangesets(): this;
    /**
     * Grants permission to list cluster nodes in a managed kdb environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxClusterNodes.html
     */
    toListKxClusterNodes(): this;
    /**
     * Grants permission to list clusters in a managed kdb environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxClusters.html
     */
    toListKxClusters(): this;
    /**
     * Grants permission to list kdb databases in a managed kdb environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxDatabases.html
     */
    toListKxDatabases(): this;
    /**
     * Grants permission to list dataviews in a database
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxDataviews.html
     */
    toListKxDataviews(): this;
    /**
     * Grants permission to list managed kdb environments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxEnvironments.html
     */
    toListKxEnvironments(): this;
    /**
     * Grants permission to list scaling groups in a managed kdb environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxScalingGroups.html
     */
    toListKxScalingGroups(): this;
    /**
     * Grants permission to list users in a managed kdb environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxUsers.html
     */
    toListKxUsers(): this;
    /**
     * Grants permission to list volumes in a managed kdb environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListKxVolumes.html
     */
    toListKxVolumes(): this;
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list FinSpace users in an environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toListUsers(): this;
    /**
     * Grants permission to load sample data bundle into your FinSpace environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toLoadSampleDataSetGroupIntoEnvironment(): this;
    /**
     * Grants permission to mount a database to a kdb cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-managed-kdb-db.html
     */
    toMountKxDatabase(): this;
    /**
     * Grants permission to reset the password for a FinSpace user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toResetUserPassword(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a FinSpace environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateEnvironment.html
     */
    toUpdateEnvironment(): this;
    /**
     * Grants permission to update code configuration for a cluster in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxClusterCodeConfiguration.html
     */
    toUpdateKxClusterCodeConfiguration(): this;
    /**
     * Grants permission to update databases for a cluster in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxClusterDatabases.html
     */
    toUpdateKxClusterDatabases(): this;
    /**
     * Grants permission to update a kdb database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxDatabase.html
     */
    toUpdateKxDatabase(): this;
    /**
     * Grants permission to update a dataview in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxDataview.html
     */
    toUpdateKxDataview(): this;
    /**
     * Grants permission to update a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxEnvironment.html
     */
    toUpdateKxEnvironment(): this;
    /**
     * Grants permission to update the network for a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxEnvironmentNetwork.html
     */
    toUpdateKxEnvironmentNetwork(): this;
    /**
     * Grants permission to update a kdb user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxUser.html
     */
    toUpdateKxUser(): this;
    /**
     * Grants permission to update a volume in a managed kdb environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateKxVolume.html
     */
    toUpdateKxVolume(): this;
    /**
     * Grants permission to update a FinSpace user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(userId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxEnvironment to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxUser to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxUser(environmentId: string, userName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxCluster to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param kxCluster - Identifier for the kxCluster.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxCluster(environmentId: string, kxCluster: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxDatabase to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param kxDatabase - Identifier for the kxDatabase.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxDatabase(environmentId: string, kxDatabase: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxScalingGroup to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param kxScalingGroup - Identifier for the kxScalingGroup.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxScalingGroup(environmentId: string, kxScalingGroup: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxDataview to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param kxDatabase - Identifier for the kxDatabase.
     * @param kxDataview - Identifier for the kxDataview.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxDataview(environmentId: string, kxDatabase: string, kxDataview: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type kxVolume to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param kxVolume - Identifier for the kxVolume.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKxVolume(environmentId: string, kxVolume: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateEnvironment()
     * - .toCreateKxCluster()
     * - .toCreateKxDatabase()
     * - .toCreateKxDataview()
     * - .toCreateKxEnvironment()
     * - .toCreateKxScalingGroup()
     * - .toCreateKxUser()
     * - .toCreateKxVolume()
     * - .toCreateUser()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - environment
     * - user
     * - kxEnvironment
     * - kxUser
     * - kxCluster
     * - kxDatabase
     * - kxScalingGroup
     * - kxDataview
     * - kxVolume
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateEnvironment()
     * - .toCreateKxCluster()
     * - .toCreateKxDatabase()
     * - .toCreateKxDataview()
     * - .toCreateKxEnvironment()
     * - .toCreateKxScalingGroup()
     * - .toCreateKxUser()
     * - .toCreateKxVolume()
     * - .toCreateUser()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [finspace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfinspace.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
