import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [gameliftstreams](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongameliftstreams.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Gameliftstreams extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to attach a StreamGroup remote location
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeRegions
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AddStreamGroupLocations.html
     */
    toAddStreamGroupLocations(): this;
    /**
     * Grants permission to associate Applications to a StreamGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html
     */
    toAssociateApplications(): this;
    /**
     * Grants permission to create application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - gameliftstreams:TagResource
     * - s3:GetObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create a StreamGroup
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - gameliftstreams:TagResource
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamGroup.html
     */
    toCreateStreamGroup(): this;
    /**
     * Grants permission to create a stream session connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html
     */
    toCreateStreamSessionConnection(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete a StreamGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DeleteStreamGroup.html
     */
    toDeleteStreamGroup(): this;
    /**
     * Grants permission to disassociate Applications from a StreamGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DisassociateApplications.html
     */
    toDisassociateApplications(): this;
    /**
     * Grants permission to export stream session files that your application generates
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html
     */
    toExportStreamSessionFiles(): this;
    /**
     * Grants permission to get an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetApplication.html
     */
    toGetApplication(): this;
    /**
     * Grants `permission` to get a StreamGroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamGroup.html
     */
    toGetStreamGroup(): this;
    /**
     * Grants permission to get a stream session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
     */
    toGetStreamSession(): this;
    /**
     * Grants permission to list applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to list StreamGroups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListStreamGroups.html
     */
    toListStreamGroups(): this;
    /**
     * Grants permission to list stream sessions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListStreamSessions.html
     */
    toListStreamSessions(): this;
    /**
     * Grants permission to list stream sessions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListStreamSessionsByAccount.html
     */
    toListStreamSessionsByAccount(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to detach a StreamGroup remote location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_RemoveStreamGroupLocations.html
     */
    toRemoveStreamGroupLocations(): this;
    /**
     * Grants permission to create a stream session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_StartStreamSession.html
     */
    toStartStreamSession(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate a stream session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html
     */
    toTerminateStreamSession(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update a StreamGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html
     */
    toUpdateStreamGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type stream group to the statement
     *
     * https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/stream-groups.html
     *
     * @param streamGroupId - Identifier for the streamGroupId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStreamGroup(streamGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateStreamGroup()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - application
     * - stream group
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateStreamGroup()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [gameliftstreams](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongameliftstreams.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
