import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Groundtruthlabeling extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a patch file with the manifest file to update the manifest file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toAssociatePatchToManifestJob(): this;
    /**
     * Grants permission to create a GT+ Batch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateBatch(): this;
    /**
     * Grants permission to create intake form
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateIntakeForm(): this;
    /**
     * Grants permission to create a GT+ Project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateProject(): this;
    /**
     * Grants permission to create a GT+ Workflow Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateWorkflowDefinition(): this;
    /**
     * Grants permission to get status of GroundTruthLabeling Jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toDescribeConsoleJob(): this;
    /**
     * Grants permission to generate LiDAR Preview Task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toGenerateLIDARPreviewTaskConfigJob(): this;
    /**
     * Grants permission to get a GT+ Batch
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toGetBatch(): this;
    /**
     * Grants permission to get a intake forms
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toGetIntakeFormStatus(): this;
    /**
     * Grants permission to list a GT+ Batchs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListBatches(): this;
    /**
     * Grants permission to list dataset objects in a manifest file
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListDatasetObjects(): this;
    /**
     * Grants permission to list a GT+ Projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListProjects(): this;
    /**
     * Grants permission to filter records from a manifest file using S3 select. Get sample entries based on random sampling
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    toRunFilterOrSampleDatasetJob(): this;
    /**
     * Grants permission to list a S3 prefix and create manifest files from objects in that location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestByCrawlingJob(): this;
    /**
     * Grants permission to generate metrics from objects in manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestMetricsJob(): this;
    /**
     * Grants permission to update a GT+ Batch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toUpdateBatch(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
