import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [medical-imaging](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awshealthimaging.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class MedicalImaging extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to copy an image set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_CopyImageSet.html
     */
    toCopyImageSet(): this;
    /**
     * Grants permission to create a data store to ingest imaging data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_CreateDatastore.html
     */
    toCreateDatastore(): this;
    /**
     * Grants permission to delete a data store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_DeleteDatastore.html
     */
    toDeleteDatastore(): this;
    /**
     * Grants permission to delete an image set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_DeleteImageSet.html
     */
    toDeleteImageSet(): this;
    /**
     * Grants permission to get an import job's properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_GetDICOMImportJob.html
     */
    toGetDICOMImportJob(): this;
    /**
     * Grants permission to get dicom instance in dcm format
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dicom_GetDICOMInstance.html
     */
    toGetDICOMInstance(): this;
    /**
     * Grants permission to get dicom instance frames in format requested by the customer
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dicom_GetDICOMInstanceFrames.html
     */
    toGetDICOMInstanceFrames(): this;
    /**
     * Grants permission to get dicom instance metadata in DICOM JSON format
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dicom_GetDICOMInstanceMetadata.html
     */
    toGetDICOMInstanceMetadata(): this;
    /**
     * Grants permission to get data store properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_GetDatastore.html
     */
    toGetDatastore(): this;
    /**
     * Grants permission to get image frame properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_GetImageFrame.html
     */
    toGetImageFrame(): this;
    /**
     * Grants permission to get image set properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_GetImageSet.html
     */
    toGetImageSet(): this;
    /**
     * Grants permission to get image set metadata properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_GetImageSetMetadata.html
     */
    toGetImageSetMetadata(): this;
    /**
     * Grants permission to list import jobs for a data store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_ListDICOMImportJobs.html
     */
    toListDICOMImportJobs(): this;
    /**
     * Grants permission to list data stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_ListDatastores.html
     */
    toListDatastores(): this;
    /**
     * Grants permission to list versions of an image set
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_ListImageSetVersions.html
     */
    toListImageSetVersions(): this;
    /**
     * Grants permission to list tags for a medical imaging resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to search image sets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_SearchImageSets.html
     */
    toSearchImageSets(): this;
    /**
     * Grants permission to start a DICOM import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_StartDICOMImportJob.html
     */
    toStartDICOMImportJob(): this;
    /**
     * Grants permission to add tags to a medical imaging resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a medical imaging resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update image set metadata properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthimaging/latest/APIReference/API_dataplane_UpdateImageSetMetadata.html
     */
    toUpdateImageSetMetadata(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type datastore to the statement
     *
     * https://docs.aws.amazon.com/healthimaging/latest/devguide/API_DatastoreProperties.html
     *
     * @param datastoreId - Identifier for the datastoreId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatastore(datastoreId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type imageset to the statement
     *
     * https://docs.aws.amazon.com/healthimaging/latest/devguide/API_ImageSetProperties.html
     *
     * @param datastoreId - Identifier for the datastoreId.
     * @param imageSetId - Identifier for the imageSetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImageset(datastoreId: string, imageSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDatastore()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * Applies to resource types:
     * - datastore
     * - imageset
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDatastore()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [medical-imaging](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awshealthimaging.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
