import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [rolesanywhere](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Rolesanywhere extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to create a trust anchor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateTrustAnchor.html
     */
    toCreateTrustAnchor(): this;
    /**
     * Grants permission to delete a mapping rule from a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteAttributeMapping.html
     */
    toDeleteAttributeMapping(): this;
    /**
     * Grants permission to delete a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteCrl.html
     */
    toDeleteCrl(): this;
    /**
     * Grants permission to delete a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteTrustAnchor.html
     */
    toDeleteTrustAnchor(): this;
    /**
     * Grants permission to disable a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableCrl.html
     */
    toDisableCrl(): this;
    /**
     * Grants permission to disable a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableProfile.html
     */
    toDisableProfile(): this;
    /**
     * Grants permission to disable a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableTrustAnchor.html
     */
    toDisableTrustAnchor(): this;
    /**
     * Grants permission to enable a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableCrl.html
     */
    toEnableCrl(): this;
    /**
     * Grants permission to enable a profile
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableProfile.html
     */
    toEnableProfile(): this;
    /**
     * Grants permission to enable a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableTrustAnchor.html
     */
    toEnableTrustAnchor(): this;
    /**
     * Grants permission to get a certificate revocation list (crl)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetCrl.html
     */
    toGetCrl(): this;
    /**
     * Grants permission to get a profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetProfile.html
     */
    toGetProfile(): this;
    /**
     * Grants permission to get a subject
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetSubject.html
     */
    toGetSubject(): this;
    /**
     * Grants permission to get a trust anchor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetTrustAnchor.html
     */
    toGetTrustAnchor(): this;
    /**
     * Grants permission to import a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ImportCrl.html
     */
    toImportCrl(): this;
    /**
     * Grants permission to list certificate revocation lists (crls)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListCrls.html
     */
    toListCrls(): this;
    /**
     * Grants permission to list profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to list subjects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListSubjects.html
     */
    toListSubjects(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list trust anchors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTrustAnchors.html
     */
    toListTrustAnchors(): this;
    /**
     * Grants permission to put a mapping rule into a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_PutAttributeMapping.html
     */
    toPutAttributeMapping(): this;
    /**
     * Grants permission to attach notification settings to a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_PutNotificationSettings.html
     */
    toPutNotificationSettings(): this;
    /**
     * Grants permission to reset custom notification settings to IAM Roles Anywhere defined default state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ResetNotificationSettings.html
     */
    toResetNotificationSettings(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateCrl.html
     */
    toUpdateCrl(): this;
    /**
     * Grants permission to update a profile
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    /**
     * Grants permission to update a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateTrustAnchor.html
     */
    toUpdateTrustAnchor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type trust-anchor to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param trustAnchorId - Identifier for the trustAnchorId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrustAnchor(trustAnchorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param profileId - Identifier for the profileId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(profileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subject to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param subjectId - Identifier for the subjectId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubject(subjectId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type crl to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param crlId - Identifier for the crlId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCrl(crlId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateProfile()
     * - .toCreateTrustAnchor()
     * - .toImportCrl()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - trust-anchor
     * - profile
     * - subject
     * - crl
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateProfile()
     * - .toCreateTrustAnchor()
     * - .toImportCrl()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [rolesanywhere](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
