"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitystoreAuth = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [identitystore-auth](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitystoreauth.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IdentitystoreAuth extends shared_1.PolicyStatement {
    /**
     * Grants permission to delete a batch of specified sessions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/manage-app-session.html
     */
    toBatchDeleteSession() {
        return this.to('BatchDeleteSession');
    }
    /**
     * Grants permission to return session attributes for a batch of specified sessions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/manage-app-session.html
     */
    toBatchGetSession() {
        return this.to('BatchGetSession');
    }
    /**
     * Grants permission to retrieve a list of active sessions for the specified user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/manage-app-session.html
     */
    toListSessions() {
        return this.to('ListSessions');
    }
    /**
     * Statement provider for service [identitystore-auth](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitystoreauth.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'identitystore-auth';
        this.accessLevelList = {
            Write: [
                'BatchDeleteSession'
            ],
            Read: [
                'BatchGetSession'
            ],
            List: [
                'ListSessions'
            ]
        };
    }
}
exports.IdentitystoreAuth = IdentitystoreAuth;
//# sourceMappingURL=data:application/json;base64,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