import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [ivs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninteractivevideoservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Ivs extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get multiple channels simultaneously by channel ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_BatchGetChannel.html
     */
    toBatchGetChannel(): this;
    /**
     * Grants permission to get multiple stream keys simultaneously by stream key ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_BatchGetStreamKey.html
     */
    toBatchGetStreamKey(): this;
    /**
     * Grants permission to perform StartViewerSessionRevocation on multiple channel ARN and viewer ID pairs simultaneously
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_BatchStartViewerSessionRevocation.html
     */
    toBatchStartViewerSessionRevocation(): this;
    /**
     * Grants permission to create a new channel and an associated stream key
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_CreateChannel.html
     */
    toCreateChannel(): this;
    /**
     * Grants permission to create a new encoder configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_CreateEncoderConfiguration.html
     */
    toCreateEncoderConfiguration(): this;
    /**
     * Grants permission to create a new ingest configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_CreateIngestConfiguration.html
     */
    toCreateIngestConfiguration(): this;
    /**
     * Grants permission to create a participant token
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_CreateParticipantToken.html
     */
    toCreateParticipantToken(): this;
    /**
     * Grants permission to create a playback restriction policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_CreatePlaybackRestrictionPolicy.html
     */
    toCreatePlaybackRestrictionPolicy(): this;
    /**
     * Grants permission to create a a new recording configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_CreateRecordingConfiguration.html
     */
    toCreateRecordingConfiguration(): this;
    /**
     * Grants permission to create a stage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_CreateStage.html
     */
    toCreateStage(): this;
    /**
     * Grants permission to create a new storage configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_CreateStorageConfiguration.html
     */
    toCreateStorageConfiguration(): this;
    /**
     * Grants permission to create a stream key
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_CreateStreamKey.html
     */
    toCreateStreamKey(): this;
    /**
     * Grants permission to delete a channel and channel's stream keys
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_DeleteChannel.html
     */
    toDeleteChannel(): this;
    /**
     * Grants permission to delete an encoder configuration for the specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_DeleteEncoderConfiguration.html
     */
    toDeleteEncoderConfiguration(): this;
    /**
     * Grants permission to delete an ingest configuration for the specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_DeleteIngestConfiguration.html
     */
    toDeleteIngestConfiguration(): this;
    /**
     * Grants permission to delete the playback key pair for a specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_DeletePlaybackKeyPair.html
     */
    toDeletePlaybackKeyPair(): this;
    /**
     * Grants permission to delete the playback restriction policy for a specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_DeletePlaybackRestrictionPolicy.html
     */
    toDeletePlaybackRestrictionPolicy(): this;
    /**
     * Grants permission to delete the public key for the specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_DeletePublicKey.html
     */
    toDeletePublicKey(): this;
    /**
     * Grants permission to delete a recording configuration for the specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_DeleteRecordingConfiguration.html
     */
    toDeleteRecordingConfiguration(): this;
    /**
     * Grants permission to delete the stage for a specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_DeleteStage.html
     */
    toDeleteStage(): this;
    /**
     * Grants permission to delete an storage configuration for the specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_DeleteStorageConfiguration.html
     */
    toDeleteStorageConfiguration(): this;
    /**
     * Grants permission to delete the stream key for a specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_DeleteStreamKey.html
     */
    toDeleteStreamKey(): this;
    /**
     * Grants permission to disconnect a participant from for the specified stage ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_DisconnectParticipant.html
     */
    toDisconnectParticipant(): this;
    /**
     * Grants permission to get the channel configuration for a specified channel ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetChannel.html
     */
    toGetChannel(): this;
    /**
     * Grants permission to get the composition for the specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetComposition.html
     */
    toGetComposition(): this;
    /**
     * Grants permission to get the encoder configuration for the specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetEncoderConfiguration.html
     */
    toGetEncoderConfiguration(): this;
    /**
     * Grants permission to get the ingest configuration for the specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetIngestConfiguration.html
     */
    toGetIngestConfiguration(): this;
    /**
     * Grants permission to get participant information for a specified stage ARN, session, and participant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetParticipant.html
     */
    toGetParticipant(): this;
    /**
     * Grants permission to get the playback keypair information for a specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetPlaybackKeyPair.html
     */
    toGetPlaybackKeyPair(): this;
    /**
     * Grants permission to get the playback restriction policy for a specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetPlaybackRestrictionPolicy.html
     */
    toGetPlaybackRestrictionPolicy(): this;
    /**
     * Grants permission to get the public key for the specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetPublicKey.html
     */
    toGetPublicKey(): this;
    /**
     * Grants permission to get the recording configuration for the specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetRecordingConfiguration.html
     */
    toGetRecordingConfiguration(): this;
    /**
     * Grants permission to get stage information for a specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetStage.html
     */
    toGetStage(): this;
    /**
     * Grants permission to get stage session information for a specified stage ARN and session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetStageSession.html
     */
    toGetStageSession(): this;
    /**
     * Grants permission to get the storage configuration for the specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_GetStorageConfiguration.html
     */
    toGetStorageConfiguration(): this;
    /**
     * Grants permission to get information about the active (live) stream on a specified channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetStream.html
     */
    toGetStream(): this;
    /**
     * Grants permission to get stream-key information for a specified ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetStreamKey.html
     */
    toGetStreamKey(): this;
    /**
     * Grants permission to get information about the stream session on a specified channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_GetStreamSession.html
     */
    toGetStreamSession(): this;
    /**
     * Grants permission to import the public key
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ImportPlaybackKeyPair.html
     */
    toImportPlaybackKeyPair(): this;
    /**
     * Grants permission to import a public key
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ImportPublicKey.html
     */
    toImportPublicKey(): this;
    /**
     * Grants permission to get summary information about channels
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListChannels.html
     */
    toListChannels(): this;
    /**
     * Grants permission to get summary information about compositions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListCompositions.html
     */
    toListCompositions(): this;
    /**
     * Grants permission to get summary information about encoder configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListEncoderConfigurations.html
     */
    toListEncoderConfigurations(): this;
    /**
     * Grants permission to get summary information about ingest configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListIngestConfigurations.html
     */
    toListIngestConfigurations(): this;
    /**
     * Grants permission to list participant events for a specified stage ARN, session, and participant
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListParticipantEvents.html
     */
    toListParticipantEvents(): this;
    /**
     * Grants permission to list participants for a specified stage ARN and session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListParticipants.html
     */
    toListParticipants(): this;
    /**
     * Grants permission to get summary information about playback key pairs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListPlaybackKeyPairs.html
     */
    toListPlaybackKeyPairs(): this;
    /**
     * Grants permission to get summary information about playback restriction policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListPlaybackRestrictionPolicies.html
     */
    toListPlaybackRestrictionPolicies(): this;
    /**
     * Grants permission to get summary information about public keys
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListPublicKeys.html
     */
    toListPublicKeys(): this;
    /**
     * Grants permission to get summary information about recording configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListRecordingConfigurations.html
     */
    toListRecordingConfigurations(): this;
    /**
     * Grants permission to list stage sessions for a specified stage ARN
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListStageSessions.html
     */
    toListStageSessions(): this;
    /**
     * Grants permission to get summary information about stages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListStages.html
     */
    toListStages(): this;
    /**
     * Grants permission to get summary information about storage configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_ListStorageConfigurations.html
     */
    toListStorageConfigurations(): this;
    /**
     * Grants permission to get summary information about stream keys
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListStreamKeys.html
     */
    toListStreamKeys(): this;
    /**
     * Grants permission to get summary information about streams sessions on a specified channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListStreamSessions.html
     */
    toListStreamSessions(): this;
    /**
     * Grants permission to get summary information about live streams
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListStreams.html
     */
    toListStreams(): this;
    /**
     * Grants permission to get information about the tags for a specified ARN
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to insert metadata into an RTMP stream for a specified channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_PutMetadata.html
     */
    toPutMetadata(): this;
    /**
     * Grants permission to start a new composition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_StartComposition.html
     */
    toStartComposition(): this;
    /**
     * Grants permission to start the process of revoking the viewer session associated with a specified channel ARN and viewer ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_StartViewerSessionRevocation.html
     */
    toStartViewerSessionRevocation(): this;
    /**
     * Grants permission to stop the composition for the specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_StopComposition.html
     */
    toStopComposition(): this;
    /**
     * Grants permission to disconnect a streamer on a specified channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_StopStream.html
     */
    toStopStream(): this;
    /**
     * Grants permission to add or update tags for a resource with a specified ARN
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags for a resource with a specified ARN
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a channel's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_UpdateChannel.html
     */
    toUpdateChannel(): this;
    /**
     * Grants permission to update ingest configuration for a specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_UpdateIngestConfiguration.html
     */
    toUpdateIngestConfiguration(): this;
    /**
     * Grants permission to update a playback restriction policy for a specified ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_UpdatePlaybackRestrictionPolicy.html
     */
    toUpdatePlaybackRestrictionPolicy(): this;
    /**
     * Grants permission to update a stage's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_UpdateStage.html
     */
    toUpdateStage(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Channel to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_Channel.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Stream-Key to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_StreamKey.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStreamKey(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Playback-Key-Pair to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_PlaybackKeyPair.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaybackKeyPair(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Playback-Restriction-Policy to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_PlaybackRestrictionPolicy.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaybackRestrictionPolicy(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Recording-Configuration to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/API_RecordingConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecordingConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Stage to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_Stage.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStage(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Composition to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_Composition.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onComposition(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Encoder-Configuration to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_EncoderConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEncoderConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Storage-Configuration to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_StorageConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStorageConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Public-Key to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_PublicKey.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPublicKey(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Ingest-Configuration to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_IngestConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIngestConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags associated with the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateChannel()
     * - .toCreateEncoderConfiguration()
     * - .toCreateIngestConfiguration()
     * - .toCreateParticipantToken()
     * - .toCreatePlaybackRestrictionPolicy()
     * - .toCreateRecordingConfiguration()
     * - .toCreateStage()
     * - .toCreateStorageConfiguration()
     * - .toCreateStreamKey()
     * - .toImportPlaybackKeyPair()
     * - .toImportPublicKey()
     * - .toListTagsForResource()
     * - .toStartComposition()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - Channel
     * - Stream-Key
     * - Playback-Key-Pair
     * - Playback-Restriction-Policy
     * - Recording-Configuration
     * - Stage
     * - Composition
     * - Encoder-Configuration
     * - Storage-Configuration
     * - Public-Key
     * - Ingest-Configuration
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateChannel()
     * - .toCreateEncoderConfiguration()
     * - .toCreateIngestConfiguration()
     * - .toCreateParticipantToken()
     * - .toCreatePlaybackRestrictionPolicy()
     * - .toCreateRecordingConfiguration()
     * - .toCreateStage()
     * - .toCreateStorageConfiguration()
     * - .toCreateStreamKey()
     * - .toImportPlaybackKeyPair()
     * - .toImportPublicKey()
     * - .toListTagsForResource()
     * - .toStartComposition()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [ivs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninteractivevideoservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
