import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [iotmanagedintegrations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotmanagedintegrations.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotmanagedintegrations extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a new account association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateAccountAssociation.html
     */
    toCreateAccountAssociation(): this;
    /**
     * Grants permission to create a new cloud connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateCloudConnector.html
     */
    toCreateCloudConnector(): this;
    /**
     * Grants permission to create a new connector destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateConnectorDestination.html
     */
    toCreateConnectorDestination(): this;
    /**
     * Grants permission to create a product credential locker
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateCredentialLocker.html
     */
    toCreateCredentialLocker(): this;
    /**
     * Grants permission to create a new destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateDestination.html
     */
    toCreateDestination(): this;
    /**
     * Grants permission to create a new event configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateEventLogConfiguration.html
     */
    toCreateEventLogConfiguration(): this;
    /**
     * Grants permission to create a new managed thing
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateManagedThing.html
     */
    toCreateManagedThing(): this;
    /**
     * Grants permission to create a new notification configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateNotificationConfiguration.html
     */
    toCreateNotificationConfiguration(): this;
    /**
     * Grants permission to create a new ota task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateOtaTask.html
     */
    toCreateOtaTask(): this;
    /**
     * Grants permission to create a new ota task configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateOtaTaskConfiguration.html
     */
    toCreateOtaTaskConfiguration(): this;
    /**
     * Grants permission to create a new provisioning profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_CreateProvisioningProfile.html
     */
    toCreateProvisioningProfile(): this;
    /**
     * Grants permission to delete an account association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteAccountAssociation.html
     */
    toDeleteAccountAssociation(): this;
    /**
     * Grants permission to delete a cloud connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteCloudConnector.html
     */
    toDeleteCloudConnector(): this;
    /**
     * Grants permission to delete a connector destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteConnectorDestination.html
     */
    toDeleteConnectorDestination(): this;
    /**
     * Grants permission to delete a credential locker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteCredentialLocker.html
     */
    toDeleteCredentialLocker(): this;
    /**
     * Grants permission to delete destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteDestination.html
     */
    toDeleteDestination(): this;
    /**
     * Grants permission to delete event log configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteEventLogConfiguration.html
     */
    toDeleteEventLogConfiguration(): this;
    /**
     * Grants permission to delete managed thing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteManagedThing.html
     */
    toDeleteManagedThing(): this;
    /**
     * Grants permission to delete notification configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteNotificationConfiguration.html
     */
    toDeleteNotificationConfiguration(): this;
    /**
     * Grants permission to delete ota task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteOtaTask.html
     */
    toDeleteOtaTask(): this;
    /**
     * Grants permission to delete ota task configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteOtaTaskConfiguration.html
     */
    toDeleteOtaTaskConfiguration(): this;
    /**
     * Grants permission to delete provisioning profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeleteProvisioningProfile.html
     */
    toDeleteProvisioningProfile(): this;
    /**
     * Grants permission to deregister account association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_DeregisterAccountAssociation.html
     */
    toDeregisterAccountAssociation(): this;
    /**
     * Grants permission to get information about an account association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetAccountAssociation.html
     */
    toGetAccountAssociation(): this;
    /**
     * Grants permission to get information about a cloud connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetCloudConnector.html
     */
    toGetCloudConnector(): this;
    /**
     * Grants permission to get information about a cloud destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetConnectorDestination.html
     */
    toGetConnectorDestination(): this;
    /**
     * Grants permission to get information about a credential locker
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetCredentialLocker.html
     */
    toGetCredentialLocker(): this;
    /**
     * Grants permission to get information about a custom endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetCustomEndpoint.html
     */
    toGetCustomEndpoint(): this;
    /**
     * Grants permission to get information about a default encryption configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetDefaultEncryptionConfiguration.html
     */
    toGetDefaultEncryptionConfiguration(): this;
    /**
     * Grants permission to get information about a destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetDestination.html
     */
    toGetDestination(): this;
    /**
     * Grants permission to get information about a device discovery
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetDeviceDiscovery.html
     */
    toGetDeviceDiscovery(): this;
    /**
     * Grants permission to get information about an event log configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetEventLogConfiguration.html
     */
    toGetEventLogConfiguration(): this;
    /**
     * Grants permission to get information about a hub configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetHubConfiguration.html
     */
    toGetHubConfiguration(): this;
    /**
     * Grants permission to get information about a managed thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetManagedThing.html
     */
    toGetManagedThing(): this;
    /**
     * Grants permission to get the capability report for a managed thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetManagedThingCapabilities.html
     */
    toGetManagedThingCapabilities(): this;
    /**
     * Grants permission to get the connectivity data for a managed thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetManagedThingConnectivityData.html
     */
    toGetManagedThingConnectivityData(): this;
    /**
     * Grants permission to get the meta data information for a managed thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetManagedThingMetaData.html
     */
    toGetManagedThingMetaData(): this;
    /**
     * Grants permission to get the device state information for a managed thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetManagedThingState.html
     */
    toGetManagedThingState(): this;
    /**
     * Grants permission to get information for a notification configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetNotificationConfiguration.html
     */
    toGetNotificationConfiguration(): this;
    /**
     * Grants permission to get information for an ota task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetOtaTask.html
     */
    toGetOtaTask(): this;
    /**
     * Grants permission to get information for an ota task configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetOtaTaskConfiguration.html
     */
    toGetOtaTaskConfiguration(): this;
    /**
     * Grants permission to get information for a provisioning profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetProvisioningProfile.html
     */
    toGetProvisioningProfile(): this;
    /**
     * Grants permission to get information for a runtime log configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetRuntimeLogConfiguration.html
     */
    toGetRuntimeLogConfiguration(): this;
    /**
     * Grants permission to get information for a version of a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_GetSchemaVersion.html
     */
    toGetSchemaVersion(): this;
    /**
     * Grants permission to list information for account associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListAccountAssociations.html
     */
    toListAccountAssociations(): this;
    /**
     * Grants permission to list information for cloud connectors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListCloudConnectors.html
     */
    toListCloudConnectors(): this;
    /**
     * Grants permission to list information for connector destinations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListConnectorDestinations.html
     */
    toListConnectorDestinations(): this;
    /**
     * Grants permission to list information for credential lockers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListCredentialLockers.html
     */
    toListCredentialLockers(): this;
    /**
     * Grants permission to list information for destinations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListDestinations.html
     */
    toListDestinations(): this;
    /**
     * Grants permission to list information for device discoveries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListDeviceDiscoveries.html
     */
    toListDeviceDiscoveries(): this;
    /**
     * Grants permission to list information for device discovered in a device discoveries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListDiscoveredDevices.html
     */
    toListDiscoveredDevices(): this;
    /**
     * Grants permission to list information for event log configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListEventLogConfigurations.html
     */
    toListEventLogConfigurations(): this;
    /**
     * Grants permission to list information for associations between managed thing and account associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListManagedThingAccountAssociations.html
     */
    toListManagedThingAccountAssociations(): this;
    /**
     * Grants permission to list schemas associated with a managed thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListManagedThingSchemas.html
     */
    toListManagedThingSchemas(): this;
    /**
     * Grants permission to list information for managed things
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListManagedThings.html
     */
    toListManagedThings(): this;
    /**
     * Grants permission to list information for notification configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListNotificationConfigurations.html
     */
    toListNotificationConfigurations(): this;
    /**
     * Grants permission to list information for ota task configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListOtaTaskConfigurations.html
     */
    toListOtaTaskConfigurations(): this;
    /**
     * Grants permission to list information for ota task executions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListOtaTaskExecutions.html
     */
    toListOtaTaskExecutions(): this;
    /**
     * Grants permission to list information for ota tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListOtaTasks.html
     */
    toListOtaTasks(): this;
    /**
     * Grants permission to list information for provisioning profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListProvisioningProfiles.html
     */
    toListProvisioningProfiles(): this;
    /**
     * Grants permission to list information for schemas
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListSchemaVersions.html
     */
    toListSchemaVersions(): this;
    /**
     * Grants permission to list tags for the specified resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to update the default settings for an encryption configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_PutDefaultEncryptionConfiguration.html
     */
    toPutDefaultEncryptionConfiguration(): this;
    /**
     * Grants permission to update a hub configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_PutHubConfiguration.html
     */
    toPutHubConfiguration(): this;
    /**
     * Grants permission to update a runtime log configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_PutRuntimeLogConfiguration.html
     */
    toPutRuntimeLogConfiguration(): this;
    /**
     * Grants permission to register an account association to a managed thing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_RegisterAccountAssociation.html
     */
    toRegisterAccountAssociation(): this;
    /**
     * Grants permission to register a custom endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_RegisterCustomEndpoint.html
     */
    toRegisterCustomEndpoint(): this;
    /**
     * Grants permission to reset a runtime log configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_ResetRuntimeLogConfiguration.html
     */
    toResetRuntimeLogConfiguration(): this;
    /**
     * Grants permission to send a connector event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_SendConnectorEvent.html
     */
    toSendConnectorEvent(): this;
    /**
     * Grants permission to send a command to a managed thing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_SendManagedThingCommand.html
     */
    toSendManagedThingCommand(): this;
    /**
     * Grants permission to start a refresh of access tokens associated with an account association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_StartAccountAssociationRefresh.html
     */
    toStartAccountAssociationRefresh(): this;
    /**
     * Grants permission to start a device discovery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_StartDeviceDiscovery.html
     */
    toStartDeviceDiscovery(): this;
    /**
     * Grants permission to add tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an account association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateAccountAssociation.html
     */
    toUpdateAccountAssociation(): this;
    /**
     * Grants permission to update a cloud connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateCloudConnector.html
     */
    toUpdateCloudConnector(): this;
    /**
     * Grants permission to update a connector destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateConnectorDestination.html
     */
    toUpdateConnectorDestination(): this;
    /**
     * Grants permission to update a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateDestination.html
     */
    toUpdateDestination(): this;
    /**
     * Grants permission to update an event log configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateEventLogConfiguration.html
     */
    toUpdateEventLogConfiguration(): this;
    /**
     * Grants permission to update a managed thing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateManagedThing.html
     */
    toUpdateManagedThing(): this;
    /**
     * Grants permission to update a notification configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateNotificationConfiguration.html
     */
    toUpdateNotificationConfiguration(): this;
    /**
     * Grants permission to update an ota task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/API_UpdateOtaTask.html
     */
    toUpdateOtaTask(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type account-association to the statement
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/
     *
     * @param accountAssociationId - Identifier for the accountAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAccountAssociation(accountAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type credential-locker to the statement
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCredentialLocker(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type managed-thing to the statement
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onManagedThing(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ota-task to the statement
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOtaTask(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type provisioning-profile to the statement
     *
     * https://docs.aws.amazon.com/iotmanagedintegrations/latest/APIReference/
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProvisioningProfile(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * Applies to actions:
     * - .toCreateAccountAssociation()
     * - .toCreateCredentialLocker()
     * - .toCreateManagedThing()
     * - .toCreateOtaTask()
     * - .toCreateProvisioningProfile()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * Applies to actions:
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - account-association
     * - credential-locker
     * - managed-thing
     * - ota-task
     * - provisioning-profile
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys that are passed in the request
     *
     * Applies to actions:
     * - .toCreateAccountAssociation()
     * - .toCreateCredentialLocker()
     * - .toCreateManagedThing()
     * - .toCreateOtaTask()
     * - .toCreateProvisioningProfile()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [iotmanagedintegrations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotmanagedintegrations.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
