import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [iq](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiq.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iq extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept an incoming voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toAcceptCall(): this;
    /**
     * Grants permission to approve a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApprovePaymentRequest(): this;
    /**
     * Grants permission to approve a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveProposal(): this;
    /**
     * Grants permission to archive a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toArchiveConversation(): this;
    /**
     * Grants permission to complete a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCompleteProposal(): this;
    /**
     * Grants permission to respond to a request or send a direct message to initiate a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateConversation(): this;
    /**
     * Grants permission to create an expert profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateExpert(): this;
    /**
     * Grants permission to create a listing
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateListing(): this;
    /**
     * Grants permission to create a milestone proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateMilestoneProposal(): this;
    /**
     * Grants permission to create a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreatePaymentRequest(): this;
    /**
     * Grants permission to submit new requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateProject(): this;
    /**
     * Grants permission to submit new requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateRequest(): this;
    /**
     * Grants permission to create a scheduled proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateScheduledProposal(): this;
    /**
     * Grants permission to create a seller profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateSeller(): this;
    /**
     * Grants permission to create an upfront proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateUpfrontProposal(): this;
    /**
     * Grants permission to decline an incoming voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDeclineCall(): this;
    /**
     * Grants permission to delete an existing attachment
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDeleteAttachment(): this;
    /**
     * Grants permission to disable individual public profile page
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDisableIndividualPublicProfile(): this;
    /**
     * Grants permission to download existing attachment
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toDownloadAttachment(): this;
    /**
     * Grants permission to enable individual public profile page
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toEnableIndividualPublicProfile(): this;
    /**
     * Grants permission to end a voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toEndCall(): this;
    /**
     * Grants permission to read buyer information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetBuyer(): this;
    /**
     * Grants permission to read details of a voice/video call
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCall(): this;
    /**
     * Grants permission to read the chat environment details about a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatInfo(): this;
    /**
     * Grants permission to read chat messages in a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatMessages(): this;
    /**
     * Grants permission to request a websocket token for the conversation notifications
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatToken(): this;
    /**
     * Grants permission to read chat messages in a company conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCompanyChatMessages(): this;
    /**
     * Grants permission to read a company profile
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCompanyProfile(): this;
    /**
     * Grants permission to read details of a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetConversation(): this;
    /**
     * Grants permission to read expert information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetExpert(): this;
    /**
     * Grants permission to read a listing
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetListing(): this;
    /**
     * Grants permission to read a seller profile information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetMarketplaceSeller(): this;
    /**
     * Grants permission to read a payment request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetPaymentRequest(): this;
    /**
     * Grants permission to read a proposal
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetProposal(): this;
    /**
     * Grants permission to get a created request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetRequest(): this;
    /**
     * Grants permission to read a review for an expert
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetReview(): this;
    /**
     * Grants permission to hide a request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toHideRequest(): this;
    /**
     * Grants permission to start a voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toInitiateCall(): this;
    /**
     * Grants permission to link an AWS certification to individual profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toLinkAwsCertification(): this;
    /**
     * Grants permission to list existing attachments
     *
     * Access Level: List
     *
     * https://aws.amazon.com/iq/
     */
    toListAttachments(): this;
    /**
     * Grants permission to list existing conversations
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListConversations(): this;
    /**
     * Grants permission to list access logs of expert activity
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListExpertAccessLogs(): this;
    /**
     * Grants permission to list listings
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListListings(): this;
    /**
     * Grants permission to list payment requests
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListPaymentRequests(): this;
    /**
     * Grants permission to list proposals
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListProposals(): this;
    /**
     * Grants permission to list requests that are created
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListRequests(): this;
    /**
     * Grants permission to list reviews for an expert
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListReviews(): this;
    /**
     * Grants permission to mark a message as read in a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toMarkChatMessageRead(): this;
    /**
     * Grants permission to reject a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectPaymentRequest(): this;
    /**
     * Grants permission to reject a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectProposal(): this;
    /**
     * Grants permission to send a message in a conversation as a company
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toSendCompanyChatMessage(): this;
    /**
     * Grants permission to send a message in a conversation as an individual
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toSendIndividualChatMessage(): this;
    /**
     * Grants permission to unarchive a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUnarchiveConversation(): this;
    /**
     * Grants permission to unlink an AWS certification from individual profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUnlinkAwsCertification(): this;
    /**
     * Grants permission to update a company profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateCompanyProfile(): this;
    /**
     * Grants permission to add more participants into a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateConversationMembers(): this;
    /**
     * Grants permission to update an expert information
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateExpert(): this;
    /**
     * Grants permission to update a listing
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateListing(): this;
    /**
     * Grants permission to update a request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateRequest(): this;
    /**
     * Grants permission to upload an attachment
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUploadAttachment(): this;
    /**
     * Grants permission to withdraw a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawPaymentRequest(): this;
    /**
     * Grants permission to withdraw a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawProposal(): this;
    /**
     * Grants permission to write a review for an expert
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWriteReview(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type conversation to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConversation(conversationId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type buyer to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param buyerId - Identifier for the buyerId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBuyer(buyerId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type expert to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param expertId - Identifier for the expertId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onExpert(expertId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type call to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param callId - Identifier for the callId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCall(callId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type token to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param tokenId - Identifier for the tokenId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onToken(tokenId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type proposal to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProposal(conversationId: string, proposalId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type paymentRequest to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param paymentRequestId - Identifier for the paymentRequestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPaymentRequest(conversationId: string, proposalId: string, paymentRequestId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type paymentSchedule to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param versionId - Identifier for the versionId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPaymentSchedule(conversationId: string, proposalId: string, versionId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type seller to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param sellerAwsAccountId - Identifier for the sellerAwsAccountId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSeller(sellerAwsAccountId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type company to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param companyId - Identifier for the companyId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCompany(companyId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type request to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param requestId - Identifier for the requestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRequest(requestId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type listing to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param listingId - Identifier for the listingId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onListing(listingId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type attachment to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param attachmentId - Identifier for the attachmentId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAttachment(attachmentId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type permission to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param permissionRequestId - Identifier for the permissionRequestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPermission(permissionRequestId: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [iq](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiq.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
