import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslaunchwizard.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Launchwizard extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an additional node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toCreateAdditionalNode(): this;
    /**
     * Grants permission to create a deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_CreateDeployment.html
     */
    toCreateDeployment(): this;
    /**
     * Grants permission to create an application settings set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toCreateSettingsSet(): this;
    /**
     * Grants permission to delete an additional node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDeleteAdditionalNode(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDeleteApp(): this;
    /**
     * Grants permission to delete a deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_DeleteDeployment.html
     */
    toDeleteDeployment(): this;
    /**
     * Grants permission to delete a settings set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDeleteSettingsSet(): this;
    /**
     * Grants permission to describe an additional node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDescribeAdditionalNode(): this;
    /**
     * Grants permission to describe provisioning applications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDescribeProvisionedApp(): this;
    /**
     * Grants permission to describe provisioning events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDescribeProvisioningEvents(): this;
    /**
     * Grants permission to describe an application settings set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDescribeSettingsSet(): this;
    /**
     * Grants permission to get a deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetDeployment.html
     */
    toGetDeployment(): this;
    /**
     * Grants permission to get infrastructure suggestion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetInfrastructureSuggestion(): this;
    /**
     * Grants permission to get customer's ip address
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetIpAddress(): this;
    /**
     * Grants permission to get resource cost estimate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetResourceCostEstimate(): this;
    /**
     * Grants permission to get recommendation for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetResourceRecommendation(): this;
    /**
     * Grants permission to get a settings set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetSettingsSet(): this;
    /**
     * Grants permission to get a workload
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkload.html
     */
    toGetWorkload(): this;
    /**
     * Grants permission to get a workload's asset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetWorkloadAsset(): this;
    /**
     * Grants permission to get workload assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetWorkloadAssets(): this;
    /**
     * Grants permission to get a deployment pattern
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html
     */
    toGetWorkloadDeploymentPattern(): this;
    /**
     * Grants permission to list additional nodes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListAdditionalNodes(): this;
    /**
     * Grants permission to list the allowed resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListAllowedResources(): this;
    /**
     * Grants permission to list the events that occured during a deployment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListDeploymentEvents.html
     */
    toListDeploymentEvents(): this;
    /**
     * Grants permission to list deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListDeployments.html
     */
    toListDeployments(): this;
    /**
     * Grants permission to list provisioning applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListProvisionedApps(): this;
    /**
     * Grants permission to list the cost estimates of resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListResourceCostEstimates(): this;
    /**
     * Grants permission to list settings sets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListSettingsSets(): this;
    /**
     * Grants permission to list tags for a LaunchWizard resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list deployment options of a given workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListWorkloadDeploymentOptions(): this;
    /**
     * Grants permission to list the deployment patterns of a workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html
     */
    toListWorkloadDeploymentPatterns(): this;
    /**
     * Grants permission to list workloads
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloads.html
     */
    toListWorkloads(): this;
    /**
     * Grants permission to create a settings set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toPutSettingsSet(): this;
    /**
     * Grants permission to start a provisioning
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toStartProvisioning(): this;
    /**
     * Grants permission to tag a LaunchWizard resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a LaunchWizard resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an application settings set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toUpdateSettingsSet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type deployment to the statement
     *
     * @param deploymentId - Identifier for the deploymentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeployment(deploymentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDeployment()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toDeleteDeployment()
     * - .toGetDeployment()
     * - .toListTagsForResource()
     * - .toTagResource()
     *
     * Applies to resource types:
     * - deployment
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDeployment()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslaunchwizard.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
