import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [license-manager-linux-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerlinuxsubscriptionsmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class LicenseManagerLinuxSubscriptions extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to permanently delete a subscription provider in AWS License Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_DeregisterSubscriptionProvider.html
     */
    toDeregisterSubscriptionProvider(): this;
    /**
     * Grants permission to get a subscription provider in AWS License Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_GetRegisteredSubscriptionProvider.html
     */
    toGetRegisteredSubscriptionProvider(): this;
    /**
     * Grants permission to get the service settings for Linux subscriptions in AWS License Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_GetServiceSettings.html
     */
    toGetServiceSettings(): this;
    /**
     * Grants permission to list all instances with Linux subscriptions in AWS License Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_ListLinuxSubscriptionInstances.html
     */
    toListLinuxSubscriptionInstances(): this;
    /**
     * Grants permission to list all Linux subscriptions in AWS License Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_ListLinuxSubscriptions.html
     */
    toListLinuxSubscriptions(): this;
    /**
     * Grants permission to list subscription providers in AWS License Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_ListRegisteredSubscriptionProviders.html
     */
    toListRegisteredSubscriptionProviders(): this;
    /**
     * Grants permission to list tags for a selected resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create a new subscription provider in AWS License Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_RegisterSubscriptionProvider.html
     */
    toRegisterSubscriptionProvider(): this;
    /**
     * Grants permission to tag a selected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a selected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the service settings for Linux subscriptions in AWS License Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-linux-subscriptions/latest/APIReference/API_UpdateServiceSettings.html
     */
    toUpdateServiceSettings(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type subscription-provider to the statement
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/subscription-providers.html
     *
     * @param subscriptionProviderId - Identifier for the subscriptionProviderId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubscriptionProvider(subscriptionProviderId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/identity-access-management.html
     *
     * Applies to actions:
     * - .toRegisterSubscriptionProvider()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * Applies to resource types:
     * - subscription-provider
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/identity-access-management.html
     *
     * Applies to actions:
     * - .toRegisterSubscriptionProvider()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [license-manager-linux-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerlinuxsubscriptionsmanager.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
