import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [apptest](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmainframemodernizationapplicationtesting.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Apptest extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a test case
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_CreateTestCase.html
     */
    toCreateTestCase(): this;
    /**
     * Grants permission to create a test configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_CreateTestConfiguration.html
     */
    toCreateTestConfiguration(): this;
    /**
     * Grants permission to create a test suite
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_CreateTestSuite.html
     */
    toCreateTestSuite(): this;
    /**
     * Grants permission to delete a test case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_DeleteTestCase.html
     */
    toDeleteTestCase(): this;
    /**
     * Grants permission to delete a test configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_DeleteTestConfiguration.html
     */
    toDeleteTestConfiguration(): this;
    /**
     * Grants permission to delete a test run
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:DeleteObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_DeleteTestRun.html
     */
    toDeleteTestRun(): this;
    /**
     * Grants permission to delete a test suite
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_DeleteTestSuite.html
     */
    toDeleteTestSuite(): this;
    /**
     * Grants permission to get a test case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_GetTestCase.html
     */
    toGetTestCase(): this;
    /**
     * Grants permission to get a test configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_GetTestConfiguration.html
     */
    toGetTestConfiguration(): this;
    /**
     * Grants permission to get test run step
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_GetTestRunStep.html
     */
    toGetTestRunStep(): this;
    /**
     * Grants permission to get a test suite
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_GetTestSuite.html
     */
    toGetTestSuite(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list test cases
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTestCases.html
     */
    toListTestCases(): this;
    /**
     * Grants permission to list test configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTestConfigurations.html
     */
    toListTestConfigurations(): this;
    /**
     * Grants permission to list steps for a test run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTestRunSteps.html
     */
    toListTestRunSteps(): this;
    /**
     * Grants permission to list test cases for a test run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTestRunTestCases.html
     */
    toListTestRunTestCases(): this;
    /**
     * Grants permission to list test runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTestRuns.html
     */
    toListTestRuns(): this;
    /**
     * Grants permission to list test suites
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_ListTestSuites.html
     */
    toListTestSuites(): this;
    /**
     * Grants permission to start a test run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - cloudformation:CreateStack
     * - cloudformation:DeleteStack
     * - cloudformation:DescribeStacks
     * - dms:DescribeReplicationTasks
     * - dms:StartReplicationTask
     * - dms:StopReplicationTask
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpointServices
     * - m2:CreateDataSetImportTask
     * - m2:GetApplication
     * - m2:GetApplicationVersion
     * - m2:GetBatchJobExecution
     * - m2:GetDataSetDetails
     * - m2:GetDataSetImportTask
     * - m2:StartApplication
     * - m2:StartBatchJob
     * - m2:StopApplication
     * - s3:CreateBucket
     * - s3:DeleteObject
     * - s3:GetObject
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_StartTestRun.html
     */
    toStartTestRun(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a test case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_UpdateTestCase.html
     */
    toUpdateTestCase(): this;
    /**
     * Grants permission to update a test configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_UpdateTestConfiguration.html
     */
    toUpdateTestConfiguration(): this;
    /**
     * Grants permission to update a test suite
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apptest/latest/APIReference/API_UpdateTestSuite.html
     */
    toUpdateTestSuite(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type TestCase to the statement
     *
     * https://docs.aws.amazon.com/m2/latest/userguide/concepts-apptest.html#TestCase-concept
     *
     * @param testCaseId - Identifier for the testCaseId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestCase(testCaseId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TestConfiguration to the statement
     *
     * https://docs.aws.amazon.com/m2/latest/userguide/concepts-apptest.html#TestConfiguration-concept
     *
     * @param testConfigurationId - Identifier for the testConfigurationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestConfiguration(testConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TestRun to the statement
     *
     * https://docs.aws.amazon.com/m2/latest/userguide/concepts-apptest.html#TestRun-concept
     *
     * @param testRunId - Identifier for the testRunId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestRun(testRunId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TestSuite to the statement
     *
     * https://docs.aws.amazon.com/m2/latest/userguide/concepts-apptest.html#TestSuite-concept
     *
     * @param testSuiteId - Identifier for the testSuiteId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestSuite(testSuiteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateTestCase()
     * - .toCreateTestConfiguration()
     * - .toCreateTestSuite()
     * - .toStartTestRun()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - TestCase
     * - TestConfiguration
     * - TestRun
     * - TestSuite
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateTestCase()
     * - .toCreateTestConfiguration()
     * - .toCreateTestSuite()
     * - .toStartTestRun()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [apptest](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmainframemodernizationapplicationtesting.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
