import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [aws-marketplace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AwsMarketplace extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to users to approve an incoming subscription request (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toAcceptAgreementApprovalRequest(): this;
    /**
     * Grants permission to users to accept their agreement requests. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toAcceptAgreementRequest(): this;
    /**
     * Grants permission to users to cancel their agreements. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toCancelAgreement(): this;
    /**
     * Grants permission to users to cancel pending subscription requests for products that require subscription verification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toCancelAgreementRequest(): this;
    /**
     * Grants permission to users to create an agreement request. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toCreateAgreementRequest(): this;
    /**
     * Grants permission to users to describe the metadata about the agreement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toDescribeAgreement(): this;
    /**
     * Grants permission to users to view the details of their incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementApprovalRequest(): this;
    /**
     * Grants permission to users to view the entitlements associated with an agreement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementEntitlements(): this;
    /**
     * Grants permission to users to view the details of their subscription requests for data products that require subscription verification
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementRequest(): this;
    /**
     * Grants permission to users to get a list of terms for an agreement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementTerms(): this;
    /**
     * Grants permission to users to list their incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListAgreementApprovalRequests(): this;
    /**
     * Grants permission to users to view charges associated with their agreements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListAgreementCharges(): this;
    /**
     * Grants permission to users to list their subscription requests for products that require subscription verification
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListAgreementRequests(): this;
    /**
     * Grants permission to users to view details of the entitlements associated with an agreement. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListEntitlementDetails(): this;
    /**
     * Grants permission to users to decline an incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toRejectAgreementApprovalRequest(): this;
    /**
     * Grants permission to users to search their agreements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toSearchAgreements(): this;
    /**
     * Grants permission to users to subscribe to AWS Marketplace products. Includes the ability to send a subscription request for products that require subscription verification. Includes the ability to enable auto-renewal for an existing subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toSubscribe(): this;
    /**
     * Grants permission to users to remove subscriptions to AWS Marketplace products. Includes the ability to disable auto-renewal for an existing subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toUnsubscribe(): this;
    /**
     * Grants permission to users to make changes to an incoming subscription request, including the ability to delete the prospective subscriber's information (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toUpdateAgreementApprovalRequest(): this;
    /**
     * Grants permission to users to update purchase orders for charges associated with their agreements
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toUpdatePurchaseOrders(): this;
    /**
     * Grants permission to users to see their account's subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toViewSubscriptions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Filters access by the type of the agreement
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAgreementType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the party type of the agreement
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPartyType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by product id for AWS Marketplace RedHat OpenShift and Bedrock Products. Note: Using this condition key will not restrict access to products in AWS Marketplace
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProductId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [aws-marketplace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplace.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
