import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AwsMarketplaceManagement extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to view additional seller notification recipients
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetAdditionalSellerNotificationRecipients(): this;
    /**
     * Grants permission to view bank account verification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetBankAccountVerificationDetails(): this;
    /**
     * Grants permission to view secondary user account verification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetSecondaryUserVerificationDetails(): this;
    /**
     * Grants permission to view account verification status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toGetSellerVerificationDetails(): this;
    /**
     * Grants permission to update additional seller notification recipients
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutAdditionalSellerNotificationRecipients(): this;
    /**
     * Grants permission to update bank account verification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutBankAccountVerificationDetails(): this;
    /**
     * Grants permission to update secondary user account verification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutSecondaryUserVerificationDetails(): this;
    /**
     * Grants permission to update account verification status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toPutSellerVerificationDetails(): this;
    /**
     * Allows access to the File Upload page inside the AWS Marketplace Management Portal
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toUploadFiles(): this;
    /**
     * Allows access to the Marketing page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewMarketing(): this;
    /**
     * Allows access to the Reports page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewReports(): this;
    /**
     * Allows access to the Settings page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSettings(): this;
    /**
     * Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSupport(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
