"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplacePrivate = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplacePrivate extends shared_1.PolicyStatement {
    /**
     * Grants permission to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toAssociateProductsWithPrivateMarketplace() {
        return this.to('AssociateProductsWithPrivateMarketplace');
    }
    /**
     * Grants permission to create a new request for a product or products to be associated with the Private Marketplace. This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toCreatePrivateMarketplaceRequests() {
        return this.to('CreatePrivateMarketplaceRequests');
    }
    /**
     * Grants permission to describe requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceRequests() {
        return this.to('DescribePrivateMarketplaceRequests');
    }
    /**
     * Grants permission to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDisassociateProductsFromPrivateMarketplace() {
        return this.to('DisassociateProductsFromPrivateMarketplace');
    }
    /**
     * Grants permission to get a queryable list for requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toListPrivateMarketplaceRequests() {
        return this.to('ListPrivateMarketplaceRequests');
    }
    /**
     * Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'AssociateProductsWithPrivateMarketplace',
                'CreatePrivateMarketplaceRequests',
                'DisassociateProductsFromPrivateMarketplace'
            ],
            List: [
                'DescribePrivateMarketplaceRequests',
                'ListPrivateMarketplaceRequests'
            ]
        };
    }
}
exports.AwsMarketplacePrivate = AwsMarketplacePrivate;
//# sourceMappingURL=data:application/json;base64,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