"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkmanagerChat = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [networkmanager-chat](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsnetworkmanagerchat.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class NetworkmanagerChat extends shared_1.PolicyStatement {
    /**
     * Grants permission to cancel a response to a message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCancelMessageResponse() {
        return this.to('CancelMessageResponse');
    }
    /**
     * Grants permission to create a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCreateConversation() {
        return this.to('CreateConversation');
    }
    /**
     * Grants permission to delete a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toDeleteConversation() {
        return this.to('DeleteConversation');
    }
    /**
     * Grants permission to list conversation messages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toListConversationMessages() {
        return this.to('ListConversationMessages');
    }
    /**
     * Grants permission to list conversations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toListConversations() {
        return this.to('ListConversations');
    }
    /**
     * Grants permission to notify whether there is activity in a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toNotifyConversationIsActive() {
        return this.to('NotifyConversationIsActive');
    }
    /**
     * Grants permission to send a conversation message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toSendConversationMessage() {
        return this.to('SendConversationMessage');
    }
    /**
     * Statement provider for service [networkmanager-chat](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsnetworkmanagerchat.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'networkmanager-chat';
        this.accessLevelList = {
            Write: [
                'CancelMessageResponse',
                'CreateConversation',
                'DeleteConversation',
                'NotifyConversationIsActive',
                'SendConversationMessage'
            ],
            List: [
                'ListConversationMessages',
                'ListConversations'
            ]
        };
    }
}
exports.NetworkmanagerChat = NetworkmanagerChat;
//# sourceMappingURL=data:application/json;base64,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