import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [opensearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearch.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Opensearch extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to access OpenSearch Application
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/
     */
    toApplicationAccessAll(): this;
    /**
     * Grants permission to cancel the query that is submitted on the OpenSearch DataSource resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CancelDirectQuery.html
     */
    toCancelDirectQuery(): this;
    /**
     * Grants permission to get the query status that are performed on the OpenSearch DataSource resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetDirectQuery.html
     */
    toGetDirectQuery(): this;
    /**
     * Grants permission to get the results of a query that is performed on the OpenSearch DataSource resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_GetDirectQueryResult.html
     */
    toGetDirectQueryResult(): this;
    /**
     * Grants permission to start a direct query on the provided OpenSearch DataSource arns
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_StartDirectQuery.html
     */
    toStartDirectQuery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplication(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasource to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/datasource.html
     *
     * @param dataSourceName - Identifier for the dataSourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatasource(dataSourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [opensearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearch.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
